/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.interaction.effect.DirtyArea;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import java.util.HashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class DirtyNodeManager {
    private boolean globalDirty = false;
    private Set<SceneNodeImpl> persistentlyDirtyNodes = new HashSet<SceneNodeImpl>();
    private Set<SceneNodeImpl> temporarilyDirtyNodes = new HashSet<SceneNodeImpl>();
    private double[] knownDirtyArea = null;

    public void makeGloballyDirty() {
        this.globalDirty = true;
    }

    public void reset(boolean bl) {
        if (!bl) {
            this.persistentlyDirtyNodes.clear();
            this.temporarilyDirtyNodes.clear();
            this.knownDirtyArea = null;
        }
        this.globalDirty = true;
    }

    public void modifyNode(SceneNodeImpl sceneNodeImpl) {
        this.makeTemporarilyDirty(sceneNodeImpl);
    }

    public void addNode(SceneNodeImpl sceneNodeImpl) {
        this.makeTemporarilyDirty(sceneNodeImpl);
    }

    public void removeNode(SceneNodeImpl sceneNodeImpl) {
        this.knownDirtyArea = DirtyNodeManager.addNodeDirtyArea(this.knownDirtyArea, sceneNodeImpl);
        if (sceneNodeImpl.isDirtyDirectly()) {
            this.decrementParentDirtyCount(sceneNodeImpl);
            this.persistentlyDirtyNodes.remove(sceneNodeImpl);
            this.temporarilyDirtyNodes.remove(sceneNodeImpl);
            sceneNodeImpl.setPersistentlyDirty(false);
            sceneNodeImpl.setTemporarilyDirty(false);
        }
    }

    public void makePersistentlyDirty(SceneNodeImpl sceneNodeImpl) {
        if (sceneNodeImpl.isPersistentlyDirty()) {
            return;
        }
        this.knownDirtyArea = DirtyNodeManager.addNodeDirtyArea(this.knownDirtyArea, sceneNodeImpl);
        boolean bl = sceneNodeImpl.isDirtyDirectly();
        sceneNodeImpl.setPersistentlyDirty(true);
        this.persistentlyDirtyNodes.add(sceneNodeImpl);
        if (!bl) {
            this.incrementParentDirtyCount(sceneNodeImpl);
        }
    }

    public void clearPersistentlyDirty(SceneNodeImpl sceneNodeImpl) {
        this.knownDirtyArea = DirtyNodeManager.addNodeDirtyArea(this.knownDirtyArea, sceneNodeImpl);
        if (!sceneNodeImpl.isPersistentlyDirty()) {
            return;
        }
        sceneNodeImpl.setPersistentlyDirty(false);
        this.persistentlyDirtyNodes.remove(sceneNodeImpl);
        if (!sceneNodeImpl.isDirty()) {
            this.decrementParentDirtyCount(sceneNodeImpl);
        }
    }

    public void renderComplete() {
        this.globalDirty = false;
        for (SceneNodeImpl sceneNodeImpl : this.temporarilyDirtyNodes) {
            sceneNodeImpl.setTemporarilyDirty(false);
            if (sceneNodeImpl.isDirty()) continue;
            this.decrementParentDirtyCount(sceneNodeImpl);
        }
        this.temporarilyDirtyNodes.clear();
    }

    private void makeTemporarilyDirty(SceneNodeImpl sceneNodeImpl) {
        this.knownDirtyArea = DirtyNodeManager.addNodeDirtyArea(this.knownDirtyArea, sceneNodeImpl);
        if (sceneNodeImpl.isTemporarilyDirty()) {
            return;
        }
        boolean bl = sceneNodeImpl.isDirtyDirectly();
        sceneNodeImpl.setTemporarilyDirty(true);
        this.temporarilyDirtyNodes.add(sceneNodeImpl);
        if (!bl) {
            this.incrementParentDirtyCount(sceneNodeImpl);
        }
    }

    private void incrementParentDirtyCount(SceneNodeImpl sceneNodeImpl) {
        boolean bl = true;
        for (SceneNodeImpl sceneNodeImpl2 = sceneNodeImpl.getParent(); sceneNodeImpl2 != null && bl; sceneNodeImpl2 = sceneNodeImpl2.getParent()) {
            bl = !sceneNodeImpl2.isDirty();
            sceneNodeImpl2.setDirtyChildCount(sceneNodeImpl2.getDirtyChildCount() + 1);
        }
    }

    private void decrementParentDirtyCount(SceneNodeImpl sceneNodeImpl) {
        boolean bl = true;
        for (SceneNodeImpl sceneNodeImpl2 = sceneNodeImpl.getParent(); sceneNodeImpl2 != null && bl; sceneNodeImpl2 = sceneNodeImpl2.getParent()) {
            sceneNodeImpl2.setDirtyChildCount(sceneNodeImpl2.getDirtyChildCount() - 1);
            bl = !sceneNodeImpl2.isDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirtyArea getSceneDirtyArea() {
        DirtyNodeManager dirtyNodeManager = this;
        synchronized (dirtyNodeManager) {
            double[] dArray = null;
            for (SceneNodeImpl sceneNodeImpl : this.persistentlyDirtyNodes) {
                if (!sceneNodeImpl.isPersistentlyDirty()) continue;
                dArray = DirtyNodeManager.addNodeDirtyArea(dArray, sceneNodeImpl);
            }
            Object object = this.knownDirtyArea != null && dArray != null ? (Object)new double[]{Math.min(this.knownDirtyArea[0], dArray[0]), Math.min(this.knownDirtyArea[1], dArray[1]), Math.max(this.knownDirtyArea[2], dArray[2]), Math.max(this.knownDirtyArea[3], dArray[3])} : (this.knownDirtyArea != null ? (Object)this.knownDirtyArea : (dArray != null ? dArray : null));
            this.knownDirtyArea = dArray;
            if (this.globalDirty) {
                return DirtyArea.makeAll();
            }
            if (object == null) {
                return DirtyArea.makeNone();
            }
            double d = Math.floor((double)object[0]);
            double d2 = Math.floor((double)object[1]);
            double d3 = Math.ceil((double)object[2]);
            double d4 = Math.ceil((double)object[3]);
            return DirtyArea.makeSome(new Rect(d, d2, d3 - d, d4 - d2));
        }
    }

    private static double[] addNodeDirtyArea(double[] dArray, SceneNodeImpl sceneNodeImpl) {
        double[] dArray2 = dArray;
        Rect rect = DirtyNodeManager.getNodeDirtyArea(sceneNodeImpl.getRenderInfo());
        if (rect != null) {
            Affine affine = sceneNodeImpl.getNetTransform();
            if (affine != null && !affine.isIdentity()) {
                rect = affine.transformBoundingBox(rect);
            }
            if (dArray2 == null) {
                dArray2 = new double[]{rect.getX(), rect.getY(), rect.getX2(), rect.getY2()};
            } else {
                dArray2[0] = Math.min(dArray2[0], rect.getX());
                dArray2[1] = Math.min(dArray2[1], rect.getY());
                dArray2[2] = Math.max(dArray2[2], rect.getX2());
                dArray2[3] = Math.max(dArray2[3], rect.getY2());
            }
        }
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            dArray2 = DirtyNodeManager.addNodeDirtyArea(dArray2, (SceneNodeImpl)sceneNode);
        }
        return dArray2;
    }

    public static Rect getNodeDirtyArea(SceneNodeRenderInfo sceneNodeRenderInfo) {
        Shape shape;
        double d;
        double d2;
        Rect rect = sceneNodeRenderInfo.getRenderBounds();
        if (rect == null) {
            return null;
        }
        Stroke stroke = sceneNodeRenderInfo.getRenderStroke();
        double d3 = stroke == null ? 0.0 : stroke.getWidth();
        double d4 = 1.5 * d3 + 2.0;
        double d5 = rect.getX() - d4 / 2.0;
        double d6 = rect.getY() - d4 / 2.0;
        double d7 = rect.getWidth() + d4;
        double d8 = rect.getHeight() + d4;
        RenderEffects renderEffects = sceneNodeRenderInfo.getRenderEffects();
        if (renderEffects != null) {
            double d9;
            double d10;
            double d11 = d5;
            double d12 = d6;
            d2 = d7;
            d = d8;
            RenderEffect renderEffect = renderEffects.getGlow();
            if (renderEffect != null) {
                d10 = 3.0 * Math.abs(renderEffect.getStdDev()) + 1.0;
                d11 -= d10;
                d12 -= d10;
                d2 += 2.0 * d10;
                d += 2.0 * d10;
            }
            d10 = d5;
            double d13 = d6;
            double d14 = d7;
            double d15 = d8;
            RenderEffect renderEffect2 = renderEffects.getShadow();
            if (renderEffect2 != null) {
                d10 += renderEffect2.getDX();
                d13 += renderEffect2.getDY();
                d9 = 3.0 * Math.abs(renderEffect2.getStdDev()) + 1.0;
                d10 -= d9;
                d13 -= d9;
                d14 += 2.0 * d9;
                d15 += 2.0 * d9;
            }
            d9 = Math.max(d5 + d7, Math.max(d11 + d2, d10 + d14));
            double d16 = Math.max(d6 + d8, Math.max(d12 + d, d13 + d15));
            d5 = Math.min(d5, Math.min(d11, d10));
            d6 = Math.min(d6, Math.min(d12, d13));
            d7 = d9 - d5;
            d8 = d16 - d6;
        }
        if ((shape = (Shape)sceneNodeRenderInfo.getNode().getShape()) != null && shape instanceof Text) {
            Text text = (Text)shape;
            int n = text.getNumLines();
            Font font = text.getFont();
            d2 = 0.25;
            d = (font.getAscent() + font.getDescent()) * (double)n;
            d8 += d;
            d6 -= d;
            double d17 = text.getWidth() * d2;
            d7 += d17;
        }
        return new Rect(d5, d6, d7, d8);
    }

    boolean isGloballyDirty() {
        return this.globalDirty;
    }

    Set<SceneNodeImpl> getPersistentlyDirtyNodes() {
        return this.persistentlyDirtyNodes;
    }

    Set<SceneNodeImpl> getTemporarilyDirtyNodes() {
        return this.temporarilyDirtyNodes;
    }

    double[] getKnownDirtyArea() {
        if (this.knownDirtyArea == null) {
            return null;
        }
        return new double[]{this.knownDirtyArea[0], this.knownDirtyArea[1], this.knownDirtyArea[2], this.knownDirtyArea[3]};
    }
}

