/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Fill;
import com.ibm.vis.engine.internal.Gradient;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.ChangeEffect;
import com.ibm.vis.interaction.EasingFunction;
import com.ibm.vis.interaction.EffectTarget;
import com.ibm.vis.interaction.events.EffectEndEvent;
import com.ibm.vis.interaction.events.EffectStartEvent;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.internal.HighlightMaker;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class Effect
implements ChangeEffect,
InterpolatorTime {
    protected EffectBuilder builder;
    protected Dim sceneSize;
    protected Set<String> targetIDs;
    public Set<String> newTargetIds;
    protected Set<SceneNodeImpl> addedSceneItems;
    protected int targetShapes;
    protected boolean animated;
    protected int startTime = 0;
    protected int duration;
    private EffectTarget[] effectTargets;
    protected double[] fadeoutDuration;
    protected double[] morphDuration;
    protected double[] fadeinDuration;
    protected int direction;
    private EventDispatcher eventDispatcher;
    private EasingFunction easingFunction;
    private double currentTime;
    public static final int DEFINED = 1000;

    protected Effect(int n) {
        this.duration = n < 1 ? 1 : n;
        this.animated = true;
        this.targetIDs = new LinkedHashSet<String>();
        this.newTargetIds = new LinkedHashSet<String>();
        this.fadeoutDuration = new double[]{0.0, 0.05};
        this.morphDuration = new double[]{0.05, 0.95};
        this.fadeinDuration = new double[]{0.95, 1.0};
        this.direction = 0;
    }

    @Override
    public void setStartTime(int n) {
        this.startTime = n < 0 ? 0 : n;
    }

    @Override
    public void setDuration(int n) {
        this.duration = n < 1 ? 1 : n;
    }

    @Override
    public void setFadeInDuration(double d, double d2) {
        this.fadeinDuration = Effect.ensureValid(d, d2, this.fadeinDuration);
    }

    @Override
    public void setFadeOutDuration(double d, double d2) {
        this.fadeoutDuration = Effect.ensureValid(d, d2, this.fadeoutDuration);
    }

    @Override
    public void setMorphDuration(double d, double d2) {
        this.morphDuration = Effect.ensureValid(d, d2, this.morphDuration);
    }

    private static double[] ensureValid(double d, double d2, double[] dArray) {
        if (d >= d2 || d > 1.0 || d < 0.0 || d2 < 0.0 || d2 > 1.0) {
            return dArray;
        }
        return new double[]{d, d2};
    }

    @Override
    public double[] getFadeInDuration() {
        return new double[]{this.fadeinDuration[0], this.fadeinDuration[1]};
    }

    @Override
    public double[] getFadeOutDuration() {
        return new double[]{this.fadeoutDuration[0], this.fadeoutDuration[1]};
    }

    @Override
    public double[] getMorphDuration() {
        return new double[]{this.morphDuration[0], this.morphDuration[1]};
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this.direction = n;
        }
    }

    public void setTargetIDs(Set<String> set) {
        assert (set != null);
        this.targetIDs = set;
        this.setTarget(1000);
    }

    public Collection<String> getTargetIDs() {
        return this.targetIDs;
    }

    public int getTargetShapes() {
        return this.targetShapes;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void clear() {
        this.targetIDs = this.newTargetIds;
        this.newTargetIds = new LinkedHashSet<String>();
    }

    public Collection<SceneNodeImpl> getAddedSceneItems() {
        return this.addedSceneItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(EffectBuilder effectBuilder) {
        this.builder = effectBuilder;
        this.builder.addEffect(this);
        this.sceneSize = this.builder.sceneTree.getSize();
        if (this.targetShapes != 1000) {
            this.targetIDs = new LinkedHashSet<String>();
            SceneTree sceneTree = this.builder.sceneTree;
            synchronized (sceneTree) {
                for (String string : this.builder.sceneTree.getAllNodeIDs()) {
                    if (!this.isTarget(string)) continue;
                    this.targetIDs.add(string);
                }
            }
        }
    }

    public void installWithPrevious(EffectBuilder effectBuilder, SceneTree sceneTree) {
        this.install(effectBuilder);
    }

    public void uninstall(EffectBuilder effectBuilder) {
    }

    protected Rect getInnerBounds(String string) {
        SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.builder.sceneTree.findNode(string + "Coords");
        return sceneNodeImpl.getShape().getNodeBounds();
    }

    protected StyleKeyFrame[] makeFadingKeyFrames(SceneNodeImpl sceneNodeImpl, double d, double d2, double d3, double d4) {
        int n = 2;
        if (d > 0.0) {
            ++n;
        }
        if (d3 < 1.0) {
            ++n;
        }
        StyleKeyFrame[] styleKeyFrameArray = new StyleKeyFrame[n];
        int n2 = 0;
        if (d > 0.0) {
            styleKeyFrameArray[n2++] = this.makeFadingKeyFrame(sceneNodeImpl, 0.0, d2);
        }
        styleKeyFrameArray[n2++] = this.makeFadingKeyFrame(sceneNodeImpl, d, d2);
        styleKeyFrameArray[n2++] = this.makeFadingKeyFrame(sceneNodeImpl, d3, d4);
        if (d3 < 1.0) {
            styleKeyFrameArray[n2++] = this.makeFadingKeyFrame(sceneNodeImpl, 1.0, d4);
        }
        return styleKeyFrameArray;
    }

    protected StyleKeyFrame makeFadingKeyFrame(SceneNodeImpl sceneNodeImpl, double d, double d2) {
        Stroke stroke;
        GradientPaintInfo gradientPaintInfo = null;
        Stroke stroke2 = null;
        Double d3 = null;
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        if (sceneNodeRenderInfo.getRenderFill() != null) {
            gradientPaintInfo = this.makeFadingFill(sceneNodeRenderInfo.getRenderFill(), d2);
        }
        if ((stroke = sceneNodeRenderInfo.getRenderStroke()) != null) {
            stroke2 = stroke.createStrokeWithColor(stroke.getColor().fadeAlpha(d2));
        }
        if (sceneNodeRenderInfo.getRenderImage() != null) {
            d3 = sceneNodeRenderInfo.getRenderImage().getAlpha() * d2;
        }
        RenderEffects renderEffects = this.makeFadingEffects(sceneNodeRenderInfo.getRenderEffects(), d2);
        return new StyleKeyFrame(d, gradientPaintInfo, stroke2, renderEffects, d3);
    }

    private GradientPaintInfo makeFadingFill(GradientPaintInfo gradientPaintInfo, double d) {
        return gradientPaintInfo.fadeAlpha(d);
    }

    private RenderEffects makeFadingEffects(RenderEffects renderEffects, double d) {
        RenderEffect renderEffect;
        if (renderEffects == null) {
            return null;
        }
        RenderEffect renderEffect2 = renderEffects.getGlow();
        if (renderEffect2 != null) {
            renderEffect2 = new RenderEffect(renderEffect2.getColor().fadeAlpha(d), renderEffect2.getStdDev(), renderEffect2.getDX(), renderEffect2.getDY());
        }
        if ((renderEffect = renderEffects.getShadow()) != null) {
            renderEffect = new RenderEffect(renderEffect.getColor().fadeAlpha(d), renderEffect.getStdDev(), renderEffect.getDX(), renderEffect.getDY());
        }
        return new RenderEffects(renderEffect2, renderEffect);
    }

    protected void setStyle(Shape shape, Fill fill, Stroke stroke) {
        shape.setFill(fill);
        shape.setStroke(stroke);
    }

    protected StyleKeyFrame makeSimpleStyleKeyFrame(SceneNodeImpl sceneNodeImpl, StyleSpec styleSpec, boolean bl) {
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        GradientPaintInfo gradientPaintInfo = sceneNodeRenderInfo.getRenderFill();
        Stroke stroke = sceneNodeRenderInfo.getRenderStroke();
        RenderEffects renderEffects = sceneNodeRenderInfo.getRenderEffects();
        Double d = sceneNodeRenderInfo.getRenderImage() != null ? Double.valueOf(sceneNodeRenderInfo.getRenderImage().getAlpha()) : null;
        Shape shape = (Shape)sceneNodeImpl.getShape();
        if (shape != null && shape.isFilled()) {
            if (styleSpec.fill instanceof FillSpec) {
                FillSpec fillSpec = (FillSpec)styleSpec.fill;
                Gradient gradient = Gradient.makeFromSpec(fillSpec, gradientPaintInfo.getSolid());
                gradientPaintInfo = gradient.makePaintInfo(shape.getLocalGradientGeometry(), shape.getGlobalGradientGeometry());
            } else {
                ColorNew colorNew = ColorUtil.toCanonicalColor(styleSpec.fill);
                if (colorNew != null) {
                    Fill fill = shape.getFill();
                    if (!bl && fill != null) {
                        ColorNew colorNew2 = fill.getSolid();
                        Gradient gradient = fill.getGradient();
                        if (colorNew2 != null) {
                            colorNew = ColorUtil.makeCombinedColor(colorNew, colorNew2);
                            gradientPaintInfo = GradientPaintInfo.makeSolid(colorNew);
                        } else if (gradient != null) {
                            gradient = Gradient.modifyGradientWithSolid(gradient, colorNew);
                            gradientPaintInfo = gradient.makePaintInfo(shape.getLocalGradientGeometry(), shape.getGlobalGradientGeometry());
                        } else {
                            gradientPaintInfo = GradientPaintInfo.makeSolid(colorNew);
                        }
                    } else {
                        gradientPaintInfo = GradientPaintInfo.makeSolid(colorNew);
                    }
                }
            }
        }
        stroke = HighlightMaker.makeHighlightStroke(stroke, styleSpec, bl);
        if (styleSpec.effect != null) {
            renderEffects = RenderEffects.makeFromStyle(styleSpec.effect);
        }
        return new StyleKeyFrame(1.0, gradientPaintInfo, stroke, renderEffects, d);
    }

    public boolean isTarget(String string) {
        if (this.targetShapes == -1) {
            return false;
        }
        if (this.targetShapes == 2 && SceneIdUtil.identifiesElement(string)) {
            return false;
        }
        if (this.targetShapes == 1 && !SceneIdUtil.identifiesElement(string)) {
            return false;
        }
        if (this.effectTargets == null || this.effectTargets.length == 0) {
            return true;
        }
        for (EffectTarget effectTarget : this.effectTargets) {
            if (!effectTarget.affectsId(string)) continue;
            return true;
        }
        return false;
    }

    public void addTargetId(String string) {
        if (!this.newTargetIds.contains(string)) {
            this.newTargetIds.add(string);
        }
        this.targetShapes = 1000;
    }

    public boolean hasChanged() {
        if (this.targetIDs.size() != this.newTargetIds.size()) {
            return true;
        }
        for (String string : this.newTargetIds) {
            if (this.targetIDs.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTarget(int n) {
        this.targetShapes = n;
        this.effectTargets = null;
    }

    @Override
    public void setTargets(int n, EffectTarget[] effectTargetArray) {
        this.targetShapes = n;
        this.effectTargets = effectTargetArray;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTime() {
        return this.startTime + this.duration;
    }

    @Override
    public void addEffectListener(RaveListener raveListener) {
        if (this.getEventDispatcher() != null) {
            this.getEventDispatcher().addListenerToGroup(this, raveListener);
        }
    }

    @Override
    public void removeEffectListener(RaveListener raveListener) {
        if (this.getEventDispatcher() != null) {
            this.getEventDispatcher().removeListenerFromGroup(this, raveListener);
        }
    }

    public Collection<RaveListener> getListeners() {
        if (this.getEventDispatcher() == null) {
            return new HashSet<RaveListener>();
        }
        return this.getEventDispatcher().getListeners(this);
    }

    public final EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void fireOnEffectStartEvent() {
        if (this.getEventDispatcher() != null) {
            EffectStartEvent effectStartEvent = new EffectStartEvent(this);
            this.getEventDispatcher().notify(effectStartEvent);
        }
    }

    public void fireOnEffectEndEvent() {
        if (this.getEventDispatcher() != null) {
            EffectEndEvent effectEndEvent = new EffectEndEvent(this);
            this.getEventDispatcher().notify(effectEndEvent);
            this.getEventDispatcher().removeAllListenersFromGroup(this);
        }
    }

    @Override
    public void setEasingFunction(EasingFunction easingFunction) {
        this.easingFunction = easingFunction;
    }

    @Override
    public EasingFunction getEasingFunction() {
        return this.easingFunction;
    }

    public void resetTimer() {
        this.currentTime = 0.0;
    }

    @Override
    public void setTime(double d) {
        this.currentTime = d;
    }

    @Override
    public double time() {
        if (this.currentTime < (double)this.startTime) {
            return 0.0;
        }
        if (this.currentTime > (double)(this.startTime + this.duration)) {
            return 1.0;
        }
        double d = (this.currentTime - (double)this.startTime) / (double)this.duration;
        EasingFunction easingFunction = this.getEasingFunction();
        if (easingFunction == null) {
            return d;
        }
        return easingFunction.ease(d);
    }
}

