/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectRunnable;
import com.ibm.vis.engine.internal.interaction.effect.SceneOwner;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.HighlightRepresentation;
import com.ibm.vis.interaction.internal.HighlightMaker;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class EffectBuilder {
    public static final String STYLE_EXT = ".XH";
    public final SceneTree sceneTree;
    public final SceneOwner sceneOwner;
    private final ArrayList<Effect> effects;
    private final ArrayList<SceneNodeImpl> modifiedItems;
    private final IntPrimitiveArrayList modifiedTypes;
    private boolean hasAnimatedItems;
    private final long duration;
    long startTime;

    public static boolean isHighlightItem(SceneNodeImpl sceneNodeImpl) {
        return EffectBuilder.isHighlightID(sceneNodeImpl.getId());
    }

    public static boolean isHighlightID(String string) {
        return string != null && string.endsWith(STYLE_EXT);
    }

    public EffectBuilder(SceneTree sceneTree, SceneOwner sceneOwner, boolean bl, long l) {
        this.sceneTree = sceneTree;
        this.sceneOwner = sceneOwner;
        this.duration = l;
        this.effects = new ArrayList();
        this.modifiedItems = new ArrayList();
        this.modifiedTypes = new IntPrimitiveArrayList();
        this.hasAnimatedItems = false;
    }

    public long getDuration() {
        return this.hasAnimatedItems ? this.duration : 1L;
    }

    public void start() {
        this.startTime = 0L;
        boolean bl = false;
        for (Effect effect : this.effects) {
            effect.resetTimer();
            if (!effect.isAnimated()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.sceneOwner.execute(new EffectRunnable(this));
        }
    }

    public void step(double d) {
        double d2 = d * (double)this.duration;
        for (Effect effect : this.effects) {
            effect.setTime(d2);
        }
        this.sceneOwner.sceneEffectsChanged(1);
    }

    public void fireStartEffectsEvent() {
        for (Effect effect : this.effects) {
            effect.fireOnEffectStartEvent();
        }
    }

    public void fireEndEffectsEvent() {
        for (Effect effect : this.effects) {
            effect.fireOnEffectEndEvent();
        }
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallEffects() {
        this.hasAnimatedItems = false;
        if (this.modifiedItems.size() == 0) {
            return;
        }
        SceneOwner sceneOwner = this.sceneOwner;
        synchronized (sceneOwner) {
            DirtyNodeManager dirtyNodeManager = this.sceneOwner.getDirtyNodeManager();
            ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
            int n = this.modifiedItems.size();
            for (int i = n - 1; i >= 0; --i) {
                SceneNodeImpl sceneNodeImpl = this.modifiedItems.get(i);
                int n2 = this.modifiedTypes.get(i);
                if (n2 == 0) {
                    arrayList.add(sceneNodeImpl);
                    continue;
                }
                if (n2 == 1) {
                    dirtyNodeManager.modifyNode(sceneNodeImpl);
                    sceneNodeImpl.removeAnimateInfo(1);
                    dirtyNodeManager.modifyNode(sceneNodeImpl);
                    continue;
                }
                sceneNodeImpl.removeAnimateInfo(n2);
                dirtyNodeManager.clearPersistentlyDirty(sceneNodeImpl);
            }
            for (SceneNodeImpl sceneNodeImpl : arrayList) {
                dirtyNodeManager.removeNode(sceneNodeImpl);
                this.sceneTree.removeNodeID(sceneNodeImpl);
                ((CompositeSceneNode)sceneNodeImpl.getParent()).removeChild(sceneNodeImpl);
            }
            this.sceneOwner.sceneEffectsChanged(0);
        }
    }

    public final SceneTree getSceneTree() {
        return this.sceneTree;
    }

    public Set<SceneNodeImpl> addHighlightShapes(HighlightRepresentation highlightRepresentation, Set<String> set, int n) {
        if (set == null || set.size() == 0 || highlightRepresentation == null) {
            return null;
        }
        HighlightMaker highlightMaker = new HighlightMaker(highlightRepresentation, this.sceneTree);
        DirtyNodeManager dirtyNodeManager = this.sceneOwner.getDirtyNodeManager();
        LinkedHashSet<SceneNodeImpl> linkedHashSet = new LinkedHashSet<SceneNodeImpl>();
        for (String string : set) {
            SceneNode sceneNode;
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.sceneTree.findNode(string);
            if (sceneNodeImpl == null || sceneNodeImpl.getParent() == null || (sceneNode = highlightMaker.makeHighlight(sceneNodeImpl)) == null) continue;
            ((SceneNodeImpl)sceneNode).setId("_" + n + string + STYLE_EXT);
            EffectBuilder.modifyHighlightShape(sceneNode, sceneNodeImpl);
            CompositeSceneNode compositeSceneNode = (CompositeSceneNode)sceneNodeImpl.getParent();
            compositeSceneNode.addChild(sceneNode);
            dirtyNodeManager.addNode((SceneNodeImpl)sceneNode);
            this.sceneTree.addNodeID(sceneNode);
            linkedHashSet.add((SceneNodeImpl)sceneNode);
        }
        return linkedHashSet;
    }

    private static void modifyHighlightShape(SceneNode sceneNode, SceneNode sceneNode2) {
        String string = sceneNode.getId();
        List<SceneNode> list = sceneNode.getChildren();
        List<SceneNode> list2 = sceneNode2.getChildren();
        if (list == null || list.size() == 0) {
            Rect rect = sceneNode2.getClipBounds();
            TransformInfo transformInfo = sceneNode2.getTransform();
            if (rect == null) {
                ((SceneNodeImpl)sceneNode).setClipBounds(null);
            } else {
                ((SceneNodeImpl)sceneNode).setClipBounds(rect);
            }
            if (transformInfo == null) {
                ((SceneNodeImpl)sceneNode).setTransform(null);
            } else {
                ((SceneNodeImpl)sceneNode).setTransform((TransformInfoImpl)transformInfo);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                SceneNode sceneNode3 = list.get(i);
                SceneNode sceneNode4 = list2.get(i);
                Rect rect = sceneNode4.getClipBounds();
                TransformInfo transformInfo = sceneNode4.getTransform();
                if (rect == null) {
                    ((SceneNodeImpl)sceneNode3).setClipBounds(null);
                } else {
                    ((SceneNodeImpl)sceneNode3).setClipBounds(rect);
                }
                if (transformInfo == null) {
                    ((SceneNodeImpl)sceneNode3).setTransform(null);
                } else {
                    ((SceneNodeImpl)sceneNode3).setTransform((TransformInfoImpl)transformInfo);
                }
                int n = string.indexOf(STYLE_EXT);
                String string2 = string.substring(0, n - 1) + "_" + i + string.substring(n);
                ((SceneNodeImpl)sceneNode3).setId(string2);
            }
        }
    }

    public void removeAddedHighlightShapes(Set<SceneNodeImpl> set) {
        if (set == null) {
            return;
        }
        DirtyNodeManager dirtyNodeManager = this.sceneOwner.getDirtyNodeManager();
        for (SceneNodeImpl sceneNodeImpl : set) {
            if (sceneNodeImpl == null || sceneNodeImpl.getParent() == null) continue;
            dirtyNodeManager.removeNode(sceneNodeImpl);
            CompositeSceneNode compositeSceneNode = (CompositeSceneNode)sceneNodeImpl.getParent();
            compositeSceneNode.removeChild(sceneNodeImpl);
            this.sceneTree.removeNodeID(sceneNodeImpl);
        }
    }

    public void addAnimatedMorph(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        if (!EffectBuilder.isHighlightItem(sceneNodeImpl)) {
            this.hasAnimatedItems = true;
        }
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(2);
        this.sceneOwner.getDirtyNodeManager().makePersistentlyDirty(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(2, scenePartInterpolator);
    }

    public void addAnimatedStyle(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        if (!EffectBuilder.isHighlightItem(sceneNodeImpl)) {
            this.hasAnimatedItems = true;
        }
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(3);
        this.sceneOwner.getDirtyNodeManager().makePersistentlyDirty(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(3, scenePartInterpolator);
    }

    public void addAnimatedTransform(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        if (!EffectBuilder.isHighlightItem(sceneNodeImpl)) {
            this.hasAnimatedItems = true;
        }
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(6);
        this.sceneOwner.getDirtyNodeManager().makePersistentlyDirty(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(6, scenePartInterpolator);
    }

    public void addAnimatedClip(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        if (!EffectBuilder.isHighlightItem(sceneNodeImpl)) {
            this.hasAnimatedItems = true;
        }
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(5);
        this.sceneOwner.getDirtyNodeManager().makePersistentlyDirty(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(5, scenePartInterpolator);
    }

    public void addAnimatedText(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        if (!EffectBuilder.isHighlightItem(sceneNodeImpl)) {
            this.hasAnimatedItems = true;
        }
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(4);
        this.sceneOwner.getDirtyNodeManager().makePersistentlyDirty(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(4, scenePartInterpolator);
    }

    public void addTemporaryItem(SceneNodeImpl sceneNodeImpl, CompositeSceneNode compositeSceneNode) {
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(0);
        if (compositeSceneNode == null) {
            compositeSceneNode = this.sceneTree.getRoot();
        }
        compositeSceneNode.addChild(sceneNodeImpl);
        this.sceneTree.addNodeID(sceneNodeImpl);
        this.sceneOwner.getDirtyNodeManager().addNode(sceneNodeImpl);
    }

    public void addOverrideStyle(SceneNodeImpl sceneNodeImpl, ScenePartInterpolator scenePartInterpolator) {
        this.modifiedItems.add(sceneNodeImpl);
        this.modifiedTypes.add(1);
        this.sceneOwner.getDirtyNodeManager().modifyNode(sceneNodeImpl);
        sceneNodeImpl.putAnimateInfo(1, scenePartInterpolator);
        this.sceneOwner.getDirtyNodeManager().modifyNode(sceneNodeImpl);
    }

    public void removeOverrideStyle(SceneNodeImpl sceneNodeImpl) {
        this.sceneOwner.getDirtyNodeManager().modifyNode(sceneNodeImpl);
        sceneNodeImpl.removeAnimateInfo(1);
        this.sceneOwner.getDirtyNodeManager().modifyNode(sceneNodeImpl);
    }
}

