/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class EffectRunnable {
    private static final double MAX_FPS = 50.0;
    private final EffectBuilder effectBuilder;
    private boolean alreadyEnded;
    private double last;

    EffectRunnable(EffectBuilder effectBuilder) {
        this.effectBuilder = effectBuilder;
        this.alreadyEnded = false;
    }

    public long getStartTime() {
        return this.effectBuilder.startTime;
    }

    public long getDuration() {
        return this.effectBuilder.getDuration();
    }

    public void begin() {
        DirtyNodeManager dirtyNodeManager;
        this.effectBuilder.fireStartEffectsEvent();
        if (this.effectBuilder.startTime == 0L) {
            this.effectBuilder.startTime = BasicFactory.getSystemTimer();
        }
        if ((dirtyNodeManager = this.effectBuilder.sceneOwner.getDirtyNodeManager()) != null) {
            dirtyNodeManager.makeGloballyDirty();
        }
        this.last = 0.0;
        this.alreadyEnded = false;
    }

    public boolean step(double d) {
        try {
            if (this.effectBuilder.sceneOwner.isInterrupted()) {
                return true;
            }
            this.effectBuilder.step(d);
            this.last = d;
        }
        catch (Exception exception) {
            this._uninstallAndFireEffectEnded();
            this.alreadyEnded = true;
            return true;
        }
        return false;
    }

    private void _uninstallAndFireEffectEnded() {
        this.effectBuilder.uninstallEffects();
        this.effectBuilder.fireEndEffectsEvent();
    }

    public void end() {
        if (this.alreadyEnded) {
            return;
        }
        if (this.last < 1.0) {
            this.effectBuilder.step(1.0);
        }
        this._uninstallAndFireEffectEnded();
        this.alreadyEnded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EffectRunnable effectRunnable = this;
        synchronized (effectRunnable) {
            this.begin();
            boolean bl = true;
            long l = this.getStartTime();
            while (true) {
                long l2 = BasicFactory.getSystemTimer();
                long l3 = l2 - l;
                if (!bl && !((double)l3 > 20.0)) continue;
                bl = false;
                l = l2;
                double d = (double)(l2 - this.getStartTime()) / (double)this.getDuration();
                boolean bl2 = this.step(d);
                if (bl2 || d >= 1.0) break;
            }
            this.end();
        }
    }
}

