/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FlyInEffect
extends Effect {
    public FlyInEffect(int n, int n2) {
        super(n);
        this.setTarget(n2);
    }

    private static String fromHighlightID(String string) {
        if (!EffectBuilder.isHighlightID(string)) {
            return string;
        }
        int n = string.indexOf(71);
        int n2 = string.indexOf(".XH");
        if (n != -1 && n2 != -1) {
            return string.substring(n, n2);
        }
        return null;
    }

    @Override
    public void install(EffectBuilder effectBuilder) {
        super.install(effectBuilder);
        double d = Math.max(this.sceneSize.getWidth(), this.sceneSize.getHeight()) * 0.6;
        Rect rect = new Rect(0.0, 0.0, this.sceneSize.getWidth(), this.sceneSize.getHeight());
        for (String string : this.targetIDs) {
            Rect rect2 = null;
            String string2 = FlyInEffect.fromHighlightID(string);
            if (string2 != null) {
                int n = -1;
                if (SceneIdUtil.identifiesElement(string2)) {
                    n = string2.indexOf("E");
                }
                rect2 = n < 0 ? rect : this.getInnerBounds(string2.substring(0, n));
            }
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)effectBuilder.sceneTree.findNode(string);
            double d2 = FlyInEffect.calculateAngle(sceneNodeImpl, rect2);
            Geom geom = sceneNodeImpl.getRenderInfo().getRenderGeom();
            if (geom == null && sceneNodeImpl.getShape() != null && sceneNodeImpl.getShape().getTextInfo() == null) continue;
            TransformInfo transformInfo = sceneNodeImpl.getTransform();
            Affine affine = transformInfo.getAffine();
            affine = affine == null ? Affine.makeTransform(d * Math.cos(d2), d * Math.sin(d2)) : affine.translate(d * Math.cos(d2), d * Math.sin(d2));
            TransformInfoImpl transformInfoImpl = new TransformInfoImpl();
            transformInfoImpl.setAffine(affine);
            effectBuilder.addAnimatedTransform(sceneNodeImpl, InterpolatorFactory.getTransformInterpolator(this, 0.0, 1.0, transformInfoImpl, transformInfo));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double calculateAngle(SceneNodeImpl sceneNodeImpl, Rect rect) {
        Point point;
        Geom geom = sceneNodeImpl.getRenderInfo().getRenderGeom();
        if (geom == null) {
            if (sceneNodeImpl.getShape() == null || sceneNodeImpl.getShape().getTextInfo() == null) return -1.5707963267948966;
            point = sceneNodeImpl.getPhysicalBounds().getCenter();
            return Math.atan2(point.getY() - rect.getHeight() / 2.0, point.getX() - rect.getWidth() / 2.0);
        } else {
            point = geom.getCenter();
        }
        return Math.atan2(point.getY() - rect.getHeight() / 2.0, point.getX() - rect.getWidth() / 2.0);
    }
}

