/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.RoundedRect;
import com.ibm.vis.scenetree.internal.ElementGroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.ShapeInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GrowEffect
extends Effect {
    public static final double GROW_FINISHED = 0.95;

    public GrowEffect(int n) {
        super(n);
        this.setTarget(1);
    }

    @Override
    public void install(EffectBuilder effectBuilder) {
        super.install(effectBuilder);
        if (effectBuilder.getSceneTree() == null) {
            return;
        }
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        this.collectElements(arrayList, effectBuilder.getSceneTree().getRoot());
        List<SceneNodeImpl> list = this.manageElements(arrayList);
        for (int i = 0; i < list.size(); ++i) {
            SceneNodeImpl sceneNodeImpl = list.get(i);
            if (!this.containsTarget(sceneNodeImpl.getChildren())) continue;
            this.installElementGrow(sceneNodeImpl, effectBuilder);
        }
    }

    private List<SceneNodeImpl> manageElements(List<SceneNodeImpl> list) {
        if (list.size() < 2) {
            return list;
        }
        HashMap<Object, SceneNodeImpl> hashMap = new HashMap<Object, SceneNodeImpl>();
        for (SceneNodeImpl object : list) {
            if (object.getId() != null && object.getId().indexOf("V") > -1) {
                SceneNodeImpl sceneNodeImpl;
                Object object2 = object.getId().substring(0, object.getId().indexOf("V"));
                if (hashMap.get(object2) == null) {
                    sceneNodeImpl = SceneNodeFactory.createElementGroupNode(((ElementGroupSceneNode)object).getElementType(), ((ElementGroupSceneNode)object).getBaseline());
                    sceneNodeImpl.getChildren().addAll(object.getChildren());
                    hashMap.put(object2, sceneNodeImpl);
                    continue;
                }
                sceneNodeImpl = (SceneNodeImpl)hashMap.get(object2);
                sceneNodeImpl.getChildren().addAll(object.getChildren());
                continue;
            }
            hashMap.put(object.getId(), object);
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : hashMap.values()) {
            arrayList.add(object2);
        }
        return arrayList;
    }

    private boolean containsTarget(List<SceneNode> list) {
        for (SceneNode sceneNode : list) {
            if (!this.isTarget(sceneNode.getId()) && !this.containsTarget(sceneNode.getChildren())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTopLevelElementGoup(SceneNodeImpl sceneNodeImpl) {
        boolean bl = false;
        if (sceneNodeImpl.getClassId() == SceneNodeClassId.ELEMENT_GROUP) {
            bl = true;
            for (int i = 0; i < sceneNodeImpl.getChildren().size(); ++i) {
                SceneNodeClassId sceneNodeClassId = sceneNodeImpl.getChildren().get(i).getClassId();
                if (sceneNodeClassId == SceneNodeClassId.ELEMENT_GROUP) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void collectElements(List<SceneNodeImpl> list, SceneNodeImpl sceneNodeImpl) {
        if (SceneNodeType.ELEMENT == sceneNodeImpl.getType() && !GrowEffect.isTopLevelElementGoup(sceneNodeImpl)) {
            list.add(sceneNodeImpl);
        }
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            this.collectElements(list, (SceneNodeImpl)sceneNode);
        }
    }

    private void installElementGrow(SceneNodeImpl sceneNodeImpl, EffectBuilder effectBuilder) {
        boolean bl;
        Line line = null;
        if (sceneNodeImpl instanceof ElementGroupSceneNode) {
            Line line2 = line = ((ElementGroupSceneNode)sceneNodeImpl).getBaseline() == null ? null : (Line)((ElementGroupSceneNode)sceneNodeImpl).getBaseline().getRenderGeom(0.0);
        }
        if (line == null) {
            this.installLocalXYGrow(sceneNodeImpl, effectBuilder);
            return;
        }
        double d = line.getX1();
        double d2 = line.getY1();
        double d3 = line.getX2();
        double d4 = line.getY2();
        boolean bl2 = Math.abs(d - d3) <= 0.001;
        boolean bl3 = bl = Math.abs(d2 - d4) <= 0.001;
        if (bl2 && bl) {
            this.installCenterPointGrow(sceneNodeImpl, line.getCenter(), effectBuilder);
            return;
        }
        if (!bl2 && !bl) {
            return;
        }
        boolean bl4 = bl2;
        double d5 = bl4 ? d : d2;
        this.installBottomUpGrow(sceneNodeImpl, bl4, d5, effectBuilder);
    }

    private void installLocalXYGrow(SceneNodeImpl sceneNodeImpl, EffectBuilder effectBuilder) {
        Object object;
        List<SceneNodeImpl> list = GrowEffect.getBasicShapesOfElement(sceneNodeImpl);
        HashMap<String, Rect> hashMap = new HashMap<String, Rect>();
        double d = 1.0;
        for (SceneNodeImpl sceneNodeImpl2 : list) {
            Rect rect;
            object = (Shape)sceneNodeImpl2.getShape();
            if (object == null || (rect = ((Shape)object).getBounds()) == null) continue;
            d = Math.max(d, Math.max(rect.getWidth(), rect.getHeight()));
            hashMap.put(sceneNodeImpl2.getId(), rect);
        }
        for (SceneNodeImpl sceneNodeImpl2 : list) {
            Object object2;
            Object object3;
            TextInfo textInfo;
            object = (Rect)hashMap.get(sceneNodeImpl2.getId());
            if (object == null) {
                this.installLateFadeIn(sceneNodeImpl2, effectBuilder);
                continue;
            }
            double d2 = Math.max(((Rect)object).getWidth(), ((Rect)object).getHeight());
            double d3 = d2 / d;
            Geom geom = sceneNodeImpl2.getRenderInfo().getRenderGeom();
            if (geom != null) {
                geom = geom.asBasic();
                effectBuilder.addAnimatedMorph(sceneNodeImpl2, InterpolatorFactory.getGeomInterpolator(this, 0.0, d3, GrowEffect.projectToLocalCenter(geom), geom, false));
                continue;
            }
            TextInfo textInfo2 = textInfo = sceneNodeImpl2.getShape() != null ? sceneNodeImpl2.getShape().getTextInfo() : null;
            if (textInfo != null) {
                object3 = (Font)textInfo.getFont();
                ((Font)object3).setMinimumSize(0.0);
                Font font = ((Font)object3).modifySize(0.0);
                Rect rect = sceneNodeImpl2.getPhysicalBounds();
                object2 = Text.createTextWithShapedValue(textInfo.getText(), rect.getCenterX(), rect.getCenterY(), textInfo.getTextAlign(), textInfo.getTextVAlign(), font, null, null, "\u2026", rect.getExtent(), false);
                ((Text)object2).setTransform(Affine.identity());
                SceneNodeRenderInfo sceneNodeRenderInfo = ((Text)object2).createSceneNode().getRenderInfo();
                effectBuilder.addAnimatedText(sceneNodeImpl2, InterpolatorFactory.getTextInterpolator(this, 0.0, d3, sceneNodeRenderInfo.getRenderText(), textInfo, sceneNodeRenderInfo.getTransform(), sceneNodeImpl2.getTransform()));
                continue;
            }
            if (this.installBoxplotGrow(sceneNodeImpl2, effectBuilder, d3)) continue;
            object3 = ((Rect)object).getCenter();
            for (SceneNodeImpl sceneNodeImpl3 : this.getItemsOfNode(sceneNodeImpl2)) {
                object2 = sceneNodeImpl3.getRenderInfo().getRenderGeom();
                if (object2 == null) continue;
                effectBuilder.addAnimatedMorph(sceneNodeImpl3, InterpolatorFactory.getGeomInterpolator(this, 0.0, d3, GrowEffect.projectToPoint((Geom)object2, (Point)object3), (Geom)object2, false));
            }
        }
    }

    private boolean installBoxplotGrow(SceneNodeImpl sceneNodeImpl, EffectBuilder effectBuilder, double d) {
        Rect rect;
        CompositeGeom compositeGeom;
        if (sceneNodeImpl.getChildren().size() != 3) {
            return false;
        }
        SceneNodeImpl sceneNodeImpl2 = (SceneNodeImpl)sceneNodeImpl.getChildren().get(0);
        CompositeGeom compositeGeom2 = GrowEffect.getBoxplotWhiskers(sceneNodeImpl2);
        if (compositeGeom2 == null) {
            return false;
        }
        boolean bl = Math.abs(compositeGeom2.getParts()[1].getBounds().getHeight()) <= 0.001;
        SceneNodeImpl sceneNodeImpl3 = (SceneNodeImpl)sceneNodeImpl.getChildren().get(1);
        Rect rect2 = GrowEffect.getBoxplotBox(sceneNodeImpl3);
        if (rect2 == null) {
            return false;
        }
        SceneNodeImpl sceneNodeImpl4 = (SceneNodeImpl)sceneNodeImpl.getChildren().get(2);
        Line line = GrowEffect.getBoxplotMedian(sceneNodeImpl4, bl);
        if (line == null) {
            return false;
        }
        if (bl) {
            double d2 = line.getX1();
            compositeGeom = GrowEffect.projectCompositeOfPaths(compositeGeom2, d2, true);
            rect = new Rect(d2, rect2.getY(), 0.0, rect2.getHeight());
        } else {
            double d3 = line.getY1();
            compositeGeom = GrowEffect.projectCompositeOfPaths(compositeGeom2, d3, false);
            rect = new Rect(rect2.getX(), d3, rect2.getWidth(), 0.0);
        }
        effectBuilder.addAnimatedMorph(sceneNodeImpl2, InterpolatorFactory.getGeomInterpolator(this, 0.0, d, compositeGeom, compositeGeom2, false));
        effectBuilder.addAnimatedMorph(sceneNodeImpl3, InterpolatorFactory.getGeomInterpolator(this, 0.0, d, rect, rect2, false));
        return true;
    }

    private static CompositeGeom projectCompositeOfPaths(CompositeGeom compositeGeom, double d, boolean bl) {
        Geom[] geomArray = new Geom[compositeGeom.getParts().length];
        for (int i = 0; i < geomArray.length; ++i) {
            BasicGeom basicGeom = compositeGeom.getParts()[i].asBasic();
            geomArray[i] = GrowEffect.projectPath(basicGeom.asPoly(), d, bl);
        }
        return new CompositeGeom(geomArray, compositeGeom.getOddEven(), null);
    }

    private static Poly projectPath(Poly poly, double d, boolean bl) {
        int n = poly.getPointCount();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return bl ? new Poly(dArray, poly.getY(), poly.isClosed()) : new Poly(poly.getX(), dArray, poly.isClosed());
    }

    static CompositeGeom getBoxplotWhiskers(SceneNodeImpl sceneNodeImpl) {
        boolean bl;
        if (!"whiskers".equals(sceneNodeImpl.getMeta("part"))) {
            return null;
        }
        CompositeGeom compositeGeom = (CompositeGeom)sceneNodeImpl.getRenderInfo().getRenderGeom();
        Geom[] geomArray = compositeGeom.getParts();
        if (geomArray.length != 4) {
            return null;
        }
        boolean bl2 = Math.abs(geomArray[1].getBounds().getHeight()) <= 0.001;
        boolean bl3 = bl = Math.abs(geomArray[1].getBounds().getWidth()) <= 0.001;
        if (bl2 && bl || !bl2 && !bl) {
            return null;
        }
        return compositeGeom;
    }

    static Rect getBoxplotBox(SceneNodeImpl sceneNodeImpl) {
        if (sceneNodeImpl.getShape() == null || sceneNodeImpl.getShape().type() != 1002) {
            return null;
        }
        if (!"box".equals(sceneNodeImpl.getMeta("part"))) {
            return null;
        }
        return sceneNodeImpl.getRenderInfo().getRenderBounds();
    }

    static Line getBoxplotMedian(SceneNodeImpl sceneNodeImpl, boolean bl) {
        if (sceneNodeImpl.getShape() == null || sceneNodeImpl.getShape().type() != 1000) {
            return null;
        }
        if (!"median".equals(sceneNodeImpl.getMeta("part"))) {
            return null;
        }
        Line line = (Line)sceneNodeImpl.getRenderInfo().getRenderGeom();
        if (bl && Math.abs(line.getX1() - line.getX2()) > 0.001 || !bl && Math.abs(line.getY1() - line.getY2()) > 0.001) {
            return null;
        }
        return line;
    }

    static List<SceneNodeImpl> getBasicShapesOfElement(SceneNodeImpl sceneNodeImpl) {
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            if (SceneNodeType.SCHEMA == sceneNode.getType()) {
                arrayList.add((SceneNodeImpl)sceneNode);
                continue;
            }
            if (sceneNode.getShape() != null) {
                arrayList.add((SceneNodeImpl)sceneNode);
            }
            if (sceneNode.getChildren().size() <= 0) continue;
            arrayList.addAll(GrowEffect.getBasicShapesOfElement((SceneNodeImpl)sceneNode));
        }
        return arrayList;
    }

    private void installCenterPointGrow(SceneNodeImpl sceneNodeImpl, Point point, EffectBuilder effectBuilder) {
        this.installGlobalXYGrow(sceneNodeImpl, point, effectBuilder);
    }

    private void installGlobalXYGrow(SceneNodeImpl sceneNodeImpl, Point point, EffectBuilder effectBuilder) {
        for (SceneNodeImpl sceneNodeImpl2 : this.getItemsOfNode(sceneNodeImpl)) {
            Geom geom;
            if (sceneNodeImpl2.getShape() == null || (geom = sceneNodeImpl2.getRenderInfo().getRenderGeom()) == null) continue;
            effectBuilder.addAnimatedMorph(sceneNodeImpl2, InterpolatorFactory.getGeomInterpolator(this, 0.0, 1.0, GrowEffect.projectToPoint(geom, point), geom, false));
        }
    }

    private void installBottomUpGrow(SceneNodeImpl sceneNodeImpl, boolean bl, double d, EffectBuilder effectBuilder) {
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        HashMap<Integer, List<SceneNodeImpl>> hashMap = new HashMap<Integer, List<SceneNodeImpl>>();
        ArrayList<SceneNodeImpl> arrayList2 = new ArrayList<SceneNodeImpl>();
        ArrayList<SceneNodeImpl> arrayList3 = new ArrayList<SceneNodeImpl>();
        ArrayList<SceneNodeImpl> arrayList4 = new ArrayList<SceneNodeImpl>();
        if (sceneNodeImpl.getChildren().size() == 0) {
            return;
        }
        this.processBottomUpGrowItems(sceneNodeImpl.getChildren(), bl, arrayList, hashMap, arrayList2, arrayList3, arrayList4);
        for (SceneNodeImpl sceneNodeImpl2 : arrayList) {
            this.installLateFadeIn(sceneNodeImpl2, effectBuilder);
        }
        this.installBarBottomUpGrow(bl, d, effectBuilder, hashMap);
        this.installPathBottomUpGrow(bl, d, effectBuilder, arrayList2);
        this.installLineBottomUpGrow(bl, d, effectBuilder, arrayList3);
        this.installPointBottomUpGrow(bl, d, effectBuilder, arrayList4);
    }

    private void processBottomUpGrowItems(List<SceneNode> list, boolean bl, List<SceneNodeImpl> list2, Map<Integer, List<SceneNodeImpl>> map, List<SceneNodeImpl> list3, List<SceneNodeImpl> list4, List<SceneNodeImpl> list5) {
        for (SceneNode sceneNode : list) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneNode;
            ShapeInfo shapeInfo = sceneNodeImpl.getShape();
            List<SceneNode> list6 = sceneNodeImpl.getChildren();
            if (list6.size() > 0) {
                if (shapeInfo instanceof MultiPartText) {
                    this.getItemsOfList(list2, list6);
                    continue;
                }
                this.processBottomUpGrowItems(list6, bl, list2, map, list3, list4, list5);
                continue;
            }
            if (shapeInfo == null) continue;
            if (shapeInfo.type() == 1002) {
                Point point = sceneNodeImpl.getRenderInfo().getRenderGeom().getCenter();
                double d = bl ? point.getY() : point.getX();
                int n = (int)Math.round(1000.0 * d);
                List<SceneNodeImpl> list7 = map.get(n);
                if (list7 == null) {
                    list7 = new ArrayList<SceneNodeImpl>();
                    map.put(n, list7);
                }
                list7.add(sceneNodeImpl);
                continue;
            }
            if (shapeInfo.type() == 1004 || shapeInfo.type() == 1003) {
                list3.add(sceneNodeImpl);
                continue;
            }
            if (shapeInfo.type() == 1000) {
                list4.add(sceneNodeImpl);
                continue;
            }
            if (shapeInfo.type() == 1001) {
                list5.add(sceneNodeImpl);
                continue;
            }
            if (!(shapeInfo instanceof Text)) continue;
            list2.add(sceneNodeImpl);
        }
    }

    private void installPathBottomUpGrow(boolean bl, double d, EffectBuilder effectBuilder, List<SceneNodeImpl> list) {
        double d2 = GrowEffect.getPathMaxDistance(bl, d, list);
        double d3 = 0.0;
        for (SceneNodeImpl sceneNodeImpl : list) {
            double d4;
            int n;
            double[] dArray;
            double[] dArray2;
            Poly poly = sceneNodeImpl.getRenderInfo().getRenderGeom().asBasic().asPoly();
            if (bl) {
                dArray2 = poly.getY();
                dArray = new double[poly.getY().length];
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = d;
                    d4 = poly.getX()[n];
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) continue;
                    d3 = Math.max(d3, Math.abs(d4 - d));
                }
            } else {
                dArray = poly.getX();
                dArray2 = new double[poly.getX().length];
                for (n = 0; n < dArray2.length; ++n) {
                    dArray2[n] = d;
                    d4 = poly.getY()[n];
                    if (Double.isNaN(d4) || Double.isInfinite(d4)) continue;
                    d3 = Math.max(d3, Math.abs(d4 - d));
                }
            }
            Poly poly2 = new Poly(dArray, dArray2, poly.isClosed());
            effectBuilder.addAnimatedMorph(sceneNodeImpl, InterpolatorFactory.getGeomInterpolator(this, 0.0, d3 / d2, poly2, poly, false));
        }
    }

    private static double getPathMaxDistance(boolean bl, double d, List<SceneNodeImpl> list) {
        double d2 = 0.0;
        for (SceneNodeImpl sceneNodeImpl : list) {
            double[] dArray;
            Poly poly = sceneNodeImpl.getRenderInfo().getRenderGeom().asBasic().asPoly();
            for (double d3 : dArray = bl ? poly.getX() : poly.getY()) {
                if (Double.isNaN(d3) || Double.isInfinite(d3)) continue;
                d2 = Math.max(d2, Math.abs(d3 - d));
            }
        }
        return d2;
    }

    private void installLineBottomUpGrow(boolean bl, double d, EffectBuilder effectBuilder, List<SceneNodeImpl> list) {
        double d2;
        Line line;
        double d3 = 0.01;
        for (SceneNodeImpl sceneNodeImpl : list) {
            line = (Line)sceneNodeImpl.getRenderInfo().getRenderGeom();
            d2 = bl ? Math.max(Math.abs(line.getX1() - d), Math.abs(line.getX2() - d)) : Math.max(Math.abs(line.getY1() - d), Math.abs(line.getY2() - d));
            d3 = Math.max(d3, d2);
        }
        for (SceneNodeImpl sceneNodeImpl : list) {
            Line line2;
            line = (Line)sceneNodeImpl.getRenderInfo().getRenderGeom();
            if (bl) {
                line2 = new Line(d, line.getY1(), d, line.getY2());
                d2 = Math.max(Math.abs(line.getX1() - d), Math.abs(line.getX2() - d));
            } else {
                line2 = new Line(line.getX1(), d, line.getX2(), d);
                d2 = Math.max(Math.abs(line.getY1() - d), Math.abs(line.getY2() - d));
            }
            effectBuilder.addAnimatedMorph(sceneNodeImpl, InterpolatorFactory.getGeomInterpolator(this, 0.0, d2 / d3, line2, line, false));
        }
    }

    private void installPointBottomUpGrow(boolean bl, double d, EffectBuilder effectBuilder, List<SceneNodeImpl> list) {
        Circle circle;
        double d2 = 0.01;
        for (SceneNodeImpl sceneNodeImpl : list) {
            circle = (Circle)sceneNodeImpl.getRenderInfo().getRenderGeom();
            double d3 = bl ? Math.abs(circle.getX() - d) : Math.abs(circle.getY() - d);
            d2 = Math.max(d2, d3);
        }
        for (SceneNodeImpl sceneNodeImpl : list) {
            double d4;
            Circle circle2;
            circle = (Circle)sceneNodeImpl.getRenderInfo().getRenderGeom();
            if (bl) {
                circle2 = new Circle(d, circle.getY(), circle.getR());
                d4 = Math.abs(circle.getX() - d);
            } else {
                circle2 = new Circle(circle.getX(), d, circle.getR());
                d4 = Math.abs(circle.getY() - d);
            }
            effectBuilder.addAnimatedMorph(sceneNodeImpl, InterpolatorFactory.getGeomInterpolator(this, 0.0, d4 / d2, circle2, circle, false));
        }
    }

    private void installBarBottomUpGrow(boolean bl, double d, EffectBuilder effectBuilder, Map<Integer, List<SceneNodeImpl>> map) {
        double d2;
        double d3 = Double.NEGATIVE_INFINITY;
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        HashMap<Integer, Double> hashMap2 = new HashMap<Integer, Double>();
        HashMap<Integer, Double> hashMap3 = new HashMap<Integer, Double>();
        boolean bl2 = true;
        for (Integer n : map.keySet()) {
            List<SceneNodeImpl> list = map.get(n);
            boolean bl3 = false;
            d2 = Double.POSITIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (SceneNodeImpl sceneNodeImpl : list) {
                Rect rect = (Rect)sceneNodeImpl.getRenderInfo().getRenderGeom();
                if (bl) {
                    if (Math.abs(rect.getX() - d) <= 0.5 || Math.abs(rect.getX2() - d) <= 0.5) {
                        bl3 = true;
                    }
                    d2 = Math.min(d2, rect.getX());
                    d4 = Math.max(d4, rect.getX2());
                    continue;
                }
                if (Math.abs(rect.getY() - d) <= 0.5 || Math.abs(rect.getY2() - d) <= 0.5) {
                    bl3 = true;
                }
                d2 = Math.min(d2, rect.getY());
                d4 = Math.max(d4, rect.getY2());
            }
            double d5 = d4 - d2;
            d3 = Math.max(d3, d5);
            hashMap.put(n, d5);
            hashMap2.put(n, d2);
            hashMap3.put(n, d4);
            if (bl3) continue;
            bl2 = false;
        }
        for (Integer n : map.keySet()) {
            double d6 = (Double)hashMap.get(n) / d3;
            d2 = bl2 ? d : ((Double)hashMap2.get(n) + (Double)hashMap3.get(n)) / 2.0;
            for (SceneNodeImpl sceneNodeImpl : map.get(n)) {
                Rect rect = (Rect)sceneNodeImpl.getRenderInfo().getRenderGeom();
                double d7 = rect.getX();
                double d8 = rect.getY();
                double d9 = rect.getWidth();
                double d10 = rect.getHeight();
                if (bl) {
                    d7 = d2;
                    d9 = 0.0;
                } else {
                    d8 = d2;
                    d10 = 0.0;
                }
                Rect rect2 = new Rect(d7, d8, d9, d10);
                effectBuilder.addAnimatedMorph(sceneNodeImpl, InterpolatorFactory.getGeomInterpolator(this, 0.0, d6, rect2, rect, false));
            }
        }
    }

    private void installLateFadeIn(SceneNodeImpl sceneNodeImpl, EffectBuilder effectBuilder) {
        StyleKeyFrame[] styleKeyFrameArray;
        if (sceneNodeImpl == null) {
            return;
        }
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            this.installLateFadeIn((SceneNodeImpl)sceneNode, effectBuilder);
        }
        if (sceneNodeImpl.getShape() == null) {
            return;
        }
        if (sceneNodeImpl.getShape() instanceof Text) {
            styleKeyFrameArray = this.makeFadingKeyFrames(sceneNodeImpl, 0.95, 0.0, 1.0, 1.0);
            effectBuilder.addAnimatedStyle(sceneNodeImpl, InterpolatorFactory.getStyleInterpolator(this, 0.0, 1.0, styleKeyFrameArray));
        } else {
            styleKeyFrameArray = this.makeFadingKeyFrames(sceneNodeImpl, 0.95, 0.001, 1.0, 1.0);
            effectBuilder.addAnimatedStyle(sceneNodeImpl, InterpolatorFactory.getStyleInterpolator(this, 0.0, 1.0, styleKeyFrameArray));
        }
    }

    private List<SceneNodeImpl> getItemsOfNode(SceneNodeImpl sceneNodeImpl) {
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        this.getItemsOfList(arrayList, sceneNodeImpl.getChildren());
        return arrayList;
    }

    private void getItemsOfList(List<SceneNodeImpl> list, List<SceneNode> list2) {
        for (SceneNode sceneNode : list2) {
            if (sceneNode.getChildren().size() > 0) {
                this.getItemsOfList(list, sceneNode.getChildren());
                continue;
            }
            if (sceneNode.getId() == null) continue;
            list.add((SceneNodeImpl)sceneNode);
        }
    }

    static Geom projectToLocalCenter(Geom geom) {
        return GrowEffect.projectToPoint(geom, geom.getCenter());
    }

    private static Geom projectToPoint(Geom geom, Point point) {
        int n = geom.type();
        double d = point.getX();
        double d2 = point.getY();
        if (n == 1000) {
            return new Line(d, d2, d, d2);
        }
        if (n == 1002) {
            return new Rect(d, d2, 0.0, 0.0);
        }
        if (n == 1005) {
            return new RoundedRect(d, d2, 0.0, 0.0, 0.0);
        }
        if (n == 1001) {
            return new Circle(d, d2, 0.0);
        }
        if (n == 1003) {
            Poly poly = (Poly)geom;
            int n2 = poly.getPointCount();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = d;
                dArray2[i] = d2;
            }
            return new Poly(dArray, dArray2, poly.isClosed());
        }
        if (n == 1004) {
            Curve curve = (Curve)geom;
            int n3 = curve.getX().length;
            double[] dArray = new double[n3];
            double[] dArray3 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray[i] = d;
                dArray3[i] = d2;
            }
            return new Curve(dArray, dArray3, curve.getControls(), curve.isClosed());
        }
        CompositeGeom compositeGeom = (CompositeGeom)geom;
        int n4 = compositeGeom.getParts().length;
        Geom[] geomArray = new Geom[n4];
        for (int i = 0; i < n4; ++i) {
            geomArray[i] = GrowEffect.projectToPoint(compositeGeom.getParts()[i], point);
        }
        return new CompositeGeom(geomArray, compositeGeom.getOddEven(), null);
    }
}

