/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.interaction.HighlightRepresentation;
import com.ibm.vis.interaction.internal.SceneState;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.LinkedHashSet;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StyleEffect
extends Effect {
    private HighlightRepresentation representation;
    private final int id;
    private final SceneState sceneState;
    private final Set<SceneNodeImpl> editedSceneItems;

    public StyleEffect(int n, HighlightRepresentation highlightRepresentation, int n2, SceneState sceneState) {
        super(n);
        this.sceneState = sceneState;
        this.setRepresentation(highlightRepresentation);
        this.animated = false;
        this.id = n2;
        this.editedSceneItems = new LinkedHashSet<SceneNodeImpl>();
    }

    @Override
    public void setTargetIDs(Set<String> set) {
        if (set != null) {
            super.setTargetIDs(set);
        }
        this.sceneState.setSelectedItemsIDs(set, this.id);
    }

    public void setRepresentation(HighlightRepresentation highlightRepresentation) {
        this.representation = highlightRepresentation;
    }

    public void apply() {
        if (this.builder != null) {
            this.setTargetIDs(this.newTargetIds);
            if (this.representation.isOverlay()) {
                this.addedSceneItems = this.builder.addHighlightShapes(this.representation, this.newTargetIds, this.id);
            } else {
                StyleSpec styleSpec = (StyleSpec)SpecUtil.createSpecObject(this.representation.getStyle(), "StyleSpec");
                for (String string : this.newTargetIds) {
                    SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)this.builder.sceneTree.findNode(string);
                    if (sceneNodeImpl == null) continue;
                    this.setKeyFrameAndAddOverrideStyle(sceneNodeImpl, styleSpec);
                }
                for (String string : this.newTargetIds) {
                    this.updateEditSceneItemsList((SceneNodeImpl)this.builder.sceneTree.findNode(string));
                }
            }
        }
        this.newTargetIds = new LinkedHashSet();
    }

    private void setKeyFrameAndAddOverrideStyle(SceneNodeImpl sceneNodeImpl, StyleSpec styleSpec) {
        if (sceneNodeImpl instanceof CompositeSceneNode) {
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                this.setKeyFrameAndAddOverrideStyle((SceneNodeImpl)sceneNode, styleSpec);
            }
        } else {
            StyleKeyFrame[] styleKeyFrameArray = new StyleKeyFrame[]{this.makeSimpleStyleKeyFrame(sceneNodeImpl, styleSpec, this.representation.isOverlay())};
            this.builder.addOverrideStyle(sceneNodeImpl, InterpolatorFactory.getStyleInterpolator(this, 0.0, 1.0, styleKeyFrameArray));
        }
    }

    private void updateEditSceneItemsList(SceneNodeImpl sceneNodeImpl) {
        if (sceneNodeImpl instanceof CompositeSceneNode) {
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                this.updateEditSceneItemsList((SceneNodeImpl)sceneNode);
            }
        } else {
            this.editedSceneItems.add(sceneNodeImpl);
        }
    }

    @Override
    public void clear() {
        this.remove();
    }

    public void remove() {
        for (SceneNodeImpl sceneNodeImpl : this.editedSceneItems) {
            if (sceneNodeImpl == null) continue;
            this.builder.removeOverrideStyle(sceneNodeImpl);
        }
        this.editedSceneItems.clear();
        this.setTargetIDs(new LinkedHashSet<String>());
        if (this.builder != null) {
            this.builder.removeAddedHighlightShapes(this.addedSceneItems);
        }
        this.addedSceneItems = null;
    }
}

