/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.AxisInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorFactory;
import com.ibm.vis.engine.internal.interaction.interpolation.TransformInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.WedgeInterpolator;
import com.ibm.vis.engine.internal.interaction.morph.FeatureGroup;
import com.ibm.vis.engine.internal.interaction.morph.ItemMatcher;
import com.ibm.vis.engine.internal.interaction.morph.MorphablePair;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.interaction.EffectTarget;
import com.ibm.vis.scenetree.internal.CoordinatesSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Transition
extends Effect {
    private static final String TRANSITION_PREFIX = "_trans_";
    private final HashMap<String, AxisInterpolator> axisInterpolators;

    public Transition(int n) {
        super(n);
        this.setTarget(0);
        this.axisInterpolators = new HashMap();
    }

    @Override
    public void setTargets(int n, EffectTarget[] effectTargetArray) {
        throw new EngineException("Transition can only target all shapes. No effect targets are allowed.", ErrorCode.ENGINE_TRANSITION_UNSUPPORTED_TARGET, null);
    }

    @Override
    public void installWithPrevious(EffectBuilder effectBuilder, SceneTree sceneTree) {
        super.installWithPrevious(effectBuilder, sceneTree);
        if (sceneTree == null || sceneTree == effectBuilder.sceneTree) {
            return;
        }
        ItemMatcher itemMatcher = new ItemMatcher(sceneTree, effectBuilder.sceneTree);
        this.buildAxisInterpolators(sceneTree, effectBuilder.sceneTree, itemMatcher);
        for (FeatureGroup featureGroup : itemMatcher.featureGroups) {
            this.prepareMatchesForTransitioning(featureGroup);
        }
        for (FeatureGroup featureGroup : itemMatcher.featureGroups) {
            this.addTransitionsForFeatureGroup(effectBuilder, featureGroup);
        }
    }

    private void buildAxisInterpolators(SceneTree sceneTree, SceneTree sceneTree2, ItemMatcher itemMatcher) {
        String string;
        String string2;
        String string3;
        AxisInterpolator axisInterpolator;
        this.axisInterpolators.clear();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.makeScaleMethods(sceneTree, hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        this.makeScaleMethods(sceneTree2, hashMap2);
        for (FeatureGroup featureGroup : itemMatcher.featureGroups) {
            if (!AxisInterpolator.isAxisMarkGroup(featureGroup) || !(axisInterpolator = new AxisInterpolator()).setInterpolator(featureGroup, string3 = (String)hashMap.get(string2 = AxisInterpolator.getAxisGroupID(featureGroup)), string = (String)hashMap2.get(string2))) continue;
            this.axisInterpolators.put(string2, axisInterpolator);
        }
        for (FeatureGroup featureGroup : itemMatcher.featureGroups) {
            if (!AxisInterpolator.isAxisTickGroup(featureGroup)) continue;
            string2 = AxisInterpolator.getAxisGroupID(featureGroup);
            string3 = (String)hashMap.get(string2);
            string = (String)hashMap2.get(string2);
            axisInterpolator = this.axisInterpolators.get(string2);
            if (axisInterpolator != null) {
                axisInterpolator.setInterpolator(featureGroup, string3, string);
                continue;
            }
            axisInterpolator = new AxisInterpolator();
            if (!axisInterpolator.setInterpolator(featureGroup, string3, string)) continue;
            this.axisInterpolators.put(string2, axisInterpolator);
        }
    }

    private void makeScaleMethods(SceneTree sceneTree, Map<String, String> map) {
        for (SceneNode sceneNode : sceneTree.getRoot().getChildren()) {
            DimensionSpec[] dimensionSpecArray;
            if (sceneNode.getClassId() != SceneNodeClassId.COORDINATES || (dimensionSpecArray = ((CoordinatesSceneNode)sceneNode).getCoordinates().dimensions) == null) continue;
            String string = sceneNode.getId();
            int n = string.indexOf("Coords");
            String string2 = string.substring(0, n);
            for (int i = 0; i < dimensionSpecArray.length; ++i) {
                String string3 = string2 + "A" + i;
                String string4 = this.getMethod(dimensionSpecArray[i]);
                map.put(string3, string4);
            }
        }
    }

    private String getMethod(DimensionSpec dimensionSpec) {
        ScaleSpec scaleSpec = dimensionSpec.scale;
        if (scaleSpec == null || scaleSpec.spans == null || scaleSpec.spans.length == 0) {
            return "linear";
        }
        SpanSpec[] spanSpecArray = scaleSpec.spans;
        if (spanSpecArray.length == 1) {
            return spanSpecArray[0].method;
        }
        return "multiple";
    }

    private void prepareMatchesForTransitioning(FeatureGroup featureGroup) {
        ArrayList<MorphablePair> arrayList = new ArrayList<MorphablePair>();
        ArrayList<MorphablePair> arrayList2 = new ArrayList<MorphablePair>();
        ArrayList<MorphablePair> arrayList3 = new ArrayList<MorphablePair>();
        ArrayList<SceneNodeImpl> arrayList4 = new ArrayList<SceneNodeImpl>();
        ArrayList<SceneNodeImpl> arrayList5 = new ArrayList<SceneNodeImpl>();
        for (MorphablePair morphablePair : featureGroup.matches) {
            if (SceneNodeType.TEXT == morphablePair.type) {
                this.processLabelMatch(morphablePair, arrayList2, arrayList3, arrayList4, arrayList5);
                continue;
            }
            if (!SceneIdUtil.isLegendBackgroundId(morphablePair.source.getId())) continue;
            arrayList.add(morphablePair);
        }
        featureGroup.removePairs(arrayList);
        featureGroup.processLabelTransition(arrayList2, arrayList3, arrayList4, arrayList5);
    }

    private void processLabelMatch(MorphablePair morphablePair, List<MorphablePair> list, List<MorphablePair> list2, List<SceneNodeImpl> list3, List<SceneNodeImpl> list4) {
        int n;
        List<SceneNodeImpl> list5 = Transition.getTextParts(morphablePair.source);
        List<SceneNodeImpl> list6 = Transition.getTextParts(morphablePair.target);
        if (SceneNodeType.MULTI_TEXT != morphablePair.source.getType() && SceneNodeType.MULTI_TEXT != morphablePair.target.getType()) {
            list.add(morphablePair);
        }
        int n2 = Math.min(list5.size(), list6.size());
        for (n = 0; n < n2; ++n) {
            list2.add(new MorphablePair(SceneNodeType.TEXT, list5.get(n), list6.get(n)));
        }
        for (n = n2; n < list5.size(); ++n) {
            list3.add(list5.get(n));
        }
        for (n = n2; n < list6.size(); ++n) {
            list4.add(list6.get(n));
        }
    }

    static List<SceneNodeImpl> getTextParts(SceneNodeImpl sceneNodeImpl) {
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        if (sceneNodeImpl.getChildren().size() == 0) {
            arrayList.add(sceneNodeImpl);
        } else {
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                for (SceneNode sceneNode2 : sceneNode.getChildren()) {
                    arrayList.add((SceneNodeImpl)sceneNode2);
                }
            }
        }
        return arrayList;
    }

    private void fadeInUnmatchedTargest(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        for (SceneNodeImpl sceneNodeImpl : featureGroup.unmatchedTargets) {
            if (sceneNodeImpl.getChildren().size() == 0) {
                this.addFadeInTransition(effectBuilder, sceneNodeImpl);
                continue;
            }
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                this.addFadeInTransition(effectBuilder, (SceneNodeImpl)sceneNode);
            }
        }
    }

    private void addUnmatchedSources(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        for (SceneNodeImpl sceneNodeImpl : featureGroup.unmatchedSources) {
            if (sceneNodeImpl.getChildren().size() == 0) {
                this.addUnmatchedTargetsForFadeout(effectBuilder, sceneNodeImpl, featureGroup);
                continue;
            }
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                this.addUnmatchedTargetsForFadeout(effectBuilder, (SceneNodeImpl)sceneNode, featureGroup);
            }
        }
    }

    private void addUnmatchedTargetsForFadeout(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl, FeatureGroup featureGroup) {
        if (featureGroup.targetAddLocation == null) {
            return;
        }
        SceneNodeImpl sceneNodeImpl2 = SceneNodeFactory.cloneNode(sceneNodeImpl);
        sceneNodeImpl2.setId(TRANSITION_PREFIX + sceneNodeImpl.getId());
        effectBuilder.addTemporaryItem(sceneNodeImpl2, featureGroup.targetAddLocation);
        this.addFadeOutTransition(effectBuilder, sceneNodeImpl2);
    }

    private void addTransitionsForFeatureGroup(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        this.addCoordinateInterpolation(effectBuilder, featureGroup);
        if (Transition.isLegendGroup(featureGroup)) {
            return;
        }
        if (this.addTransitionsForAxisGroup(effectBuilder, featureGroup)) {
            return;
        }
        this.addTransitionsForMorphablePairs(effectBuilder, featureGroup);
        this.addUnmatchedSources(effectBuilder, featureGroup);
        this.fadeInUnmatchedTargest(effectBuilder, featureGroup);
    }

    private static boolean isLegendGroup(FeatureGroup featureGroup) {
        return featureGroup.type != null && SceneNodeTypeUtil.isLegend(featureGroup.type);
    }

    private void addCoordinateInterpolation(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        if (Transition.isLegendGroup(featureGroup)) {
            return;
        }
        if (featureGroup.targetGroup != null) {
            this.addNeededClipInterpolation(effectBuilder, featureGroup.targetGroup, featureGroup.sourceClip, featureGroup.targetClip);
            this.addNeededTransformInterpolation(effectBuilder, featureGroup.targetGroup, featureGroup.sourceTransform, featureGroup.targetTransform);
        }
        for (MorphablePair morphablePair : featureGroup.matches) {
            SceneNodeImpl sceneNodeImpl = morphablePair.target;
            String string = sceneNodeImpl.getId();
            if (!SceneIdUtil.isCoordsId(string) && !SceneIdUtil.isOutId(string)) continue;
            SceneNodeImpl sceneNodeImpl2 = morphablePair.source;
            this.addNeededClipInterpolation(effectBuilder, sceneNodeImpl, sceneNodeImpl2.getClipBounds(), sceneNodeImpl.getClipBounds());
            this.addNeededTransformInterpolation(effectBuilder, sceneNodeImpl, sceneNodeImpl2.getTransform(), sceneNodeImpl.getTransform());
        }
    }

    private void addNeededTransformInterpolation(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl, TransformInfo transformInfo, TransformInfo transformInfo2) {
        if (FeatureGroup.transformDiffers(transformInfo, transformInfo2)) {
            Interpolator interpolator = InterpolatorFactory.getTransformInterpolator(this, this.morphDuration[0], this.morphDuration[1], transformInfo, transformInfo2);
            effectBuilder.addAnimatedTransform(sceneNodeImpl, interpolator);
        }
    }

    private void addNeededClipInterpolation(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl, Rect rect, Rect rect2) {
        if (FeatureGroup.geomDiffers(rect, rect2)) {
            Interpolator interpolator = InterpolatorFactory.getGeomInterpolator(this, this.morphDuration[0], this.morphDuration[1], rect, rect2, true);
            effectBuilder.addAnimatedClip(sceneNodeImpl, interpolator);
        }
    }

    private boolean addTransitionsForAxisGroup(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        StyleKeyFrame[] styleKeyFrameArray;
        Object object;
        TransformInfo transformInfo;
        SceneNodeImpl sceneNodeImpl;
        if (!AxisInterpolator.isAxisGroup(featureGroup)) {
            return false;
        }
        String string = AxisInterpolator.getAxisGroupID(featureGroup);
        AxisInterpolator axisInterpolator = this.axisInterpolators.get(string);
        if (axisInterpolator == null) {
            return false;
        }
        this.addTransitionsForMorphablePairs(effectBuilder, featureGroup);
        for (SceneNodeImpl sceneNodeImpl2 : featureGroup.unmatchedTargets) {
            sceneNodeImpl = SceneNodeFactory.cloneNode(sceneNodeImpl2);
            transformInfo = axisInterpolator.makeSourceAffine(sceneNodeImpl2);
            if (transformInfo != null) {
                object = new TransformInterpolator(this, this.morphDuration[0], this.morphDuration[1], transformInfo, sceneNodeImpl.getTransform());
                effectBuilder.addAnimatedTransform(sceneNodeImpl2, (ScenePartInterpolator)object);
            }
            object = axisInterpolator.getTransitionTimesForItems(sceneNodeImpl2, sceneNodeImpl2);
            styleKeyFrameArray = this.makeAxisFadingKeyFrames(sceneNodeImpl2, true, (double[])object);
            this.addAnimatedStyle(effectBuilder, sceneNodeImpl2, styleKeyFrameArray);
        }
        for (SceneNodeImpl sceneNodeImpl2 : featureGroup.unmatchedSources) {
            sceneNodeImpl = SceneNodeFactory.cloneNode(sceneNodeImpl2);
            transformInfo = axisInterpolator.makeTargetAffine(sceneNodeImpl2);
            if (transformInfo != null) {
                object = new TransformInterpolator(this, this.morphDuration[0], this.morphDuration[1], sceneNodeImpl.getTransform(), transformInfo);
                effectBuilder.addAnimatedTransform(sceneNodeImpl, (ScenePartInterpolator)object);
            }
            sceneNodeImpl.setId(TRANSITION_PREFIX + sceneNodeImpl2.getId());
            effectBuilder.addTemporaryItem(sceneNodeImpl, featureGroup.targetAddLocation);
            object = axisInterpolator.getTransitionTimesForItems(sceneNodeImpl2, sceneNodeImpl);
            styleKeyFrameArray = this.makeAxisFadingKeyFrames(sceneNodeImpl, false, (double[])object);
            this.addAnimatedStyle(effectBuilder, sceneNodeImpl, styleKeyFrameArray);
        }
        return true;
    }

    private double[] scaleByMoveDuration(double[] dArray) {
        double[] dArray2 = new double[]{this.morphDuration[0] + (this.morphDuration[1] - this.morphDuration[0]) * dArray[0], this.morphDuration[0] + (this.morphDuration[1] - this.morphDuration[0]) * dArray[1]};
        return dArray2;
    }

    private StyleKeyFrame[] makeAxisFadingKeyFrames(SceneNodeImpl sceneNodeImpl, boolean bl, double[] dArray) {
        double[] dArray2 = this.scaleByMoveDuration(dArray);
        if (dArray[0] == 0.0 && dArray[1] == 1.0) {
            double d = bl ? 0.001 : 1.0;
            double d2 = bl ? 1.0 : 0.001;
            return this.buildFadingFrames(sceneNodeImpl, new double[][]{{0.0, d}, {dArray2[0], d}, {dArray2[1], d2}, {1.0, d2}});
        }
        if (bl) {
            double d = dArray[0];
            double d3 = dArray2[0];
            double d4 = d3 + 0.001 < dArray2[1] ? d3 + 0.001 : (d3 + dArray2[1]) / 2.0;
            return this.buildFadingFrames(sceneNodeImpl, new double[][]{{0.0, 0.001}, {d3, 0.001}, {d4, d}, {dArray2[1], 1.0}, {1.0, 1.0}});
        }
        double d = 1.0 - dArray[1];
        double d5 = dArray2[1];
        double d6 = d5 - 0.001 > dArray2[0] ? d5 - 0.001 : (d5 + dArray2[0]) / 2.0;
        return this.buildFadingFrames(sceneNodeImpl, new double[][]{{0.0, 1.0}, {dArray2[0], 1.0}, {d6, d}, {d5, 0.001}, {1.0, 0.001}});
    }

    private StyleKeyFrame[] buildFadingFrames(SceneNodeImpl sceneNodeImpl, double[][] dArray) {
        assert (dArray.length >= 4);
        int n = dArray[1][0] == 0.0 ? 1 : 0;
        int n2 = dArray[dArray.length - 2][0] == 1.0 ? dArray.length - 1 : dArray.length;
        StyleKeyFrame[] styleKeyFrameArray = new StyleKeyFrame[n2 - n];
        for (int i = n; i < n2; ++i) {
            styleKeyFrameArray[i - n] = this.makeFadingKeyFrame(sceneNodeImpl, dArray[i][0], dArray[i][1]);
        }
        return styleKeyFrameArray;
    }

    private void addTransitionsForMorphablePairs(EffectBuilder effectBuilder, FeatureGroup featureGroup) {
        for (MorphablePair morphablePair : featureGroup.matches) {
            this.addAnimatedMorph(effectBuilder, morphablePair);
        }
    }

    void addAnimatedMorph(EffectBuilder effectBuilder, MorphablePair morphablePair) {
        if (morphablePair.source.getRenderInfo().getRenderText() != null && morphablePair.target.getRenderInfo().getRenderText() != null) {
            this.addTextMorph(effectBuilder, morphablePair);
        } else if (((Shape)morphablePair.source.getShape()).getType() == 1005 && ((Shape)morphablePair.target.getShape()).getType() == 1005) {
            this.addWedgeMorph(effectBuilder, morphablePair);
        } else if (((Shape)morphablePair.source.getShape()).getType() == 1007 && ((Shape)morphablePair.target.getShape()).getType() == 1007) {
            this.addMultiTextMorph(effectBuilder, morphablePair);
        } else {
            this.addGeomMorph(effectBuilder, morphablePair);
            return;
        }
        StyleKeyFrame[] styleKeyFrameArray = this.makeStylekeyFrames(morphablePair.source, morphablePair.target, false);
        if (styleKeyFrameArray != null) {
            this.addAnimatedStyle(effectBuilder, morphablePair.target, styleKeyFrameArray);
        }
    }

    public void addTextMorph(EffectBuilder effectBuilder, MorphablePair morphablePair) {
        SceneNodeRenderInfo sceneNodeRenderInfo = morphablePair.source.getRenderInfo();
        SceneNodeRenderInfo sceneNodeRenderInfo2 = morphablePair.target.getRenderInfo();
        if (FeatureGroup.textDiffers(sceneNodeRenderInfo.getRenderText(), sceneNodeRenderInfo2.getRenderText()) || FeatureGroup.transformDiffers(sceneNodeRenderInfo.getTransform(), sceneNodeRenderInfo2.getTransform())) {
            TransformInfo transformInfo = morphablePair.source.getTransform();
            TransformInfo transformInfo2 = morphablePair.target.getTransform();
            Interpolator interpolator = InterpolatorFactory.getTextInterpolator(this, this.morphDuration[0], this.morphDuration[1], sceneNodeRenderInfo.getRenderText(), sceneNodeRenderInfo2.getRenderText(), transformInfo, transformInfo2);
            effectBuilder.addAnimatedText(morphablePair.target, interpolator);
        } else {
            Rect rect;
            Rect rect2 = morphablePair.source.getRenderInfo().getRenderBounds();
            if (FeatureGroup.geomDiffers(rect2, rect = morphablePair.target.getRenderInfo().getRenderBounds())) {
                Interpolator interpolator = InterpolatorFactory.getGeomInterpolator(this, this.morphDuration[0], this.morphDuration[1], rect2, rect, true);
                effectBuilder.addAnimatedMorph(morphablePair.target, interpolator);
            }
        }
    }

    private void addWedgeMorph(EffectBuilder effectBuilder, MorphablePair morphablePair) {
        Shape shape = (Shape)morphablePair.source.getShape();
        Shape shape2 = (Shape)morphablePair.target.getShape();
        WedgeInterpolator wedgeInterpolator = new WedgeInterpolator(this, this.morphDuration[0], this.morphDuration[1], (Wedge)shape.getGeom(), (Wedge)shape2.getGeom());
        effectBuilder.addAnimatedMorph(morphablePair.target, wedgeInterpolator);
    }

    private void addMultiTextMorph(EffectBuilder effectBuilder, MorphablePair morphablePair) {
        TransformInfo transformInfo = morphablePair.source.getTransform();
        TransformInfo transformInfo2 = morphablePair.target.getTransform();
        Interpolator interpolator = InterpolatorFactory.getTransformInterpolator(this, this.morphDuration[0], this.morphDuration[1], transformInfo, transformInfo2);
        effectBuilder.addAnimatedTransform(morphablePair.target, interpolator);
    }

    private static TransformInfo translatedTransform(TransformInfo transformInfo, Point point) {
        Affine affine = Affine.makeTransform(point.getX(), point.getY());
        TransformInfoImpl transformInfoImpl = new TransformInfoImpl();
        if (transformInfo != null) {
            transformInfoImpl.setAffine(transformInfo.getAffine() == null ? affine : transformInfo.getAffine().multiply(affine));
        } else {
            transformInfoImpl.setAffine(affine);
        }
        return transformInfoImpl;
    }

    private static Geom translatedGeom(Geom geom, Point point) {
        Geom geom2 = geom.copy();
        geom2.transform(1.0, point.getX(), 1.0, point.getY());
        return geom2;
    }

    void addGeomMorph(EffectBuilder effectBuilder, MorphablePair morphablePair) {
        Interpolator interpolator;
        Geom geom = morphablePair.source.getRenderInfo().getRenderGeom();
        TransformInfo transformInfo = morphablePair.source.getTransform();
        Geom geom2 = null;
        if (geom != null) {
            transformInfo = Transition.translatedTransform(transformInfo, geom.getCenter());
            geom2 = Transition.translatedGeom(geom, geom.getCenter().negate());
        }
        Geom geom3 = morphablePair.target.getRenderInfo().getRenderGeom();
        TransformInfo transformInfo2 = morphablePair.target.getTransform();
        Geom geom4 = null;
        if (geom3 != null) {
            transformInfo2 = Transition.translatedTransform(transformInfo2, geom3.getCenter());
            geom4 = Transition.translatedGeom(geom3, geom3.getCenter().negate());
        }
        StyleKeyFrame[] styleKeyFrameArray = this.makeStylekeyFrames(morphablePair.source, morphablePair.target, true);
        this.addAnimatedStyle(effectBuilder, morphablePair.target, styleKeyFrameArray);
        if (geom2 != null && geom4 != null) {
            interpolator = InterpolatorFactory.getGeomInterpolator(this, this.morphDuration[0], this.morphDuration[1], geom2, geom4, true);
            effectBuilder.addAnimatedMorph(morphablePair.target, interpolator);
        }
        interpolator = InterpolatorFactory.getTransformInterpolator(this, this.morphDuration[0], this.morphDuration[1], transformInfo, transformInfo2);
        effectBuilder.addAnimatedTransform(morphablePair.target, interpolator);
    }

    private void addFadeInTransition(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl) {
        StyleKeyFrame[] styleKeyFrameArray = this.makeFadingKeyFrames(sceneNodeImpl, this.fadeinDuration[0], 0.0, this.fadeinDuration[1], 1.0);
        this.addAnimatedStyle(effectBuilder, sceneNodeImpl, styleKeyFrameArray);
    }

    private void addFadeOutTransition(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl) {
        StyleKeyFrame[] styleKeyFrameArray = this.makeFadingKeyFrames(sceneNodeImpl, this.fadeoutDuration[0], 1.0, this.fadeoutDuration[1], 0.0);
        this.addAnimatedStyle(effectBuilder, sceneNodeImpl, styleKeyFrameArray);
    }

    private void addAnimatedStyle(EffectBuilder effectBuilder, SceneNodeImpl sceneNodeImpl, StyleKeyFrame[] styleKeyFrameArray) {
        if (sceneNodeImpl.getId() == null) {
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                this.addAnimatedStyle(effectBuilder, (SceneNodeImpl)sceneNode, styleKeyFrameArray);
            }
        } else {
            effectBuilder.addAnimatedStyle(sceneNodeImpl, InterpolatorFactory.getStyleInterpolator(this, 0.0, 1.0, styleKeyFrameArray));
        }
    }

    private StyleKeyFrame[] makeStylekeyFrames(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2, boolean bl) {
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        SceneNodeRenderInfo sceneNodeRenderInfo2 = sceneNodeImpl2.getRenderInfo();
        GradientPaintInfo gradientPaintInfo = sceneNodeRenderInfo.getRenderFill();
        GradientPaintInfo gradientPaintInfo2 = sceneNodeRenderInfo2.getRenderFill();
        Stroke stroke = sceneNodeRenderInfo.getRenderStroke();
        Stroke stroke2 = sceneNodeRenderInfo2.getRenderStroke();
        RenderEffects renderEffects = sceneNodeRenderInfo.getRenderEffects();
        RenderEffects renderEffects2 = sceneNodeRenderInfo2.getRenderEffects();
        if (bl || FeatureGroup.fillDiffers(gradientPaintInfo, gradientPaintInfo2) || FeatureGroup.strokeDiffers(stroke, stroke2) || FeatureGroup.effectsDiffers(renderEffects, renderEffects2)) {
            Geom geom = sceneNodeRenderInfo.getRenderGeom();
            Geom geom2 = sceneNodeRenderInfo2.getRenderGeom();
            if (bl) {
                if (gradientPaintInfo != null && geom != null) {
                    gradientPaintInfo = gradientPaintInfo.moveBy(-geom.getCenter().getX(), -geom.getCenter().getY());
                }
                if (gradientPaintInfo2 != null && geom2 != null) {
                    gradientPaintInfo2 = gradientPaintInfo2.moveBy(-geom2.getCenter().getX(), -geom2.getCenter().getY());
                }
            }
            return new StyleKeyFrame[]{new StyleKeyFrame(this.morphDuration[0], gradientPaintInfo, stroke, renderEffects, Transition.getAlpha(sceneNodeImpl)), new StyleKeyFrame(this.morphDuration[1], gradientPaintInfo2, stroke2, renderEffects2, Transition.getAlpha(sceneNodeImpl2))};
        }
        return null;
    }

    private static Double getAlpha(SceneNodeImpl sceneNodeImpl) {
        ImageFill imageFill = sceneNodeImpl.getRenderInfo().getRenderImage();
        return imageFill == null ? null : Double.valueOf(imageFill.getAlpha());
    }
}

