/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.interaction.interpolation.AxisInterpolatorScale;
import com.ibm.vis.engine.internal.interaction.morph.FeatureGroup;
import com.ibm.vis.engine.internal.interaction.morph.MorphablePair;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AxisInterpolator {
    AxisInterpolatorScale source = new AxisInterpolatorScale();
    AxisInterpolatorScale target = new AxisInterpolatorScale();

    public boolean isValid() {
        return this.source.isValid() && this.target.isValid() && this.source.isHorizontal() == this.target.isHorizontal();
    }

    public static boolean isAxisMarkGroup(FeatureGroup featureGroup) {
        return SceneNodeType.AXIS_MARK == featureGroup.type;
    }

    public static boolean isAxisTickGroup(FeatureGroup featureGroup) {
        return SceneNodeType.AXIS_MARK == featureGroup.type || SceneNodeType.AXIS_BACK == featureGroup.type || SceneNodeType.AXIS_MINOR == featureGroup.type;
    }

    public static boolean isAxisGroup(FeatureGroup featureGroup) {
        return AxisInterpolator.isAxisTickGroup(featureGroup) || SceneNodeType.AXIS_LABEL == featureGroup.type;
    }

    public static String getAxisGroupID(FeatureGroup featureGroup) {
        if (!AxisInterpolator.isAxisGroup(featureGroup)) {
            return null;
        }
        return featureGroup.baseId.substring(0, featureGroup.baseId.length() - 1);
    }

    public boolean setInterpolator(FeatureGroup featureGroup, String string, String string2) {
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        for (MorphablePair object : featureGroup.matches) {
            arrayList.add(object.source);
        }
        arrayList.addAll(featureGroup.unmatchedSources);
        ArrayList arrayList2 = new ArrayList();
        for (MorphablePair bl2 : featureGroup.matches) {
            arrayList2.add(bl2.target);
        }
        arrayList2.addAll(featureGroup.unmatchedTargets);
        boolean bl = this.source.setScale(arrayList, string);
        boolean bl2 = this.target.setScale(arrayList2, string2);
        return bl && bl2;
    }

    protected static double getItemValue(SceneNodeImpl sceneNodeImpl) {
        Object object = sceneNodeImpl.getValue();
        if (!BasicFactory.isNumber(object)) {
            return Double.NaN;
        }
        return ((Number)object).doubleValue();
    }

    public TransformInfo makeSourceAffine(SceneNodeImpl sceneNodeImpl) {
        return this.makeAffine(sceneNodeImpl, true);
    }

    public TransformInfo makeTargetAffine(SceneNodeImpl sceneNodeImpl) {
        return this.makeAffine(sceneNodeImpl, false);
    }

    private TransformInfo makeAffine(SceneNodeImpl sceneNodeImpl, boolean bl) {
        if (!this.isValid() || sceneNodeImpl.getShape() == null) {
            return null;
        }
        Shape shape = (Shape)sceneNodeImpl.getShape();
        if (shape.getType() != 1009 && shape.getType() != 1001) {
            return null;
        }
        double d = AxisInterpolator.getItemValue(sceneNodeImpl);
        if (Double.isNaN(d)) {
            return null;
        }
        double d2 = bl ? this.source.getLocation(d) - this.target.getLocation(d) : this.target.getLocation(d) - this.source.getLocation(d);
        Affine affine = sceneNodeImpl.getTransform().getAffine();
        if (affine == null) {
            affine = Affine.identity();
        }
        if (shape.getType() == 1001) {
            affine = this.source.isHorizontal() ? affine.translate(d2, 0.0) : affine.translate(0.0, d2);
        }
        if (shape.getType() == 1009) {
            double d3;
            double d4;
            if (this.source.isHorizontal()) {
                d4 = d2;
                d3 = 0.0;
            } else {
                d4 = 0.0;
                d3 = d2;
            }
            double d5 = affine.m00 * d4 + affine.m10 * d3;
            double d6 = affine.m01 * d4 + affine.m11 * d3;
            affine = affine.translate(d5, d6);
        }
        TransformInfoImpl transformInfoImpl = new TransformInfoImpl();
        transformInfoImpl.setAffine(affine);
        return transformInfoImpl;
    }

    public double[] getTransitionTimesForItems(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        double d = AxisInterpolator.getItemValue(sceneNodeImpl);
        double d2 = AxisInterpolator.getItemValue(sceneNodeImpl2);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return new double[]{0.0, 1.0};
        }
        return this.getTransitionTimes(this.source.getLocation(d), this.target.getLocation(d2));
    }

    public double[] getTransitionTimes(double d, double d2) {
        double d3;
        double d4;
        boolean bl;
        double[] dArray = new double[]{0.0, 1.0};
        if (!this.isValid()) {
            return dArray;
        }
        Range range = this.source.getExtent();
        Range range2 = this.target.getExtent();
        boolean bl2 = range.getMin() - 0.05 <= d && d <= range.getMax() + 0.05;
        boolean bl3 = bl = range2.getMin() - 0.05 <= d2 && d2 <= range2.getMax() + 0.05;
        if (!bl2 && !bl) {
            return dArray;
        }
        if (bl2 && bl) {
            return dArray;
        }
        if (d < range.getMin() || d2 < range2.getMin()) {
            d4 = range.getMin();
            d3 = range2.getMin();
        } else {
            d4 = range.getMax();
            d3 = range2.getMax();
        }
        double d5 = d4 == d ? 0.0 : (d4 - d) / (d2 - d - (d3 - d4));
        if (bl2) {
            dArray[1] = Math.max(d5, 0.001);
        } else {
            dArray[0] = Math.min(d5, 0.999);
        }
        return dArray;
    }
}

