/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.interaction.interpolation.AxisInterpolator;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Line;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class AxisInterpolatorScale {
    public static final int TYPE_LINEAR = 0;
    public static final int TYPE_LOG = 1;
    private boolean valid = false;
    private int type = 0;
    private boolean horizontal = false;
    private double M = 0.0;
    private double B = 0.0;
    private Range locationRange = new Range(0.0, 0.0);
    private Range valueRange = new Range(0.0, 0.0);

    AxisInterpolatorScale() {
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final boolean isHorizontal() {
        return this.horizontal;
    }

    public final int getType() {
        return this.type;
    }

    public final double getLocation(double d) {
        if (this.type == 1) {
            if (d <= 0.0) {
                return this.M * Math.log(0.1 * this.valueRange.getMin()) + this.B;
            }
            return this.M * Math.log(d) + this.B;
        }
        return this.M * d + this.B;
    }

    public final Range getExtent() {
        return this.locationRange;
    }

    final double getM() {
        return this.M;
    }

    final double getB() {
        return this.B;
    }

    final Range getValueRange() {
        return this.valueRange;
    }

    public boolean setScale(List<SceneNodeImpl> list, String string) {
        int n;
        if ("linear".equals(string)) {
            n = 0;
        } else if ("log".equals(string)) {
            n = 1;
        } else {
            return false;
        }
        if (!this.valid) {
            return this.processItems(n, list);
        }
        return this.checkItems(n, list);
    }

    private boolean processItems(int n, List<SceneNodeImpl> list) {
        double d;
        double d2;
        int n2 = list.size();
        if (n2 < 2) {
            return false;
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        double[] dArray3 = this.getItemInfo(list.get(0));
        if (dArray3 == null) {
            return false;
        }
        boolean bl = dArray3[2] != 0.0;
        double d3 = dArray3[1];
        double d4 = dArray3[1];
        double d5 = dArray3[0];
        double d6 = dArray3[0];
        for (SceneNodeImpl sceneNodeImpl : list) {
            dArray3 = this.getItemInfo(sceneNodeImpl);
            if (dArray3 == null) {
                return false;
            }
            if (bl != (dArray3[2] != 0.0)) {
                return false;
            }
            if (n == 1 && dArray3[0] <= 0.0) {
                return false;
            }
            dArray[n3] = dArray3[0];
            dArray2[n3] = dArray3[1];
            if (dArray2[n3] < d3) {
                d3 = dArray2[n3];
                d5 = dArray[n3];
            }
            if (dArray2[n3] > d4) {
                d4 = dArray2[n3];
                d6 = dArray[n3];
            }
            ++n3;
        }
        if (d5 == d6 || d3 == d4) {
            return false;
        }
        if (n2 == 2) {
            this.valid = true;
            this.type = n;
            this.horizontal = bl;
            if (n == 0) {
                this.M = (d4 - d3) / (d6 - d5);
                this.B = d3 - this.M * d5;
            } else {
                this.M = (d4 - d3) / (Math.log(d6) - Math.log(d5));
                this.B = d3 - this.M * Math.log(d5);
            }
            this.locationRange = new Range(d3, d4);
            this.valueRange = new Range(d5, d6);
            return true;
        }
        if (n == 0) {
            d2 = (d4 - d3) / (d6 - d5);
            d = d3 - d2 * d5;
        } else {
            d2 = (d4 - d3) / (Math.log(d6) - Math.log(d5));
            d = d3 - d2 * Math.log(d5);
        }
        for (int i = 0; i < n3; ++i) {
            double d7 = n == 0 ? d2 * dArray[i] + d : d2 * Math.log(dArray[i]) + d;
            if (!(Math.abs(d7 - dArray2[i]) > 2.0)) continue;
            return false;
        }
        this.valid = true;
        this.type = n;
        this.horizontal = bl;
        this.M = d2;
        this.B = d;
        this.locationRange = new Range(d3, d4);
        this.valueRange = new Range(d5, d6);
        return true;
    }

    private boolean checkItems(int n, List<SceneNodeImpl> list) {
        if (n != this.type) {
            return false;
        }
        if (list.size() < 1) {
            return true;
        }
        double[] dArray = this.getItemInfo(list.get(0));
        if (dArray == null) {
            return false;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[0];
        double d4 = dArray[1];
        for (SceneNodeImpl sceneNodeImpl : list) {
            dArray = this.getItemInfo(sceneNodeImpl);
            if (dArray == null) {
                return false;
            }
            if (this.horizontal != (dArray[2] != 0.0)) {
                return false;
            }
            if (n == 1 && dArray[0] <= 0.0) {
                return false;
            }
            double d5 = n == 0 ? this.M * dArray[0] + this.B : this.M * Math.log(dArray[0]) + this.B;
            if (Math.abs(d5 - dArray[1]) > 2.0) {
                return false;
            }
            if (dArray[1] < d2) {
                d2 = dArray[1];
                d = dArray[0];
            }
            if (!(dArray[1] > d4)) continue;
            d4 = dArray[1];
            d3 = dArray[0];
        }
        this.locationRange = this.locationRange.unionValue(d2);
        this.locationRange = this.locationRange.unionValue(d4);
        this.valueRange = this.valueRange.unionValue(d);
        this.valueRange = this.valueRange.unionValue(d3);
        return true;
    }

    private double[] getItemInfo(SceneNodeImpl sceneNodeImpl) {
        boolean bl;
        double d = AxisInterpolator.getItemValue(sceneNodeImpl);
        if (Double.isNaN(d)) {
            return null;
        }
        if (sceneNodeImpl.getShape().type() != 1000) {
            return null;
        }
        Line line = (Line)sceneNodeImpl.getRenderInfo().getRenderGeom();
        boolean bl2 = Math.abs(line.getX2() - line.getX1()) <= 0.01;
        boolean bl3 = bl = Math.abs(line.getY2() - line.getY1()) <= 0.01;
        if (bl2 && bl) {
            return null;
        }
        if (!bl2 && !bl) {
            return null;
        }
        if (bl2) {
            return new double[]{d, line.getX1(), 1.0};
        }
        return new double[]{d, line.getY1(), 0.0};
    }
}

