/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.interaction.interpolation.TransformInterpolatorData;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeneralAffineInterpolator
extends Interpolator {
    public static final int NONE = 0;
    public static final int TRANSLATE_ONLY = 1;
    public static final int TRANSLATE_ROTATE = 3;
    public static final int ALL = 7;
    private final TransformInterpolatorData start;
    private final TransformInterpolatorData end;
    private int interpolationMode;

    protected GeneralAffineInterpolator(InterpolatorTime interpolatorTime, double d, double d2, TransformInterpolatorData transformInterpolatorData, TransformInterpolatorData transformInterpolatorData2, int n) {
        super(interpolatorTime, d, d2);
        this.start = transformInterpolatorData;
        this.end = transformInterpolatorData2;
        this.interpolationMode = n == 0 || n == 1 || n == 3 || n == 7 ? n : 7;
    }

    @Override
    protected Affine doInterpolate(double d) {
        return this.interpolateWithTranslation(d, 0.0, 0.0);
    }

    protected Affine interpolateWithTranslation(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        Affine affine;
        Affine affine2 = this.start.getAffine();
        Affine affine3 = this.end.getAffine();
        Affine affine4 = affine = d < 0.5 ? affine2 : affine3;
        if (this.interpolationMode == 0) {
            return new Affine(affine.m00, affine.m01, affine.m02 + d2, affine.m10, affine.m11, affine.m12 + d3);
        }
        double d7 = GeneralAffineInterpolator.interpolateDouble(this.start.getTx(), this.end.getTx(), d);
        double d8 = GeneralAffineInterpolator.interpolateDouble(this.start.getTy(), this.end.getTy(), d);
        if (this.interpolationMode == 1 || !this.start.isDecomposable() || !this.end.isDecomposable()) {
            return new Affine(affine.m00, affine.m01, d7 + d2, affine.m10, affine.m11, d8 + d3);
        }
        double d9 = this.end.getTheta() - this.start.getTheta();
        if (d9 > Math.PI) {
            d9 -= Math.PI * 2;
        } else if (d9 < -Math.PI) {
            d9 += Math.PI * 2;
        }
        double d10 = this.start.getTheta() + d * d9;
        double d11 = Math.cos(d10);
        double d12 = Math.sin(d10);
        double d13 = d6 = d12 == 0.0 ? 0.0 : -d12;
        if (this.interpolationMode == 7) {
            d5 = GeneralAffineInterpolator.interpolateDouble(this.start.getSx(), this.end.getSx(), d);
            d4 = GeneralAffineInterpolator.interpolateDouble(this.start.getSy(), this.end.getSy(), d);
        } else if (d < 0.5) {
            d5 = this.start.getSx();
            d4 = this.start.getSy();
        } else {
            d5 = this.end.getSx();
            d4 = this.end.getSy();
        }
        return new Affine(d5 * d11, d5 * d6, d7 + d2, d4 * d12, d4 * d11, d8 + d3);
    }
}

