/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GeomInterpolator
extends Interpolator {
    private final Geom start;
    private final Geom end;

    protected GeomInterpolator(InterpolatorTime interpolatorTime, double d, double d2, Geom geom, Geom geom2, boolean bl) {
        super(interpolatorTime, d, d2);
        if (bl) {
            this.start = GeomInterpolator.clockwise(GeomInterpolator.ensureValid(geom, geom2));
            this.end = GeomInterpolator.clockwise(GeomInterpolator.ensureValid(geom2, geom));
        } else {
            this.start = GeomInterpolator.ensureValid(geom, geom2);
            this.end = GeomInterpolator.ensureValid(geom2, geom);
        }
    }

    private static Geom clockwise(Geom geom) {
        return geom != null && geom.type() == 1003 ? ((Poly)geom).asClockwise() : geom;
    }

    private static final Geom ensureValid(Geom geom, Geom geom2) {
        if (geom != null) {
            return geom;
        }
        if (geom2 == null) {
            return null;
        }
        Point point = geom2.getCenter();
        Geom geom3 = geom2.copy();
        geom3.transform(0.0, point.getX(), 0.0, point.getY());
        return geom3;
    }

    @Override
    protected Object doInterpolate(double d) {
        if (d == 0.0) {
            return this.start;
        }
        if (d == 1.0) {
            return this.end;
        }
        if (this.start == null || this.end == null) {
            if (d < 0.5) {
                return this.start;
            }
            return this.end;
        }
        return GeomInterpolator.interpolateGeoms(this.start, this.end, d);
    }

    private static Geom interpolateGeoms(Geom geom, Geom geom2, double d) {
        if (geom.type() == 1007 || geom2.type() == 1007) {
            return GeomInterpolator.interpolateCompositeGeom(d, geom, geom2);
        }
        if (geom.type() == geom2.type()) {
            if (geom.type() == 1002) {
                return GeomInterpolator.morphRectangle((Rect)geom, (Rect)geom2, d);
            }
            if (geom.type() == 1001) {
                return GeomInterpolator.morphCircle((Circle)geom, (Circle)geom2, d);
            }
            if (geom.type() == 1000) {
                return GeomInterpolator.morphLine((Line)geom, (Line)geom2, d);
            }
            if (geom.type() == 1004) {
                return GeomInterpolator.morphCurve((Curve)geom, (Curve)geom2, d);
            }
        }
        return GeomInterpolator.interpolatePoly(geom.asBasic().asPoly(), geom2.asBasic().asPoly(), d);
    }

    private static Geom morphCurve(Curve curve, Curve curve2, double d) {
        if (curve.sameStructure(curve2)) {
            int n = curve.getX().length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = GeomInterpolator.interpolateDouble(curve.getX()[i], curve2.getX()[i], d);
                dArray2[i] = GeomInterpolator.interpolateDouble(curve.getY()[i], curve2.getY()[i], d);
            }
            return new Curve(dArray, dArray2, curve.getControls(), curve.isClosed());
        }
        return GeomInterpolator.interpolatePoly(curve.asBasic().asPoly(), curve2.asBasic().asPoly(), d);
    }

    private static Rect morphRectangle(Rect rect, Rect rect2, double d) {
        double d2 = GeomInterpolator.interpolateDouble(rect.getX(), rect2.getX(), d);
        double d3 = GeomInterpolator.interpolateDouble(rect.getY(), rect2.getY(), d);
        double d4 = GeomInterpolator.interpolateDouble(rect.getWidth(), rect2.getWidth(), d);
        double d5 = GeomInterpolator.interpolateDouble(rect.getHeight(), rect2.getHeight(), d);
        return new Rect(d2, d3, d4, d5);
    }

    private static Circle morphCircle(Circle circle, Circle circle2, double d) {
        double d2 = GeomInterpolator.interpolateDouble(circle.getR(), circle2.getR(), d);
        double d3 = GeomInterpolator.interpolateDouble(circle.getX(), circle2.getX(), d);
        double d4 = GeomInterpolator.interpolateDouble(circle.getY(), circle2.getY(), d);
        return new Circle(d3, d4, d2);
    }

    private static Line morphLine(Line line, Line line2, double d) {
        double d2 = GeomInterpolator.interpolateDouble(line.getX1(), line2.getX1(), d);
        double d3 = GeomInterpolator.interpolateDouble(line.getY1(), line2.getY1(), d);
        double d4 = GeomInterpolator.interpolateDouble(line.getX2(), line2.getX2(), d);
        double d5 = GeomInterpolator.interpolateDouble(line.getY2(), line2.getY2(), d);
        return new Line(d2, d3, d4, d5);
    }

    private static Geom interpolateCompositeGeom(double d, Geom geom, Geom geom2) {
        int n;
        Geom[] geomArray;
        Geom[] geomArray2;
        if (geom.type() == 1007) {
            geomArray2 = ((CompositeGeom)geom).getParts();
        } else {
            Geom[] geomArray3 = new Geom[1];
            geomArray2 = geomArray3;
            geomArray3[0] = geom;
        }
        Geom[] geomArray4 = geomArray2;
        if (geom2.type() == 1007) {
            geomArray = ((CompositeGeom)geom2).getParts();
        } else {
            Geom[] geomArray5 = new Geom[1];
            geomArray = geomArray5;
            geomArray5[0] = geom2;
        }
        Geom[] geomArray6 = geomArray;
        int n2 = d <= 0.5 ? geomArray4.length : geomArray6.length;
        Geom[] geomArray7 = new Geom[n2];
        for (n = 0; n < n2; ++n) {
            geomArray7[n] = n >= geomArray4.length ? geomArray6[n] : (n >= geomArray6.length ? geomArray4[n] : GeomInterpolator.interpolateGeoms(geomArray4[n], geomArray6[n], d));
        }
        n = (geom.type() == 1007 ? ((CompositeGeom)geom).getOddEven() : ((CompositeGeom)geom2).getOddEven()) ? 1 : 0;
        return new CompositeGeom(geomArray7, n != 0, null);
    }

    private static Geom interpolatePoly(Poly poly, Poly poly2, double d) {
        int n;
        double[] dArray = poly.getX();
        double[] dArray2 = poly2.getX();
        int n2 = dArray2.length;
        if (n2 < (n = dArray.length)) {
            return GeomInterpolator.interpolatePoly(poly2, poly, 1.0 - d);
        }
        double[] dArray3 = poly.getY();
        double[] dArray4 = poly2.getY();
        boolean bl = d < 0.5 ? poly.isClosed() : poly2.isClosed();
        double[] dArray5 = new double[dArray2.length];
        double[] dArray6 = new double[dArray2.length];
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.round((float)i * (float)n / (float)n2);
            n3 = Math.min(n3, n - 1);
            dArray5[i] = (1.0 - d) * dArray[n3] + d * dArray2[i];
            dArray6[i] = (1.0 - d) * dArray3[n3] + d * dArray4[i];
        }
        return new Poly(dArray5, dArray6, bl);
    }
}

