/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.internal.ScenePartInterpolator;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class Interpolator
implements ScenePartInterpolator {
    private static final double EPSILON = 0.001;
    protected static final int BOTH_NULL = 0;
    protected static final int START_NULL = 1;
    protected static final int END_NULL = 2;
    protected static final int BOTH_NON_NULL = 3;
    private final double start_time;
    private final double end_time;
    private final InterpolatorTime timer;
    private double lastTime = -1.0;
    private Object lastValue = null;

    protected Interpolator(InterpolatorTime interpolatorTime, double d, double d2) {
        this.timer = interpolatorTime;
        this.start_time = d < d2 ? d : d2;
        this.end_time = d < d2 ? d2 : d;
    }

    @Override
    public final Object interpolate() {
        double d = this.time();
        if (this.lastValue != null && Math.abs(d - this.lastTime) <= 0.001) {
            return this.lastValue;
        }
        this.lastValue = this.doInterpolate(d);
        this.lastTime = d;
        return this.lastValue;
    }

    protected abstract Object doInterpolate(double var1);

    protected final double time() {
        double d = this.timer.time();
        if (d <= this.start_time) {
            return 0.0;
        }
        if (d >= this.end_time) {
            return 1.0;
        }
        return (d - this.start_time) / (this.end_time - this.start_time);
    }

    protected static final double interpolateDouble(double d, double d2, double d3) {
        return d + d3 * (d2 - d);
    }

    protected int calculateConversion(Object object, Object object2) {
        if (object2 == null) {
            return object == null ? 0 : 2;
        }
        return object == null ? 1 : 3;
    }
}

