/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.GeneralAffineInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.GeomInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.interaction.interpolation.StyleInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.TextInfoImpl;
import com.ibm.vis.engine.internal.interaction.interpolation.TextInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.TransformInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.TransformInterpolatorData;
import com.ibm.vis.engine.internal.interaction.interpolation.TranslateAffineIterpolator;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class InterpolatorFactory {
    public static Interpolator getGeomInterpolator(InterpolatorTime interpolatorTime, double d, double d2, Geom geom, Geom geom2, boolean bl) {
        return new GeomInterpolator(interpolatorTime, d, d2, geom, geom2, bl);
    }

    public static Interpolator getTextInterpolator(InterpolatorTime interpolatorTime, double d, double d2, TextInfo textInfo, TextInfo textInfo2, TransformInfo transformInfo, TransformInfo transformInfo2) {
        Affine affine = transformInfo == null ? null : transformInfo.getAffine();
        Affine affine2 = transformInfo2 == null ? null : transformInfo2.getAffine();
        TextInfoImpl textInfoImpl = TextInfoImpl.makeImpl(textInfo, affine);
        TextInfoImpl textInfoImpl2 = TextInfoImpl.makeImpl(textInfo2, affine2);
        Interpolator interpolator = InterpolatorFactory.getAffineInterpolator(interpolatorTime, d, d2, textInfoImpl.getAffine(), textInfoImpl2.getAffine());
        return new TextInterpolator(interpolatorTime, d, d2, textInfoImpl, textInfoImpl2, interpolator);
    }

    protected static Interpolator getAffineInterpolator(InterpolatorTime interpolatorTime, double d, double d2, Affine affine, Affine affine2) {
        if (InterpolatorFactory.isTranslateOnly(affine) && InterpolatorFactory.isTranslateOnly(affine2)) {
            return new TranslateAffineIterpolator(interpolatorTime, d, d2, affine, affine2);
        }
        TransformInterpolatorData transformInterpolatorData = affine == null ? TransformInterpolatorData.makeTransformInterpolatorDataFromTranslate(0.0, 0.0) : TransformInterpolatorData.makeTransformInterpolatorDataFromAffine(affine);
        TransformInterpolatorData transformInterpolatorData2 = affine2 == null ? TransformInterpolatorData.makeTransformInterpolatorDataFromTranslate(0.0, 0.0) : TransformInterpolatorData.makeTransformInterpolatorDataFromAffine(affine2);
        int n = 3;
        return new GeneralAffineInterpolator(interpolatorTime, d, d2, transformInterpolatorData, transformInterpolatorData2, n);
    }

    private static boolean isTranslateOnly(Affine affine) {
        return affine == null || affine.translateOnly;
    }

    public static Interpolator getTransformInterpolator(InterpolatorTime interpolatorTime, double d, double d2, TransformInfo transformInfo, TransformInfo transformInfo2) {
        return new TransformInterpolator(interpolatorTime, d, d2, transformInfo, transformInfo2);
    }

    public static Interpolator getStyleInterpolator(InterpolatorTime interpolatorTime, double d, double d2, StyleKeyFrame[] styleKeyFrameArray) {
        return new StyleInterpolator(interpolatorTime, d, d2, styleKeyFrameArray);
    }
}

