/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.GradientStop;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PaintInterpolator
extends Interpolator {
    private final GradientPaintInfo start;
    private final GradientPaintInfo end;
    private int conversion;

    public PaintInterpolator(InterpolatorTime interpolatorTime, double d, double d2, GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2) {
        super(interpolatorTime, d, d2);
        this.start = gradientPaintInfo;
        this.end = gradientPaintInfo2;
        this.conversion = PaintInterpolator.getType(gradientPaintInfo) + 10 * PaintInterpolator.getType(gradientPaintInfo2);
    }

    private static int getType(GradientPaintInfo gradientPaintInfo) {
        if (gradientPaintInfo == null) {
            return 0;
        }
        if (gradientPaintInfo.getColors().length > 0) {
            return 2;
        }
        if (gradientPaintInfo.getSolid() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected Object doInterpolate(double d) {
        if (d == 0.0) {
            return this.start;
        }
        if (d == 1.0) {
            return this.end;
        }
        GradientPaintInfo gradientPaintInfo = null;
        switch (this.conversion) {
            default: {
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                gradientPaintInfo = this.interpolateSolids(this.start, this.end, d);
                break;
            }
            case 2: {
                gradientPaintInfo = PaintInterpolator.interpolateGradientWithSolid(this.start, null, d);
                break;
            }
            case 20: {
                gradientPaintInfo = PaintInterpolator.interpolateGradientWithSolid(this.end, null, 1.0 - d);
                break;
            }
            case 12: {
                gradientPaintInfo = PaintInterpolator.interpolateGradientWithSolid(this.start, this.end, d);
                break;
            }
            case 21: {
                gradientPaintInfo = PaintInterpolator.interpolateGradientWithSolid(this.end, this.start, 1.0 - d);
                break;
            }
            case 22: {
                gradientPaintInfo = PaintInterpolator.interpolateGradients(this.start, this.end, d);
            }
        }
        return gradientPaintInfo;
    }

    private GradientPaintInfo interpolateSolids(GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2, double d) {
        ColorNew colorNew;
        ColorNew colorNew2 = this.start == null ? null : this.start.getSolid();
        ColorNew colorNew3 = ColorUtil.interpolateColor(colorNew2, colorNew = this.end == null ? null : this.end.getSolid(), d);
        if (colorNew3 == null) {
            return null;
        }
        return GradientPaintInfo.makeSolid(colorNew3);
    }

    private static GradientPaintInfo interpolateGradientWithSolid(GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2, double d) {
        ColorNew colorNew = gradientPaintInfo2 == null ? null : gradientPaintInfo2.getSolid();
        ColorNew[] colorNewArray = gradientPaintInfo.getColors();
        float[] fArray = gradientPaintInfo.getOffsets();
        GradientStop[] gradientStopArray = new GradientStop[colorNewArray.length];
        for (int i = 0; i < colorNewArray.length; ++i) {
            gradientStopArray[i] = new GradientStop(ColorUtil.interpolateColor(colorNewArray[i], colorNew, d), fArray[i]);
        }
        return new GradientPaintInfo(gradientPaintInfo.getType(), gradientStopArray, gradientPaintInfo.getX1(), gradientPaintInfo.getY1(), gradientPaintInfo.getX2(), gradientPaintInfo.getY2(), gradientPaintInfo.getCx(), gradientPaintInfo.getCy(), gradientPaintInfo.getCr(), null);
    }

    private static GradientPaintInfo interpolateGradients(GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2, double d) {
        float[] fArray;
        int n = gradientPaintInfo.getType();
        float[] fArray2 = gradientPaintInfo.getOffsets();
        if (fArray2.length != (fArray = gradientPaintInfo2.getOffsets()).length || n != gradientPaintInfo2.getType()) {
            return d < 0.5 ? gradientPaintInfo : gradientPaintInfo2;
        }
        ColorNew[] colorNewArray = gradientPaintInfo.getColors();
        ColorNew[] colorNewArray2 = gradientPaintInfo2.getColors();
        GradientStop[] gradientStopArray = new GradientStop[colorNewArray.length];
        for (int i = 0; i < colorNewArray.length; ++i) {
            float f = (float)PaintInterpolator.interpolateDouble(fArray2[i], fArray[i], d);
            gradientStopArray[i] = new GradientStop(ColorUtil.interpolateColor(colorNewArray[i], colorNewArray2[i], d), f);
        }
        double d2 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getX1(), gradientPaintInfo2.getX1(), d);
        double d3 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getX2(), gradientPaintInfo2.getX2(), d);
        double d4 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getY1(), gradientPaintInfo2.getY1(), d);
        double d5 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getY2(), gradientPaintInfo2.getY2(), d);
        double d6 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getCx(), gradientPaintInfo2.getCx(), d);
        double d7 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getCy(), gradientPaintInfo2.getCy(), d);
        double d8 = PaintInterpolator.interpolateDouble(gradientPaintInfo.getCr(), gradientPaintInfo2.getCr(), d);
        return new GradientPaintInfo(n, gradientStopArray, d2, d4, d3, d5, d6, d7, d8, null);
    }
}

