/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RenderEffectsInterpolator
extends Interpolator {
    private final RenderEffects start;
    private final RenderEffects end;

    public RenderEffectsInterpolator(InterpolatorTime interpolatorTime, double d, double d2, RenderEffects renderEffects, RenderEffects renderEffects2) {
        super(interpolatorTime, d, d2);
        this.start = renderEffects;
        this.end = renderEffects2;
    }

    @Override
    protected Object doInterpolate(double d) {
        if (this.start == null && this.end == null) {
            return null;
        }
        if (d == 0.0) {
            return this.start;
        }
        if (d == 1.0) {
            return this.end;
        }
        RenderEffect renderEffect = this.start == null ? null : this.start.getGlow();
        RenderEffect renderEffect2 = this.end == null ? null : this.end.getGlow();
        RenderEffect renderEffect3 = this.start == null ? null : this.start.getShadow();
        RenderEffect renderEffect4 = this.end == null ? null : this.end.getShadow();
        return new RenderEffects(RenderEffectsInterpolator.interpolateEffect(d, renderEffect, renderEffect2), RenderEffectsInterpolator.interpolateEffect(d, renderEffect3, renderEffect4));
    }

    private static RenderEffect interpolateEffect(double d, RenderEffect renderEffect, RenderEffect renderEffect2) {
        if (renderEffect == null && renderEffect2 == null) {
            return null;
        }
        if (renderEffect == null) {
            return new RenderEffect(renderEffect2.getColor().fadeAlpha(d), renderEffect2.getStdDev(), renderEffect2.getDX(), renderEffect2.getDY());
        }
        if (renderEffect2 == null) {
            return new RenderEffect(renderEffect.getColor().fadeAlpha(1.0 - d), renderEffect.getStdDev(), renderEffect.getDX(), renderEffect.getDY());
        }
        return new RenderEffect(renderEffect.getColor().interpolateWithColor(renderEffect2.getColor(), d), RenderEffectsInterpolator.interpolateDouble(renderEffect.getStdDev(), renderEffect2.getStdDev(), d), RenderEffectsInterpolator.interpolateDouble(renderEffect.getDX(), renderEffect2.getDX(), d), RenderEffectsInterpolator.interpolateDouble(renderEffect.getDY(), renderEffect2.getDY(), d));
    }
}

