/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StrokeInterpolator
extends Interpolator {
    private final Stroke start;
    private final Stroke end;
    private final int conversion;

    StrokeInterpolator(InterpolatorTime interpolatorTime, double d, double d2, Stroke stroke, Stroke stroke2) {
        super(interpolatorTime, d, d2);
        this.start = stroke;
        this.end = stroke2;
        this.conversion = this.calculateConversion(stroke, stroke2);
    }

    @Override
    protected Object doInterpolate(double d) {
        if (d == 0.0) {
            return this.start;
        }
        if (d == 1.0) {
            return this.end;
        }
        Stroke stroke = null;
        switch (this.conversion) {
            case 0: {
                break;
            }
            case 1: {
                stroke = this.interpolateStroke(this.end, 0.0, null, 1.0 - d);
                break;
            }
            case 2: {
                stroke = this.interpolateStroke(this.start, 0.0, null, d);
                break;
            }
            case 3: {
                if (d < 0.5) {
                    double d2 = this.end.getWidth();
                    ColorNew colorNew = this.end.getColor();
                    stroke = this.interpolateStroke(this.start, d2, colorNew, d);
                    break;
                }
                double d3 = this.start.getWidth();
                ColorNew colorNew = this.start.getColor();
                stroke = this.interpolateStroke(this.end, d3, colorNew, 1.0 - d);
            }
        }
        return stroke;
    }

    private Stroke interpolateStroke(Stroke stroke, double d, ColorNew colorNew, double d2) {
        double d3 = StrokeInterpolator.interpolateDouble(stroke.getWidth(), d, d2);
        ColorNew colorNew2 = ColorUtil.interpolateColor(stroke.getColor(), colorNew, d2);
        String string = stroke.getCap();
        String string2 = stroke.getDashing();
        Object object = stroke.getJoin();
        return new Stroke(d3, string2, object, string, colorNew2);
    }
}

