/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.interaction.effect.StyleKeyFrame;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.interaction.interpolation.PaintInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.RenderEffectsInterpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.StrokeInterpolator;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StyleInterpolator
extends Interpolator {
    private StyleKeyFrame[] frames;
    private PaintInterpolator[] paints;
    private StrokeInterpolator[] strokes;
    private RenderEffectsInterpolator[] effects;

    public StyleInterpolator(InterpolatorTime interpolatorTime, double d, double d2, StyleKeyFrame[] styleKeyFrameArray) {
        super(interpolatorTime, d, d2);
        this.frames = styleKeyFrameArray;
        int n = styleKeyFrameArray.length - 1;
        this.paints = new PaintInterpolator[n];
        this.strokes = new StrokeInterpolator[n];
        this.effects = new RenderEffectsInterpolator[n];
        for (int i = 0; i < n; ++i) {
            this.paints[i] = new PaintInterpolator(interpolatorTime, 0.0, 1.0, styleKeyFrameArray[i].fill, styleKeyFrameArray[i + 1].fill);
            this.strokes[i] = new StrokeInterpolator(interpolatorTime, 0.0, 1.0, styleKeyFrameArray[i].stroke, styleKeyFrameArray[i + 1].stroke);
            this.effects[i] = new RenderEffectsInterpolator(interpolatorTime, 0.0, 1.0, styleKeyFrameArray[i].effects, styleKeyFrameArray[i + 1].effects);
        }
    }

    @Override
    protected Object doInterpolate(double d) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.frames.length && !(d < this.frames[n2].step)) {
            n = n2++;
        }
        if (n == -1) {
            return this.frames[0].asObjects();
        }
        if (n == this.frames.length - 1) {
            return this.frames[n].asObjects();
        }
        double d2 = this.frames[n + 1].step - this.frames[n].step;
        if (d2 < 1.0E-6) {
            return this.frames[n].asObjects();
        }
        double d3 = (d - this.frames[n].step) / d2;
        return new Object[]{this.paints[n].interpolate(), this.strokes[n].interpolate(), StyleInterpolator.interpolateAlpha(this.frames[n].imageAlpha, this.frames[n + 1].imageAlpha, d3), this.effects[n].interpolate()};
    }

    private static final Double interpolateAlpha(Double d, Double d2, double d3) {
        if (d == null) {
            return d2 == null ? null : Double.valueOf(1.0 + (d2 - 1.0) * d3);
        }
        return d2 == null ? d * (1.0 - d3) + d3 : d * (1.0 - d3) + d2 * d3;
    }
}

