/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.FontInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextInfoImpl
implements TextInfo,
TransformInfo {
    protected static final String MIDDLE = "middle";
    private String text;
    private Font font;
    private String textAlign;
    private String textVAlign;
    private Point anchor;
    private Dim size;
    private Double ascent;
    private Affine affine;
    private Rect bounds;

    private TextInfoImpl(String string, Font font, String string2, String string3, Point point, Dim dim, Double d, Affine affine) {
        this.text = string;
        this.font = font;
        this.textAlign = string2;
        this.textVAlign = string3;
        this.anchor = point;
        this.size = dim;
        this.ascent = d;
        this.affine = affine;
    }

    @Override
    public final Rect getNonTransformedBounds() {
        if (this.bounds == null) {
            this.bounds = new Rect(this.size.getWidth() / -2.0, this.size.getHeight() / -2.0, this.size.getWidth(), this.size.getHeight());
        }
        return this.bounds;
    }

    public final TransformInfo getTransformInfo() {
        return this;
    }

    @Override
    public final Affine getAffine() {
        return this.affine;
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Override
    public final FontInfo getFont() {
        return this.font;
    }

    @Override
    public final String getTextAlign() {
        return this.textAlign;
    }

    @Override
    public final String getTextVAlign() {
        return this.textVAlign;
    }

    @Override
    public final Point getAnchorPoint() {
        return this.anchor;
    }

    @Override
    public final Dim getTextSize() {
        return this.size;
    }

    @Override
    public final Double requiredPreciseAscent() {
        return this.ascent;
    }

    public static TextInfoImpl makeFromInterpolated(TextInfoImpl textInfoImpl, Font font, Dim dim, Affine affine) {
        return new TextInfoImpl(textInfoImpl.text, font, textInfoImpl.textAlign, textInfoImpl.textVAlign, textInfoImpl.anchor, dim, textInfoImpl.ascent, affine);
    }

    public static TextInfoImpl makeImpl(TextInfo textInfo, Affine affine) {
        if (textInfo == null) {
            return null;
        }
        Point point = textInfo.getAnchorPoint();
        double d = point.getX();
        double d2 = point.getY();
        String string = textInfo.getTextAlign();
        Dim dim = textInfo.getTextSize();
        if (!MIDDLE.equals(string)) {
            double d3 = dim.getWidth() / 2.0;
            d = "end".equals(string) ? d - d3 : d + d3;
        }
        Affine affine2 = Affine.makeTransform(d, d2);
        Affine affine3 = affine == null ? affine2 : affine.multiply(affine2);
        return new TextInfoImpl(textInfo.getText(), (Font)textInfo.getFont(), MIDDLE, textInfo.getTextVAlign(), new Point(0.0, 0.0), dim, textInfo.requiredPreciseAscent(), affine3);
    }
}

