/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.interaction.interpolation.TextInfoImpl;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.provisional.FontInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextInterpolator
extends Interpolator {
    private static final int SAME_TEXT = 4;
    private final TextInfoImpl start;
    private final TextInfoImpl end;
    private final Interpolator affineInterpolator;
    private final int conversion;

    public TextInterpolator(InterpolatorTime interpolatorTime, double d, double d2, TextInfoImpl textInfoImpl, TextInfoImpl textInfoImpl2, Interpolator interpolator) {
        super(interpolatorTime, d, d2);
        this.start = textInfoImpl;
        this.end = textInfoImpl2;
        this.affineInterpolator = interpolator;
        this.conversion = this.calculateConversion();
    }

    private int calculateConversion() {
        boolean bl = this.isVisible(this.start);
        boolean bl2 = this.isVisible(this.end);
        if (bl && bl2) {
            return this.start.getText().equals(this.end.getText()) ? 4 : 3;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }

    private final boolean isVisible(TextInfo textInfo) {
        return textInfo != null && !textInfo.getText().trim().isEmpty();
    }

    @Override
    protected Object doInterpolate(double d) {
        TextInfo textInfo = null;
        switch (this.conversion) {
            case 0: {
                break;
            }
            case 2: {
                textInfo = this.fade(this.start, d);
                break;
            }
            case 1: {
                textInfo = this.fade(this.end, 1.0 - d);
                break;
            }
            case 4: {
                textInfo = this.interpolateText(this.start, d);
                break;
            }
            case 3: {
                TextInfoImpl textInfoImpl = d < 0.5 ? this.start : this.end;
                textInfo = this.interpolateText(textInfoImpl, d);
                break;
            }
        }
        return textInfo;
    }

    private TextInfo interpolateText(TextInfoImpl textInfoImpl, double d) {
        Font font = this.interpolateFont(d);
        Dim dim = this.interpolateSize(d, font);
        Affine affine = (Affine)this.affineInterpolator.interpolate();
        return TextInfoImpl.makeFromInterpolated(textInfoImpl, font, dim, affine);
    }

    private Dim interpolateSize(double d, Font font) {
        double d2;
        double d3;
        Dim dim = this.start.getTextSize();
        Dim dim2 = this.end.getTextSize();
        if (this.conversion == 3) {
            double d4 = this.end.getFont().getSize() / this.start.getFont().getSize();
            if (d < 0.5) {
                d3 = TextInterpolator.interpolateDouble(dim.getWidth(), dim.getWidth() * d4, d);
                d2 = TextInterpolator.interpolateDouble(dim.getHeight(), dim.getHeight() * d4, d);
            } else {
                d3 = TextInterpolator.interpolateDouble(dim2.getWidth() / d4, dim2.getWidth(), d);
                d2 = TextInterpolator.interpolateDouble(dim2.getHeight() / d4, dim2.getHeight(), d);
            }
        } else {
            d3 = TextInterpolator.interpolateDouble(dim.getWidth(), dim2.getWidth(), d);
            d2 = TextInterpolator.interpolateDouble(dim.getHeight(), dim2.getHeight(), d);
        }
        return new Dim(d3, d2);
    }

    private Font interpolateFont(double d) {
        FontInfo fontInfo = this.start.getFont();
        FontInfo fontInfo2 = this.end.getFont();
        double d2 = TextInterpolator.interpolateDouble(fontInfo.getSize(), fontInfo2.getSize(), d);
        if (d < 0.5) {
            return ((Font)fontInfo).modifySize(d2);
        }
        return ((Font)fontInfo2).modifySize(d2);
    }

    private TextInfo fade(TextInfo textInfo, double d) {
        return textInfo;
    }
}

