/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.interaction.interpolation.TransformInterpolatorData;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TransformInterpolator
extends Interpolator {
    private final TransformInterpolatorData start_data;
    private final TransformInterpolatorData end_data;
    private int interpolationMode;
    private TransformInfoImpl result;
    public static final int TRANSLATE_ONLY = 1;
    public static final int TRANSLATE_ROTATE = 3;
    public static final int ALL = 7;

    public TransformInterpolator(InterpolatorTime interpolatorTime, double d, double d2, TransformInfo transformInfo, TransformInfo transformInfo2) {
        super(interpolatorTime, d, d2);
        Affine affine = transformInfo == null ? null : transformInfo.getAffine();
        Affine affine2 = transformInfo2 == null ? null : transformInfo2.getAffine();
        this.start_data = TransformInterpolatorData.makeTransformInterpolatorDataFromAffine(affine);
        this.end_data = TransformInterpolatorData.makeTransformInterpolatorDataFromAffine(affine2);
        this.interpolationMode = 7;
        this.result = new TransformInfoImpl();
    }

    public void setInterpolationMode(int n) {
        this.interpolationMode = n;
    }

    @Override
    protected Object doInterpolate(double d) {
        Affine affine = this.start_data.getAffine();
        Affine affine2 = this.end_data.getAffine();
        Affine affine3 = d < 0.5 ? affine : affine2;
        double d2 = TransformInterpolator.interpolateDouble(this.start_data.getTx(), this.end_data.getTx(), d);
        double d3 = TransformInterpolator.interpolateDouble(this.start_data.getTy(), this.end_data.getTy(), d);
        if (this.interpolationMode == 1 || !this.start_data.isDecomposable() || !this.end_data.isDecomposable()) {
            Affine affine4 = new Affine(affine3.m00, affine3.m01, d2, affine3.m10, affine3.m11, d3);
            this.result.setAffine(affine4);
        } else {
            double d4;
            double d5;
            double d6;
            double d7 = this.end_data.getTheta() - this.start_data.getTheta();
            if (d7 > Math.PI) {
                d7 -= Math.PI * 2;
            } else if (d7 < -Math.PI) {
                d7 += Math.PI * 2;
            }
            double d8 = this.start_data.getTheta() + d * d7;
            double d9 = Math.cos(d8);
            double d10 = Math.sin(d8);
            double d11 = d6 = d10 == 0.0 ? 0.0 : -d10;
            if (this.interpolationMode == 7) {
                d5 = TransformInterpolator.interpolateDouble(this.start_data.getSx(), this.end_data.getSx(), d);
                d4 = TransformInterpolator.interpolateDouble(this.start_data.getSy(), this.end_data.getSy(), d);
            } else if (d < 0.5) {
                d5 = this.start_data.getSx();
                d4 = this.start_data.getSy();
            } else {
                d5 = this.end_data.getSx();
                d4 = this.end_data.getSy();
            }
            Affine affine5 = new Affine(d5 * d9, d5 * d6, d2, d4 * d10, d4 * d9, d3);
            this.result.setAffine(affine5);
        }
        return this.result;
    }
}

