/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TransformInterpolatorData {
    private final Affine affine;
    private final boolean decomposable;
    private final double tx;
    private final double ty;
    private final double theta;
    private final double sx;
    private final double sy;
    private static final TransformInterpolatorData identityData = TransformInterpolatorData.makeTransformInterpolatorDataFromTranslate(0.0, 0.0);

    private TransformInterpolatorData(Affine affine, boolean bl, double d, double d2, double d3, double d4, double d5) {
        this.affine = affine;
        this.decomposable = bl;
        this.tx = d;
        this.ty = d2;
        this.theta = d3;
        this.sx = d4;
        this.sy = d5;
    }

    public static TransformInterpolatorData makeTransformInterpolatorDataFromTranslate(double d, double d2) {
        return new TransformInterpolatorData(new Affine(1.0, 0.0, d, 0.0, 1.0, d2), true, d, d2, 0.0, 1.0, 1.0);
    }

    public static TransformInterpolatorData makeTransformInterpolatorDataFromAffine(Affine affine) {
        double d;
        double d2;
        double d3;
        double d4;
        if (affine == null || affine.isIdentity()) {
            return identityData;
        }
        double d5 = affine.m00;
        double d6 = affine.m01;
        double d7 = affine.m02;
        double d8 = affine.m10;
        double d9 = affine.m11;
        double d10 = affine.m12;
        double d11 = d7;
        double d12 = d10;
        if (d8 == 0.0 && d5 == 0.0 || d6 == 0.0 && d9 == 0.0) {
            return new TransformInterpolatorData(affine, false, d11, d12, Double.NaN, Double.NaN, Double.NaN);
        }
        double d13 = Math.sqrt(d5 * d5 + d8 * d8);
        double d14 = Math.sqrt(d6 * d6 + d9 * d9);
        double d15 = Math.atan2(d8, d5);
        if (Math.abs(d15 - (d4 = Math.atan2(d6 == 0.0 ? 0.0 : -d6, d9))) < 0.001) {
            d3 = d13;
            d2 = d14;
        } else if (Math.abs(Math.abs(d15 - d4) - Math.PI) < 0.001) {
            d3 = -d13;
            d2 = d14;
        } else {
            return new TransformInterpolatorData(affine, false, d11, d12, Double.NaN, Double.NaN, Double.NaN);
        }
        if (d8 != 0.0) {
            if (d8 * d3 * d15 > 0.0) {
                d = d15;
            } else {
                if ((d15 += Math.PI) > Math.PI) {
                    d15 -= Math.PI * 2;
                }
                d = d15;
            }
        } else {
            d = d5 * d3 > 0.0 ? 0.0 : Math.PI;
        }
        return new TransformInterpolatorData(affine, true, d11, d12, d, d3, d2);
    }

    public final Affine getAffine() {
        return this.affine;
    }

    public final boolean isDecomposable() {
        return this.decomposable;
    }

    public final double getTx() {
        return this.tx;
    }

    public final double getTy() {
        return this.ty;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final double getSx() {
        return this.sx;
    }

    public final double getSy() {
        return this.sy;
    }
}

