/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TranslateAffineIterpolator
extends Interpolator {
    private final Affine start;
    private final Affine end;
    private final int conversion;

    protected TranslateAffineIterpolator(InterpolatorTime interpolatorTime, double d, double d2, Affine affine, Affine affine2) {
        super(interpolatorTime, d, d2);
        this.start = affine;
        this.end = affine2;
        this.conversion = this.calculateConversion(affine, affine2);
    }

    @Override
    protected Object doInterpolate(double d) {
        if (d == 0.0) {
            return this.start;
        }
        if (d == 1.0) {
            return this.end;
        }
        Affine affine = null;
        switch (this.conversion) {
            case 0: {
                break;
            }
            case 1: {
                affine = d <= 0.5 ? null : Affine.makeTransform(TranslateAffineIterpolator.interpolateDouble(0.0, this.end.m02, d), TranslateAffineIterpolator.interpolateDouble(0.0, this.end.m12, d));
                break;
            }
            case 2: {
                affine = d > 0.5 ? null : Affine.makeTransform(TranslateAffineIterpolator.interpolateDouble(this.start.m02, 0.0, d), TranslateAffineIterpolator.interpolateDouble(this.start.m12, 0.0, d));
                break;
            }
            case 3: {
                affine = Affine.makeTransform(TranslateAffineIterpolator.interpolateDouble(this.start.m02, this.end.m02, d), TranslateAffineIterpolator.interpolateDouble(this.start.m12, this.end.m12, d));
            }
        }
        return affine;
    }
}

