/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.interpolation;

import com.ibm.vis.engine.internal.interaction.interpolation.Interpolator;
import com.ibm.vis.engine.internal.interaction.interpolation.InterpolatorTime;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Wedge;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class WedgeInterpolator
extends Interpolator {
    private final Wedge start;
    private final Wedge end;
    private Wedge mid;

    public WedgeInterpolator(InterpolatorTime interpolatorTime, double d, double d2, Wedge wedge, Wedge wedge2) {
        super(interpolatorTime, d, d2);
        this.start = wedge;
        this.end = wedge2;
        this.mid = wedge.copy();
    }

    @Override
    protected Object doInterpolate(double d) {
        this.mid.setOriginX(WedgeInterpolator.interpolateDouble(this.start.getOrigin().getX(), this.end.getOrigin().getX(), d));
        this.mid.setOriginY(WedgeInterpolator.interpolateDouble(this.start.getOrigin().getY(), this.end.getOrigin().getY(), d));
        this.mid.setR1(WedgeInterpolator.interpolateDouble(this.start.getR1(), this.end.getR1(), d));
        this.mid.setR2(WedgeInterpolator.interpolateDouble(this.start.getR2(), this.end.getR2(), d));
        double d2 = (this.end.getA1() + this.end.getA2()) / 2.0;
        double d3 = (this.start.getA1() + this.start.getA2()) / 2.0;
        double d4 = d2 - d3;
        if (d4 > Math.PI) {
            d4 -= Math.PI * 2;
        }
        if (d4 <= -Math.PI) {
            d4 += Math.PI * 2;
        }
        double d5 = d3 + d * d4;
        double d6 = Math.abs(this.end.getA2() - this.end.getA1()) * d + Math.abs(this.start.getA2() - this.start.getA1()) * (1.0 - d);
        this.mid.setA1(d5 - d6 / 2.0);
        this.mid.setA2(d5 + d6 / 2.0);
        return this.mid;
    }
}

