/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.morph;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.RenderEffects;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.interaction.morph.Matchable;
import com.ibm.vis.engine.internal.interaction.morph.MorphablePair;
import com.ibm.vis.engine.internal.interaction.morph.MorphablePairComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.FontInfo;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeClassId;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FeatureGroup {
    public static final int USE_ID_FOR_KEY = 0;
    public static final int USE_KEY_FOR_KEY = 1;
    public static final int USE_VALUE_FOR_KEY = 2;
    private final int useForKey;
    public final SceneNodeType type;
    public final String baseId;
    final Map<Object, Matchable> members;
    public boolean hasSource;
    public boolean hasTarget;
    public final List<MorphablePair> matches;
    public final List<SceneNodeImpl> unmatchedSources;
    public final List<SceneNodeImpl> unmatchedTargets;
    public CoordinatesSpec targetCoords;
    public CoordinatesSpec sourceCoords;
    public CompositeSceneNode targetAddLocation;
    public TransformInfo sourceTransform;
    public Rect sourceClip;
    public TransformInfo targetTransform;
    public Rect targetClip;
    public SceneNodeImpl targetGroup;
    private static final int ID_MATCH_SCORE = 1;
    private static final int TRANSFORM_MATCH_SCORE = 2;
    private static final int STROKE_MATCH_SCORE = 4;
    private static final int FILL_MATCH_SCORE = 8;
    private static final int SHAPE_MATCH_SCORE = 16;
    private static final int META_MATCH_SCORE = 16;
    private final int MIN_THRESHOLD_SCORE = 6;
    private final int MAX_THRESHOLD_SCORE = 46;
    private static final int CHECK_SHAPE = 0;
    private static final int CHECK_TEXT = 1;
    private static final int CHECK_FONT = 2;
    private static final int CHECK_STROKE = 3;
    private static final int CHECK_FILL = 4;
    private static final int CHECK_TRANSFORM = 5;
    private static final int CHECK_META = 6;
    private static final int CHECK_ID = 7;
    private static final int CHECK_EFFECTS = 8;

    public FeatureGroup(String string, SceneNodeType sceneNodeType, int n) {
        this.type = SceneNodeType.MULTI_TEXT == sceneNodeType ? SceneNodeType.TEXT : sceneNodeType;
        this.baseId = string;
        this.useForKey = n;
        this.members = new HashMap<Object, Matchable>();
        this.hasSource = false;
        this.hasTarget = false;
        this.matches = new ArrayList<MorphablePair>();
        this.unmatchedSources = new ArrayList<SceneNodeImpl>();
        this.unmatchedTargets = new ArrayList<SceneNodeImpl>();
        this.targetAddLocation = null;
        this.sourceTransform = null;
        this.sourceClip = null;
        this.targetTransform = null;
        this.targetClip = null;
    }

    public void addSource(SceneNodeImpl sceneNodeImpl) {
        Object object;
        this.hasSource = true;
        SceneNodeType sceneNodeType = this.type;
        if (FeatureGroup.isTransitionText(sceneNodeImpl)) {
            sceneNodeType = SceneNodeType.TEXT;
        }
        if ((object = this.getItemKey(sceneNodeImpl)) != null) {
            Matchable matchable = this.members.get(object);
            if (matchable == null) {
                matchable = new Matchable(sceneNodeType);
                this.members.put(object, matchable);
            }
            matchable.addSource(sceneNodeImpl);
        } else {
            this.addUnmatchedItem(this.unmatchedSources, sceneNodeImpl);
        }
    }

    public void setTargetAddLocation(SceneNode sceneNode) {
        if (this.targetAddLocation != null || sceneNode == null || sceneNode.getClassId() != SceneNodeClassId.ELEMENT_GROUP && sceneNode.getClassId() != SceneNodeClassId.GROUP) {
            return;
        }
        for (SceneNode sceneNode2 : sceneNode.getChildren()) {
            if (FeatureGroup.isFeatureGroupType(sceneNode2)) continue;
            this.targetAddLocation = (CompositeSceneNode)sceneNode;
            return;
        }
    }

    public void addTarget(SceneNodeImpl sceneNodeImpl) {
        this.hasTarget = true;
        Object object = this.getItemKey(sceneNodeImpl);
        Matchable matchable = this.members.get(object);
        if (matchable == null) {
            this.addUnmatchedItem(this.unmatchedTargets, sceneNodeImpl);
        } else {
            matchable.addTarget(sceneNodeImpl);
        }
    }

    public void match(Map<String, String> map) {
        Matchable matchable;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.members.keySet()) {
            boolean bl;
            ArrayList<MorphablePair> arrayList2;
            matchable = this.members.get(object);
            if (matchable.sources.size() == 1 && matchable.targets.size() == 1) {
                arrayList2 = matchable.sources.get(0);
                SceneNodeImpl sceneNodeImpl = matchable.targets.get(0);
                MorphablePair morphablePair = new MorphablePair(matchable.type, (SceneNodeImpl)((Object)arrayList2), sceneNodeImpl);
                this.registerIdMatch(map, morphablePair);
                if (!this.checkDiffers((SceneNodeImpl)((Object)arrayList2), sceneNodeImpl, matchable.type)) continue;
                this.matches.add(morphablePair);
                continue;
            }
            arrayList2 = this.matchInMatchable(matchable);
            if (arrayList2 != null) {
                for (MorphablePair morphablePair : arrayList2) {
                    this.registerIdMatch(map, morphablePair);
                    if (!this.checkDiffers(morphablePair.source, morphablePair.target, matchable.type)) continue;
                    this.matches.add(morphablePair);
                }
            }
            boolean bl2 = bl = BasicFactory.isString(object) && object.toString().indexOf("|L") != -1;
            if (!bl) {
                this.addUnmatchedItemsAll(this.unmatchedSources, matchable.sources);
                this.addUnmatchedItemsAll(this.unmatchedTargets, matchable.targets);
                continue;
            }
            arrayList.add(object);
        }
        for (Object object : arrayList) {
            matchable = this.members.get(object);
            this.addUnmatchedItemsAll(this.unmatchedSources, matchable.sources);
            this.addUnmatchedItemsAll(this.unmatchedTargets, matchable.targets);
        }
        this.members.clear();
    }

    private void registerIdMatch(Map<String, String> map, MorphablePair morphablePair) {
        String string = morphablePair.source.getId();
        String string2 = morphablePair.target.getId();
        if (string != null && string2 != null) {
            map.put(string, string2);
            if (SceneIdUtil.isPartId(string) && SceneIdUtil.isPartId(string2)) {
                string = SceneIdUtil.getMainId(string);
                string2 = SceneIdUtil.getMainId(string2);
                map.put(string, string2);
            }
        }
    }

    public void removePairs(List<MorphablePair> list) {
        for (MorphablePair morphablePair : list) {
            this.matches.remove(morphablePair);
            this.addUnmatchedItem(this.unmatchedSources, morphablePair.source);
            this.addUnmatchedItem(this.unmatchedTargets, morphablePair.target);
        }
    }

    public void processLabelTransition(List<MorphablePair> list, List<MorphablePair> list2, List<SceneNodeImpl> list3, List<SceneNodeImpl> list4) {
        for (MorphablePair object : list) {
            this.matches.remove(object);
        }
        for (MorphablePair morphablePair : list2) {
            this.matches.add(morphablePair);
        }
        for (SceneNodeImpl sceneNodeImpl : list3) {
            this.addUnmatchedItem(this.unmatchedSources, sceneNodeImpl);
        }
        for (SceneNodeImpl sceneNodeImpl : list4) {
            this.addUnmatchedItem(this.unmatchedTargets, sceneNodeImpl);
        }
    }

    public static boolean isTransitionShape(SceneNode sceneNode) {
        return sceneNode.getShape() != null && sceneNode.getChildren().size() == 0 || FeatureGroup.isTransitionMultiText(sceneNode);
    }

    public static boolean isTransitionText(SceneNode sceneNode) {
        Shape shape = (Shape)sceneNode.getShape();
        if (shape == null) {
            return false;
        }
        return shape.getType() == 1007 || shape.getType() == 1009;
    }

    public static boolean isTransitionMultiText(SceneNode sceneNode) {
        Shape shape = (Shape)sceneNode.getShape();
        if (shape == null) {
            return false;
        }
        return shape.getType() == 1007;
    }

    private Object getItemKey(SceneNodeImpl sceneNodeImpl) {
        String string;
        Object object = sceneNodeImpl.getShape().getKey();
        if (this.useForKey == 2) {
            object = sceneNodeImpl.getValue() == null ? null : sceneNodeImpl.getValue();
        } else if (this.useForKey == 0) {
            object = sceneNodeImpl.getId();
        }
        if (object == null && this.useForKey != 0) {
            return sceneNodeImpl.getId();
        }
        if (object != null && FeatureGroup.isTransitionText(sceneNodeImpl) && SceneIdUtil.identifiesElementShape(sceneNodeImpl.getId()) && !(string = "" + object).endsWith("|L")) {
            return string + "|L";
        }
        return object;
    }

    private void addUnmatchedItem(List<SceneNodeImpl> list, SceneNodeImpl sceneNodeImpl) {
        if (sceneNodeImpl.getChildren().size() == 0) {
            list.add(sceneNodeImpl);
        } else {
            for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
                list.add((SceneNodeImpl)sceneNode);
            }
        }
    }

    private void addUnmatchedItemsAll(List<SceneNodeImpl> list, List<SceneNodeImpl> list2) {
        for (SceneNodeImpl sceneNodeImpl : list2) {
            this.addUnmatchedItem(list, sceneNodeImpl);
        }
    }

    private boolean checkDiffers(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2, SceneNodeType sceneNodeType) {
        if (SceneNodeType.TEXT == sceneNodeType) {
            return this.checkTextItemDiffers(sceneNodeImpl, sceneNodeImpl2);
        }
        return FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 0) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 4) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 3) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 8) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 5);
    }

    private boolean checkTextItemDiffers(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        if (sceneNodeImpl == sceneNodeImpl2) {
            return false;
        }
        int n = sceneNodeImpl.getChildren().size();
        if (n != sceneNodeImpl2.getChildren().size()) {
            return true;
        }
        if (n == 0) {
            return FeatureGroup.textItemDiffer(sceneNodeImpl, sceneNodeImpl2);
        }
        if (FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 5)) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            SceneNodeImpl sceneNodeImpl3 = (SceneNodeImpl)sceneNodeImpl.getChildren().get(i);
            SceneNodeImpl sceneNodeImpl4 = (SceneNodeImpl)sceneNodeImpl2.getChildren().get(i);
            int n2 = sceneNodeImpl3.getChildren().size();
            if (n2 != sceneNodeImpl4.getChildren().size()) {
                return true;
            }
            if (FeatureGroup.itemPartDiffers(sceneNodeImpl3, sceneNodeImpl4, 5)) {
                return true;
            }
            for (int j = 0; j < n2; ++j) {
                SceneNodeImpl sceneNodeImpl5 = (SceneNodeImpl)sceneNodeImpl3.getChildren().get(j);
                SceneNodeImpl sceneNodeImpl6 = (SceneNodeImpl)sceneNodeImpl4.getChildren().get(j);
                if (((Shape)sceneNodeImpl5.getShape()).getType() == 1009) {
                    if (((Shape)sceneNodeImpl6.getShape()).getType() == 1009) {
                        if (!FeatureGroup.textItemDiffer(sceneNodeImpl5, sceneNodeImpl6)) continue;
                        return true;
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean textItemDiffer(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2) {
        return FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 1) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 2) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 4) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 5) || FeatureGroup.itemPartDiffers(sceneNodeImpl, sceneNodeImpl2, 0);
    }

    private static boolean itemPartDiffers(SceneNodeImpl sceneNodeImpl, SceneNodeImpl sceneNodeImpl2, int n) {
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        SceneNodeRenderInfo sceneNodeRenderInfo2 = sceneNodeImpl2.getRenderInfo();
        if (n == 0) {
            return FeatureGroup.geomDiffers(sceneNodeRenderInfo.getRenderGeom(), sceneNodeRenderInfo2.getRenderGeom());
        }
        if (n == 1) {
            return FeatureGroup.textDiffers(sceneNodeRenderInfo.getRenderText(), sceneNodeRenderInfo2.getRenderText());
        }
        if (n == 0) {
            return FeatureGroup.geomDiffers(sceneNodeRenderInfo.getRenderGeom(), sceneNodeRenderInfo2.getRenderGeom());
        }
        if (n == 2) {
            return FeatureGroup.fontDiffers(sceneNodeRenderInfo.getRenderText(), sceneNodeRenderInfo2.getRenderText());
        }
        if (n == 3) {
            return FeatureGroup.strokeDiffers(sceneNodeRenderInfo.getRenderStroke(), sceneNodeRenderInfo2.getRenderStroke());
        }
        if (n == 4) {
            return FeatureGroup.fillDiffers(sceneNodeRenderInfo.getRenderFill(), sceneNodeRenderInfo2.getRenderFill());
        }
        if (n == 8) {
            return FeatureGroup.effectsDiffers(sceneNodeRenderInfo.getRenderEffects(), sceneNodeRenderInfo2.getRenderEffects());
        }
        if (n == 5) {
            return FeatureGroup.transformDiffers(sceneNodeImpl.getTransform(), sceneNodeImpl2.getTransform());
        }
        if (n == 6) {
            return FeatureGroup.metaDiffers(sceneNodeImpl.getMetaMap(), sceneNodeImpl2.getMetaMap());
        }
        if (n == 7) {
            return FeatureGroup.stringDiffers(sceneNodeImpl.getId(), sceneNodeImpl2.getId());
        }
        throw new IllegalStateException();
    }

    private static boolean stringDiffers(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        return !string.equals(string2);
    }

    private static boolean metaDiffers(Map<String, String> map, Map<String, String> map2) {
        if (map == null) {
            return map2 != null;
        }
        if (map2 == null) {
            return true;
        }
        if (map.size() != map2.size()) {
            return true;
        }
        for (String string : map.keySet()) {
            if (map.get(string).equals(map2.get(string))) continue;
            return true;
        }
        return false;
    }

    public static boolean strokeDiffers(Stroke stroke, Stroke stroke2) {
        if (stroke == null) {
            return stroke2 != null;
        }
        if (stroke2 == null) {
            return true;
        }
        if (stroke.getWidth() != stroke2.getWidth()) {
            return true;
        }
        return FeatureGroup.colorDiffers(stroke.getColor(), stroke2.getColor()) || Math.abs(stroke.getWidth() - stroke2.getWidth()) > 0.01;
    }

    public static boolean geomDiffers(Geom geom, Geom geom2) {
        if (geom == null) {
            return geom2 != null;
        }
        if (geom2 == null) {
            return true;
        }
        return geom.type() != geom2.type() || !geom.similar(geom2);
    }

    public static boolean transformDiffers(TransformInfo transformInfo, TransformInfo transformInfo2) {
        if (transformInfo == null) {
            return transformInfo2 != null;
        }
        if (transformInfo2 == null) {
            return true;
        }
        Affine affine = transformInfo.getAffine();
        Affine affine2 = transformInfo2.getAffine();
        if (affine == null) {
            return affine2 != null;
        }
        if (affine2 == null) {
            return true;
        }
        return !affine.similar(affine2);
    }

    public static boolean fillDiffers(GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2) {
        if (gradientPaintInfo == null) {
            return gradientPaintInfo2 != null;
        }
        if (gradientPaintInfo2 == null) {
            return true;
        }
        if (FeatureGroup.colorDiffers(gradientPaintInfo.getSolid(), gradientPaintInfo2.getSolid())) {
            return true;
        }
        if (gradientPaintInfo.getColors().length != gradientPaintInfo2.getColors().length) {
            return true;
        }
        if (FeatureGroup.controlPointsDiffer(gradientPaintInfo, gradientPaintInfo2)) {
            return true;
        }
        for (int i = 0; i < gradientPaintInfo.getColors().length; ++i) {
            if (gradientPaintInfo.getOffsets()[i] != gradientPaintInfo2.getOffsets()[i]) {
                return true;
            }
            if (!FeatureGroup.colorDiffers(gradientPaintInfo.getColors()[i], gradientPaintInfo2.getColors()[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean effectsDiffers(RenderEffects renderEffects, RenderEffects renderEffects2) {
        if (renderEffects == null) {
            return renderEffects2 != null;
        }
        if (renderEffects2 == null) {
            return true;
        }
        return FeatureGroup.effectDiffers(renderEffects.getGlow(), renderEffects2.getGlow()) || FeatureGroup.effectDiffers(renderEffects.getShadow(), renderEffects2.getShadow());
    }

    public static boolean effectDiffers(RenderEffect renderEffect, RenderEffect renderEffect2) {
        if (renderEffect == null) {
            return renderEffect2 != null;
        }
        if (renderEffect2 == null) {
            return true;
        }
        return renderEffect.getStdDev() != renderEffect2.getStdDev() || renderEffect.getDX() != renderEffect2.getDX() || renderEffect.getDY() != renderEffect2.getDY() || FeatureGroup.colorDiffers(renderEffect.getColor(), renderEffect2.getColor());
    }

    private static boolean controlPointsDiffer(GradientPaintInfo gradientPaintInfo, GradientPaintInfo gradientPaintInfo2) {
        return gradientPaintInfo.getCr() != gradientPaintInfo2.getCr() || gradientPaintInfo.getCx() != gradientPaintInfo2.getCx() || gradientPaintInfo.getCy() != gradientPaintInfo2.getCy() || gradientPaintInfo.getX1() != gradientPaintInfo2.getX1() || gradientPaintInfo.getX2() != gradientPaintInfo2.getX2() || gradientPaintInfo.getY1() != gradientPaintInfo2.getY1() || gradientPaintInfo.getY2() != gradientPaintInfo2.getY2();
    }

    private static boolean colorDiffers(ColorNew colorNew, ColorNew colorNew2) {
        double[] dArray;
        if (colorNew == null) {
            return colorNew2 != null;
        }
        if (colorNew2 == null) {
            return true;
        }
        double[] dArray2 = colorNew.getRGBA();
        return dArray2[0] != (dArray = colorNew2.getRGBA())[0] || dArray2[1] != dArray[1] || dArray2[2] != dArray[2] || dArray2[3] != dArray[3];
    }

    public static boolean textDiffers(TextInfo textInfo, TextInfo textInfo2) {
        if (textInfo == null) {
            return textInfo2 != null;
        }
        if (textInfo2 == null) {
            return true;
        }
        if (!textInfo.getText().equals(textInfo2.getText())) {
            return true;
        }
        return !textInfo.getAnchorPoint().similar(textInfo2.getAnchorPoint());
    }

    private static boolean fontDiffers(TextInfo textInfo, TextInfo textInfo2) {
        FontInfo fontInfo;
        FontInfo fontInfo2 = textInfo == null ? null : textInfo.getFont();
        FontInfo fontInfo3 = fontInfo = textInfo2 == null ? null : textInfo2.getFont();
        if (fontInfo2 == null) {
            return fontInfo != null;
        }
        if (fontInfo == null) {
            return true;
        }
        return !fontInfo2.getFamily().equals(fontInfo.getFamily()) || fontInfo2.getSize() != fontInfo.getSize();
    }

    private ArrayList<MorphablePair> matchInMatchable(Matchable matchable) {
        if (matchable.targets.size() == 0) {
            return null;
        }
        SceneNodeImpl[] sceneNodeImplArray = matchable.sources.toArray(new SceneNodeImpl[matchable.sources.size()]);
        SceneNodeImpl[] sceneNodeImplArray2 = matchable.targets.toArray(new SceneNodeImpl[matchable.targets.size()]);
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        ArrayList<SceneNodeImpl> arrayList2 = new ArrayList<SceneNodeImpl>();
        ArrayList<MorphablePair> arrayList3 = new ArrayList<MorphablePair>();
        MorphablePairComparator morphablePairComparator = new MorphablePairComparator();
        ArrayList<Object> arrayList4 = null;
        HashMap<Integer, ArrayList<MorphablePair>> hashMap = new HashMap<Integer, ArrayList<MorphablePair>>();
        for (int i = 0; i < sceneNodeImplArray2.length; ++i) {
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<Object>();
            }
            for (int j = 0; j < sceneNodeImplArray.length; ++j) {
                if (sceneNodeImplArray[j] == null) continue;
                Object object = new MorphablePair(matchable.type, sceneNodeImplArray[j], sceneNodeImplArray2[i]);
                this.scorePair((MorphablePair)object);
                if (((MorphablePair)object).score >= 46) {
                    arrayList3.add((MorphablePair)object);
                    this.removeSourcePairs(hashMap, sceneNodeImplArray[j]);
                    arrayList.add(sceneNodeImplArray[j]);
                    arrayList2.add(sceneNodeImplArray2[i]);
                    sceneNodeImplArray[j] = null;
                    sceneNodeImplArray2[i] = null;
                    arrayList4 = null;
                    break;
                }
                if (((MorphablePair)object).score <= 6) continue;
                arrayList4.add(object);
            }
            if (arrayList4 == null || arrayList4.size() <= 0) continue;
            hashMap.put(i, arrayList4);
            arrayList4 = null;
        }
        this.removeMatchedFromList(matchable.sources, arrayList);
        this.removeMatchedFromList(matchable.targets, arrayList2);
        ArrayList<MorphablePair> arrayList5 = new ArrayList<MorphablePair>();
        for (Object object : hashMap.keySet()) {
            ArrayList arrayList6 = (ArrayList)hashMap.get(object);
            int n = arrayList6.size();
            if (n < 3) {
                arrayList5.addAll(arrayList6);
                continue;
            }
            if (n <= 2) continue;
            BasicFactory.sortList(arrayList6, morphablePairComparator);
            arrayList5.add((MorphablePair)arrayList6.get(0));
            arrayList5.add((MorphablePair)arrayList6.get(1));
        }
        ArrayList<MorphablePair> arrayList7 = this.getBestMorphablePairs(matchable.sources, matchable.targets, arrayList5);
        arrayList3.addAll(arrayList7);
        return arrayList3;
    }

    private ArrayList<MorphablePair> getBestMorphablePairs(ArrayList<SceneNodeImpl> arrayList, ArrayList<SceneNodeImpl> arrayList2, ArrayList<MorphablePair> arrayList3) {
        BasicFactory.sortList(arrayList3, new MorphablePairComparator());
        ArrayList<MorphablePair> arrayList4 = new ArrayList<MorphablePair>();
        while (this.acceptHighestMatch(arrayList4, arrayList, arrayList2, arrayList3)) {
        }
        return arrayList4;
    }

    private boolean acceptHighestMatch(ArrayList<MorphablePair> arrayList, ArrayList<SceneNodeImpl> arrayList2, ArrayList<SceneNodeImpl> arrayList3, ArrayList<MorphablePair> arrayList4) {
        if (arrayList4.size() < 1 || arrayList2.size() < 1 || arrayList3.size() < 1) {
            return false;
        }
        MorphablePair morphablePair = arrayList4.get(0);
        arrayList4.remove(0);
        arrayList2.remove(morphablePair.source);
        arrayList3.remove(morphablePair.target);
        this.removeCompetingPairs(arrayList4, morphablePair);
        arrayList.add(morphablePair);
        return true;
    }

    private void removeCompetingPairs(ArrayList<MorphablePair> arrayList, MorphablePair morphablePair) {
        ArrayList<MorphablePair> arrayList2 = new ArrayList<MorphablePair>();
        for (MorphablePair morphablePair2 : arrayList) {
            if (morphablePair2.source != morphablePair.source && morphablePair2.target != morphablePair.target) continue;
            arrayList2.add(morphablePair2);
        }
        for (MorphablePair morphablePair2 : arrayList2) {
            arrayList.remove(morphablePair2);
        }
    }

    private void removeMatchedFromList(ArrayList<SceneNodeImpl> arrayList, ArrayList<SceneNodeImpl> arrayList2) {
        for (SceneNodeImpl sceneNodeImpl : arrayList2) {
            arrayList.remove(sceneNodeImpl);
        }
    }

    private void removeSourcePairs(Map<Integer, ArrayList<MorphablePair>> map, SceneNodeImpl sceneNodeImpl) {
        for (Integer n : map.keySet()) {
            ArrayList<MorphablePair> arrayList = map.get(n);
            MorphablePair morphablePair = null;
            for (MorphablePair morphablePair2 : arrayList) {
                if (morphablePair2.source != sceneNodeImpl) continue;
                morphablePair = morphablePair2;
                break;
            }
            if (morphablePair == null) continue;
            arrayList.remove(morphablePair);
        }
    }

    private int scorePair(MorphablePair morphablePair) {
        if (SceneNodeType.TEXT == morphablePair.type) {
            return this.scoreText(morphablePair);
        }
        int n = FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 5) ? 0 : 2;
        n += FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 3) ? 0 : 4;
        n += FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 4) ? 0 : 8;
        n += FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 6) ? 0 : 16;
        n += FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 7) ? 0 : 1;
        morphablePair.score = n += FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 0) ? 0 : 16;
        return n;
    }

    private int scoreText(MorphablePair morphablePair) {
        int n = FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 5) ? 0 : 2;
        boolean bl = FeatureGroup.itemPartDiffers(morphablePair.source, morphablePair.target, 0);
        if (bl && !SceneIdUtil.isHighlightShape(morphablePair.source.getId()) && !SceneIdUtil.isHighlightShape(morphablePair.target.getId())) {
            String[] stringArray = this.getTexts(morphablePair.source);
            String[] stringArray2 = this.getTexts(morphablePair.target);
            n += this.scoreTextPairs(stringArray, stringArray2);
        } else {
            n = 46;
        }
        morphablePair.score = n;
        return n;
    }

    private int scoreTextPairs(String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        String string = "";
        for (int i = 0; i < stringArray2.length; ++i) {
            string = string + stringArray2[i];
        }
        String string2 = "";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string2 = string2 + stringArray[n2];
        }
        n2 = stringArray.length + stringArray2.length;
        int n3 = (int)Math.floor(24 / n2);
        n3 = n3 < 1 ? 1 : n3;
        int n4 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            if (string2.indexOf(stringArray2[n]) == -1) continue;
            n4 += n3;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (string.indexOf(stringArray[n]) == -1) continue;
            n4 += n3;
        }
        n = stringArray.length == stringArray2.length ? 6 + n4 : n4;
        n = n > 26 ? 26 : n;
        return n;
    }

    private String[] getTexts(SceneNodeImpl sceneNodeImpl) {
        int n = sceneNodeImpl.getChildren().size();
        if (n == 0) {
            return new String[]{sceneNodeImpl.getRenderInfo().getRenderText().getText()};
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SceneNodeImpl sceneNodeImpl2 = (SceneNodeImpl)sceneNodeImpl.getChildren().get(i);
            stringArray[i] = sceneNodeImpl2.getRenderInfo().getRenderText().getText();
        }
        return stringArray;
    }

    public static boolean isFeatureGroupType(SceneNode sceneNode) {
        SceneNodeType sceneNodeType = sceneNode.getType();
        if (sceneNodeType == null) {
            return false;
        }
        switch (sceneNodeType) {
            case FACET: 
            case ELEMENT: 
            case LEGEND: {
                return true;
            }
        }
        return SceneNodeTypeUtil.isAxis(sceneNodeType);
    }

    public static int getKey(SceneNode sceneNode) {
        SceneNodeType sceneNodeType = sceneNode.getType();
        switch (sceneNodeType) {
            case ELEMENT: {
                return 1;
            }
            case LEGEND: {
                return 2;
            }
        }
        if (SceneNodeTypeUtil.isAxis(sceneNodeType)) {
            return 2;
        }
        return 0;
    }

    public static String getBaseId(SceneNode sceneNode) {
        if (sceneNode.getId() != null) {
            return FeatureGroup.baseIdForGroup(sceneNode.getId());
        }
        if (sceneNode.getChildren().size() > 0) {
            return FeatureGroup.getBaseId(sceneNode.getChildren().get(0));
        }
        return null;
    }

    public static String baseIdForGroup(String string) {
        int n;
        int n2;
        if (string == null || string.length() == 1) {
            return null;
        }
        if (string.indexOf("L") == 0) {
            int n3 = string.indexOf("LE");
            if (n3 > 0) {
                return string.substring(0, n3 + 2);
            }
            n3 = string.indexOf("LC");
            if (n3 > 0) {
                return string.substring(0, n3 + 3);
            }
            return string;
        }
        int n4 = string.indexOf(69);
        if (n4 > -1) {
            n2 = string.indexOf(83);
            if (n2 > 0) {
                return string.substring(0, n2 + 1);
            }
            n = string.indexOf(76);
            if (n > 0) {
                return string.substring(0, n + 1);
            }
        }
        if ((n2 = string.indexOf(65)) > -1) {
            n = string.indexOf(84);
            if (n > 0) {
                return string.substring(0, n + 1);
            }
            int n5 = string.indexOf(78);
            if (n5 > 0) {
                return string.substring(0, n5 + 1);
            }
            int n6 = string.indexOf(71, n2);
            if (n6 > 0) {
                return string.substring(0, n6 + 1);
            }
            int n7 = string.indexOf(77);
            if (n7 > 0) {
                return string.substring(0, n7 + 1);
            }
            int n8 = string.indexOf(76);
            if (n8 > 0) {
                return string.substring(0, n8 + 1);
            }
        }
        if (string.charAt(0) == 'G') {
            return string.substring(0, 2);
        }
        return string;
    }
}

