/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.morph;

import com.ibm.vis.engine.internal.interaction.morph.FeatureGroup;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.SceneNodeTypeUtil;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ItemMatcher {
    private final Map<String, FeatureGroup> sceneParts = new HashMap<String, FeatureGroup>();
    public final List<FeatureGroup> featureGroups = new ArrayList<FeatureGroup>();
    private int pseudoIdCounter = 0;
    private final Map<String, String> idMap = new HashMap<String, String>();
    public static final SceneNodeType SCENE_ROOT = SceneNodeType.ROOT;
    public static final String SCENE_ROOT_BASEID = SceneNodeTypeUtil.toString(SceneNodeType.ROOT);

    public ItemMatcher(SceneTree sceneTree, SceneTree sceneTree2) {
        this.processScene(sceneTree.getRoot(), true);
        this.processScene(sceneTree2.getRoot(), false);
        this.match();
    }

    public Map<String, String> getIDMap() {
        return this.idMap;
    }

    private void processScene(SceneNodeImpl sceneNodeImpl, boolean bl) {
        FeatureGroup featureGroup = this.getFeatureGroup(SCENE_ROOT_BASEID, SCENE_ROOT, 0);
        if (!bl) {
            featureGroup.setTargetAddLocation(sceneNodeImpl);
        }
        this.processSceneRecursive(featureGroup, sceneNodeImpl, bl);
    }

    private void processSceneRecursive(FeatureGroup featureGroup, SceneNodeImpl sceneNodeImpl, boolean bl) {
        if (FeatureGroup.isTransitionShape(sceneNodeImpl)) {
            if (bl) {
                featureGroup.addSource(sceneNodeImpl);
            } else {
                featureGroup.addTarget(sceneNodeImpl);
            }
            return;
        }
        if (sceneNodeImpl.getChildren().size() == 0) {
            return;
        }
        if (!bl) {
            featureGroup.setTargetAddLocation(sceneNodeImpl);
        }
        for (SceneNode sceneNode : sceneNodeImpl.getChildren()) {
            if (ItemMatcher.needsFeatureGroup(sceneNode)) {
                FeatureGroup featureGroup2 = this.getFeatureGroup(FeatureGroup.getBaseId(sceneNode), sceneNode.getType(), FeatureGroup.getKey(sceneNode));
                this.setTransformAndClipInfo(featureGroup2, (SceneNodeImpl)sceneNode, bl);
                this.processSceneRecursive(featureGroup2, (SceneNodeImpl)sceneNode, bl);
                continue;
            }
            this.processSceneRecursive(featureGroup, (SceneNodeImpl)sceneNode, bl);
        }
    }

    private static boolean needsFeatureGroup(SceneNode sceneNode) {
        if (sceneNode.getChildren().size() == 0) {
            return false;
        }
        return FeatureGroup.isFeatureGroupType(sceneNode);
    }

    private void setTransformAndClipInfo(FeatureGroup featureGroup, SceneNodeImpl sceneNodeImpl, boolean bl) {
        TransformInfo transformInfo = sceneNodeImpl.getTransform();
        Rect rect = sceneNodeImpl.getClipBounds();
        if (bl) {
            featureGroup.sourceTransform = transformInfo;
            featureGroup.sourceClip = rect;
        } else {
            featureGroup.targetGroup = sceneNodeImpl;
            featureGroup.targetTransform = transformInfo;
            featureGroup.targetClip = rect;
        }
    }

    private FeatureGroup getFeatureGroup(String string, SceneNodeType sceneNodeType, int n) {
        FeatureGroup featureGroup;
        if (string == null) {
            string = "PFG" + this.pseudoIdCounter;
            ++this.pseudoIdCounter;
        }
        if ((featureGroup = this.sceneParts.get(string)) == null) {
            featureGroup = new FeatureGroup(string, sceneNodeType, n);
            this.sceneParts.put(string, featureGroup);
            this.featureGroups.add(featureGroup);
        }
        return featureGroup;
    }

    private void match() {
        for (String string : this.sceneParts.keySet()) {
            FeatureGroup featureGroup = this.sceneParts.get(string);
            featureGroup.match(this.idMap);
        }
    }
}

