/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.layout;

import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.layout.ContentLayout;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FlowLayout
implements ContentLayout {
    public static final ContentLayout TITLE_LAYOUT = new FlowLayout(true, false);
    public static final ContentLayout VERTICAL = new FlowLayout(true, true);
    public static final ContentLayout HORIZONTAL = new FlowLayout(false, true);
    private final boolean isVertical;
    private final boolean offFlowRestricted;

    private FlowLayout(boolean bl, boolean bl2) {
        this.isVertical = bl;
        this.offFlowRestricted = bl2;
    }

    @Override
    public void layout(ContentFrame contentFrame, Dim dim, Dim dim2) {
        double d;
        Object object;
        int n;
        boolean bl;
        Object object2;
        Object object3;
        ArrayList<ContentFrame> arrayList = contentFrame.getChildren();
        int n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        Dim dim3 = contentFrame.getExtent();
        double d2 = this.getInFlowDim(dim3);
        double d3 = this.getOffFlowDim(dim3);
        if (n2 == 1) {
            ContentFrame contentFrame2 = arrayList.get(0);
            this.layoutSingleton(contentFrame2, this.getRestrictedSize(contentFrame2, dim3), d2, d3, dim, dim2);
            return;
        }
        ArrayList<ContentFrame> arrayList2 = new ArrayList<ContentFrame>();
        HashMap<ContentFrame, SizeInfo> hashMap = new HashMap<ContentFrame, SizeInfo>();
        double d4 = d2;
        for (ContentFrame contentFrame3 : arrayList) {
            SizeInfo sizeInfo = this.getRestrictedSize(contentFrame3, dim3);
            hashMap.put(contentFrame3, sizeInfo);
            Dim dim4 = sizeInfo.getMinimum().toDim(dim, dim2);
            object3 = sizeInfo.getPreferred().toDim(dim, dim2);
            double d5 = this.getInFlowDim(dim4);
            if (((Dim)object3).getWidth() <= 0.0 || ((Dim)object3).getHeight() <= 0.0 || !FlowLayout.fits(d5, d2) || !FlowLayout.fits(this.getOffFlowDim(dim4), d3)) {
                contentFrame3.layoutWithBounds(new Rect(0.0, 0.0, 0.0, 0.0), dim, dim2);
                continue;
            }
            if (!FlowLayout.fits(d5, d4)) {
                d4 = -1.0;
                contentFrame3.layoutWithBounds(new Rect(0.0, 0.0, 0.0, 0.0), dim, dim2);
                continue;
            }
            d4 -= d5;
            arrayList2.add(contentFrame3);
        }
        n2 = arrayList2.size();
        if (n2 == 0) {
            return;
        }
        if (n2 == 1) {
            object2 = (ContentFrame)arrayList2.get(0);
            this.layoutSingleton((ContentFrame)object2, (SizeInfo)hashMap.get(object2), d2, d3, dim, dim2);
            return;
        }
        object2 = new ContentFrame[n2];
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            object2[i] = object3 = (ContentFrame)arrayList2.get(i);
            Dim dim5 = ((SizeInfo)hashMap.get(object3)).getPreferred().toDim(dim, dim2);
            d6 += this.getInFlowDim(dim5);
        }
        double[] dArray = new double[n2];
        object3 = new double[n2];
        double d7 = 0.0;
        if (FlowLayout.fits(d6, d2)) {
            bl = true;
            for (n = 0; n < n2; ++n) {
                object = ((SizeInfo)hashMap.get(object2[n])).getMaximum().toDim(dim, dim2);
                dArray[n] = Math.min(d2, this.getInFlowDim((Dim)object));
                object3[n] = Math.min(d3, this.getOffFlowDim((Dim)object));
                d7 += dArray[n];
            }
        } else {
            bl = false;
            for (n = 0; n < n2; ++n) {
                object = ((SizeInfo)hashMap.get(object2[n])).getPreferred().toDim(dim, dim2);
                dArray[n] = Math.min(d2, this.getInFlowDim((Dim)object));
                Dim dim6 = ((SizeInfo)hashMap.get(object2[n])).getMaximum().toDim(dim, dim2);
                object3[n] = Math.min(d3, this.getOffFlowDim(dim6));
                d7 += dArray[n];
            }
        }
        if (FlowLayout.fits(d7, d2)) {
            double d8;
            if (this.isVertical) {
                d8 = 0.0;
            } else {
                double d9 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d9 += dArray[i];
                }
                d8 = (d2 - d9) / 2.0;
            }
            for (int i = 0; i < n2; ++i) {
                object2[i].layoutWithBounds(this.makeLayoutRect(object2[i], d8, dArray[i], (double)object3[i], d3), dim, dim2);
                d8 += dArray[i];
            }
            return;
        }
        d4 = d2;
        double[] dArray2 = new double[n2];
        object = new boolean[n2];
        int n3 = 0;
        double d10 = d2;
        for (int i = 0; i < n2; ++i) {
            ContentFrame contentFrame4 = object2[i];
            d = bl ? this.getInFlowDim(((SizeInfo)hashMap.get(contentFrame4)).getPreferred().toDim(dim, dim2)) : this.getInFlowDim(((SizeInfo)hashMap.get(object2[i])).getMinimum().toDim(dim, dim2));
            dArray2[i] = d;
            double d11 = dArray[i] - d;
            if (d11 < 0.5) {
                object[i] = true;
            } else {
                d10 = Math.min(d10, dArray[i] - d);
                ++n3;
            }
            d4 -= d;
        }
        while (n3 > 0 && d4 > 0.5 && d10 > 0.5) {
            double d12 = Math.min(d10, d4 / (double)n3);
            d = d2;
            for (int i = 0; i < n2; ++i) {
                if (object[i] != false) continue;
                int n4 = i;
                dArray2[n4] = dArray2[n4] + d12;
                d4 -= d12;
                double d13 = dArray[i] - dArray2[i];
                if (d13 < 0.5) {
                    object[i] = true;
                    --n3;
                    continue;
                }
                d = Math.min(d, d13);
            }
            d10 = d;
        }
        double d14 = 0.0;
        for (int i = 0; i < n2; ++i) {
            object2[i].layoutWithBounds(this.makeLayoutRect(object2[i], d14, dArray2[i], (double)object3[i], d3), dim, dim2);
            d14 += dArray2[i];
        }
    }

    private SizeInfo getRestrictedSize(ContentFrame contentFrame, Dim dim) {
        if (!this.offFlowRestricted) {
            return contentFrame.getSizeInfo(null, null);
        }
        if (!this.isVertical) {
            return contentFrame.getSizeInfo(null, dim.getHeight());
        }
        return contentFrame.getSizeInfo(dim.getWidth(), null);
    }

    private void layoutSingleton(ContentFrame contentFrame, SizeInfo sizeInfo, double d, double d2, Dim dim, Dim dim2) {
        Dim dim3 = sizeInfo.getMinimum().toDim(dim, dim2);
        if (!FlowLayout.fits(this.getInFlowDim(dim3), d) || !FlowLayout.fits(this.getOffFlowDim(dim3), d2)) {
            contentFrame.layoutWithBounds(new Rect(0.0, 0.0, 0.0, 0.0), dim, dim2);
        } else {
            Dim dim4 = sizeInfo.getPreferred().toDim(dim, dim2);
            Dim dim5 = sizeInfo.getMaximum().toDim(dim, dim2);
            double d3 = this.getInFlowDim(dim4);
            double d4 = FlowLayout.fits(d3, d) ? Math.min(d, this.getInFlowDim(dim5)) : Math.min(d, d3);
            double d5 = Math.min(d2, this.getOffFlowDim(dim5));
            double d6 = this.alignWithinParent(contentFrame.getStyle());
            double d7 = (d - d4) * d6;
            Rect rect = this.makeLayoutRect(contentFrame, d7, d4, d5, d2);
            contentFrame.layoutWithBounds(rect, dim, dim2);
        }
    }

    private double alignWithinParent(StyleSpec styleSpec) {
        String string;
        String string2 = styleSpec == null ? null : (string = this.isVertical ? styleSpec.valign : styleSpec.align);
        if ("start".equals(string)) {
            return 0.0;
        }
        if ("end".equals(string)) {
            return 1.0;
        }
        if ("middle".equals(string)) {
            return 0.5;
        }
        return this.isVertical ? 0.0 : 0.5;
    }

    private Length getInFlowLength(Size size) {
        return this.isVertical ? size.getHeight() : size.getWidth();
    }

    private Length getOffFlowLength(Size size) {
        return this.isVertical ? size.getWidth() : size.getHeight();
    }

    private double getInFlowDim(Dim dim) {
        return this.isVertical ? dim.getHeight() : dim.getWidth();
    }

    private double getOffFlowDim(Dim dim) {
        return this.isVertical ? dim.getWidth() : dim.getHeight();
    }

    private Rect makeLayoutRect(ContentFrame contentFrame, double d, double d2, double d3, double d4) {
        String string = "start";
        double d5 = 0.0;
        if ("middle".equals(string)) {
            d5 = (d4 - d3) / 2.0;
        } else if ("end".equals(string)) {
            d5 = d4 - d3;
        }
        if (!this.isVertical) {
            return new Rect(d, d5, d2, d3);
        }
        return new Rect(d5, d, d3, d2);
    }

    private Size makeLayoutDim(Length length, Length length2) {
        if (!this.isVertical) {
            return new Size(length, length2);
        }
        return new Size(length2, length);
    }

    @Override
    public SizeInfo getSizeInfo(ContentFrame contentFrame, Double d, Double d2) {
        Size size = null;
        Length length = Lengths.ZERO;
        Length length2 = Lengths.ZERO;
        Length length3 = Lengths.ZERO;
        Length length4 = Lengths.ZERO;
        Length length5 = Lengths.ZERO;
        Length length6 = Lengths.ZERO;
        SizeInfo sizeInfo = null;
        for (ContentFrame object2 : contentFrame.getChildren()) {
            sizeInfo = object2.getSizeInfo(d, d2);
            size = sizeInfo.getPreferred();
            length = Lengths.sum(length, this.getInFlowLength(size));
            length2 = Lengths.max(length2, this.getOffFlowLength(size));
            size = sizeInfo.getMinimum();
            length5 = Lengths.sum(length5, this.getInFlowLength(size));
            length6 = Lengths.max(length6, this.getOffFlowLength(size));
            size = sizeInfo.getMaximum();
            length3 = Lengths.sum(length3, this.getInFlowLength(size));
            length4 = Lengths.max(length4, this.getOffFlowLength(size));
        }
        Size size2 = this.makeLayoutDim(length, length2);
        Size size3 = this.makeLayoutDim(length5, length6);
        Size size4 = this.makeLayoutDim(length3, length4);
        return new SizeInfo(size2, size3, size4);
    }

    private static boolean fits(double d, double d2) {
        return d <= d2 + 0.25;
    }
}

