/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.layout;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.layout.ContentLayout;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class OverlayLayout
implements ContentLayout {
    public static final OverlayLayout INSTANCE = new OverlayLayout();

    @Override
    public SizeInfo getSizeInfo(ContentFrame contentFrame, Double d, Double d2) {
        Size size = Size.ZERO;
        Size size2 = Size.ZERO;
        Size size3 = Size.ZERO;
        for (ContentFrame contentFrame2 : contentFrame.getChildren()) {
            SizeInfo sizeInfo = contentFrame2.getSizeInfo(d, d2);
            Bounds bounds = contentFrame2.getSpecifiedBounds();
            size = Size.max(size, OverlayLayout.modifyWithDefinedPositions(sizeInfo.getMinimum(), bounds));
            size2 = Size.max(size2, OverlayLayout.modifyWithDefinedPositions(sizeInfo.getPreferred(), bounds));
            size3 = Size.max(size3, OverlayLayout.modifyWithDefinedPositions(sizeInfo.getMaximum(), bounds));
        }
        return new SizeInfo(size2, size, size3);
    }

    @Override
    public void layout(ContentFrame contentFrame, Dim dim, Dim dim2) {
        Dim dim3 = contentFrame.getExtent();
        Rect rect = new Rect(0.0, 0.0, dim3.getWidth(), dim3.getHeight());
        for (ContentFrame contentFrame2 : contentFrame.getChildren()) {
            Bounds bounds = contentFrame2.getSpecifiedBounds();
            if (bounds != null) {
                Rect rect2 = bounds.getRect(dim3);
                rect2 = rect.makeIntersection(rect2);
                contentFrame2.layoutWithBounds(rect2, dim, dim2);
                continue;
            }
            contentFrame2.layoutWithBounds(rect, dim, dim2);
        }
    }

    private static Size modifyWithDefinedPositions(Size size, Bounds bounds) {
        Size size2 = size;
        if (bounds != null) {
            Length length = size.getWidth();
            Length length2 = size.getHeight();
            Length length3 = null;
            Length length4 = null;
            Length length5 = null;
            Length length6 = null;
            Object object = bounds.getValue("width");
            if (object != null) {
                length = Lengths.fromSpec(object);
            }
            if ((object = bounds.getValue("height")) != null) {
                length2 = Lengths.fromSpec(object);
            }
            if ((object = bounds.getValue("left")) != null) {
                length6 = Lengths.fromSpec(object);
            }
            if ((object = bounds.getValue("right")) != null) {
                length4 = Lengths.fromSpec(object);
            }
            if ((object = bounds.getValue("top")) != null) {
                length3 = Lengths.fromSpec(object);
            }
            if ((object = bounds.getValue("bottom")) != null) {
                length5 = Lengths.fromSpec(object);
            }
            length = OverlayLayout.adjustDim(length, length6, length4);
            length2 = OverlayLayout.adjustDim(length2, length3, length5);
            size2 = new Size(length, length2);
        }
        return size2;
    }

    private static Length adjustDim(Length length, Length length2, Length length3) {
        Length length4 = length;
        if (length3 != null) {
            length4 = length3.isNegative() ? Lengths.sum(Lengths.abs(length3), length4) : length3;
        } else if (length2 != null && length4 != null && !length2.isNegative()) {
            length4 = Lengths.sum(length2, length4);
        }
        return length4;
    }
}

