/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.layout.length;

import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.layout.length.AbsLength;
import com.ibm.vis.engine.internal.layout.length.CeilLength;
import com.ibm.vis.engine.internal.layout.length.FixedLength;
import com.ibm.vis.engine.internal.layout.length.FractionOverallLength;
import com.ibm.vis.engine.internal.layout.length.FractionParentLength;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.MaxLength;
import com.ibm.vis.engine.internal.layout.length.MinLength;
import com.ibm.vis.engine.internal.layout.length.SubtractLength;
import com.ibm.vis.engine.internal.layout.length.SumLength;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Lengths {
    public static final Length UNLIMITED = Lengths.makeFixed(Double.POSITIVE_INFINITY);
    public static final Length ZERO = Lengths.makeFixed(0.0);

    private Lengths() {
    }

    public static Length makeFixed(double d) {
        return new FixedLength(d);
    }

    public static Length makeFractionParent(double d) {
        return new FractionParentLength(d);
    }

    public static Length makeFractionOverall(double d) {
        return new FractionOverallLength(d);
    }

    public static Length max(Length length, Length length2) {
        assert (!length.isNegative());
        assert (!length2.isNegative());
        if (length instanceof FixedLength && length2 instanceof FixedLength) {
            return new FixedLength(Math.max(((FixedLength)length).getValue(), ((FixedLength)length2).getValue()));
        }
        if (length instanceof FractionParentLength && length2 instanceof FractionParentLength) {
            return new FractionParentLength(Math.max(((FractionParentLength)length).getValue(), ((FractionParentLength)length2).getValue()));
        }
        if (length instanceof FractionOverallLength && length2 instanceof FractionOverallLength) {
            return new FractionOverallLength(Math.max(((FractionOverallLength)length).getValue(), ((FractionOverallLength)length2).getValue()));
        }
        return new MaxLength(length, length2);
    }

    public static Length min(Length length, Length length2) {
        assert (!length.isNegative());
        assert (!length2.isNegative());
        if (length instanceof FixedLength && length2 instanceof FixedLength) {
            return new FixedLength(Math.min(((FixedLength)length).getValue(), ((FixedLength)length2).getValue()));
        }
        if (length instanceof FractionParentLength && length2 instanceof FractionParentLength) {
            return new FractionParentLength(Math.min(((FractionParentLength)length).getValue(), ((FractionParentLength)length2).getValue()));
        }
        if (length instanceof FractionOverallLength && length2 instanceof FractionOverallLength) {
            return new FractionOverallLength(Math.min(((FractionOverallLength)length).getValue(), ((FractionOverallLength)length2).getValue()));
        }
        return new MinLength(length, length2);
    }

    public static Length sum(Length length, Length length2) {
        assert (!length.isNegative());
        assert (!length2.isNegative());
        if (length instanceof FixedLength && length2 instanceof FixedLength) {
            return new FixedLength(((FixedLength)length).getValue() + ((FixedLength)length2).getValue());
        }
        if (length instanceof FractionParentLength && length2 instanceof FractionParentLength) {
            return new FractionParentLength(((FractionParentLength)length).getValue() + ((FractionParentLength)length2).getValue());
        }
        if (length instanceof FractionOverallLength && length2 instanceof FractionOverallLength) {
            return new FractionOverallLength(((FractionOverallLength)length).getValue() + ((FractionOverallLength)length2).getValue());
        }
        return new SumLength(length, length2);
    }

    public static Length subtract(Length length, Length length2) {
        if (length instanceof FixedLength && length2 instanceof FixedLength) {
            return new FixedLength(((FixedLength)length).getValue() - ((FixedLength)length2).getValue());
        }
        if (length instanceof FractionParentLength && length2 instanceof FractionParentLength) {
            return new FractionParentLength(((FractionParentLength)length).getValue() - ((FractionParentLength)length2).getValue());
        }
        if (length instanceof FractionOverallLength && length2 instanceof FractionOverallLength) {
            return new FractionOverallLength(((FractionOverallLength)length).getValue() - ((FractionOverallLength)length2).getValue());
        }
        return new SubtractLength(length, length2);
    }

    public static Length ceil(Length length) {
        double d;
        Length length2 = length instanceof FixedLength ? (Double.isInfinite(d = ((FixedLength)length).getValue()) ? length : new FixedLength(Math.ceil(d))) : new CeilLength(length);
        return length2;
    }

    public static Length abs(Length length) {
        if (length instanceof FixedLength) {
            return new FixedLength(Math.abs(((FixedLength)length).getValue()));
        }
        if (length instanceof FractionParentLength) {
            return new FractionParentLength(Math.abs(((FractionParentLength)length).getValue()));
        }
        if (length instanceof FractionOverallLength) {
            return new FractionOverallLength(Math.abs(((FractionOverallLength)length).getValue()));
        }
        return new AbsLength(length);
    }

    public static Length fromSpec(Object object) {
        Object object2;
        assert (object != null);
        Length length = null;
        if (BasicFactory.isString(object)) {
            if (BasicFactory.isWhitespaceString(object.toString())) {
                throw new EngineException("Empty value can not be converted to length", ErrorCode.PARAMETER_VALUE_IS_EMPTY, object.toString());
            }
            object2 = (String)object;
            int n = ((String)object2).length();
            if (n >= 2 && ((String)object2).substring(n - 1, n).equals("%")) {
                length = ((String)object2).substring(n - 2, n - 1).equals("%") ? new FractionOverallLength(Lengths.tryParse(((String)object2).substring(0, n - 2)) / 100.0) : new FractionParentLength(Lengths.tryParse(((String)object2).substring(0, n - 1)) / 100.0);
            }
        }
        if (length == null) {
            object2 = UnitConverter.convertLength(object, null, null);
            if (object2 != null) {
                length = new FixedLength((Double)object2);
            } else {
                throw new EngineException("Could not parse the length ", ErrorCode.SPEC_INVALID_LENGTH, object.toString());
            }
        }
        return length;
    }

    static double tryParse(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new EngineException("Could not parse the length ", ErrorCode.SPEC_INVALID_LENGTH, string);
        }
    }
}

