/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.layout.length;

import com.ibm.vis.engine.internal.layout.length.FixedLength;
import com.ibm.vis.engine.internal.layout.length.FractionOverallLength;
import com.ibm.vis.engine.internal.layout.length.FractionParentLength;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.PaddingSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Size {
    public static final Size ZERO = Size.makeFixed(0.0, 0.0);
    public static final Size UNLIMITED = Size.makeFixed(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Length width;
    private final Length height;

    public Size(Length length, Length length2) {
        this.width = length;
        this.height = length2;
    }

    public static Size makeFixed(double d, double d2) {
        return new Size(Lengths.makeFixed(d), Lengths.makeFixed(d2));
    }

    public static Size ceil(Size size) {
        return new Size(Lengths.ceil(size.width), Lengths.ceil(size.height));
    }

    public static Size max(Size size, Size size2) {
        return new Size(Lengths.max(size.width, size2.width), Lengths.max(size.height, size2.height));
    }

    public static Size sum(Size size, Size size2) {
        return new Size(Lengths.sum(size.width, size2.width), Lengths.sum(size.height, size2.height));
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getHeight() {
        return this.height;
    }

    public Dim toDim(Dim dim, Dim dim2) {
        assert (dim.getWidth() >= 0.0 && dim.getHeight() >= 0.0);
        assert (dim2.getWidth() >= 0.0 && dim2.getHeight() >= 0.0);
        double d = this.width.resolve(dim.getWidth(), dim2.getWidth());
        double d2 = this.height.resolve(dim.getHeight(), dim2.getHeight());
        return new Dim(d, d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Size)) {
            return false;
        }
        Size size = (Size)object;
        if (!this.height.equals(size.height)) {
            return false;
        }
        return this.width.equals(size.width);
    }

    public int hashCode() {
        int n = this.width.hashCode();
        n = 31 * n + this.height.hashCode();
        return n;
    }

    public String toString() {
        return this.width + " x " + this.height;
    }

    public Size pad(Object object) {
        Length length = Lengths.ZERO;
        Length length2 = Lengths.ZERO;
        Length length3 = Lengths.ZERO;
        Length length4 = Lengths.ZERO;
        if (object instanceof PaddingSpec) {
            PaddingSpec paddingSpec = (PaddingSpec)object;
            if (paddingSpec.right != null) {
                length = Lengths.fromSpec(paddingSpec.right);
            }
            if (paddingSpec.left != null) {
                length2 = Lengths.fromSpec(paddingSpec.left);
            }
            if (paddingSpec.top != null) {
                length3 = Lengths.fromSpec(paddingSpec.top);
            }
            if (paddingSpec.bottom != null) {
                length4 = Lengths.fromSpec(paddingSpec.bottom);
            }
        } else {
            Length length5;
            length = length5 = Lengths.fromSpec(object);
            length2 = length5;
            length3 = length5;
            length4 = length5;
        }
        return new Size(Size.padLength(this.width, length, length2), Size.padLength(this.height, length3, length4));
    }

    private static Length padLength(Length length, Length length2, Length length3) {
        if (length instanceof FixedLength) {
            double d = 0.0;
            double d2 = ((FixedLength)length).getValue();
            if (length2 instanceof FixedLength) {
                d2 += ((FixedLength)length2).getValue();
            } else if (length2 instanceof FractionParentLength) {
                d += ((FractionParentLength)length2).getValue();
            } else if (length2 instanceof FractionOverallLength) {
                d += ((FractionOverallLength)length2).getValue();
            } else {
                throw new EngineException("Size#padLength was called with an unknown pad type (not fixed value, fraction, or percent)", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
            }
            if (length3 instanceof FixedLength) {
                d2 += ((FixedLength)length3).getValue();
            } else if (length3 instanceof FractionParentLength) {
                d += ((FractionParentLength)length3).getValue();
            } else if (length3 instanceof FractionOverallLength) {
                d += ((FractionOverallLength)length3).getValue();
            } else {
                throw new EngineException("Size#padLength was called with an unknown pad type (not fixed value, fraction, or percent)", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
            }
            return new FixedLength(d2 / (1.0 - d));
        }
        return Lengths.sum(length, Lengths.sum(length2, length3));
    }
}

