/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LegendAestheticGroup {
    private final List<Aesthetic> aesthetics = new ArrayList<Aesthetic>();
    private boolean uniformSources;
    private final Element element;
    private final LabelProducer labelProducer;
    private final Field field;
    private final Scale scale;
    private boolean uniformSecondaryProperties;
    private final String type;
    private final JSONArray paletteSpecAsJSON;
    private final JSONArray mappingSpecAsJSON;
    private final ModifiesSpec modifiesSpec;

    LegendAestheticGroup(Aesthetic aesthetic) {
        this.aesthetics.add(aesthetic);
        this.uniformSources = true;
        this.uniformSecondaryProperties = true;
        this.element = aesthetic.element;
        this.labelProducer = aesthetic.labelProducer;
        this.field = aesthetic.valueProvider.getBaseField();
        this.scale = aesthetic.scale;
        this.type = aesthetic.type;
        this.paletteSpecAsJSON = LegendAestheticGroup.specArrayToJSON(aesthetic.spec.palette);
        this.mappingSpecAsJSON = LegendAestheticGroup.specArrayToJSON(aesthetic.spec.mapping);
        this.modifiesSpec = this.getModifies(aesthetic.spec);
    }

    final List<Aesthetic> getAesthetics() {
        return this.aesthetics;
    }

    final boolean hasUniformSources() {
        return this.uniformSources;
    }

    boolean addAesthetic(Aesthetic aesthetic) {
        if (this.field == null || aesthetic.valueProvider.getBaseField() == null) {
            return false;
        }
        if (!this.checkPrimaryProperties(aesthetic.valueProvider.getBaseField(), aesthetic.scale)) {
            return false;
        }
        boolean bl = this.checkSecondaryProperties(aesthetic.type, LegendAestheticGroup.specArrayToJSON(aesthetic.spec.palette), LegendAestheticGroup.specArrayToJSON(aesthetic.spec.mapping), this.getModifies(aesthetic.spec));
        if (!(this.uniformSources && aesthetic.element == this.element && aesthetic.labelProducer == this.labelProducer || this.uniformSecondaryProperties && bl)) {
            return false;
        }
        this.aesthetics.add(aesthetic);
        if (aesthetic.element != this.element || aesthetic.labelProducer != this.labelProducer) {
            this.uniformSources = false;
        }
        if (!bl) {
            this.uniformSecondaryProperties = false;
        }
        return true;
    }

    boolean mergeGroups(LegendAestheticGroup legendAestheticGroup) {
        if (this.field == null || legendAestheticGroup.field == null) {
            return false;
        }
        if (!this.checkPrimaryProperties(legendAestheticGroup.field, legendAestheticGroup.scale)) {
            return false;
        }
        boolean bl = this.checkSecondaryProperties(legendAestheticGroup.type, legendAestheticGroup.paletteSpecAsJSON, legendAestheticGroup.mappingSpecAsJSON, legendAestheticGroup.modifiesSpec);
        if (!(this.uniformSources && legendAestheticGroup.uniformSources && legendAestheticGroup.element == this.element && legendAestheticGroup.labelProducer == this.labelProducer || this.uniformSecondaryProperties && legendAestheticGroup.uniformSecondaryProperties && bl)) {
            return false;
        }
        this.aesthetics.addAll(legendAestheticGroup.aesthetics);
        if (legendAestheticGroup.element != this.element || legendAestheticGroup.labelProducer != this.labelProducer) {
            this.uniformSources = false;
        }
        if (!bl) {
            this.uniformSecondaryProperties = false;
        }
        return true;
    }

    private boolean checkPrimaryProperties(Field field, Scale scale) {
        if (field != this.field) {
            return false;
        }
        if (!field.unit.equals(this.field.unit)) {
            return false;
        }
        return scale.areCompatible(this.scale);
    }

    private boolean checkSecondaryProperties(String string, JSONArray jSONArray, JSONArray jSONArray2, ModifiesSpec modifiesSpec) {
        return this.type.equals(string) && BasicFactory.isEqual((JSONArtifact)this.paletteSpecAsJSON, (JSONArtifact)jSONArray) && BasicFactory.isEqual((JSONArtifact)this.mappingSpecAsJSON, (JSONArtifact)jSONArray2) && LegendAestheticGroup.stringEqualsWithNull(this.modifiesSpec.part, modifiesSpec.part) && LegendAestheticGroup.stringEqualsWithNull(this.modifiesSpec.type, modifiesSpec.type);
    }

    private static boolean stringEqualsWithNull(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private ModifiesSpec getModifies(AestheticSpec aestheticSpec) {
        if (aestheticSpec.modifies instanceof ModifiesSpec) {
            return (ModifiesSpec)aestheticSpec.modifies;
        }
        ModifiesSpec modifiesSpec = new ModifiesSpec();
        modifiesSpec.type = (String)aestheticSpec.modifies;
        return modifiesSpec;
    }

    protected static JSONArray specArrayToJSON(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        JSONArray jSONArray = BasicFactory.createJSONArray();
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object instanceof MappedJSONObject) {
                object = ((MappedJSONObject)object).toJSON();
            }
            BasicFactory.addAt(jSONArray, object, i);
        }
        return jSONArray;
    }
}

