/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.legend.LegendAestheticGroup;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticReferenceSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LegendAesthetics {
    protected static List<List<Aesthetic>> getDefaultSimpleLegendAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray) {
        Set<String> set = LegendAesthetics.getReferencedAestheticIDs(legendSpecArray);
        boolean bl = LegendAesthetics.isFacetChart(grammarArray);
        ArrayList arrayList = new ArrayList();
        for (Grammar grammar : grammarArray) {
            for (Element element : grammar.elements) {
                arrayList.addAll(LegendAesthetics.makeDefaultSimpleAestheticGroups(element.aesthetics, set, bl));
            }
        }
        ArrayList arrayList2 = new ArrayList();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            LegendAestheticGroup legendAestheticGroup = (LegendAestheticGroup)object.next();
            boolean bl2 = false;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                LegendAestheticGroup legendAestheticGroup2 = (LegendAestheticGroup)iterator.next();
                if (!legendAestheticGroup2.mergeGroups(legendAestheticGroup)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList2.add(legendAestheticGroup);
        }
        arrayList = arrayList2;
        object = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LegendAestheticGroup legendAestheticGroup = (LegendAestheticGroup)iterator.next();
            object.add(legendAestheticGroup.getAesthetics());
        }
        return object;
    }

    private static List<LegendAestheticGroup> makeDefaultSimpleAestheticGroups(Aesthetic[] aestheticArray, Set<String> set, boolean bl) {
        ArrayList<LegendAestheticGroup> arrayList = new ArrayList<LegendAestheticGroup>();
        if (aestheticArray == null || aestheticArray.length == 0) {
            return arrayList;
        }
        for (Aesthetic aesthetic : aestheticArray) {
            if (!LegendAesthetics.isDefaultSimpleLegendable(aesthetic, bl, set)) continue;
            boolean bl2 = false;
            for (LegendAestheticGroup legendAestheticGroup : arrayList) {
                if (!legendAestheticGroup.addAesthetic(aesthetic)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList.add(new LegendAestheticGroup(aesthetic));
        }
        return arrayList;
    }

    private static boolean isDefaultSimpleLegendable(Aesthetic aesthetic, boolean bl, Set<String> set) {
        boolean bl2 = aesthetic.scale.localScale != null && aesthetic.scale.localScale != false;
        return !(aesthetic.valueProvider.getBaseField() == null || bl2 && bl || aesthetic.id != null && set.contains(aesthetic.id) || !LegendAesthetics.isSimpleLegendable(aesthetic, true));
    }

    protected static List<List<Aesthetic>> getSimpleAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        List<Aesthetic> list = LegendAesthetics.getAestheticsByReferences(aestheticReferenceSpecArray, vis);
        int n = list.size();
        Aesthetic aesthetic = list.get(0);
        LegendAesthetics.validateSimpleLegendAesthetic(aesthetic);
        LegendAestheticGroup legendAestheticGroup = new LegendAestheticGroup(aesthetic);
        for (int i = 1; i < n; ++i) {
            aesthetic = list.get(i);
            LegendAesthetics.validateSimpleLegendAesthetic(aesthetic);
            if (legendAestheticGroup.addAesthetic(list.get(i))) continue;
            throw new SpecException("The aesthetics " + LegendAesthetics.getIDsAsString(aestheticReferenceSpecArray) + " cannot be displayed together in a simple or swatch legend", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        ArrayList<List<Aesthetic>> arrayList = new ArrayList<List<Aesthetic>>();
        arrayList.add(list);
        return arrayList;
    }

    private static void validateSimpleLegendAesthetic(Aesthetic aesthetic) {
        if (!LegendAesthetics.isSimpleLegendable(aesthetic, false)) {
            throw new SpecException("Aesthetic '" + aesthetic.id + "' of type " + aesthetic.type + " cannot be displayed by a simple or swatch legend", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
    }

    private static boolean isSimpleLegendable(Aesthetic aesthetic, boolean bl) {
        return bl ? aesthetic.isDefaultLegendAesthetic() : aesthetic.isApplicableToLegend();
    }

    protected static Set<String> getReferencedAestheticIDs(LegendSpec[] legendSpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (legendSpecArray != null) {
            for (LegendSpec legendSpec : legendSpecArray) {
                if (legendSpec.aesthetics == null) continue;
                for (AestheticReferenceSpec aestheticReferenceSpec : legendSpec.aesthetics) {
                    hashSet.add(aestheticReferenceSpec.aesthetic.$ref);
                }
            }
        }
        return hashSet;
    }

    protected static List<Aesthetic> getAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        if (aestheticReferenceSpecArray.length == 0) {
            throw new SpecException("Legends with 'aesthetics' must list at least one aesthetic", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        ArrayList<Aesthetic> arrayList = new ArrayList<Aesthetic>();
        for (AestheticReferenceSpec aestheticReferenceSpec : aestheticReferenceSpecArray) {
            if (aestheticReferenceSpec == null || aestheticReferenceSpec.aesthetic == null || aestheticReferenceSpec.aesthetic.$ref == null) {
                throw new SpecException("Legend 'aesthetics' must be non-null, and each must have a non-null 'aesthetic' with non-null '$ref' to an aesthetic", ErrorCode.SPEC_INVALID_LEGENDS, null);
            }
            IdentifiableItem identifiableItem = vis.getByID(aestheticReferenceSpec.aesthetic.$ref);
            if (!(identifiableItem instanceof Aesthetic)) {
                throw new SpecException("Legend 'aesthetics' reference '" + aestheticReferenceSpec.aesthetic.$ref + "' which is not an aesthetic", ErrorCode.SPEC_INVALID_LEGENDS, null);
            }
            Aesthetic aesthetic = (Aesthetic)identifiableItem;
            arrayList.add(aesthetic);
        }
        return arrayList;
    }

    protected static boolean isFacetChart(Grammar[] grammarArray) {
        for (Grammar grammar : grammarArray) {
            if (!grammar.isFacetChart()) continue;
            return true;
        }
        return false;
    }

    protected static String getIDsAsString(AestheticReferenceSpec[] aestheticReferenceSpecArray) {
        String string = "";
        for (int i = 0; i < aestheticReferenceSpecArray.length; ++i) {
            string = string + "'" + aestheticReferenceSpecArray[i].aesthetic.$ref + "'";
            if (i >= aestheticReferenceSpecArray.length - 1) continue;
            string = string + ",";
        }
        return string;
    }
}

