/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.legend.LegendAesthetics;
import com.ibm.vis.engine.internal.legend.SimpleLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.NonSimpleLegendMaker;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.LegendSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/legendLayer")
public class LegendMaker {
    private int legendIndex = 0;

    public List<ContentFrame> makeLegendFrames(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec) {
        if (legendSpec.elements != null && legendSpec.aesthetics != null) {
            throw new SpecException("Legends containing both 'aesthetics' and 'elements' are not supported.", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        List<ContentFrame> list = legendSpec.elements == null && (legendSpec.method == null || "simple".equals(legendSpec.method)) ? LegendMaker.makeSimpleLegends(vis, legendSpecArray, legendSpec, this.legendIndex) : NonSimpleLegendMaker.makeLegends(vis, legendSpecArray, legendSpec, this.legendIndex);
        this.legendIndex += list.size();
        return list;
    }

    private static List<ContentFrame> makeSimpleLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        List<List<Aesthetic>> list = legendSpec.aesthetics != null && legendSpec.aesthetics.length > 0 ? LegendAesthetics.getSimpleAestheticsByReferences(legendSpec.aesthetics, vis) : LegendAesthetics.getDefaultSimpleLegendAesthetics(vis.getGrammar(), legendSpecArray);
        int n2 = n;
        int n3 = 0;
        for (LegendSpec legendSpec2 : legendSpecArray) {
            if (!legendSpec2.method.equals("simple")) continue;
            ++n3;
        }
        n3 += list.size();
        for (List list2 : list) {
            SimpleLegend simpleLegend = new SimpleLegend(vis, legendSpec, n2, list2, n3);
            arrayList.add(simpleLegend);
            ++n2;
        }
        return arrayList;
    }
}

