/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.LegendPosition;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Length;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.legend.SimpleLegendBuilder;
import com.ibm.vis.engine.internal.legend.SimpleSwatch;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

class SimpleLegend
extends ContentFrame {
    private final Vis parentVis;
    private final LegendSpec legendSpec;
    private final int legendIndex;
    private final List<Aesthetic> aesthetics;
    private final SizeInfo sizeInfo;
    private final double numLegends;

    SimpleLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list, int n2) {
        this.parentVis = vis;
        this.legendSpec = legendSpec;
        this.legendIndex = n;
        this.aesthetics = list;
        this.numLegends = n2;
        this.sizeInfo = this.makeSizeInfo();
        this.setId("L" + n);
        this.setBackgroundIdSuffixes("-legendBackgroundStroke", "-legendBackgroundFill");
        this.setStyle(legendSpec.boundsStyle);
        this.setRequiresBackgroundShape(false);
    }

    private SizeInfo makeSizeInfo() {
        Object object;
        Length length = null;
        Length length2 = null;
        Length length3 = null;
        Length length4 = null;
        if (this.legendSpec.location instanceof BoundsSpec) {
            object = (BoundsSpec)this.legendSpec.location;
            if (((BoundsSpec)object).width != null) {
                length3 = length = Lengths.fromSpec(((BoundsSpec)object).width);
            }
            if (((BoundsSpec)object).height != null) {
                length4 = length2 = Lengths.fromSpec(((BoundsSpec)object).height);
            }
        }
        if (length == null || length2 == null) {
            object = this.parentVis.getLegendPosition(this.legendSpec);
            if (object == LegendPosition.TOP || object == LegendPosition.BOTTOM) {
                if (length == null) {
                    length = Lengths.makeFractionParent(1.0 / this.numLegends);
                    length3 = Lengths.makeFixed(Double.POSITIVE_INFINITY);
                }
                if (length2 == null) {
                    length4 = length2 = Lengths.makeFractionParent(0.2);
                }
            } else {
                if (length == null) {
                    length3 = length = Lengths.makeFractionParent(0.2);
                }
                if (length2 == null) {
                    length2 = Lengths.makeFractionParent(1.0 / this.numLegends);
                    length4 = Lengths.makeFixed(Double.POSITIVE_INFINITY);
                }
            }
        }
        return new SizeInfo(new Size(length, length2), new Size(length, length2), new Size(length3, length4));
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        return this.sizeInfo;
    }

    @Override
    protected List<SceneNode> createContent() {
        StyleSpec styleSpec;
        SwatchType swatchType;
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        Rect rect = this.getBounds();
        if (this.aesthetics.size() == 0) {
            return arrayList;
        }
        Aesthetic aesthetic = this.aesthetics.get(0);
        Field field = aesthetic.valueProvider.getBaseField();
        boolean bl = false;
        int n = this.aesthetics.size();
        for (int i = 0; i < n; ++i) {
            if (this.aesthetics.get((int)i).typeNumber != 4) continue;
            bl = true;
            break;
        }
        SimpleSwatch simpleSwatch = new SimpleSwatch(this.parentVis, swatchType, this.legendSpec, (swatchType = SwatchType.makeForAesthetics(this.aesthetics, this.legendSpec)).hasMixedSources() || aesthetic.element == null ? null : aesthetic.element.size, bl);
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND);
        groupSceneNode.setId("L" + this.legendIndex);
        String string = null;
        if (field != null) {
            string = field.id;
            groupSceneNode.setField(string);
        }
        arrayList.add(groupSceneNode);
        if (this.legendSpec.boundsStyle != null) {
            styleSpec = (StyleSpec)this.legendSpec.boundsStyle.copy();
        } else {
            styleSpec = new StyleSpec();
            styleSpec.padding = 0;
        }
        Insets insets = Insets.makeForStyle(styleSpec, rect.getExtent());
        double d = this.makeTitle(groupSceneNode, field, rect, insets);
        Rect rect2 = new Rect(0.0, d, rect.getWidth() - insets.left - insets.right, rect.getHeight() - d - insets.top - insets.bottom);
        SimpleLegendBuilder simpleLegendBuilder = new SimpleLegendBuilder(this.parentVis, this.legendSpec, this.legendIndex, rect2, string);
        ScaleSpan scaleSpan = aesthetic.scale.spans.get(0);
        ArrayList<Tick> arrayList2 = new ArrayList<Tick>();
        boolean bl2 = true;
        if (this.legendSpec.scale != null && this.legendSpec.scale.local != null) {
            bl2 = this.legendSpec.scale.local;
        }
        if (scaleSpan.getCategoryCount() > 0) {
            scaleSpan.setupMaxTickCount(50);
            scaleSpan.addTicks(arrayList2, bl2);
            this.buildLegendEntries(groupSceneNode, arrayList2, simpleLegendBuilder, simpleSwatch, scaleSpan, false);
        } else {
            int[] nArray = new int[]{11, 7, 3, 2};
            boolean bl3 = false;
            for (int i = 0; !bl3 && i < nArray.length; ++i) {
                arrayList2.clear();
                scaleSpan.setupForTickCount(nArray[i], nArray[i]);
                scaleSpan.addTicks(arrayList2, bl2);
                aesthetic.scale.initializeForRequiredTickCount(null);
                if (!this.buildLegendEntries(groupSceneNode, arrayList2, simpleLegendBuilder, simpleSwatch, scaleSpan, true)) continue;
                bl3 = true;
            }
            if (!bl3) {
                simpleLegendBuilder.clear();
                simpleLegendBuilder.build(groupSceneNode, true);
            }
        }
        return arrayList;
    }

    private boolean buildLegendEntries(GroupSceneNode groupSceneNode, List<Tick> list, SimpleLegendBuilder simpleLegendBuilder, SimpleSwatch simpleSwatch, ScaleSpan scaleSpan, boolean bl) {
        boolean bl2;
        SwatchType swatchType = simpleSwatch.getSwatchType();
        Dim dim = simpleSwatch.getSwatchSize();
        CustomGlyphBuilder customGlyphBuilder = simpleSwatch.getSwatchBuilder();
        double d = this.aesthetics.get((int)0).element.getMaxShapeSize();
        if (d > 0.0) {
            for (Aesthetic aesthetic : this.aesthetics) {
                if (!aesthetic.type.equals("size")) continue;
                dim = new Dim(d, d);
                if (customGlyphBuilder.spec.shape[0].style.font == null) break;
                customGlyphBuilder.spec.shape[0].style.font.size = d;
                break;
            }
        }
        Unit unit = scaleSpan.getInputUnit();
        simpleLegendBuilder.clear();
        if (scaleSpan.getCategoryCount() == 0) {
            bl2 = true;
        } else {
            LegendPosition legendPosition = this.parentVis.getLegendPosition(this.legendSpec);
            boolean bl3 = bl2 = (legendPosition == LegendPosition.LEFT || legendPosition == LegendPosition.RIGHT) && this.aesthetics.get((int)0).element.grammar.coordinates.containsStacking() && !this.aesthetics.get((int)0).element.grammar.coordinates.containsPolar();
        }
        if (this.legendSpec.scale != null && this.legendSpec.scale.reverse != null && this.legendSpec.scale.reverse.booleanValue()) {
            bl2 = !bl2;
        }
        boolean bl4 = this.aesthetics.get((int)0).scale.reverse;
        boolean bl5 = true;
        int n = list.size();
        for (int i = 0; bl5 && i < n; ++i) {
            Tick tick = bl2 ? list.get(n - 1 - i) : list.get(i);
            Double d2 = tick.value;
            Shape shape = customGlyphBuilder.makeCustomShape(0.0, 0.0, dim.getWidth(), dim.getHeight(), null);
            double d3 = scaleSpan.toZeroOne(d2, unit, true);
            if (bl4) {
                d3 = 1.0 - d3;
            }
            shape = this.applyAesthetics(shape, swatchType, d2, d3);
            bl5 = simpleLegendBuilder.addEntry(shape, tick);
        }
        if (!bl5 && bl) {
            return false;
        }
        simpleLegendBuilder.build(groupSceneNode, !bl5 || scaleSpan.getCategoryCount() > 50);
        return true;
    }

    private double makeTitle(GroupSceneNode groupSceneNode, Field field, Rect rect, Insets insets) {
        StyleSpec styleSpec;
        Object[] objectArray = null;
        if (this.legendSpec.title != null) {
            objectArray = this.legendSpec.title;
        } else if (field != null) {
            objectArray = new Object[]{field.label != null ? field.label : field.id};
        }
        if (objectArray == null || objectArray.length == 0) {
            return 0.0;
        }
        if (this.legendSpec.titleStyle != null) {
            styleSpec = (StyleSpec)this.legendSpec.titleStyle.copy();
            styleSpec.align = null;
            styleSpec.valign = null;
        } else {
            styleSpec = new StyleSpec();
            styleSpec.font = new FontSpec();
            styleSpec.font.weight = "bold";
            styleSpec.padding = 2.5;
        }
        LabelProducer labelProducer = LabelProducer.makeSimpleInside(this.parentVis, styleSpec, "middle", "start", null);
        Shape shape = ShapeFactory2.CreateRect(0.0, 0.0, rect.getWidth() - insets.left - insets.right, rect.getHeight());
        Text text = labelProducer.makeLabel(objectArray, shape);
        if (text == null) {
            return 0.0;
        }
        text.setID("L" + this.legendIndex + "T");
        if (field != null) {
            text.setField(field.id);
        }
        groupSceneNode.addChild(text.createSceneNode());
        Insets insets2 = SimpleLegendBuilder.makePaddingForStyle(styleSpec, rect.getExtent(), 2.5);
        Rect rect2 = text.getBounds();
        return rect2.getHeight() + insets2.top + insets2.bottom;
    }

    private Shape applyAesthetics(Shape shape, SwatchType swatchType, Number number, double d) {
        Shape shape2 = shape;
        switch (swatchType.getType()) {
            case 1: 
            case 6: 
            case 12: {
                shape2 = this.applySimpleAesthetics(shape2, number, d, 430);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                shape2 = this.applySimpleAesthetics(shape2, number, d, 398);
                break;
            }
            case 9: {
                shape2 = this.applySimpleAesthetics(shape2, number, d, 394);
                break;
            }
            case 3: {
                shape2 = this.applyLineWithPointAesthetics(shape2, number, d);
                break;
            }
            case 4: 
            case 5: {
                shape2 = this.applyAreaAesthetics(shape2, number, d);
                break;
            }
            case 10: {
                shape2 = this.applySimpleAesthetics(shape2, number, d, 398);
                break;
            }
            case 11: {
                shape2 = this.applySimpleAesthetics(shape2, number, d, 391);
                break;
            }
        }
        return shape2;
    }

    private Shape applySimpleAesthetics(Shape shape, Number number, double d, int n) {
        Shape shape2 = this.applyShapeAesthetics(shape.getPart(0), number, d, n);
        Schema schema = (Schema)shape;
        return new Schema(schema.getX(), schema.getY(), schema.getWidth(), schema.getHeight(), new Shape[]{shape2}, schema.isFilled());
    }

    private Shape applyAreaAesthetics(Shape shape, Number number, double d) {
        Shape shape2 = shape.getPart(0);
        Shape shape3 = shape.getPart(1);
        for (Aesthetic aesthetic : this.aesthetics) {
            String string = SimpleLegend.getModifiesType(aesthetic);
            boolean bl = "outline".equals(string);
            boolean bl2 = "both".equals(string);
            switch (aesthetic.typeNumber) {
                case 2: 
                case 128: 
                case 256: {
                    if (bl || bl2) {
                        shape3 = aesthetic.applyValue(shape3, d, number, false);
                    }
                    if (bl) break;
                    shape2 = aesthetic.applyValue(shape2, d, number, false);
                    break;
                }
                case 8: {
                    shape3 = aesthetic.applyValue(shape3, d, number, false);
                }
            }
        }
        Schema schema = (Schema)shape;
        return new Schema(schema.getX(), schema.getY(), schema.getWidth(), schema.getHeight(), new Shape[]{shape2, shape3}, schema.isFilled());
    }

    private Shape applyLineWithPointAesthetics(Shape shape, Number number, double d) {
        Shape shape2 = shape.getPart(0);
        Shape shape3 = shape.getPart(1);
        shape3.setGlyphLike();
        for (Aesthetic aesthetic : this.aesthetics) {
            String string = SimpleLegend.getModifiesPart(aesthetic);
            boolean bl = "line".equals(string);
            boolean bl2 = "both".equals(string);
            switch (aesthetic.typeNumber) {
                case 2: 
                case 4: 
                case 8: 
                case 128: 
                case 256: {
                    if (!bl) {
                        shape3 = aesthetic.applyValue(shape3, d, number, false);
                    }
                    if (!bl && !bl2 && string != null) break;
                    shape2 = aesthetic.applyValue(shape2, d, number, false);
                    break;
                }
                case 32: {
                    shape3 = aesthetic.applyValue(shape3, d, number, false);
                    break;
                }
            }
        }
        Schema schema = (Schema)shape;
        return new Schema(schema.getX(), schema.getY(), schema.getWidth(), schema.getHeight(), new Shape[]{shape2, shape3}, schema.isFilled());
    }

    private Shape applyShapeAesthetics(Shape shape, Number number, double d, int n) {
        Shape shape2 = shape;
        for (Aesthetic aesthetic : this.aesthetics) {
            if ((aesthetic.typeNumber & n) == 0) continue;
            shape2 = aesthetic.applyValue(shape2, d, number, false);
        }
        return shape2;
    }

    private static String getModifiesType(Aesthetic aesthetic) {
        AestheticSpec aestheticSpec = aesthetic.spec;
        if (aestheticSpec.modifies == null) {
            return null;
        }
        if (BasicFactory.isString(aestheticSpec.modifies)) {
            return (String)aestheticSpec.modifies;
        }
        return ((ModifiesSpec)aestheticSpec.modifies).type;
    }

    private static String getModifiesPart(Aesthetic aesthetic) {
        AestheticSpec aestheticSpec = aesthetic.spec;
        if (aestheticSpec.modifies instanceof ModifiesSpec) {
            return ((ModifiesSpec)aestheticSpec.modifies).part;
        }
        return null;
    }
}

