/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

class SimpleLegendBuilder {
    private static final StyleSpec TRANSPARENT_STYLE = new StyleSpec();
    private final LegendSpec legendSpec;
    private final int legendIndex;
    private final Rect bounds;
    private final String fieldName;
    private final LabelProducer labeler;
    private final StyleSpec legendEntryStyle;
    private static final double DEFAULT_LEGEND_ENTRY_PADDING = 2.5;
    private final double totalPaddingWidth;
    private final double totalPaddingSwatchHeight;
    private final double totalPaddingLabelHeight;
    private List<Shape> swatches;
    private Dim maxSwatchSize;
    private List<Tick> labels;
    private Dim minLabelSize;
    private Dim maxLabelSize;

    SimpleLegendBuilder(Vis vis, LegendSpec legendSpec, int n, Rect rect, String string) {
        this.legendSpec = legendSpec;
        this.legendIndex = n;
        this.bounds = rect;
        this.fieldName = string;
        this.labeler = LabelProducer.makeSimpleInside(vis, legendSpec.labelStyle, "start", "middle", null);
        if (legendSpec.legendEntryStyle == null) {
            this.legendEntryStyle = TRANSPARENT_STYLE;
        } else {
            this.legendEntryStyle = (StyleSpec)legendSpec.legendEntryStyle.copy();
            if (this.legendEntryStyle.fill == null) {
                this.legendEntryStyle.fill = "transparent";
            }
            if (this.legendEntryStyle.outline == null) {
                this.legendEntryStyle.outline = "transparent";
            }
        }
        Dim dim = rect.getExtent();
        Insets insets = SimpleLegendBuilder.makePaddingForStyle(legendSpec.legendEntryStyle, dim, 2.5);
        Insets insets2 = SimpleLegendBuilder.makePaddingForStyle(legendSpec.itemStyle, dim, 0.0);
        Insets insets3 = SimpleLegendBuilder.makePaddingForStyle(legendSpec.itemBoxStyle, dim, 0.0);
        Insets insets4 = SimpleLegendBuilder.makePaddingForStyle(legendSpec.labelStyle, dim, 0.0);
        this.totalPaddingWidth = insets.getHorizontal() + insets2.getHorizontal() + insets3.left + Math.max(3.0, insets3.right + insets4.right) + insets4.right;
        this.totalPaddingSwatchHeight = insets.getVertical() + insets2.getVertical() + insets3.getVertical();
        this.totalPaddingLabelHeight = insets.getVertical() + insets4.getVertical();
        Text text = this.labeler.makeLabel(new Object[]{"\u2026"}, ShapeFactory2.CreateRect(0.0, 0.0, rect.getWidth(), rect.getHeight()));
        if (text != null) {
            Rect rect2 = text.getBounds();
            this.minLabelSize = new Dim(2.0 * rect2.getWidth(), rect2.getHeight() + 2.0);
        } else {
            this.minLabelSize = new Dim(14.0, 14.0);
        }
        this.clear();
    }

    void clear() {
        this.swatches = new ArrayList<Shape>();
        this.labels = new ArrayList<Tick>();
        this.maxSwatchSize = new Dim(0.0, 0.0);
        this.maxLabelSize = new Dim(this.minLabelSize.getWidth(), this.minLabelSize.getHeight());
    }

    boolean addEntry(Shape shape, Tick tick) {
        int n = this.swatches.size();
        Rect rect = shape.getBounds();
        double d = Math.max(rect.getWidth(), this.maxSwatchSize.getWidth());
        double d2 = Math.max(rect.getHeight(), this.maxSwatchSize.getHeight());
        Shape shape2 = ShapeFactory2.CreateRect(0.0, 0.0, this.bounds.getWidth() - this.totalPaddingWidth - d, this.minLabelSize.getHeight());
        double d3 = this.maxLabelSize.getWidth();
        double d4 = this.maxLabelSize.getHeight();
        Text text = this.labeler.makeLabelForContent(tick.content, shape2);
        if (text != null) {
            Rect rect2 = text.getBounds();
            d3 = Math.max(rect2.getWidth(), d3);
            d4 = Math.max(rect2.getHeight(), d4);
        }
        double d5 = d + this.minLabelSize.getWidth() + this.totalPaddingWidth;
        double d6 = Math.max(d2 + this.totalPaddingSwatchHeight, d4 + this.totalPaddingLabelHeight);
        int n2 = (int)Math.floor(this.bounds.getWidth() / d5) * (int)Math.floor(this.bounds.getHeight() / d6);
        if (n2 < n + 1) {
            return false;
        }
        this.maxSwatchSize.setWidth(d);
        this.maxSwatchSize.setHeight(d2);
        this.maxLabelSize.setWidth(d3);
        this.maxLabelSize.setHeight(d4);
        this.swatches.add(shape);
        this.labels.add(tick);
        return true;
    }

    void build(GroupSceneNode groupSceneNode, boolean bl) {
        int n;
        int n2;
        int n3;
        Rect[] rectArray = this.makeLayoutInfo();
        double d = rectArray[0].getWidth();
        double d2 = rectArray[0].getHeight();
        int n4 = (int)Math.floor(this.bounds.getHeight() / d2);
        if (n4 == 0) {
            n4 = 1;
        }
        if ((n3 = (int)Math.floor(this.bounds.getWidth() / d)) == 0) {
            n3 = 1;
        }
        double d3 = this.bounds.getX();
        double d4 = this.bounds.getY();
        int n5 = this.swatches.size();
        int n6 = 0;
        if (bl) {
            GroupSceneNode groupSceneNode2;
            if (n5 == n4 * n3) {
                --n5;
            }
            n2 = n5 % n4;
            n = (int)Math.floor(n5 / n4);
            if ((groupSceneNode2 = this.makeEllipsisEntry(n6++, d3 + (double)n * d, d4 + (double)n2 * d2, rectArray)) != null) {
                groupSceneNode.addChild(groupSceneNode2);
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n = n2 % n4;
            int n7 = (int)Math.floor(n2 / n4);
            groupSceneNode.addChild(this.makeLegendEntry(n2, n6++, d3 + (double)n7 * d, d4 + (double)n * d2, rectArray));
        }
    }

    private Rect[] makeLayoutInfo() {
        int n;
        double d = Math.max(this.maxSwatchSize.getHeight() + this.totalPaddingSwatchHeight, this.maxLabelSize.getHeight() + this.totalPaddingLabelHeight);
        int n2 = (int)Math.floor(this.bounds.getHeight() / d);
        if (n2 == 0) {
            n2 = 1;
        }
        if ((n = (int)Math.ceil((double)this.swatches.size() / (double)n2)) == 0) {
            n = 1;
        }
        double d2 = this.bounds.getWidth() / (double)n;
        Rect rect = new Rect(0.0, 0.0, d2, d);
        Dim dim = this.bounds.getExtent();
        Insets insets = SimpleLegendBuilder.makePaddingForStyle(this.legendSpec.legendEntryStyle, dim, 2.5);
        Rect rect2 = insets.insetRect(rect);
        double d3 = this.maxSwatchSize.getWidth();
        double d4 = this.maxSwatchSize.getHeight();
        Insets insets2 = SimpleLegendBuilder.makePaddingForStyle(this.legendSpec.itemStyle, dim, 0.0);
        double d5 = d3 + insets2.getHorizontal();
        double d6 = d4 + insets2.getVertical();
        Insets insets3 = SimpleLegendBuilder.makePaddingForStyle(this.legendSpec.itemBoxStyle, dim, 0.0);
        double d7 = (rect2.getHeight() - d6 - insets3.getVertical()) / 2.0;
        Rect rect3 = new Rect(rect2.getX() + insets3.left, rect2.getY() + insets3.top + d7, d5, d6);
        Rect rect4 = new Rect(rect3.getX() + insets2.left, rect3.getY() + insets2.top, d3, d4);
        Insets insets4 = SimpleLegendBuilder.makePaddingForStyle(this.legendSpec.labelStyle, dim, 0.0);
        double d8 = Math.max(3.0, insets3.right + insets4.left);
        double d9 = rect2.getWidth() - (d5 + insets3.left + d8 + insets4.right);
        double d10 = this.minLabelSize.getHeight();
        d7 = (rect2.getHeight() - d10 - insets4.getVertical()) / 2.0;
        Rect rect5 = new Rect(rect3.getX2() + d8, rect2.getY() + d7, d9 + insets4.left + insets4.right, d10 + insets4.top + insets4.bottom);
        return new Rect[]{rect, rect2, rect3, rect4, rect5};
    }

    private GroupSceneNode makeLegendEntry(int n, int n2, double d, double d2, Rect[] rectArray) {
        Shape shape;
        String string = "L" + this.legendIndex + "LE" + n2;
        double d3 = this.labels.get((int)n).value;
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
        groupSceneNode.setId(string);
        int n3 = this.legendSpec.itemBoxStyle != null ? 4 : 3;
        Shape[] shapeArray = new Shape[n3];
        int n4 = 0;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        shapeArray[n4] = SimpleLegendBuilder.makeRect(rectArray[1], d, d2, this.legendEntryStyle);
        arrayList.add(n4++, true);
        if (this.legendSpec.itemBoxStyle != null) {
            shapeArray[n4] = SimpleLegendBuilder.makeRect(rectArray[2], d, d2, this.legendSpec.itemBoxStyle);
            arrayList.add(n4++, false);
        }
        Shape shape2 = this.swatches.get(n);
        Point point = rectArray[3].getCenter();
        shape2.affine(1.0, d + point.getX(), 1.0, d2 + point.getY(), true);
        shapeArray[n4] = shape2;
        arrayList.add(n4++, true);
        shapeArray[n4] = shape = SimpleLegendBuilder.makeRect(rectArray[4], d, d2, TRANSPARENT_STYLE);
        arrayList.add(n4++, true);
        for (int i = 0; i < n3; ++i) {
            shapeArray[i].setField(this.fieldName);
            shapeArray[i].setValue(d3);
        }
        Schema schema = new Schema(d, d2, rectArray[0].getWidth(), rectArray[0].getY(), shapeArray, true);
        schema.setID(string + "SW0");
        schema.setField(this.fieldName);
        schema.setValue(d3);
        ImageStyle.addImageShape(schema, groupSceneNode.getChildren());
        groupSceneNode.addChild(schema.createSceneNode());
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((Boolean)arrayList.get(i)).booleanValue()) continue;
            shapeArray[i].setID(shapeArray[i].getID() + "Y");
        }
        Text text = this.labeler.makeLabelForContent(this.labels.get((int)n).content, shape);
        if (text != null) {
            text.setID(string + "T");
            text.setField(this.fieldName);
            text.setValue(d3);
            groupSceneNode.addChild(text.createSceneNode());
        }
        return groupSceneNode;
    }

    private static Shape makeRect(Rect rect, double d, double d2, StyleSpec styleSpec) {
        Shape shape = ShapeFactory2.CreateRect(d + rect.getX(), d2 + rect.getY(), rect.getWidth(), rect.getHeight());
        StyleBuilder.setFilled(shape, styleSpec);
        return shape;
    }

    private GroupSceneNode makeEllipsisEntry(int n, double d, double d2, Rect[] rectArray) {
        Text text = this.labeler.makeLabel(new Object[]{"\u2026"}, ShapeFactory2.CreateRect(0.0, 0.0, this.bounds.getWidth(), this.bounds.getHeight()));
        if (text == null) {
            return null;
        }
        Rect rect = text.getBounds();
        text.affine(1.0, d + rectArray[0].getCenter().getX() - rect.getCenter().getX(), 1.0, d2 + 2.0 - rect.getY(), true);
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
        String string = "L" + this.legendIndex + "LE" + n;
        groupSceneNode.setId(string);
        text.setID(string + "SW0");
        groupSceneNode.addChild(text.createSceneNode());
        return groupSceneNode;
    }

    static Insets makePaddingForStyle(StyleSpec styleSpec, Dim dim, double d) {
        if (styleSpec == null || styleSpec.padding == null) {
            double d2 = Math.max(0.0, d);
            return new Insets(d2, d2, d2, d2);
        }
        Insets insets = Insets.makeForStylePadding(styleSpec.padding, dim, dim);
        return new Insets(Math.max(0.0, insets.top), Math.max(0.0, insets.left), Math.max(0.0, insets.bottom), Math.max(0.0, insets.right));
    }

    static {
        SimpleLegendBuilder.TRANSPARENT_STYLE.fill = "transparent";
        SimpleLegendBuilder.TRANSPARENT_STYLE.outline = "transparent";
    }
}

