/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;

class SimpleSwatch {
    private final SwatchType swatchType;
    private final Dim swatchSize;
    private final CustomGlyphBuilder builder;

    SimpleSwatch(Vis vis, SwatchType swatchType, LegendSpec legendSpec, Dim dim, boolean bl) {
        this.swatchType = swatchType;
        this.swatchSize = SimpleSwatch.makeSwatchSize(swatchType, legendSpec, dim, bl, vis);
        Dim dim2 = SimpleSwatch.makeSymbolSize(swatchType, legendSpec, dim, bl, vis);
        SymbolSpec symbolSpec = SimpleSwatch.makeSymbolSpec(swatchType, legendSpec, dim, this.swatchSize, dim2);
        this.builder = new CustomGlyphBuilder(symbolSpec, dim2, vis.getVisContext());
    }

    final SwatchType getSwatchType() {
        return this.swatchType;
    }

    final CustomGlyphBuilder getSwatchBuilder() {
        return this.builder;
    }

    final Dim getSwatchSize() {
        return this.swatchSize;
    }

    private static Dim makeSwatchSize(SwatchType swatchType, LegendSpec legendSpec, Dim dim, boolean bl, Vis vis) {
        Dim dim2;
        StyleSpec styleSpec = legendSpec.itemStyle;
        switch (swatchType.getType()) {
            default: {
                dim2 = SimpleSwatch.makePointElementSize(dim, swatchType.getStyle(), styleSpec, bl, vis);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                dim2 = new Dim(50.0, 20.0);
                dim2 = StyleBuilder.modifySizeByStyle(dim2, dim2, styleSpec);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                dim2 = new Dim(20.0, 20.0);
                dim2 = StyleBuilder.modifySizeByStyle(dim2, dim2, styleSpec);
            }
        }
        return dim2;
    }

    private static Dim makeSymbolSize(SwatchType swatchType, LegendSpec legendSpec, Dim dim, boolean bl, Vis vis) {
        if (swatchType.getType() == 3) {
            return SimpleSwatch.makePointElementSize(dim, swatchType.getSymbolStyle(), legendSpec.itemStyle, bl, vis);
        }
        return new Dim(0.0, 0.0);
    }

    private static Dim makePointElementSize(Dim dim, StyleSpec styleSpec, StyleSpec styleSpec2, boolean bl, Vis vis) {
        Dim dim2 = dim != null ? new Dim(dim.getWidth(), dim.getHeight()) : new Dim(20.0, 20.0);
        dim2 = StyleBuilder.modifySizeByStyle(dim2, vis.getSize(), styleSpec);
        if (styleSpec2 != null && (styleSpec2.size != null || styleSpec2.width != null || styleSpec2.height != null)) {
            dim2 = StyleBuilder.modifySizeByStyle(dim2, dim2, styleSpec2);
        } else if (dim == null || !bl) {
            boolean bl2 = true;
            if (styleSpec != null && BasicFactory.isString(styleSpec.symbol)) {
                String string = (String)styleSpec.symbol;
                boolean bl3 = bl2 = !string.startsWith("rect") && !"i-beam".equals(string) && !"t-beam".equals(string);
            }
            if (bl2) {
                double d = Math.max(10.0, Math.min(20.0, Math.min(dim2.getWidth(), dim2.getHeight())));
                dim2.setWidth(d);
                dim2.setHeight(d);
            } else {
                double d = dim2.getWidth();
                double d2 = dim2.getHeight();
                Range range = new Range(10.0, 20.0);
                if (d <= 0.0 && d2 <= 0.0) {
                    d = 20.0;
                    d2 = 20.0;
                } else if (d <= 0.0) {
                    d = 0.0;
                    d2 = range.clamp(d2);
                } else if (d2 <= 0.0) {
                    d = range.clamp(d);
                    d2 = 0.0;
                } else if (d > 20.0 || d2 > 20.0) {
                    double d3 = 20.0 / Math.max(d, d2);
                    d *= d3;
                    d2 *= d3;
                } else if (d < 10.0 && d2 < 10.0) {
                    double d4 = 10.0 / Math.max(d, d2);
                    d *= d4;
                    d2 *= d4;
                }
                dim2.setWidth(d);
                dim2.setHeight(d2);
            }
        }
        return dim2;
    }

    private static SymbolSpec makeSymbolSpec(SwatchType swatchType, LegendSpec legendSpec, Dim dim, Dim dim2, Dim dim3) {
        SymbolShapeSpec[] symbolShapeSpecArray;
        StyleSpec styleSpec;
        StyleSpec styleSpec2 = legendSpec.itemStyle;
        StyleSpec styleSpec3 = swatchType.getStyle();
        Object object = null;
        StyleSpec styleSpec4 = styleSpec3;
        if (styleSpec4 == null) {
            styleSpec4 = new StyleSpec();
            styleSpec4.outline = "#000";
        }
        if (styleSpec4.fill == null) {
            styleSpec4.fill = "#aaa";
        }
        if ((styleSpec4 = StyleBuilder.mergeStyles(styleSpec4, styleSpec2)) != null) {
            object = styleSpec4.symbol;
            styleSpec4 = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec4, false, false, 10.0);
        }
        if ((styleSpec = styleSpec3) == null) {
            styleSpec = new StyleSpec();
            styleSpec.fill = "#000";
        }
        if ((styleSpec = StyleBuilder.mergeStyles(styleSpec, styleSpec2)) != null) {
            styleSpec = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, true, false, 10.0);
        }
        SymbolSpec symbolSpec = new SymbolSpec();
        switch (swatchType.getType()) {
            default: {
                object = object == null ? "letter-A" : object;
            }
            case 1: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{SimpleSwatch.makePointElementSpecification(object, styleSpec4)};
                break;
            }
            case 2: 
            case 3: {
                symbolShapeSpecArray = SimpleSwatch.makeLineElementSpecification(swatchType, dim2, dim3, styleSpec);
                break;
            }
            case 4: {
                symbolShapeSpecArray = SimpleSwatch.makeAreaElementSpecification(styleSpec4, true);
                break;
            }
            case 5: {
                symbolShapeSpecArray = SimpleSwatch.makeAreaElementSpecification(styleSpec4, false);
                break;
            }
            case 6: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{SimpleSwatch.makePointElementSpecification(object == null ? "rect" : object, styleSpec4)};
                break;
            }
            case 7: 
            case 8: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec()};
                symbolShapeSpecArray[0].type = "path";
                symbolShapeSpecArray[0].style = styleSpec;
                symbolShapeSpecArray[0].path = "M0,0.5L1,0.5";
                break;
            }
            case 9: 
            case 10: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec()};
                symbolShapeSpecArray[0].type = "rect";
                symbolShapeSpecArray[0].style = styleSpec4;
                break;
            }
            case 12: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{SimpleSwatch.makePointElementSpecification("square", styleSpec4)};
            }
        }
        symbolSpec.shape = symbolShapeSpecArray;
        return symbolSpec;
    }

    private static StyleSpec modifyStyleSpecForSwatch(StyleSpec styleSpec, boolean bl, boolean bl2, double d) {
        Object object;
        if (styleSpec == null) {
            return null;
        }
        StyleSpec styleSpec2 = (StyleSpec)styleSpec.copy();
        styleSpec2.size = null;
        styleSpec2.width = null;
        styleSpec2.height = null;
        styleSpec2.symbol = null;
        styleSpec2.padding = null;
        if (bl && styleSpec.size != null && (styleSpec2.stroke == null || styleSpec2.stroke.width == null)) {
            if (styleSpec2.stroke == null) {
                styleSpec2.stroke = new StrokeSpec();
            }
            styleSpec2.stroke.width = styleSpec.size;
        }
        if (styleSpec2.stroke != null && styleSpec2.stroke.width != null) {
            object = UnitConverter.convertLength(styleSpec2.stroke.width, 1.0, 20.0);
            styleSpec2.stroke.width = object == null ? Double.valueOf(1.0) : Double.valueOf(Math.min(((Number)object).doubleValue(), d));
        }
        if (styleSpec2.font != null) {
            object = UnitConverter.convertLength(styleSpec2.font.size, 20.0, 20.0);
            styleSpec2.font.size = object == null ? (Number)12 : (Number)MathUtil.r3(Math.max(7.5, Math.min(((Number)object).doubleValue(), 15.0)));
        }
        if (styleSpec2.fill instanceof FillSpec) {
            object = (FillSpec)((FillSpec)styleSpec2.fill).copy();
            ((FillSpec)object).global = false;
            styleSpec2.fill = object;
        }
        if (BasicFactory.isEmpty(styleSpec2.toJSON())) {
            if (!bl2) {
                return null;
            }
            styleSpec2.fill = "#aaa";
        }
        return styleSpec2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SymbolShapeSpec makePointElementSpecification(Object object, StyleSpec styleSpec) {
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        if (object != null) {
            if (BasicFactory.isString(object)) {
                symbolShapeSpec.style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, false, false, 3.0);
                symbolShapeSpec.type = (String)object;
                return symbolShapeSpec;
            } else {
                SymbolSpec symbolSpec = (SymbolSpec)object;
                if (symbolSpec.shape == null) throw new SpecException("Must specify shape array for custom symbol", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
                symbolShapeSpec.type = "group";
                int n = symbolSpec.shape.length;
                symbolShapeSpec.shape = new SymbolShapeSpec[n];
                symbolShapeSpec.style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, false, false, 3.0);
                for (int i = 0; i < n; ++i) {
                    symbolShapeSpec.shape[i] = (SymbolShapeSpec)symbolSpec.shape[i].copy();
                    symbolShapeSpec.shape[i].style = SimpleSwatch.modifyStyleSpecForSwatch(StyleBuilder.mergeStyles(styleSpec, symbolSpec.shape[i].style), false, false, 3.0);
                    if (symbolShapeSpec.shape[i].style == null) continue;
                    symbolShapeSpec.shape[i].style.symbol = null;
                }
            }
            return symbolShapeSpec;
        } else {
            symbolShapeSpec.type = "circle";
            symbolShapeSpec.style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, false, true, 3.0);
        }
        return symbolShapeSpec;
    }

    private static SymbolShapeSpec[] makeLineElementSpecification(SwatchType swatchType, Dim dim, Dim dim2, StyleSpec styleSpec) {
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.type = "path";
        symbolShapeSpec.path = "M0,0.5L1,0.5";
        symbolShapeSpec.style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, true, false, 10.0);
        if (swatchType.getType() != 3) {
            return new SymbolShapeSpec[]{symbolShapeSpec};
        }
        StyleSpec styleSpec2 = swatchType.getSymbolStyle();
        if (styleSpec2 == null) {
            styleSpec2 = new StyleSpec();
        } else {
            styleSpec2 = (StyleSpec)styleSpec2.copy();
            if (styleSpec2.fill == null) {
                styleSpec2.fill = "#aaa";
            }
        }
        SymbolShapeSpec symbolShapeSpec2 = SimpleSwatch.makePointElementSpecification(styleSpec2.symbol, styleSpec2);
        symbolShapeSpec2.bounds = new BoundsSpec();
        double d = dim2.getWidth() / dim.getWidth();
        double d2 = dim2.getHeight() / dim.getHeight();
        symbolShapeSpec2.bounds.left = MathUtil.r3(100.0 * (0.5 - d / 2.0)) + "%";
        symbolShapeSpec2.bounds.width = MathUtil.r3(100.0 * d) + "%";
        symbolShapeSpec2.bounds.top = MathUtil.r3(100.0 * (0.5 - d2 / 2.0)) + "%";
        symbolShapeSpec2.bounds.height = MathUtil.r3(100.0 * d2) + "%";
        return new SymbolShapeSpec[]{symbolShapeSpec, symbolShapeSpec2};
    }

    private static SymbolShapeSpec[] makeAreaElementSpecification(StyleSpec styleSpec, boolean bl) {
        SymbolShapeSpec[] symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec(), new SymbolShapeSpec()};
        symbolShapeSpecArray[0].type = "path";
        symbolShapeSpecArray[0].style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, false, false, 3.0);
        if (symbolShapeSpecArray[0].style == null) {
            symbolShapeSpecArray[0].style = new StyleSpec();
            symbolShapeSpecArray[0].style.fill = "#aaa";
        }
        symbolShapeSpecArray[0].style.outline = "transparent";
        symbolShapeSpecArray[1].type = "path";
        symbolShapeSpecArray[1].style = SimpleSwatch.modifyStyleSpecForSwatch(styleSpec, false, false, 3.0);
        if (symbolShapeSpecArray[1].style == null) {
            (symbolShapeSpecArray[1].style = new StyleSpec()).fill = styleSpec == null ? "transparent" : "#000";
        } else if (symbolShapeSpecArray[1].style.outline == null && symbolShapeSpecArray[1].style.fill != null) {
            symbolShapeSpecArray[1].style.fill = symbolShapeSpecArray[1].style.stroke != null ? "#000" : "transparent";
        } else {
            symbolShapeSpecArray[1].style.fill = symbolShapeSpecArray[1].style.outline;
            symbolShapeSpecArray[1].style.outline = null;
        }
        if (bl) {
            symbolShapeSpecArray[0].path = "M0,1C0,0.7,0.4,0.6,0.5,0.5C0.6,0.4,0.7,0,1,0L1,1Z";
            symbolShapeSpecArray[1].path = "M0,1C0,0.7,0.4,0.6,0.5,0.5C0.6,0.4,0.7,0,1,0";
        } else {
            symbolShapeSpecArray[0].path = "M0,1L0.4,0.25L0.6,0.5L1.0,0.0L1.0,1.0Z";
            symbolShapeSpecArray[1].path = "M0,1L0.4,0.25L0.6,0.5L1.0,0.0";
        }
        return symbolShapeSpecArray;
    }
}

