/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend;

import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.template.JSONSerialization;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SwatchType {
    private final int type;
    private final StyleSpec style;
    private final StyleSpec symbolStyle;
    private final boolean mixedSources;
    private static final int INCOMPATIBLE_TYPES = 0;
    public static final int POINT = 1;
    public static final int LINE = 2;
    public static final int LINE_WITH_POINTS = 3;
    public static final int AREA_SMOOTHED = 4;
    public static final int AREA_UNSMOOTHED = 5;
    public static final int INTERVAL = 6;
    public static final int EDGE = 7;
    public static final int PATH = 8;
    public static final int POLYGON = 9;
    public static final int SCHEMA = 10;
    public static final int TEXT = 11;
    public static final int FALLBACK = 12;
    private static final String INCOMPATIBLE_STYLES = "NOPE";

    private SwatchType(int n, StyleSpec styleSpec, StyleSpec styleSpec2, boolean bl) {
        this.type = n;
        this.style = styleSpec;
        this.symbolStyle = styleSpec2;
        this.mixedSources = bl;
    }

    public final int getType() {
        return this.type;
    }

    public final StyleSpec getStyle() {
        return this.style;
    }

    public final StyleSpec getSymbolStyle() {
        return this.symbolStyle;
    }

    public final boolean hasMixedSources() {
        return this.mixedSources;
    }

    public static SwatchType makeForFallback() {
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.symbol = "square";
        styleSpec.outline = "#000";
        styleSpec.fill = "#aaa";
        return new SwatchType(12, styleSpec, null, false);
    }

    public static SwatchType makeForAesthetics(List<Aesthetic> list, LegendSpec legendSpec) {
        StyleSpec styleSpec;
        Object object;
        Object object2;
        int n;
        int n2 = list.size();
        Aesthetic aesthetic = list.get(0);
        Element element = aesthetic.element;
        LabelProducer labelProducer = aesthetic.labelProducer;
        if (n2 == 1) {
            if (labelProducer != null) {
                return SwatchType.makeForLabelProducer(labelProducer);
            }
            return SwatchType.makeForElement(element, legendSpec);
        }
        boolean bl = false;
        for (n = 1; !bl && n < n2; ++n) {
            object2 = list.get(n);
            if (((Aesthetic)object2).element == element && ((Aesthetic)object2).labelProducer == labelProducer) continue;
            bl = true;
        }
        if (!bl) {
            if (labelProducer != null) {
                return SwatchType.makeForLabelProducer(labelProducer);
            }
            return SwatchType.makeForElement(element, legendSpec);
        }
        n = SwatchType.modifySwatchType(SwatchType.typeFromSource(element, labelProducer), legendSpec);
        object2 = SwatchType.styleToString(element.spec.style);
        String string = SwatchType.styleToString(element.spec.symbolStyle);
        for (int i = 1; i < n2; ++i) {
            object = list.get(i);
            n = SwatchType.mixTypes(n, SwatchType.modifySwatchType(SwatchType.typeFromSource(((Aesthetic)object).element, ((Aesthetic)object).labelProducer), legendSpec));
            object2 = SwatchType.mixStyles((String)object2, SwatchType.styleToString(((Aesthetic)object).element.spec.style));
            string = SwatchType.mixStyles(string, SwatchType.styleToString(((Aesthetic)object).element.spec.symbolStyle));
        }
        if (n == 0) {
            n = "dashing".equals(aesthetic.type) ? 2 : ("font".equals(aesthetic.type) ? 11 : 12);
        }
        if (!INCOMPATIBLE_STYLES.equals(object2)) {
            styleSpec = element.spec.style;
        } else {
            styleSpec = new StyleSpec();
            if (n == 12) {
                styleSpec.symbol = "square";
            }
            if (n == 2 || n == 3 || n == 7 || n == 8) {
                styleSpec.fill = "#000";
            } else {
                styleSpec.fill = "#aaa";
                styleSpec.outline = "#000";
            }
        }
        if (!INCOMPATIBLE_STYLES.equals(string)) {
            object = element.spec.symbolStyle;
        } else if (n != 3) {
            object = null;
        } else {
            object = new StyleSpec();
            ((StyleSpec)object).symbol = "circle";
        }
        return new SwatchType(n, styleSpec, (StyleSpec)object, true);
    }

    public static SwatchType makeForElement(Element element, LegendSpec legendSpec) {
        int n = SwatchType.modifySwatchType(SwatchType.typeFromElement(element), legendSpec);
        return new SwatchType(n, element.spec.style, element.spec.symbolStyle, false);
    }

    protected static int modifySwatchType(int n, LegendSpec legendSpec) {
        if ((5 == n || 4 == n) && legendSpec != null && legendSpec.itemStyle != null && legendSpec.itemStyle.symbol != null) {
            return 1;
        }
        return n;
    }

    public static SwatchType makeForLabelProducer(LabelProducer labelProducer) {
        return new SwatchType(11, labelProducer.style, null, false);
    }

    private static int mixTypes(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2) {
            return n;
        }
        if (n == 2 || n == 3 || n == 7 || n == 8) {
            if (n2 == 2 || n2 == 3 || n2 == 7 || n2 == 8) {
                if (n == 3 || n2 == 3) {
                    return 3;
                }
                return 2;
            }
        } else if (n == 5 || n == 4) {
            if (n2 == 5 || n2 == 4) {
                return 5;
            }
        } else if (!(n != 9 && n != 10 || n2 != 9 && n2 != 10)) {
            return 9;
        }
        return 0;
    }

    private static int typeFromSource(Element element, LabelProducer labelProducer) {
        return labelProducer != null ? 11 : SwatchType.typeFromElement(element);
    }

    private static int typeFromElement(Element element) {
        String string = element.type;
        if (string.equals("point")) {
            return 1;
        }
        if (string.equals("line")) {
            if (element.isLineWithPoints) {
                return 3;
            }
            return 2;
        }
        if (string.equals("area")) {
            if ("smooth".equals(element.spec.interpolation)) {
                return 4;
            }
            return 5;
        }
        if (string.equals("interval")) {
            return 6;
        }
        if (string.equals("edge")) {
            return 7;
        }
        if (string.equals("path")) {
            return 8;
        }
        if (string.equals("polygon")) {
            return 9;
        }
        if (string.startsWith("schema")) {
            return 10;
        }
        if (string.equals("text")) {
            return 11;
        }
        return 12;
    }

    private static String mixStyles(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null || string2 == null) {
            return INCOMPATIBLE_STYLES;
        }
        if (string == INCOMPATIBLE_STYLES || string2 == INCOMPATIBLE_STYLES) {
            return INCOMPATIBLE_STYLES;
        }
        if (string.equals(string2)) {
            return string;
        }
        return INCOMPATIBLE_STYLES;
    }

    private static String styleToString(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return null;
        }
        return JSONSerialization.forJSONComparison().serialize(styleSpec.toJSON());
    }
}

