/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.FormatWrapper;
import com.ibm.vis.engine.internal.LegendPosition;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.scale.LogScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.legend.nonsimple.BaseLegend;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.PaddingSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
abstract class AbstractAxisLegend
extends BaseLegend {
    protected static final String LOG = "log";
    protected static final String COLOR = "color";
    protected static final String HORIZONTAL_ORIENTATION = "horizontal";
    protected static final String TRANSPARENT = "transparent";
    protected static final double DEFAULT_COLOR_GRADIENT_SWATCH_SIZE = 15.0;
    protected static final double DEFAULT_STAGGER_SWATCH_SIZE = 20.0;
    protected static final int PAD = 5;
    protected static final String MIN_Y_FIELD = "minYForLegend";
    protected static final String Y_FIELD = "yForLegend";
    protected static final double AVAILABLE_SIZE_BUFFER = 5.0;
    protected String fieldName;
    protected List<SceneNode> theScene;
    protected boolean verticalLegend;
    protected double maxAxisLabelWidth = -1.0;
    protected double expandedWidth = 0.0;

    protected abstract List<SceneNode> makeScene();

    protected abstract double getAxisWidth();

    protected abstract double getPad();

    protected AbstractAxisLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list) {
        super(vis, legendSpec, n, list);
        Object object;
        Object object2;
        this.setStyle(legendSpec.boundsStyle);
        if (legendSpec.orientation != null) {
            this.verticalLegend = !HORIZONTAL_ORIENTATION.equals(legendSpec.orientation);
        } else {
            object2 = vis.getLegendPosition(legendSpec);
            boolean bl = this.verticalLegend = object2 == LegendPosition.LEFT || object2 == LegendPosition.RIGHT;
        }
        if (legendSpec.location != null && legendSpec.location instanceof BoundsSpec) {
            object2 = (BoundsSpec)legendSpec.location;
            object = new Bounds((BoundsSpec)object2, vis.getVisContext().getLogger());
            this.setSpecifiedBounds((Bounds)object);
        }
        this.fieldName = (object2 = list.get((int)0).valueProvider.getBaseField()) == null ? null : ((Field)object2).id;
        object = (FormatWrapper)this.parentVis.getLegendVis().getVisContext().formatContext.integratorNumberFormatter;
        if (object != null) {
            ((FormatWrapper)object).addMapping(this.getFieldKey(), this.fieldName);
        }
    }

    public abstract String getFieldKey();

    protected double getSwatchSize(double d) {
        if (this.legendSpec.itemStyle == null) {
            return d;
        }
        Double d2 = this.verticalLegend ? this.getSpecifiedSize(this.legendSpec.itemStyle.width, this.legendSpec.itemStyle.size) : this.getSpecifiedSize(this.legendSpec.itemStyle.height, this.legendSpec.itemStyle.size);
        return d2 == null ? d : d2;
    }

    private Double getSpecifiedSize(Object object, Object object2) {
        Double d = UnitConverter.convertLength(object, 100.0, 100.0);
        if (d != null) {
            return d;
        }
        return UnitConverter.convertLength(object2, 100.0, 100.0);
    }

    protected void validateContinuousColorAesthetics(String string, boolean bl) {
        if (this.aesthetics == null || this.aesthetics.size() != 1 || !COLOR.equals(this.firstAesthetic.type)) {
            throw new SpecException("Legend.method " + string + " requires a single color aesthetic", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        Unit unit = this.firstAesthetic.valueProvider.getUnit();
        if (unit != null && unit.measure.categorical) {
            throw new SpecException("Legend.method  " + string + "  requires a continuous (not categorical) color aesthetic", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (!bl && this.isAestheticLogScale(this.firstAesthetic)) {
            throw new SpecException("Legend.method  " + string + "  does not support log scales", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    protected AxisSpec makeAxisSpec(boolean bl, boolean bl2, boolean bl3) {
        PreferredSizeSpec preferredSizeSpec;
        AxisSpec axisSpec = new AxisSpec();
        axisSpec.opposite = this.isAxisOpposite();
        StyleSpec styleSpec = this.getLabelStyle();
        if (bl2 && styleSpec == null) {
            axisSpec.tickStyle = this.makeDefaultLabelStyle();
        } else if (styleSpec != null) {
            axisSpec.tickStyle = (StyleSpec)styleSpec.copy();
            if (axisSpec.tickStyle.valign != null) {
                axisSpec.tickStyle.valign = null;
                if (BasicFactory.isEmpty(axisSpec.tickStyle.toJSON())) {
                    axisSpec.tickStyle = this.makeDefaultLabelStyle();
                }
            }
        }
        axisSpec.markStyle = this.legendSpec.markStyle == null ? new StyleSpec() : (StyleSpec)this.legendSpec.markStyle.copy();
        if (axisSpec.markStyle.size == null) {
            axisSpec.markStyle.size = bl ? 5 : 0;
        }
        axisSpec.preferredSize = preferredSizeSpec = new PreferredSizeSpec();
        double d = this.getAxisWidth();
        preferredSizeSpec.max = this.expandedWidth > 0.0 ? d + this.expandedWidth : d + 10.0;
        preferredSizeSpec.min = this.verticalLegend && bl3 ? preferredSizeSpec.max : Double.valueOf(this.expandedWidth > 0.0 ? d + this.expandedWidth : d);
        if (!this.verticalLegend && !bl) {
            axisSpec.method = HORIZONTAL_ORIENTATION;
        }
        return axisSpec;
    }

    protected boolean isAngleText(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return false;
        }
        return styleSpec.angle != null && ((Number)styleSpec.angle).doubleValue() != 90.0;
    }

    protected StyleSpec makeVisStyle(boolean bl, int n, boolean bl2, double d, boolean bl3, boolean bl4) {
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.fill = TRANSPARENT;
        PaddingSpec paddingSpec = new PaddingSpec();
        if (this.verticalLegend) {
            if (this.isAxisOpposite()) {
                paddingSpec.left = n;
            } else {
                paddingSpec.right = n;
            }
            if (bl) {
                paddingSpec.bottom = Math.ceil((double)n + this.getLabelFont().getHeight() / 2.0);
            }
            if (bl2) {
                paddingSpec.top = Math.ceil(d);
            }
        } else {
            paddingSpec.left = bl4 ? Math.ceil((double)n + this.getMaxAxisLabelWidth() / 2.0) : (double)n;
            paddingSpec.bottom = n;
            paddingSpec.right = bl4 ? Math.ceil((double)n + this.getMaxAxisLabelWidth() / 2.0) : (double)n;
            if (this.isAngleText(this.getLabelStyle())) {
                paddingSpec.left = Math.ceil(this.getLabelFont().getSize() + (double)n);
            }
            if (bl3) {
                paddingSpec.top = Math.ceil(d);
            }
        }
        styleSpec.padding = paddingSpec;
        return styleSpec;
    }

    protected double getPadding(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return 0.0;
        }
        Insets insets = Insets.makeForStyle(styleSpec, new Dim(100.0, 100.0));
        return this.verticalLegend ? insets.getHorizontal() : insets.getVertical();
    }

    protected DoublePrimitiveArrayList getValidTickValues() {
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        Aesthetic aesthetic = this.firstAesthetic;
        String[] stringArray = aesthetic.valueProvider.getCategories();
        if (stringArray != null && this.legendSpec.scale != null && this.legendSpec.scale.spans != null && this.legendSpec.scale.spans[0].categories != null) {
            DoublePrimitiveArrayList doublePrimitiveArrayList2 = new DoublePrimitiveArrayList(this.legendSpec.scale.spans[0].categories.length);
            for (Number number : this.legendSpec.scale.spans[0].categories) {
                doublePrimitiveArrayList2.add(number.doubleValue());
            }
            for (Tick tick : aesthetic.scale.getAllTicks()) {
                if (!doublePrimitiveArrayList2.contains(tick.value)) continue;
                doublePrimitiveArrayList.add(tick.value);
            }
        } else if (stringArray != null && this.isScaleLocal()) {
            for (int i = 0; i < stringArray.length; ++i) {
                doublePrimitiveArrayList.add(i);
            }
        } else {
            doublePrimitiveArrayList = this.getValidTicksNumerical(aesthetic.scale);
        }
        return doublePrimitiveArrayList;
    }

    protected DoublePrimitiveArrayList getValidTicksNumerical(Scale scale) {
        DoublePrimitiveArrayList doublePrimitiveArrayList = new DoublePrimitiveArrayList();
        if (this.isScaleLocal()) {
            for (Tick tick : scale.getAllTicks()) {
                doublePrimitiveArrayList.add(tick.value);
            }
        } else {
            for (Tick tick : scale.getTicksForData()) {
                doublePrimitiveArrayList.add(tick.value);
            }
        }
        return doublePrimitiveArrayList;
    }

    protected int getNumberOfTicksInScale(Scale scale) {
        if (this.isScaleLocal()) {
            return scale.getAllTicks().size();
        }
        return scale.getTicksForData().size();
    }

    private boolean isScaleLocal() {
        return this.legendSpec.scale != null && this.legendSpec.scale.local != null && this.legendSpec.scale.local == false;
    }

    protected SpanSpec[] buildSpansForDimension(DoublePrimitiveArrayList doublePrimitiveArrayList, boolean bl, int n) {
        Aesthetic aesthetic;
        SpanSpec spanSpec = new SpanSpec();
        spanSpec.fit = "exact";
        double d = doublePrimitiveArrayList.get(0);
        double d2 = doublePrimitiveArrayList.get(0);
        for (int i = 1; i < doublePrimitiveArrayList.size(); ++i) {
            d = Math.min(d, doublePrimitiveArrayList.get(i));
            d2 = Math.max(d2, doublePrimitiveArrayList.get(i));
        }
        double d3 = d;
        double d4 = d2;
        double d5 = (d4 - d3) / (double)(doublePrimitiveArrayList.size() - 1);
        if (bl && this.aestheticHasScaleSpan(aesthetic = this.firstAesthetic) && aesthetic.scale.spans.get(0).getAdjustedInputRange() != null) {
            double d6 = aesthetic.scale.spans.get(0).getAdjustedInputRange().getMin();
            double d7 = aesthetic.scale.spans.get(0).getAdjustedInputRange().getMax();
            if (d6 <= d3 || d7 >= d4) {
                d3 = d6;
                d4 = d7;
                d5 = aesthetic.scale.spans.get(0).getTickSize();
            }
        }
        spanSpec.min = d3;
        spanSpec.max = d4;
        spanSpec.tickDelta = d5 * (double)n;
        if (this.isAestheticLogScale(this.firstAesthetic)) {
            spanSpec.method = LOG;
        }
        return new SpanSpec[]{spanSpec};
    }

    protected boolean isAestheticLogScale(Aesthetic aesthetic) {
        return this.aestheticHasScaleSpan(aesthetic) && aesthetic.scale.spans.get(0) instanceof LogScaleSpan;
    }

    private boolean aestheticHasScaleSpan(Aesthetic aesthetic) {
        return aesthetic.scale != null && aesthetic.scale.spans.size() > 0 && aesthetic.scale.spans.get(0) != null;
    }

    protected double getDefaultAxisWidth(int n) {
        if (this.verticalLegend) {
            double d = 1.0;
            double d2 = this.getEffectiveMarkSize(n);
            StyleSpec styleSpec = this.getLabelStyle();
            styleSpec = styleSpec == null ? this.makeDefaultLabelStyle() : styleSpec;
            Dim dim = new Dim(100.0, 100.0);
            Insets insets = Insets.makeForStyle(styleSpec, dim);
            double d3 = insets.getHorizontal();
            return d2 + d + this.getMaxAxisLabelWidth() + d3;
        }
        double d = 1.0;
        double d4 = this.getEffectiveMarkSize(n);
        StyleSpec styleSpec = this.getLabelStyle();
        styleSpec = styleSpec == null ? this.makeDefaultLabelStyle() : styleSpec;
        double d5 = this.getPadding(styleSpec);
        return d4 + d + this.getLabelFont().getHeight() + d5;
    }

    protected StyleSpec makeDefaultLabelStyle() {
        StyleSpec styleSpec = new StyleSpec();
        PaddingSpec paddingSpec = new PaddingSpec();
        double d = this.getPad();
        if (this.verticalLegend) {
            if (this.isAxisOpposite()) {
                paddingSpec.left = d;
            } else {
                paddingSpec.right = d;
            }
        } else if (this.isAxisOpposite()) {
            paddingSpec.bottom = d;
        } else {
            paddingSpec.top = d;
        }
        styleSpec.padding = paddingSpec;
        return styleSpec;
    }

    protected Font getLabelFont() {
        StyleSpec styleSpec = this.getLabelStyle();
        FontSpec fontSpec = null;
        if (styleSpec != null) {
            fontSpec = styleSpec.font;
        }
        Font font = FontHelper.makeFromSpec(fontSpec, this.parentVis.getVisContext().getMinimumFontSize(), this.parentVis.getVisContext().usesFractionalMetrics());
        return font;
    }

    private double calculateMaxAxisLabelWidth() {
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.getValidTickValues();
        StyleSpec styleSpec = this.getLabelStyle();
        Font font = this.getLabelFont();
        Dim dim = new Dim(1000.0, 400.0);
        if (this.firstAesthetic.spec.field == null) {
            Number number = this.firstAesthetic.spec.value;
            String string = "" + number;
            Text text = Text.createTextWithShapedValue(string, 0.0, 0.0, "start", "middle", font, styleSpec, null, "...", dim, this.parentVis.getVisContext().getTooltipsForTruncatedText());
            return text.getWidth();
        }
        String string = this.firstAesthetic.spec.field.$ref;
        Field field = (Field)this.parentVis.getByID(string);
        double d = 0.0;
        int n = doublePrimitiveArrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = field.getFormattedStringValue(doublePrimitiveArrayList.get(i), 0, null);
            Text text = Text.createTextWithShapedValue(string2, 0.0, 0.0, "start", "middle", font, styleSpec, null, "...", dim, this.parentVis.getVisContext().getTooltipsForTruncatedText());
            d = Math.max(d, text.getWidth());
        }
        return d;
    }

    double getMaxAxisLabelWidth() {
        if (this.maxAxisLabelWidth == -1.0) {
            this.maxAxisLabelWidth = this.calculateMaxAxisLabelWidth();
        }
        return this.maxAxisLabelWidth;
    }

    protected boolean isAestheticExactScale() {
        return this.firstAesthetic.spec.scale != null && this.firstAesthetic.spec.scale.spans != null && this.firstAesthetic.spec.scale.spans[0].fit != null && "exact".equals(this.firstAesthetic.spec.scale.spans[0].fit);
    }

    protected boolean isScaleReverse() {
        return this.legendSpec.scale != null && this.legendSpec.scale.reverse != null && this.legendSpec.scale.reverse != false;
    }

    protected boolean isAxisOpposite() {
        boolean bl;
        boolean bl2 = bl = this.legendSpec.mirroredLabels == null ? false : this.legendSpec.mirroredLabels;
        return this.verticalLegend ? !bl : bl;
    }

    protected double getEffectiveMarkSize(int n) {
        if (this.legendSpec.markStyle == null) {
            return n;
        }
        if ("end".equals(this.legendSpec.markStyle.align)) {
            return 1.0;
        }
        double d = "start".equals(this.legendSpec.markStyle.align) ? 1.0 : 0.52;
        double d2 = 5.0;
        if (this.legendSpec.markStyle.size != null && BasicFactory.isNumber(this.legendSpec.markStyle.size)) {
            d2 = ((Number)this.legendSpec.markStyle.size).doubleValue();
        }
        return Math.ceil(d2 * d);
    }

    protected StyleSpec getLabelStyle() {
        StyleSpec styleSpec = null;
        if (this.legendSpec.labelStyle != null) {
            styleSpec = this.legendSpec.labelStyle;
        } else if (this.legendSpec.tickStyle != null) {
            styleSpec = this.legendSpec.tickStyle;
        }
        return styleSpec;
    }

    protected TransformSpec[] makeTransforms() {
        if (!this.verticalLegend) {
            TransformSpec[] transformSpecArray = new TransformSpec[]{new TransformSpec()};
            transformSpecArray[0].type = "transpose";
            return transformSpecArray;
        }
        return null;
    }

    protected CoordinatesSpec makeCoordSpec(DoublePrimitiveArrayList doublePrimitiveArrayList, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        CoordinatesSpec coordinatesSpec = new CoordinatesSpec();
        DimensionSpec[] dimensionSpecArray = new DimensionSpec[]{new DimensionSpec()};
        coordinatesSpec.dimensions = dimensionSpecArray;
        dimensionSpecArray[0].axis = new AxisSpec[1];
        dimensionSpecArray[0].axis[0] = this.makeAxisSpec(bl, bl2, bl3);
        dimensionSpecArray[0].scale = new ScaleSpec();
        dimensionSpecArray[0].scale.spans = this.buildSpansForDimension(doublePrimitiveArrayList, bl4, n);
        if (this.isScaleReverse()) {
            dimensionSpecArray[0].scale.reverse = true;
        }
        coordinatesSpec.transforms = this.makeTransforms();
        return coordinatesSpec;
    }

    protected PositionSpec[] makePositionSpecsWithFields(String string, String string2) {
        PositionSpec positionSpec = new PositionSpec();
        positionSpec.field = new FieldValueRefSpec();
        positionSpec.field.$ref = string;
        PositionSpec positionSpec2 = new PositionSpec();
        positionSpec2.field = new FieldValueRefSpec();
        positionSpec2.field.$ref = string2;
        return new PositionSpec[]{positionSpec, positionSpec2};
    }

    protected String getUnitForAestheticField() {
        Field field = this.firstAesthetic.valueProvider.getBaseField();
        return field == null ? Unit.RATIO.name : field.unit.name;
    }

    protected Dim getAvailableSize() {
        Dim dim = this.parentVis.getExtent();
        if (this.legendSpec.location != null && this.legendSpec.location instanceof BoundsSpec) {
            BoundsSpec boundsSpec = (BoundsSpec)this.legendSpec.location;
            Bounds bounds = new Bounds(boundsSpec, null);
            Rect rect = bounds.getRect(dim);
            Dim dim2 = new Dim(rect.getWidth() - 5.0, rect.getHeight() - 5.0);
            return dim2;
        }
        return dim;
    }

    @Override
    protected List<SceneNode> createContent() {
        return this.makeScene();
    }
}

