/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.ArgumentSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.ImageSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.SizeSpec;
import com.ibm.vis.spec.internal.StringValueSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TitleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.List;

class BaseLegend
extends ContentFrame {
    protected final Vis parentVis;
    protected final LegendSpec legendSpec;
    protected final int legendIndex;
    protected final List<Aesthetic> aesthetics;
    protected final Aesthetic firstAesthetic;
    private double defaultTitlePadding = 5.0;

    BaseLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list) {
        this.parentVis = vis;
        this.legendSpec = legendSpec;
        this.legendIndex = n;
        this.aesthetics = list;
        this.firstAesthetic = list == null || list.size() == 0 ? null : list.get(0);
        this.setId("L" + n);
        this.setBackgroundIdSuffixes("-legendBackgroundStroke", "-legendBackgroundFill");
        this.setStyle(legendSpec.boundsStyle);
        this.setRequiresBackgroundShape(false);
    }

    protected void addVersion(VisJSONSpec visJSONSpec) {
        visJSONSpec.version = "7.2";
    }

    protected StyleSpec makeGrammarStyle() {
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.fill = "transparent";
        return styleSpec;
    }

    protected Dim getTitleSize(Double d, Double d2) {
        VisJSONSpec visJSONSpec;
        VisJSONSpec visJSONSpec2 = new VisJSONSpec();
        visJSONSpec2.titles = this.makeTitles();
        this.addVersion(visJSONSpec2);
        VisJSONSpec visJSONSpec3 = visJSONSpec = visJSONSpec2.titles == null ? null : visJSONSpec2;
        if (visJSONSpec == null) {
            return new Dim(0.0, 0.0);
        }
        visJSONSpec2.size = new SizeSpec();
        visJSONSpec2.size.width = d;
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = vis.setTypedSpecification(visJSONSpec);
        visState = vis.makeSceneTree(null, visState);
        return visState.getSceneTree().getSize();
    }

    protected TitleSpec[] makeTitles() {
        Object object;
        Object[] objectArray;
        if (this.legendSpec.title != null && this.legendSpec.title.length == 0) {
            return null;
        }
        if (this.legendSpec.title != null) {
            objectArray = BaseLegend.makeTitleContent(this.parentVis, this.legendSpec.title);
        } else {
            Field field = null;
            if (this.firstAesthetic != null && this.firstAesthetic.valueProvider != null) {
                field = this.firstAesthetic.valueProvider.getBaseField();
            }
            if (field != null) {
                object = field.label;
                if (object == null) {
                    object = field.id;
                }
                if (object == null) {
                    object = "Field";
                }
            } else {
                return null;
            }
            objectArray = new Object[]{object};
        }
        object = new TitleSpec();
        ((TitleSpec)object).type = "title";
        ((TitleSpec)object).content = objectArray;
        ((TitleSpec)object).style = this.legendSpec.titleStyle;
        if (this.legendSpec.titleStyle == null || this.legendSpec.titleStyle.font == null || this.legendSpec.titleStyle.font.weight == null) {
            if (((TitleSpec)object).style == null) {
                ((TitleSpec)object).style = new StyleSpec();
            }
            if (((TitleSpec)object).style.font == null) {
                ((TitleSpec)object).style.font = new FontSpec();
                ((TitleSpec)object).style.font.weight = "bold";
            }
            if (((TitleSpec)object).style.padding == null) {
                ((TitleSpec)object).style.padding = this.defaultTitlePadding;
            }
        }
        return new TitleSpec[]{object};
    }

    static Object[] makeTitleContent(Vis vis, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof FieldValueRefSpec) {
                FieldValueRefSpec fieldValueRefSpec = (FieldValueRefSpec)objectArray[i];
                IdentifiableItem identifiableItem = vis.getByID(fieldValueRefSpec.$ref);
                if (identifiableItem instanceof Field) {
                    Field field = (Field)identifiableItem;
                    StringValueSpec stringValueSpec = new StringValueSpec();
                    stringValueSpec.style = fieldValueRefSpec.style;
                    stringValueSpec.value = field.label == null ? field.id : field.label;
                    objectArray2[i] = stringValueSpec;
                    continue;
                }
                objectArray2[i] = "";
                continue;
            }
            objectArray2[i] = objectArray[i] instanceof ArgumentSpec || objectArray[i] instanceof ImageSpec ? "" : objectArray[i];
        }
        return objectArray2;
    }

    protected void setDefaultTitlePadding(double d) {
        this.defaultTitlePadding = d;
    }
}

