/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.legend.nonsimple.AbstractAxisLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.SceneToLegendConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.ColorOffsetSpec;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.List;

class ColorGradientLegend
extends AbstractAxisLegend {
    public static final String METHOD = "continuous";
    private static final String LINEAR_FILL = "linear";
    private static final int VERTICAL_GRADIENT = 270;
    private static final int HORIZONTAL_GRADIENT = 180;
    private Dim grammarDim;
    private Dim titleDim;
    private SizeInfo cachedSizeInfo;

    protected ColorGradientLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list) {
        super(vis, legendSpec, n, list);
        this.validateContinuousColorAesthetics(METHOD, true);
        this.cachedSizeInfo = null;
    }

    @Override
    protected double getAxisWidth() {
        return this.getDefaultAxisWidth(5);
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        Size size;
        Size size2;
        if (this.cachedSizeInfo != null) {
            return this.cachedSizeInfo;
        }
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = this.setLegendVisSpec();
        visState = vis.makeSceneTree(null, visState);
        SceneTree sceneTree = visState.getSceneTree();
        Dim dim = sceneTree.getSize();
        Dim dim2 = this.getMinSize();
        Dim dim3 = this.getAvailableSize();
        if (dim3 != null && (dim2.getWidth() > dim3.getWidth() || dim2.getHeight() > dim3.getHeight())) {
            this.cachedSizeInfo = new SizeInfo(Size.ZERO, Size.ZERO, Size.ZERO);
            return this.cachedSizeInfo;
        }
        if (this.verticalLegend) {
            size2 = Size.makeFixed(dim.getWidth(), dim.getHeight());
            size = new Size(size2.getWidth(), Lengths.UNLIMITED);
        } else {
            size2 = Size.makeFixed(dim.getWidth(), Math.max(dim.getHeight(), dim2.getHeight()));
            size = new Size(Lengths.UNLIMITED, size2.getHeight());
        }
        this.cachedSizeInfo = new SizeInfo(size2, Size.ZERO, size);
        return this.cachedSizeInfo;
    }

    @Override
    protected List<SceneNode> makeScene() {
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = this.setLegendVisSpec();
        Dim dim = this.getExtent();
        visState = this.updateForExtent(dim, visState);
        visState = vis.makeSceneTree(dim, visState);
        SceneTree sceneTree = visState.getSceneTree();
        String string = this.firstAesthetic.valueProvider.getBaseField() == null ? null : this.firstAesthetic.valueProvider.getBaseField().id;
        SceneToLegendConverter sceneToLegendConverter = new SceneToLegendConverter((GroupSceneNode)sceneTree.getRoot(), this.legendIndex, string, METHOD);
        GroupSceneNode groupSceneNode = sceneToLegendConverter.getLegend();
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        arrayList.add(groupSceneNode);
        return arrayList;
    }

    protected VisState setLegendVisSpec() {
        if (this.firstAesthetic == null) {
            return null;
        }
        Vis vis = this.parentVis.getLegendVis();
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.getValidTickValues();
        VisJSONSpec visJSONSpec = this.makeVisSpec(this.getSwatchSize(15.0), doublePrimitiveArrayList);
        return vis.setTypedSpecification(visJSONSpec);
    }

    protected VisState updateForExtent(Dim dim, VisState visState) {
        visState.isSpecSet();
        Vis vis = this.parentVis.getLegendVis();
        VisJSONSpec visJSONSpec = vis.getCurrentSpec();
        DimensionSpec dimensionSpec = visJSONSpec.grammar[0].coordinates.dimensions[0];
        dimensionSpec.scale.spans[0].tickDelta = null;
        return vis.setTypedSpecification(visJSONSpec);
    }

    private Dim getUnconstrainedTitleSize() {
        if (this.titleDim == null) {
            this.titleDim = this.getTitleSize(null, null);
        }
        return this.titleDim;
    }

    private Dim getMinSize() {
        Dim dim = this.getGrammarSize();
        double d = dim.getWidth() + 2.0;
        double d2 = dim.getHeight() + 2.0;
        Dim dim2 = this.getUnconstrainedTitleSize();
        double d3 = dim2.getHeight();
        double d4 = this.getDefaultTopPadding(d3);
        boolean bl = d4 > 0.0;
        Insets insets = Insets.makeForStyle(this.makeVisStyle(true, 5, bl, d4, false, true), new Dim(100.0, 100.0));
        d += insets.getHorizontal();
        d2 += insets.getVertical();
        d2 += d3;
        double d5 = dim2.getWidth();
        if (d5 > d) {
            d = d5 + insets.getHorizontal();
        }
        return new Dim(d, d2);
    }

    private Dim getGrammarSize() {
        if (this.grammarDim == null) {
            this.grammarDim = this.computeGrammarSizeWithoutTitle();
        }
        return this.grammarDim;
    }

    protected Dim computeGrammarSizeWithoutTitle() {
        double d;
        double d2;
        double d3 = this.getSwatchSize(15.0);
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.getValidTickValues();
        double d4 = this.getLabelFont().getHeight();
        if (this.verticalLegend) {
            d2 = d3 + this.getAxisWidth() + 11.0;
            d = (double)doublePrimitiveArrayList.size() * 1.25 * d4;
        } else {
            d2 = (double)doublePrimitiveArrayList.size() * 1.25 * d4;
            d = d3 + this.getAxisWidth() + 1.0;
        }
        return new Dim(Math.ceil(d2), Math.ceil(d));
    }

    VisJSONSpec makeVisSpec(double d, DoublePrimitiveArrayList doublePrimitiveArrayList) {
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        visJSONSpec.data = this.makeDataSpecs(doublePrimitiveArrayList);
        GrammarSpec grammarSpec = new GrammarSpec();
        grammarSpec.coordinates = this.makeCoordSpec(doublePrimitiveArrayList, true, this.verticalLegend, true, true, 1);
        grammarSpec.bounds = this.makeGrammarBounds();
        grammarSpec.elements = this.makeElementSpecs(d);
        grammarSpec.style = this.makeGrammarStyle();
        visJSONSpec.grammar = new GrammarSpec[]{grammarSpec};
        visJSONSpec.titles = this.makeTitles();
        double d2 = this.getDefaultTopPadding(this.getUnconstrainedTitleSize().getHeight());
        boolean bl = d2 > 0.0;
        visJSONSpec.style = this.makeVisStyle(true, 5, bl, d2, false, true);
        this.addVersion(visJSONSpec);
        return visJSONSpec;
    }

    private double getDefaultTopPadding(double d) {
        return d > 0.0 ? 0.0 : this.getLabelFont().getHeight() / 2.0 - 5.0;
    }

    private ElementsSpec[] makeElementSpecs(double d) {
        ElementsSpec[] elementsSpecArray = new ElementsSpec[1];
        ElementsSpec elementsSpec = new ElementsSpec();
        elementsSpec.type = "interval";
        elementsSpec.position = this.makePositionSpecsWithFields("minYForLegend", "yForLegend");
        if (this.legendSpec.itemStyle == null) {
            elementsSpec.style = new StyleSpec();
            elementsSpec.style.outline = "black";
            StyleSpec styleSpec = ((Aesthetic)this.aesthetics.get((int)0)).element.spec.style;
            if (styleSpec != null) {
                elementsSpec.style.fill = styleSpec.fill;
            }
        } else {
            elementsSpec.style = (StyleSpec)this.legendSpec.itemStyle.copy();
        }
        elementsSpec.style.size = d;
        this.updateElementFillStyle(elementsSpec.style);
        elementsSpecArray[0] = elementsSpec;
        return elementsSpecArray;
    }

    DataSpec[] makeDataSpecs(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        DataSpec[] dataSpecArray = new DataSpec[]{new DataSpec()};
        double d = doublePrimitiveArrayList.get(0);
        double d2 = doublePrimitiveArrayList.get(doublePrimitiveArrayList.size() - 1);
        if (this.isAestheticExactScale()) {
            ScaleSpan scaleSpan = this.firstAesthetic.scale.getSpans().get(0);
            d = scaleSpan.zeroOneToDataValue(0.0);
            d2 = scaleSpan.zeroOneToDataValue(1.0);
        }
        ColorGradientLegend.addRows(dataSpecArray[0], d, d2);
        this.addFields(dataSpecArray[0]);
        return dataSpecArray;
    }

    private static void addRows(DataSpec dataSpec, double d, double d2) {
        double[][] dArrayArray = new double[1][];
        double[] dArray = new double[]{d, d2};
        dArrayArray[0] = dArray;
        dataSpec.rows = dArrayArray;
    }

    private void addFields(DataSpec dataSpec) {
        FieldSpec[] fieldSpecArray = new FieldSpec[2];
        fieldSpecArray[0] = new FieldSpec();
        String string = this.getUnitForAestheticField();
        fieldSpecArray[0].id = "minYForLegend";
        fieldSpecArray[0].unit = string;
        fieldSpecArray[1] = new FieldSpec();
        fieldSpecArray[1].id = "yForLegend";
        fieldSpecArray[1].unit = string;
        dataSpec.fields = fieldSpecArray;
    }

    private List<ColorOffsetSpec> getColorArrayForDefaultAestheticMapping(ColorNew colorNew) {
        ArrayList<ColorOffsetSpec> arrayList = new ArrayList<ColorOffsetSpec>(10);
        for (double d = 0.0; d <= 1.0; d += 0.1) {
            ColorOffsetSpec colorOffsetSpec = new ColorOffsetSpec();
            colorOffsetSpec.offset = d;
            ColorNew colorNew2 = this.isScaleReverse() ? ColorGradientLegend.getDefaultColor(colorOffsetSpec.offset.doubleValue(), this.aesthetics, colorNew) : ColorGradientLegend.getDefaultColor(1.0 - colorOffsetSpec.offset.doubleValue(), this.aesthetics, colorNew);
            ColorSpec colorSpec = ColorGradientLegend.convertToColorSpec(colorNew2);
            colorOffsetSpec.color = colorSpec;
            arrayList.add(0, colorOffsetSpec);
        }
        return arrayList;
    }

    private static ColorSpec convertToColorSpec(ColorNew colorNew) {
        ColorSpec colorSpec = new ColorSpec();
        double[] dArray = colorNew.getRGBA();
        colorSpec.r = dArray[0];
        colorSpec.g = dArray[1];
        colorSpec.b = dArray[2];
        colorSpec.a = dArray[3];
        return colorSpec;
    }

    private static ColorNew getDefaultColor(double d, List<Aesthetic> list, ColorNew colorNew) {
        ColorNew colorNew2 = ColorUtil.createColor();
        colorNew2 = colorNew2.combineWithColor(colorNew);
        colorNew2 = colorNew2.combineWithColor((ColorNew)list.get(0).getProducer().getDefaultForNumeric(d, null));
        for (int i = 1; i < list.size(); ++i) {
            ColorNew colorNew3 = (ColorNew)list.get(i).getProducer().getDefaultForNumeric(d, null);
            colorNew2 = colorNew2.combineWithColor(colorNew3);
        }
        return colorNew2;
    }

    private void updateElementFillStyle(StyleSpec styleSpec) {
        List<ColorOffsetSpec> list;
        ColorNew colorNew = this.getFillColor(styleSpec);
        ColorNew colorNew2 = ColorGradientLegend.getOutlineBaseColor(styleSpec);
        ColorNew colorNew3 = ColorUtil.createColor();
        colorNew3 = ColorGradientLegend.combineOutlineOrBaseColor(colorNew3, this.aesthetics, colorNew, colorNew2);
        if (this.firstAesthetic.getMapping() != null) {
            boolean bl = this.firstAesthetic.scale.reverse;
            int n = this.firstAesthetic.getMapping().size();
            list = new ArrayList<ColorOffsetSpec>();
            for (int i = 0; i < n; ++i) {
                double d = this.firstAesthetic.getMapping().getStop(i);
                if (bl) {
                    d = 1.0 - d;
                }
                list.add(0, this.getColor(d, i, this.aesthetics, colorNew3));
            }
        } else {
            list = this.getColorArrayForDefaultAestheticMapping(colorNew3);
        }
        FillSpec fillSpec = new FillSpec();
        fillSpec.angle = this.verticalLegend ? 270 : 180;
        fillSpec.type = LINEAR_FILL;
        fillSpec.colors = list.toArray(new ColorOffsetSpec[list.size()]);
        styleSpec.fill = fillSpec;
    }

    private static ColorNew getOutlineBaseColor(StyleSpec styleSpec) {
        if (styleSpec.outline == null) {
            return null;
        }
        if (styleSpec.outline instanceof FillSpec) {
            return null;
        }
        if (BasicFactory.isString(styleSpec.outline)) {
            return ColorUtil.createColorFromString((String)styleSpec.outline);
        }
        if (styleSpec.outline instanceof ColorSpec) {
            return ColorUtil.createColorFromColorSpec((ColorSpec)styleSpec.outline);
        }
        return null;
    }

    private ColorNew getFillColor(StyleSpec styleSpec) {
        if (styleSpec == null || styleSpec.fill == null) {
            return null;
        }
        if (styleSpec.fill instanceof FillSpec) {
            return null;
        }
        if (BasicFactory.isString(styleSpec.fill)) {
            return ColorUtil.createColorFromString((String)styleSpec.fill);
        }
        if (styleSpec.fill instanceof ColorSpec) {
            return ColorUtil.createColorFromColorSpec((ColorSpec)styleSpec.fill);
        }
        return null;
    }

    private static ColorNew combineOutlineOrBaseColor(ColorNew colorNew, List<Aesthetic> list, ColorNew colorNew2, ColorNew colorNew3) {
        ColorNew colorNew4 = colorNew;
        if ("outline".equals(list.get(0).getModifiesType())) {
            if (colorNew3 != null) {
                colorNew4 = colorNew4.combineWithColor(colorNew3);
            }
        } else if (colorNew2 != null) {
            colorNew4 = colorNew4.combineWithColor(colorNew2);
        }
        return colorNew4;
    }

    private ColorOffsetSpec getColor(double d, int n, List<Aesthetic> list, ColorNew colorNew) {
        ColorNew colorNew2 = ColorUtil.createColor();
        double d2 = d;
        if (colorNew != null) {
            colorNew2 = colorNew2.combineWithColor(colorNew);
        }
        for (int i = 0; i < list.size(); ++i) {
            ColorNew colorNew3;
            double d3;
            Aesthetic aesthetic = list.get(i);
            double d4 = d2;
            ColorNew colorNew4 = (ColorNew)aesthetic.getMapping().getValue(n);
            if (d4 < 0.0) {
                if (n == aesthetic.getMapping().size() - 1) {
                    d4 = 0.0;
                } else {
                    d3 = aesthetic.getMapping().getStop(n + 1);
                    if (d3 >= 0.0) {
                        colorNew3 = (ColorNew)aesthetic.getMapping().getValue(n + 1);
                        colorNew4 = colorNew4.interpolateWithColor(colorNew3, (0.0 - d4) / (d3 - d4));
                    }
                    d4 = 0.0;
                }
            } else if (d4 > 1.0) {
                if (n == 0) {
                    d4 = 1.0;
                } else {
                    d3 = aesthetic.getMapping().getStop(n - 1);
                    if (d3 <= 1.0) {
                        colorNew3 = (ColorNew)aesthetic.getMapping().getValue(n - 1);
                        colorNew4 = colorNew4.interpolateWithColor(colorNew3, (d4 - 1.0) / (d4 - d3));
                    }
                    d4 = 1.0;
                }
            }
            colorNew2 = colorNew2.combineWithColor(colorNew4);
            if (i != list.size() - 1) continue;
            d2 = d4;
        }
        ColorOffsetSpec colorOffsetSpec = new ColorOffsetSpec();
        colorOffsetSpec.offset = this.isScaleReverse() ? Double.valueOf(d2) : Double.valueOf(1.0 - d2);
        colorOffsetSpec.color = ColorGradientLegend.convertToColorSpec(colorNew2);
        return colorOffsetSpec;
    }

    protected BoundsSpec makeGrammarBounds() {
        BoundsSpec boundsSpec = new BoundsSpec();
        Dim dim = this.getGrammarSize();
        if (this.verticalLegend) {
            boundsSpec.width = dim.getWidth();
        } else {
            boundsSpec.height = dim.getHeight();
        }
        return boundsSpec;
    }

    @Override
    protected double getPad() {
        return 5.0;
    }

    @Override
    public String getFieldKey() {
        return "minYForLegend";
    }
}

