/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.legend.nonsimple.BaseLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.ElementSwatch;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchLegend;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementRefSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StringValueSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ElementLegend
extends ContentFrame {
    private final SwatchLegend swatchLegend;
    private static final String FIELD_ID = "elementLegendField";

    protected ElementLegend(Vis vis, LegendSpec legendSpec, int n) {
        this.setId("L" + n);
        this.setBackgroundIdSuffixes("-legendBackgroundStroke", "-legendBackgroundFill");
        this.setStyle(legendSpec.boundsStyle);
        this.setRequiresBackgroundShape(false);
        if (legendSpec.location != null && legendSpec.location instanceof BoundsSpec) {
            BoundsSpec boundsSpec = (BoundsSpec)legendSpec.location;
            Bounds bounds = new Bounds(boundsSpec, vis.getVisContext().getLogger());
            this.setSpecifiedBounds(bounds);
        }
        this.swatchLegend = this.makeSwatchLegend(vis, legendSpec, n);
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        return this.swatchLegend.getContentSizeInfo(d, d2);
    }

    @Override
    protected List<SceneNode> createContent() {
        return this.swatchLegend.createContent();
    }

    @Override
    public void layoutWithBounds(Rect rect, Dim dim, Dim dim2) {
        super.layoutWithBounds(rect, dim, dim2);
        this.swatchLegend.layoutWithBounds(rect, dim, dim2);
    }

    private SwatchLegend makeSwatchLegend(Vis vis, LegendSpec legendSpec, int n) {
        List<Element> list = this.makeElements(vis, legendSpec);
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        visJSONSpec.style = new StyleSpec();
        visJSONSpec.style.fill = "transparent";
        visJSONSpec.version = "7.2";
        visJSONSpec.data = this.makeDataSpec(vis, list);
        visJSONSpec.grammar = new GrammarSpec[]{new GrammarSpec()};
        visJSONSpec.grammar[0].elements = new ElementsSpec[]{new ElementsSpec()};
        ElementsSpec elementsSpec = visJSONSpec.grammar[0].elements[0];
        elementsSpec.type = "point";
        elementsSpec.symbol = this.makeSymbolAesthetic(vis, list, legendSpec);
        Vis vis2 = Vis.createVisWithContext(vis.getVisContext());
        VisState visState = vis2.setTypedSpecification(visJSONSpec);
        visState.isSpecSet();
        ArrayList<Aesthetic> arrayList = new ArrayList<Aesthetic>();
        arrayList.add(vis2.getGrammar()[0].elements[0].aesthetics[0]);
        LegendSpec legendSpec2 = new LegendSpec();
        legendSpec2.boundsStyle = legendSpec.boundsStyle;
        legendSpec2.columns = legendSpec.columns;
        legendSpec2.itemBoxStyle = legendSpec.itemBoxStyle;
        legendSpec2.itemStyle = legendSpec.itemStyle;
        legendSpec2.labelStyle = legendSpec.labelStyle;
        legendSpec2.legendEntryStyle = legendSpec.legendEntryStyle;
        legendSpec2.location = legendSpec.location;
        legendSpec2.multiline = legendSpec.multiline;
        legendSpec2.orientation = legendSpec.orientation;
        legendSpec2.rows = legendSpec.rows;
        legendSpec2.scale = legendSpec.scale;
        legendSpec2.title = legendSpec.title != null ? BaseLegend.makeTitleContent(vis, legendSpec.title) : new Object[]{"Elements"};
        legendSpec2.titleStyle = legendSpec.titleStyle;
        SwatchLegend swatchLegend = new SwatchLegend(vis, legendSpec2, n, arrayList, false);
        swatchLegend.setFieldInfo(false);
        return swatchLegend;
    }

    private List<Element> makeElements(Vis vis, LegendSpec legendSpec) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (legendSpec.elements.length == 0) {
            throw new SpecException("Legend 'elements' must have at least one element reference", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        for (ElementRefSpec elementRefSpec : legendSpec.elements) {
            if (elementRefSpec == null || elementRefSpec.$ref == null) {
                throw new SpecException("Legend 'elements' must each be non-null and have a non-null '$ref' to an element", ErrorCode.SPEC_INVALID_LEGENDS, null);
            }
            IdentifiableItem identifiableItem = vis.getByID(elementRefSpec.$ref);
            if (!(identifiableItem instanceof Element)) {
                throw new SpecException("Legend 'elements' reference '" + elementRefSpec.$ref + "' is not an element", ErrorCode.SPEC_INVALID_LEGENDS, null);
            }
            arrayList.add((Element)identifiableItem);
        }
        return arrayList;
    }

    private DataSpec[] makeDataSpec(Vis vis, List<Element> list) {
        int n = list.size();
        DataSpec dataSpec = new DataSpec();
        dataSpec.fields = new FieldSpec[]{new FieldSpec()};
        dataSpec.fields[0].id = FIELD_ID;
        dataSpec.fields[0].categories = new String[n];
        dataSpec.rows = new double[n][];
        for (int i = 0; i < n; ++i) {
            dataSpec.fields[0].categories[i] = this.makeLabel(vis, list.get(i));
            dataSpec.rows[i] = new double[]{i};
        }
        return new DataSpec[]{dataSpec};
    }

    private String makeLabel(Vis vis, Element element) {
        Object[] objectArray = element.getDescription();
        objectArray = objectArray == null || objectArray.length == 0 ? new Object[]{""} : BaseLegend.makeTitleContent(vis, objectArray);
        String string = "";
        for (Object object : objectArray) {
            if (BasicFactory.isString(object)) {
                string = string + (String)object;
                continue;
            }
            if (BasicFactory.isNumber(object)) {
                string = string + BasicFactory.unformattedNumber((Number)object);
                continue;
            }
            if (!(object instanceof StringValueSpec)) continue;
            string = string + ((StringValueSpec)object).value;
        }
        return string;
    }

    private AestheticSpec[] makeSymbolAesthetic(Vis vis, List<Element> list, LegendSpec legendSpec) {
        AestheticSpec aestheticSpec = new AestheticSpec();
        aestheticSpec.field = new FieldValueRefSpec();
        aestheticSpec.field.$ref = FIELD_ID;
        int n = list.size();
        aestheticSpec.palette = new Object[n];
        for (int i = 0; i < n; ++i) {
            Element element = list.get(i);
            SwatchType swatchType = SwatchType.makeForElement(element, legendSpec);
            ElementSwatch elementSwatch = new ElementSwatch(swatchType, element, null, true, false, null);
            SymbolSpec symbolSpec = new SymbolSpec();
            symbolSpec.shape = new SymbolShapeSpec[]{elementSwatch.makeSwatchSpecification(legendSpec.itemStyle)};
            aestheticSpec.palette[i] = symbolSpec;
        }
        return new AestheticSpec[]{aestheticSpec};
    }
}

