/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchSizer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class ElementSwatch {
    protected static final String SWATCHLEGENDENTRY_SWATCH = "legendentry_swatch9238749274";
    protected static final String SWATCHLEGENDENTRY_SYMBOL = "legendentry_symbol9238749274";
    protected static final String SWATCHLEGENDENTRY_LINE = "legendentry_line9238749274";
    protected static final String SWATCHLEGENDENTRY_AREAFILL = "legendentry_areafill9238749274";
    protected static final String SWATCHLEGENDENTRY_AREAOUTLINE = "legendentry_areaoutline9238749274";
    protected static final double MAX_STROKE_WIDTH = 3.0;
    private final SwatchType swatchType;
    private final Element element;
    private final LabelProducer labelProducer;
    private final boolean elementLegend;
    private final double strokeClamp;
    private final SwatchSizer sizer;

    ElementSwatch(SwatchType swatchType, Element element, LabelProducer labelProducer, boolean bl, boolean bl2, SwatchSizer swatchSizer) {
        this.swatchType = swatchType;
        this.element = element;
        this.labelProducer = labelProducer;
        this.elementLegend = bl;
        this.strokeClamp = bl2 ? 3.0 : 10.0;
        this.sizer = swatchSizer;
    }

    SymbolShapeSpec makeSwatchSpecification(StyleSpec styleSpec) {
        SymbolShapeSpec[] symbolShapeSpecArray;
        StyleSpec styleSpec2;
        Dim[] dimArray = this.makeSwatchSizes(styleSpec);
        StyleSpec styleSpec3 = this.swatchType.getStyle();
        Object object = null;
        StyleSpec styleSpec4 = styleSpec3;
        if ((this.sizer != null && !this.sizer.isStrokeChanging() || this.sizer == null) && ElementSwatch.getStrokeWidth(styleSpec4) > 3.0) {
            styleSpec4 = (StyleSpec)styleSpec4.copy();
            styleSpec4.stroke.width = 3.0;
        }
        if (styleSpec4 == null) {
            styleSpec4 = new StyleSpec();
            styleSpec4.fill = "#aaa";
            styleSpec4.outline = "#000";
        }
        if ((styleSpec4 = StyleBuilder.mergeStyles(styleSpec4, styleSpec)) != null) {
            object = styleSpec4.symbol;
            styleSpec4 = this.modifyStyleSpecForSwatch(styleSpec4, false);
        }
        if ((styleSpec2 = styleSpec3) == null) {
            styleSpec2 = new StyleSpec();
            styleSpec2.fill = "#000";
        }
        if ((styleSpec2 = StyleBuilder.mergeStyles(styleSpec2, styleSpec)) != null) {
            styleSpec2 = this.modifyStyleSpecForSwatch(styleSpec2, true);
        }
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.type = "group";
        symbolShapeSpec.style = new StyleSpec();
        if (this.sizer != null && this.sizer.isStrokeChanging()) {
            symbolShapeSpecArray = this.sizer.getMaxStrokeSwatch();
            double d = Math.max(symbolShapeSpecArray.getHeight(), dimArray[0].getHeight());
            symbolShapeSpec.style.width = dimArray[0].getWidth();
            symbolShapeSpec.style.height = d;
        } else if (this.sizer != null && this.sizer.isSizeChanging()) {
            symbolShapeSpec.style.width = dimArray[0].getWidth();
            symbolShapeSpec.style.height = dimArray[0].getHeight();
            this.sizer.modifyStyleSize(symbolShapeSpec.style, this.labelProducer);
        } else {
            symbolShapeSpec.style.width = dimArray[0].getWidth();
            symbolShapeSpec.style.height = dimArray[0].getHeight();
        }
        symbolShapeSpec.part = SWATCHLEGENDENTRY_SWATCH;
        switch (this.swatchType.getType()) {
            default: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{this.makePointElementSpecification(object, styleSpec4)};
                break;
            }
            case 2: 
            case 3: {
                symbolShapeSpecArray = this.makeLineElementSpecification(dimArray, styleSpec2);
                break;
            }
            case 4: 
            case 5: {
                symbolShapeSpecArray = this.makeAreaElementSpecification(styleSpec4);
                break;
            }
            case 6: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{this.makePointElementSpecification(object == null ? "rect" : object, styleSpec4)};
                break;
            }
            case 7: 
            case 8: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec()};
                symbolShapeSpecArray[0].part = SWATCHLEGENDENTRY_SYMBOL;
                symbolShapeSpecArray[0].type = "path";
                symbolShapeSpecArray[0].style = styleSpec2;
                symbolShapeSpecArray[0].path = "M0,0.5L1,0.5";
                break;
            }
            case 9: 
            case 10: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec()};
                symbolShapeSpecArray[0].part = SWATCHLEGENDENTRY_SYMBOL;
                symbolShapeSpecArray[0].type = "rect";
                symbolShapeSpecArray[0].style = styleSpec4;
                break;
            }
            case 11: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec()};
                symbolShapeSpecArray[0].part = SWATCHLEGENDENTRY_SYMBOL;
                symbolShapeSpecArray[0].type = "letter-A";
                symbolShapeSpecArray[0].style = styleSpec4;
                if (this.sizer == null || !this.sizer.isSizeChanging()) break;
                this.sizer.modifyStyleSize(styleSpec4, this.labelProducer);
                break;
            }
            case 12: {
                symbolShapeSpecArray = new SymbolShapeSpec[]{this.makePointElementSpecification("square", styleSpec4)};
            }
        }
        symbolShapeSpec.shape = symbolShapeSpecArray;
        return symbolShapeSpec;
    }

    private static double getStrokeWidth(StyleSpec styleSpec) {
        if (styleSpec != null && styleSpec.stroke != null) {
            Double d = UnitConverter.convertLength(styleSpec.stroke.width, 1.0, 1.0);
            return d == null ? 1.0 : d;
        }
        return 1.0;
    }

    Dim[] makeSwatchSizes(StyleSpec styleSpec) {
        Dim dim = null;
        Dim dim2 = null;
        switch (this.swatchType.getType()) {
            default: {
                dim = this.getPointElementSize(this.swatchType.getStyle(), styleSpec);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                dim = new Dim(20.0, 20.0);
                dim = StyleBuilder.modifySizeByStyle(dim, dim, styleSpec);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                dim = new Dim(20.0, 20.0);
                if (this.sizer != null && (dim = this.sizer.getSwatchSize(dim)).getHeight() < 20.0) {
                    dim.setHeight(20.0);
                }
                dim = StyleBuilder.modifySizeByStyle(dim, dim, styleSpec);
                break;
            }
            case 11: {
                dim = new Dim(20.0, 20.0);
                dim = StyleBuilder.modifySizeByStyle(dim, dim, styleSpec);
            }
        }
        if (this.swatchType.getType() == 3) {
            if (this.sizer != null && this.sizer.isSizeChanging()) {
                dim2 = this.sizer.getMaxSymbolSwatch();
                if (dim2 == null) {
                    dim2 = this.getPointElementSize(this.swatchType.getSymbolStyle(), styleSpec);
                }
            } else {
                dim2 = this.getPointElementSize(this.swatchType.getSymbolStyle(), styleSpec);
            }
        } else {
            dim2 = new Dim(0.0, 0.0);
        }
        return new Dim[]{dim, dim2};
    }

    private Dim getPointElementSize(StyleSpec styleSpec, StyleSpec styleSpec2) {
        Dim dim = this.element.size != null ? new Dim(this.element.size.getWidth(), this.element.size.getHeight()) : new Dim(20.0, 20.0);
        dim = StyleBuilder.modifySizeByStyle(dim, dim, styleSpec);
        if (styleSpec2 != null && (styleSpec2.size != null || styleSpec2.width != null || styleSpec2.height != null)) {
            dim = StyleBuilder.modifySizeByStyle(dim, dim, styleSpec2);
        } else {
            boolean bl = true;
            if (styleSpec != null && BasicFactory.isString(styleSpec.symbol)) {
                String string = (String)styleSpec.symbol;
                boolean bl2 = bl = !string.startsWith("rect");
            }
            if (bl) {
                double d = styleSpec == null || styleSpec.size == null ? Math.max(10.0, Math.min(20.0, Math.min(dim.getWidth(), dim.getHeight()))) : (this.swatchType != null && this.swatchType.getStyle() != null && this.swatchType.getStyle().stroke != null ? Math.min(20.0, Math.min(dim.getWidth(), dim.getHeight())) : Math.max(10.0, Math.min(20.0, Math.min(dim.getWidth(), dim.getHeight()))));
                dim.setWidth(d);
                dim.setHeight(d);
            } else {
                double d = dim.getWidth();
                double d2 = dim.getHeight();
                Range range = new Range(10.0, 20.0);
                if (d <= 0.0 && d2 <= 0.0) {
                    d = 20.0;
                    d2 = 20.0;
                } else if (d <= 0.0) {
                    d = 0.0;
                    d2 = range.clamp(d2);
                } else if (d2 <= 0.0) {
                    d = range.clamp(d);
                    d2 = 0.0;
                } else if (d > 20.0 || d2 > 20.0) {
                    double d3 = 20.0 / Math.max(d, d2);
                    d *= d3;
                    d2 *= d3;
                } else if (d < 10.0 && d2 < 10.0) {
                    double d4 = 10.0 / Math.max(d, d2);
                    d *= d4;
                    d2 *= d4;
                }
                dim.setWidth(d);
                dim.setHeight(d2);
            }
        }
        return dim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SymbolShapeSpec makePointElementSpecification(Object object, StyleSpec styleSpec) {
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.part = SWATCHLEGENDENTRY_SYMBOL;
        if (object != null) {
            if (BasicFactory.isString(object)) {
                symbolShapeSpec.style = this.modifyStyleSpecForSwatch(styleSpec, false);
                symbolShapeSpec.type = (String)object;
                return symbolShapeSpec;
            } else {
                SymbolSpec symbolSpec = (SymbolSpec)object;
                if (symbolSpec.shape == null) throw new SpecException("Must specify shape array for custom symbol", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
                symbolShapeSpec.type = "group";
                int n = symbolSpec.shape.length;
                symbolShapeSpec.shape = new SymbolShapeSpec[n];
                for (int i = 0; i < n; ++i) {
                    symbolShapeSpec.shape[i] = (SymbolShapeSpec)symbolSpec.shape[i].copy();
                    symbolShapeSpec.shape[i].style = this.modifyStyleSpecForSwatch(StyleBuilder.mergeStyles(styleSpec, symbolSpec.shape[i].style), false);
                    if (symbolShapeSpec.shape[i].style == null) continue;
                    symbolShapeSpec.shape[i].style.symbol = null;
                }
            }
            return symbolShapeSpec;
        } else {
            symbolShapeSpec.type = "circle";
            symbolShapeSpec.style = this.modifyStyleSpecForSwatch(styleSpec, false);
        }
        return symbolShapeSpec;
    }

    SymbolShapeSpec[] makeLineElementSpecification(Dim[] dimArray, StyleSpec styleSpec) {
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.type = "path";
        symbolShapeSpec.path = "M0,0.5L1,0.5";
        symbolShapeSpec.part = SWATCHLEGENDENTRY_LINE;
        symbolShapeSpec.style = this.modifyStyleSpecForSwatch(styleSpec, true);
        if (this.swatchType.getType() != 3) {
            return new SymbolShapeSpec[]{symbolShapeSpec};
        }
        StyleSpec styleSpec2 = this.swatchType.getSymbolStyle();
        Object object = styleSpec2 == null ? null : styleSpec2.symbol;
        SymbolShapeSpec symbolShapeSpec2 = this.makePointElementSpecification(object, styleSpec2);
        symbolShapeSpec2.bounds = new BoundsSpec();
        double d = dimArray[1].getWidth() / dimArray[0].getWidth();
        double d2 = dimArray[1].getHeight() / dimArray[0].getHeight();
        symbolShapeSpec2.bounds.left = MathUtil.r3(100.0 * (0.5 - d / 2.0)) + "%";
        symbolShapeSpec2.bounds.width = MathUtil.r3(100.0 * d) + "%";
        symbolShapeSpec2.bounds.top = MathUtil.r3(100.0 * (0.5 - d2 / 2.0)) + "%";
        symbolShapeSpec2.bounds.height = MathUtil.r3(100.0 * d2) + "%";
        return new SymbolShapeSpec[]{symbolShapeSpec, symbolShapeSpec2};
    }

    SymbolShapeSpec[] makeAreaElementSpecification(StyleSpec styleSpec) {
        SymbolShapeSpec[] symbolShapeSpecArray = new SymbolShapeSpec[]{new SymbolShapeSpec(), new SymbolShapeSpec()};
        symbolShapeSpecArray[0].type = "path";
        symbolShapeSpecArray[0].part = SWATCHLEGENDENTRY_AREAFILL;
        symbolShapeSpecArray[0].style = this.modifyStyleSpecForSwatch(styleSpec, false);
        if (symbolShapeSpecArray[0].style == null) {
            symbolShapeSpecArray[0].style = new StyleSpec();
            symbolShapeSpecArray[0].style.fill = "#aaa";
        }
        symbolShapeSpecArray[0].style.outline = "transparent";
        symbolShapeSpecArray[1].type = "path";
        symbolShapeSpecArray[1].part = SWATCHLEGENDENTRY_AREAOUTLINE;
        symbolShapeSpecArray[1].style = this.modifyStyleSpecForSwatch(styleSpec, false);
        if (symbolShapeSpecArray[1].style == null) {
            (symbolShapeSpecArray[1].style = new StyleSpec()).fill = styleSpec == null ? "transparent" : "#000";
        } else if (symbolShapeSpecArray[1].style.outline == null && symbolShapeSpecArray[1].style.fill != null) {
            symbolShapeSpecArray[1].style.fill = symbolShapeSpecArray[1].style.stroke != null ? "#000" : "transparent";
        } else {
            symbolShapeSpecArray[1].style.fill = symbolShapeSpecArray[1].style.outline;
            symbolShapeSpecArray[1].style.outline = null;
        }
        if (this.swatchType.getType() == 4) {
            symbolShapeSpecArray[0].path = "M0,1C0,0.7,0.4,0.6,0.5,0.5C0.6,0.4,0.7,0,1,0L1,1Z";
            symbolShapeSpecArray[1].path = "M0,1C0,0.7,0.4,0.6,0.5,0.5C0.6,0.4,0.7,0,1,0";
        } else {
            symbolShapeSpecArray[0].path = "M0,1L0.4,0.25L0.6,0.5L1.0,0.0L1.0,1.0Z";
            symbolShapeSpecArray[1].path = "M0,1L0.4,0.25L0.6,0.5L1.0,0.0";
        }
        return symbolShapeSpecArray;
    }

    private StyleSpec modifyStyleSpecForSwatch(StyleSpec styleSpec, boolean bl) {
        Object object;
        if (styleSpec == null) {
            return null;
        }
        StyleSpec styleSpec2 = (StyleSpec)styleSpec.copy();
        styleSpec2.size = null;
        styleSpec2.width = null;
        styleSpec2.height = null;
        styleSpec2.symbol = null;
        styleSpec2.padding = null;
        if (bl && styleSpec.size != null && (styleSpec2.stroke == null || styleSpec2.stroke.width == null)) {
            if (styleSpec2.stroke == null) {
                styleSpec2.stroke = new StrokeSpec();
            }
            styleSpec2.stroke.width = styleSpec.size;
        }
        if (styleSpec2.stroke != null && styleSpec2.stroke.width != null) {
            object = UnitConverter.convertLength(styleSpec2.stroke.width, 1.0, 20.0);
            styleSpec2.stroke.width = object == null ? Double.valueOf(1.0) : (this.sizer != null && this.sizer.isStrokeChanging() ? Double.valueOf(((Number)object).doubleValue()) : Double.valueOf(Math.min(((Number)object).doubleValue(), this.strokeClamp)));
        }
        if (styleSpec2.font != null) {
            object = UnitConverter.convertLength(styleSpec2.font.size, 20.0, 20.0);
            styleSpec2.font.size = object == null ? (Number)12 : (Number)MathUtil.r3(Math.max(7.5, Math.min(((Number)object).doubleValue(), 15.0)));
        }
        if (styleSpec2.fill instanceof FillSpec) {
            object = (FillSpec)((FillSpec)styleSpec2.fill).copy();
            ((FillSpec)object).global = false;
            styleSpec2.fill = object;
        }
        if (BasicFactory.isEmpty(styleSpec2.toJSON())) {
            return null;
        }
        return styleSpec2;
    }
}

