/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.LogScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LegendDataCreator {
    public static final String FIELD_ID = "legendField";
    public static final String VALUE_ID = "legendValue";
    public static final String STRING_ID = "legendString";
    private int maxSwatches = 80;
    private final boolean bHasLegendEntries;
    private final Number[] legendCategories;
    private final boolean aestheticIsLocal;
    private final FieldSpec fieldSpec;
    private final String fieldName;
    private boolean legendReverseOrder;
    private final boolean scaleReverseOrder;
    private final Scale scale;
    private HashMap<Double, Integer> recoding;
    private DataSpec data;
    private List<Tick> dataTicks;
    private int desiredTickCount;
    private double[] tickValues;

    LegendDataCreator(LegendSpec legendSpec, List<Aesthetic> list, boolean bl) {
        List<Tick> list2;
        Object object;
        this.scale = LegendDataCreator.getCombinedScale(list);
        if (legendSpec != null && legendSpec.maximumSwatches != null) {
            this.maxSwatches = legendSpec.maximumSwatches.intValue();
        }
        if (legendSpec != null && legendSpec.scale != null) {
            object = legendSpec.scale;
            this.legendReverseOrder = ((ScaleSpec)object).reverse != null && ((ScaleSpec)object).reverse != false;
            this.legendCategories = ((ScaleSpec)object).spans == null ? null : ((ScaleSpec)object).spans[0].categories;
            this.aestheticIsLocal = ((ScaleSpec)object).local == null ? this.scale.isCategorical() : ((ScaleSpec)object).local.booleanValue();
        } else {
            this.legendReverseOrder = false;
            this.legendCategories = null;
            this.aestheticIsLocal = this.scale.isCategorical();
        }
        object = list.get((int)0).valueProvider.getBaseField();
        if (object == null) {
            this.fieldSpec = null;
            this.fieldName = null;
        } else {
            this.fieldSpec = ((Field)object).getFieldSpec();
            this.fieldName = ((Field)object).id;
        }
        if (bl && (!this.scale.isCategorical() || LegendDataCreator.stackedCoords(list.get(0)) && this.scale.isCategorical())) {
            this.legendReverseOrder = !this.legendReverseOrder;
        }
        this.bHasLegendEntries = (list2 = this.scale.getTicks()) != null && list2.size() > 0;
        this.scaleReverseOrder = this.scale.reverse;
        this.desiredTickCount = 7;
        this.recoding = null;
    }

    public void reset() {
        this.data = null;
    }

    final String getFieldName() {
        return this.fieldName;
    }

    private static boolean stackedCoords(Aesthetic aesthetic) {
        Coordinates coordinates = aesthetic.element.grammar.coordinates;
        boolean bl = coordinates.containsStacking();
        boolean bl2 = !coordinates.containsPolar() && !coordinates.containsTranspose() || coordinates.scales.length != 1;
        return bl && bl2;
    }

    private static Scale getCombinedScale(List<Aesthetic> list) {
        for (Aesthetic aesthetic : list) {
            if (aesthetic.scale == null) continue;
            return aesthetic.scale;
        }
        throw new IllegalStateException();
    }

    final boolean hasLegendEntries() {
        return this.bHasLegendEntries;
    }

    DataSpec[] getDataSpec() {
        if (!this.bHasLegendEntries) {
            return null;
        }
        return new DataSpec[]{this.build()};
    }

    private DataSpec build() {
        int n;
        List<Tick> list;
        String[] stringArray;
        if (!this.bHasLegendEntries) {
            this.dataTicks = new ArrayList<Tick>();
            this.recoding = null;
            this.data = null;
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        ScaleSpan scaleSpan = this.scale.spans.get(0);
        this.data = new DataSpec();
        this.data.fields = new FieldSpec[]{new FieldSpec(), new FieldSpec(), new FieldSpec()};
        FieldSpec fieldSpec = this.data.fields[0];
        fieldSpec.id = FIELD_ID;
        fieldSpec.unit = scaleSpan.getInputUnit().name;
        if (this.fieldSpec != null) {
            fieldSpec.format = this.fieldSpec.format;
            fieldSpec.granularity = this.fieldSpec.granularity;
        }
        this.data.fields[1].id = VALUE_ID;
        this.data.fields[2].id = STRING_ID;
        if (scaleSpan instanceof ContinuousScaleSpan) {
            stringArray = ((ContinuousScaleSpan)scaleSpan).makeCopyWithoutTickInfo();
            list = new ArrayList<Tick>();
            stringArray.setupForTickCount(this.desiredTickCount, this.desiredTickCount);
            stringArray.addTicks(list, true);
        } else {
            list = this.scale.getTicks();
        }
        this.recoding = null;
        if (this.scale.isCategorical()) {
            this.recoding = new HashMap();
            stringArray = new String[list.size()];
            for (n = 0; n < list.size(); ++n) {
                Tick tick = list.get(n);
                if (tick.content != null) {
                    stringArray[n] = tick.content.getText();
                }
                this.recoding.put(tick.value, n);
            }
            fieldSpec.categories = stringArray;
        }
        if (this.aestheticIsLocal) {
            list = this.scale.getTicksForData();
        }
        list = this.limitSwatches(this.filter(list));
        this.dataTicks = list;
        this.data.fields[2].categories = this.getLegendLabels();
        int n2 = list.size();
        this.data.rows = new double[n2][];
        this.tickValues = new double[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = this.legendReverseOrder ? n2 - 1 - n : n;
            double d = list.get((int)n3).value;
            if (this.scale.isCategorical()) {
                d = this.recoding.get(d).intValue();
            }
            this.tickValues[n] = d;
            this.data.rows[n] = new double[]{d, d, n3};
        }
        return this.data;
    }

    MappingSpec[] makeRecodedMapping(MappingSpec[] mappingSpecArray) {
        MappingSpec[] mappingSpecArray2;
        int n;
        if (!this.scale.isCategorical() || mappingSpecArray == null) {
            return mappingSpecArray;
        }
        this.build();
        if (this.recoding == null) {
            return mappingSpecArray;
        }
        ArrayList<MappingSpec> arrayList = new ArrayList<MappingSpec>();
        for (n = 0; n < mappingSpecArray.length; ++n) {
            int n2;
            mappingSpecArray2 = mappingSpecArray[n];
            if (mappingSpecArray2.at != null) {
                Double d = ((Number)mappingSpecArray2.at).doubleValue();
                if (!this.recoding.containsKey(d)) continue;
                MappingSpec mappingSpec = (MappingSpec)mappingSpecArray2.copy();
                mappingSpec.at = this.recoding.get(d);
                arrayList.add(mappingSpec);
                continue;
            }
            if (mappingSpecArray2.atLabel == null) continue;
            boolean bl = false;
            int n3 = -1;
            int n4 = -1;
            FieldSpec[] fieldSpecArray = this.data.fields;
            for (int i = 0; i < fieldSpecArray.length; ++i) {
                if (fieldSpecArray[i].categories == null) continue;
                for (n2 = 0; n2 < fieldSpecArray[i].categories.length; ++n2) {
                    if (!mappingSpecArray2.atLabel.equals(fieldSpecArray[i].categories[n2])) continue;
                    n3 = i;
                    n4 = n2;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (!bl) continue;
            double[][] dArray = this.data.rows;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                Double d;
                if (dArray[n2][n3] != (double)n4 || !this.recoding.containsKey(d = Double.valueOf(n2))) continue;
                MappingSpec mappingSpec = (MappingSpec)mappingSpecArray2.copy();
                mappingSpec.at = this.recoding.get(d);
                arrayList.add(mappingSpec);
            }
        }
        n = arrayList.size();
        mappingSpecArray2 = new MappingSpec[n];
        for (int i = 0; i < n; ++i) {
            mappingSpecArray2[i] = (MappingSpec)arrayList.get(i);
        }
        return mappingSpecArray2;
    }

    private List<Tick> filter(List<Tick> list) {
        if (this.legendCategories == null) {
            return list;
        }
        HashMap<Double, Tick> hashMap = new HashMap<Double, Tick>();
        for (Tick object2 : list) {
            hashMap.put(object2.value, object2);
        }
        int n = 0;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (Number number : this.legendCategories) {
            Tick tick = (Tick)hashMap.get(number.doubleValue());
            if (tick == null) continue;
            arrayList.add(tick);
            if (++n >= this.maxSwatches) break;
        }
        return arrayList;
    }

    private List<Tick> limitSwatches(List<Tick> list) {
        if (list.size() <= this.maxSwatches) {
            return list;
        }
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (int i = 0; i < this.maxSwatches; ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    int getRowCount() {
        DataSpec dataSpec = this.build();
        if (dataSpec == null) {
            return 0;
        }
        return dataSpec.rows.length;
    }

    ScaleSpec getScaleSpec() {
        ScaleSpec scaleSpec = new ScaleSpec();
        scaleSpec.local = false;
        scaleSpec.reverse = this.scaleReverseOrder;
        if (!this.scale.isCategorical()) {
            ScaleSpan scaleSpan = this.scale.spans.get(0);
            scaleSpec.spans = new SpanSpec[]{new SpanSpec()};
            scaleSpec.spans[0].min = scaleSpan.getAdjustedInputRange().getMin();
            scaleSpec.spans[0].max = scaleSpan.getAdjustedInputRange().getMax();
            if (scaleSpan instanceof LogScaleSpan) {
                scaleSpec.spans[0].method = "log";
            }
        }
        return scaleSpec;
    }

    void setDesiredTickCount(int n) {
        this.desiredTickCount = Math.max(0, n);
        this.data = null;
    }

    int getDesiredTickCount() {
        return this.desiredTickCount;
    }

    String[] getLegendLabels() {
        this.build();
        int n = this.dataTicks.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (this.dataTicks.get(i).getContent() == null) continue;
            stringArray[i] = this.dataTicks.get(i).getContent().getText();
        }
        return stringArray;
    }

    boolean isNumeric() {
        return !this.scale.isCategorical();
    }

    final double[] getTickValues() {
        return this.tickValues;
    }
}

