/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.legend.LegendAesthetics;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticReferenceSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class NonSimpleLegendAesthetics
extends LegendAesthetics {
    private static final int STAGGER = 0;
    private static final int CONTINUOUS = 1;
    private static final int AXIS = 2;
    private static final String[] LEGEND_NAMES = new String[]{"stagger", "continuous", "axis"};

    NonSimpleLegendAesthetics() {
    }

    static List<List<Aesthetic>> getDefaultSwatchLegendAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray) {
        return NonSimpleLegendAesthetics.getDefaultSimpleLegendAesthetics(grammarArray, legendSpecArray);
    }

    static List<List<Aesthetic>> getSwatchAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        return NonSimpleLegendAesthetics.getSimpleAestheticsByReferences(aestheticReferenceSpecArray, vis);
    }

    static List<List<Aesthetic>> getDefaultStaggerLegendAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray) {
        return NonSimpleLegendAesthetics.makeDefaultNonSwatchAesthetics(grammarArray, legendSpecArray, 0);
    }

    static List<List<Aesthetic>> getStaggerAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        return NonSimpleLegendAesthetics.makeNonSwatchAestheticsByReferences(aestheticReferenceSpecArray, vis, 0);
    }

    static List<List<Aesthetic>> getDefaultContinuousLegendAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray) {
        return NonSimpleLegendAesthetics.makeDefaultNonSwatchAesthetics(grammarArray, legendSpecArray, 1);
    }

    static List<List<Aesthetic>> getContinuousAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        return NonSimpleLegendAesthetics.makeNonSwatchAestheticsByReferences(aestheticReferenceSpecArray, vis, 1);
    }

    static List<List<Aesthetic>> getDefaultAxisLegendAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray) {
        return NonSimpleLegendAesthetics.makeDefaultNonSwatchAesthetics(grammarArray, legendSpecArray, 2);
    }

    static List<List<Aesthetic>> getAxisAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis) {
        return NonSimpleLegendAesthetics.makeNonSwatchAestheticsByReferences(aestheticReferenceSpecArray, vis, 2);
    }

    private static List<List<Aesthetic>> makeDefaultNonSwatchAesthetics(Grammar[] grammarArray, LegendSpec[] legendSpecArray, int n) {
        Set<String> set = NonSimpleLegendAesthetics.getReferencedAestheticIDs(legendSpecArray);
        ArrayList<List<Aesthetic>> arrayList = new ArrayList<List<Aesthetic>>();
        boolean bl = NonSimpleLegendAesthetics.isFacetChart(grammarArray);
        for (Grammar grammar : grammarArray) {
            for (Element element : grammar.elements) {
                if (element.aesthetics == null || element.aesthetics.length == 0) continue;
                for (Aesthetic aesthetic : element.aesthetics) {
                    if (!NonSimpleLegendAesthetics.isDefaultNonSwatchLegendable(aesthetic, n, bl, set)) continue;
                    ArrayList<Aesthetic> arrayList2 = new ArrayList<Aesthetic>();
                    arrayList2.add(aesthetic);
                    arrayList.add(arrayList2);
                }
            }
        }
        return arrayList;
    }

    private static boolean isDefaultNonSwatchLegendable(Aesthetic aesthetic, int n, boolean bl, Set<String> set) {
        boolean bl2 = aesthetic.scale.localScale != null && aesthetic.scale.localScale != false;
        return !(aesthetic.valueProvider.getBaseField() == null || bl2 && bl || aesthetic.id != null && set.contains(aesthetic.id) || !NonSimpleLegendAesthetics.isNonSwatchLegendable(aesthetic, n));
    }

    private static List<List<Aesthetic>> makeNonSwatchAestheticsByReferences(AestheticReferenceSpec[] aestheticReferenceSpecArray, Vis vis, int n) {
        if (aestheticReferenceSpecArray.length != 1) {
            throw new SpecException("The aesthetics " + NonSimpleLegendAesthetics.getIDsAsString(aestheticReferenceSpecArray) + " cannot be displayed together in a " + LEGEND_NAMES[n] + " legend, only one aesthetic is supported", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        List<Aesthetic> list = NonSimpleLegendAesthetics.getAestheticsByReferences(aestheticReferenceSpecArray, vis);
        for (Aesthetic aesthetic : list) {
            if (NonSimpleLegendAesthetics.isNonSwatchLegendable(aesthetic, n)) continue;
            throw new SpecException("The aesthetic '" + aesthetic.id + "' cannot be displayed by a " + LEGEND_NAMES[n] + "legend", ErrorCode.SPEC_INVALID_LEGENDS, null);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(list);
        return arrayList;
    }

    private static boolean isNonSwatchLegendable(Aesthetic aesthetic, int n) {
        if (n == 0) {
            return "color".equals(aesthetic.type) && !aesthetic.scale.isCategorical();
        }
        if (n == 1) {
            return "color".equals(aesthetic.type) && !aesthetic.scale.isCategorical();
        }
        if (n == 2) {
            if (!"size".equals(aesthetic.type)) {
                return false;
            }
            Field field = aesthetic.valueProvider.getBaseField();
            if (field != null) {
                return !field.isCategorical() && (aesthetic.spec.mapping == null || aesthetic.spec.mapping.length == 0 || aesthetic.spec.mapping.length == 2);
            }
            return true;
        }
        return false;
    }

    static boolean isStaggerLegendable(Aesthetic aesthetic) {
        return "color".equals(aesthetic.type) && !aesthetic.scale.isCategorical() && aesthetic.valueProvider.getBaseField() != null && aesthetic.scale.getAllTicks().size() >= 2;
    }

    static boolean isContinuousLegendable(Aesthetic aesthetic) {
        return "color".equals(aesthetic.type) && !aesthetic.scale.isCategorical() && aesthetic.scale.getAllTicks().size() >= 2;
    }
}

