/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.ContentFrame;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.legend.nonsimple.BaseLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.ColorGradientLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.ElementLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.NonSimpleLegendAesthetics;
import com.ibm.vis.engine.internal.legend.nonsimple.SizeAxisLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.StaggerLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchLegend;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.LegendSpec;
import java.util.ArrayList;
import java.util.List;

@OnDemandLoad(value="com/ibm/vis/layers/nonsimpleLegendLayer")
public class NonSimpleLegendMaker {
    public static List<ContentFrame> makeLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        if (legendSpec.elements != null) {
            return NonSimpleLegendMaker.makeElementLegends(vis, legendSpec, n);
        }
        if ("swatch".equals(legendSpec.method) || legendSpec.method == null) {
            return NonSimpleLegendMaker.makeSwatchLegends(vis, legendSpecArray, legendSpec, n);
        }
        if ("axis".equals(legendSpec.method)) {
            return NonSimpleLegendMaker.makeAxisLegends(vis, legendSpecArray, legendSpec, n);
        }
        if ("stagger".equals(legendSpec.method)) {
            return NonSimpleLegendMaker.makeStaggerLegends(vis, legendSpecArray, legendSpec, n);
        }
        if ("continuous".equals(legendSpec.method)) {
            return NonSimpleLegendMaker.makeContinuousLegends(vis, legendSpecArray, legendSpec, n);
        }
        throw new EngineException("Bad spec.method '" + legendSpec.method + "' in NonSimpleLegendMaker", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
    }

    private static List<ContentFrame> makeElementLegends(Vis vis, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        if (legendSpec.elements.length > 0) {
            ElementLegend elementLegend = new ElementLegend(vis, legendSpec, n);
            arrayList.add(elementLegend);
        }
        return arrayList;
    }

    private static List<ContentFrame> makeAxisLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        List<List<Aesthetic>> list = legendSpec.aesthetics != null && legendSpec.aesthetics.length > 0 ? NonSimpleLegendAesthetics.getAxisAestheticsByReferences(legendSpec.aesthetics, vis) : NonSimpleLegendAesthetics.getDefaultAxisLegendAesthetics(vis.getGrammar(), legendSpecArray);
        int n2 = n;
        for (List<Aesthetic> list2 : list) {
            SizeAxisLegend sizeAxisLegend = new SizeAxisLegend(vis, legendSpec, n2, list2);
            arrayList.add(sizeAxisLegend);
            ++n2;
        }
        return arrayList;
    }

    private static List<ContentFrame> makeStaggerLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        List<List<Aesthetic>> list = legendSpec.aesthetics != null && legendSpec.aesthetics.length > 0 ? NonSimpleLegendAesthetics.getStaggerAestheticsByReferences(legendSpec.aesthetics, vis) : NonSimpleLegendAesthetics.getDefaultStaggerLegendAesthetics(vis.getGrammar(), legendSpecArray);
        int n2 = n;
        for (List<Aesthetic> list2 : list) {
            boolean bl = true;
            for (Aesthetic aesthetic : list2) {
                if (NonSimpleLegendAesthetics.isStaggerLegendable(aesthetic)) continue;
                bl = false;
                break;
            }
            BaseLegend baseLegend = bl ? new StaggerLegend(vis, legendSpec, n2, list2) : new SwatchLegend(vis, legendSpec, n2, list2, true);
            arrayList.add(baseLegend);
            ++n2;
        }
        return arrayList;
    }

    private static List<ContentFrame> makeContinuousLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        List<List<Aesthetic>> list = legendSpec.aesthetics != null && legendSpec.aesthetics.length > 0 ? NonSimpleLegendAesthetics.getContinuousAestheticsByReferences(legendSpec.aesthetics, vis) : NonSimpleLegendAesthetics.getDefaultContinuousLegendAesthetics(vis.getGrammar(), legendSpecArray);
        int n2 = n;
        for (List<Aesthetic> list2 : list) {
            boolean bl = true;
            for (Aesthetic aesthetic : list2) {
                if (NonSimpleLegendAesthetics.isContinuousLegendable(aesthetic)) continue;
                bl = false;
                break;
            }
            BaseLegend baseLegend = bl ? new ColorGradientLegend(vis, legendSpec, n2, list2) : new SwatchLegend(vis, legendSpec, n2, list2, true);
            arrayList.add(baseLegend);
            ++n2;
        }
        return arrayList;
    }

    private static List<ContentFrame> makeSwatchLegends(Vis vis, LegendSpec[] legendSpecArray, LegendSpec legendSpec, int n) {
        ArrayList<ContentFrame> arrayList = new ArrayList<ContentFrame>();
        List<List<Aesthetic>> list = legendSpec.aesthetics != null && legendSpec.aesthetics.length > 0 ? NonSimpleLegendAesthetics.getSwatchAestheticsByReferences(legendSpec.aesthetics, vis) : NonSimpleLegendAesthetics.getDefaultSwatchLegendAesthetics(vis.getGrammar(), legendSpecArray);
        int n2 = n;
        for (List<Aesthetic> list2 : list) {
            SwatchLegend swatchLegend = new SwatchLegend(vis, legendSpec, n2, list2, false);
            arrayList.add(swatchLegend);
            ++n2;
        }
        return arrayList;
    }
}

