/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SceneToLegendConverter {
    private static final String LE = "LE";
    private static final String VALUE = "value";
    private final String baseId;
    private final String field;
    private final GroupSceneNode scene;
    private final String legendType;
    private GroupSceneNode builtLegend;
    private boolean addFieldInfo;
    private Rect bounds;
    private Font font;

    SceneToLegendConverter(GroupSceneNode groupSceneNode, int n, String string, String string2) {
        this.baseId = "L" + n;
        this.field = string;
        this.scene = groupSceneNode;
        this.legendType = string2;
        this.addFieldInfo = true;
    }

    void setFieldInfo(boolean bl) {
        this.addFieldInfo = bl;
    }

    void setEllipsisValues(Rect rect, Font font) {
        this.bounds = rect;
        this.font = font;
    }

    GroupSceneNode getLegend() {
        if (this.builtLegend == null) {
            this.builtLegend = this.createLegend();
        }
        return this.builtLegend;
    }

    private GroupSceneNode createLegend() {
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND);
        if (this.addFieldInfo && this.field != null) {
            groupSceneNode.setField(this.field);
        }
        this.addNonLegendEntryParts(groupSceneNode);
        if ("stagger".equals(this.legendType)) {
            this.createLegendEntriesForAxisLegend(groupSceneNode, true, true);
        } else if ("continuous".equals(this.legendType)) {
            this.createLegendEntriesForAxisLegend(groupSceneNode, false, true);
        } else if ("axis".equals(this.legendType)) {
            this.createLegendEntriesForAxisLegend(groupSceneNode, false, false);
        } else {
            this.addElementLegendEntries(groupSceneNode);
        }
        return groupSceneNode;
    }

    private void addNonLegendEntryParts(GroupSceneNode groupSceneNode) {
        groupSceneNode.setId(this.baseId);
        if (this.field != null) {
            groupSceneNode.setField(this.field);
        }
        SceneToLegendConverter.addBacks(this.scene, this.baseId, groupSceneNode);
        this.addTitles(this.baseId, groupSceneNode);
    }

    private void createLegendEntriesForAxisLegend(GroupSceneNode groupSceneNode, boolean bl, boolean bl2) {
        if (bl2) {
            this.addColorSwatchLegendEntry(0, groupSceneNode, bl);
            this.createAxisLegendEntries(1, groupSceneNode);
        } else if (this.sizeAxisLegendFits(groupSceneNode)) {
            this.addAxisLine(groupSceneNode);
            this.createAxisLegendEntries(1, groupSceneNode);
        } else {
            this.addEllipsisEntry(groupSceneNode);
        }
    }

    boolean sizeAxisLegendFits(GroupSceneNode groupSceneNode) {
        Shape shape;
        Rect rect;
        int n = groupSceneNode.getChildrenCount();
        return this.bounds == null || n <= 0 || !((rect = (Rect)(shape = (Shape)groupSceneNode.getChild(0).getShape()).getGeom()).getHeight() > this.bounds.getHeight() + 2.0);
    }

    private void addEllipsisEntry(GroupSceneNode groupSceneNode) {
        Dim dim = new Dim(this.bounds.getWidth(), this.bounds.getHeight());
        Text text = Text.createTextWithShapedValue("\u2026", 0.0, 0.0, null, null, this.font, null, null, "\u2026", dim, false);
        if (text == null) {
            return;
        }
        Rect rect = text.getBounds();
        text.affine(1.0, this.bounds.getCenterX() - rect.getWidth() * 0.5, 1.0, 10.0 + 2.0 * rect.getHeight(), true);
        GroupSceneNode groupSceneNode2 = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
        String string = this.baseId + "LE_0";
        groupSceneNode2.setId(string);
        text.setID(string + "_EL");
        groupSceneNode2.addChild(text.createSceneNode());
        groupSceneNode.addChild(groupSceneNode2);
    }

    SceneNode getElement(int n) {
        int n2 = this.scene.getChildrenCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SceneNode sceneNode = this.scene.getChild(i);
            if (SceneNodeType.ELEMENT != sceneNode.getType()) continue;
            if (n3 == n) {
                return sceneNode;
            }
            ++n3;
        }
        return null;
    }

    private void addColorSwatchLegendEntry(int n, GroupSceneNode groupSceneNode, boolean bl) {
        Object object;
        SceneNode sceneNode = this.getElement(0);
        if (sceneNode == null) {
            return;
        }
        GroupSceneNode groupSceneNode2 = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
        String string = this.baseId + LE + n;
        groupSceneNode2.setId(string);
        String string2 = string + "SW";
        SceneToLegendConverter.addColorSwatches(sceneNode, string2, groupSceneNode2);
        if (bl) {
            object = this.getElement(1);
            SceneToLegendConverter.addColorSwatches((SceneNode)object, string2, groupSceneNode2);
        }
        if ((object = sceneNode.getTransform()) != null) {
            groupSceneNode2.setTransform((TransformInfoImpl)object);
        }
        if (this.addFieldInfo && this.field != null) {
            groupSceneNode2.setField(this.field);
        }
        groupSceneNode.addChild(groupSceneNode2);
    }

    private static void addColorSwatches(SceneNode sceneNode, String string, GroupSceneNode groupSceneNode) {
        if (sceneNode == null) {
            return;
        }
        List<SceneNode> list = ((SceneNodeImpl)sceneNode).getChildren();
        int n = groupSceneNode.getChildrenCount();
        for (SceneNode sceneNode2 : list) {
            String string2 = string + n;
            ((SceneNodeImpl)sceneNode2).setId(string2);
            ((SceneNodeImpl)sceneNode2).setRows(null);
            groupSceneNode.addChild(sceneNode2);
            ++n;
        }
    }

    protected void createAxisLegendEntries(int n, GroupSceneNode groupSceneNode) {
        Object object;
        Object object22;
        if (groupSceneNode == null) {
            return;
        }
        SceneNodeImpl sceneNodeImpl = this.getAxis();
        if (sceneNodeImpl == null) {
            return;
        }
        TransformInfo transformInfo = sceneNodeImpl.getTransform();
        GroupSceneNode groupSceneNode2 = this.getChild(SceneNodeType.AXIS_MARK, sceneNodeImpl);
        GroupSceneNode groupSceneNode3 = this.getChild(SceneNodeType.AXIS_LABEL, sceneNodeImpl);
        if (groupSceneNode2 == null && groupSceneNode3 == null) {
            return;
        }
        HashMap<Object, ArrayList<SceneNodeImpl>> hashMap = new HashMap<Object, ArrayList<SceneNodeImpl>>();
        if (groupSceneNode2 != null) {
            this.addToMap(hashMap, groupSceneNode2);
        }
        if (groupSceneNode3 != null) {
            this.addToMap(hashMap, groupSceneNode3);
        }
        HashMap<String, GroupSceneNode> hashMap2 = new HashMap<String, GroupSceneNode>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object22 : hashMap.keySet()) {
            object = this.makeAxisLegendEntry(hashMap.get(object22), n);
            if (object == null) continue;
            String string = ((SceneNodeImpl)object).getId();
            hashMap2.put(string, (GroupSceneNode)object);
            arrayList.add(string);
            if (transformInfo != null) {
                ((SceneNodeImpl)object).setTransform((TransformInfoImpl)transformInfo);
            }
            if (!this.addFieldInfo || this.field == null) continue;
            ((SceneNodeImpl)object).setField(this.field);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        object22 = new double[stringArray.length];
        object = this.baseId + LE;
        for (int i = 0; i < stringArray.length; ++i) {
            object22[i] = BasicFactory.parseDouble(stringArray[i].substring(((String)object).length()));
        }
        int[] nArray = BasicFactory.makeSortOrder((double[])object22);
        for (int i = 0; i < stringArray.length; ++i) {
            SceneNode sceneNode = (SceneNode)hashMap2.get(stringArray[nArray[i]]);
            groupSceneNode.addChild(sceneNode);
        }
    }

    protected SceneNodeImpl getAxis() {
        int n = this.scene.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = this.scene.getChild(i);
            if (SceneNodeType.AXIS != sceneNode.getType()) continue;
            return (SceneNodeImpl)sceneNode;
        }
        return null;
    }

    private void addAxisLine(GroupSceneNode groupSceneNode) {
        SceneNodeImpl sceneNodeImpl = this.getAxis();
        if (sceneNodeImpl == null) {
            return;
        }
        SceneNodeImpl sceneNodeImpl2 = this.getAxisLine(sceneNodeImpl);
        if (sceneNodeImpl2 == null) {
            return;
        }
        ArrayList<SceneNodeImpl> arrayList = new ArrayList<SceneNodeImpl>();
        arrayList.add(sceneNodeImpl2);
        String string = this.baseId + LE + "0";
        GroupSceneNode groupSceneNode2 = this.makeLegendEntry(arrayList, string);
        if (groupSceneNode2 == null) {
            return;
        }
        groupSceneNode.addChild(groupSceneNode2);
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneNodeImpl.getTransform();
        if (transformInfoImpl != null) {
            groupSceneNode2.setTransform(transformInfoImpl);
        }
    }

    private SceneNodeImpl getAxisLine(SceneNodeImpl sceneNodeImpl) {
        List<SceneNode> list = sceneNodeImpl.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (SceneNode sceneNode : list) {
            String string = sceneNode.getId();
            if (string.indexOf("L") <= 0) continue;
            return (SceneNodeImpl)sceneNode;
        }
        return null;
    }

    private static void addBacks(GroupSceneNode groupSceneNode, String string, GroupSceneNode groupSceneNode2) {
        int n = groupSceneNode.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)groupSceneNode.getChild(i);
            String string2 = sceneNodeImpl.getId();
            if (!SceneIdUtil.isBackId(string2)) continue;
            String string3 = string + "-back";
            if (SceneIdUtil.isOutId(string2)) {
                string3 = string3 + "outline";
            }
            sceneNodeImpl.setId(string3);
            groupSceneNode2.addChild(sceneNodeImpl);
        }
    }

    protected void addTitles(String string, GroupSceneNode groupSceneNode) {
        SceneNodeImpl sceneNodeImpl = this.getTitle();
        if (sceneNodeImpl != null) {
            sceneNodeImpl.setId(string + "T");
            List<SceneNode> list = sceneNodeImpl.getChildren();
            if (list.size() == 2) {
                ((SceneNodeImpl)list.get(0)).setId(string + "TLB");
                ((SceneNodeImpl)list.get(1)).setId(string + "T_0");
            } else if (list.size() == 1) {
                ((SceneNodeImpl)list.get(0)).setId(string + "T_0");
            }
            if (this.addFieldInfo && this.field != null) {
                sceneNodeImpl.setField(this.field);
                for (SceneNode sceneNode : list) {
                    ((SceneNodeImpl)sceneNode).setField(this.field);
                }
            }
            groupSceneNode.addChild(sceneNodeImpl);
        }
    }

    SceneNodeImpl getTitle() {
        int n = this.scene.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNode sceneNode = this.scene.getChild(i);
            if (SceneNodeType.TITLE != sceneNode.getType()) continue;
            return (SceneNodeImpl)sceneNode;
        }
        return null;
    }

    private static String getPartSuffix(String string) {
        int n = string.indexOf(95, 1);
        if (n > 0) {
            return string.substring(n);
        }
        return "";
    }

    private String createLegendEntryChildId(String string, String string2) {
        String string3 = SceneToLegendConverter.getPartSuffix(string);
        String string4 = string.indexOf("T") > 0 ? "T" : "SW";
        return string2 + string4 + string3;
    }

    private GroupSceneNode makeLegendEntry(ArrayList<SceneNodeImpl> arrayList, String string) {
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
        groupSceneNode.setId(string);
        for (SceneNodeImpl sceneNodeImpl : arrayList) {
            String string2 = sceneNodeImpl.getId();
            String string3 = this.createLegendEntryChildId(string2, string);
            sceneNodeImpl.setId(string3);
            if (this.addFieldInfo && this.field != null) {
                sceneNodeImpl.setField(this.field);
            }
            groupSceneNode.addChild(sceneNodeImpl);
        }
        return groupSceneNode;
    }

    private GroupSceneNode getChild(SceneNodeType sceneNodeType, SceneNodeImpl sceneNodeImpl) {
        List<SceneNode> list = sceneNodeImpl.getChildren();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (SceneNode sceneNode : list) {
            SceneNodeType sceneNodeType2 = sceneNode.getType();
            if (sceneNodeType != sceneNodeType2) continue;
            return (GroupSceneNode)sceneNode;
        }
        return null;
    }

    private GroupSceneNode makeAxisLegendEntry(ArrayList<SceneNodeImpl> arrayList, int n) {
        SceneNodeImpl sceneNodeImpl = arrayList.get(0);
        String string = sceneNodeImpl.getId();
        String string2 = this.makeLegendEntryId(string, n);
        return this.makeLegendEntry(arrayList, string2);
    }

    private String getAxisMemberIndex(String string) {
        int n;
        int n2 = string.indexOf("M") + 1;
        if (n2 == 0) {
            n2 = string.indexOf("T") + 1;
        }
        if ((n = string.indexOf(95, n2)) > 0) {
            return string.substring(n2, n);
        }
        return string.substring(n2);
    }

    private String makeLegendEntryId(String string, int n) {
        String string2 = this.getAxisMemberIndex(string);
        String string3 = null;
        if (n == 0) {
            string3 = this.baseId + LE + string2;
        } else {
            Number number = IntegerUtil.parseInt(string2, 10);
            int n2 = number.intValue() + n;
            string3 = this.baseId + LE + n2;
        }
        return string3;
    }

    private void addToMap(HashMap<Object, ArrayList<SceneNodeImpl>> hashMap, GroupSceneNode groupSceneNode) {
        if (groupSceneNode == null || groupSceneNode.getChildrenCount() == 0) {
            return;
        }
        int n = groupSceneNode.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)groupSceneNode.getChild(i);
            Object object = sceneNodeImpl.getValue();
            ArrayList<SceneNodeImpl> arrayList = hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(object, arrayList);
            }
            arrayList.add(sceneNodeImpl);
        }
    }

    private void addElementLegendEntries(GroupSceneNode groupSceneNode) {
        Object object;
        int n;
        String string;
        Object object2;
        SceneNode sceneNode = this.getElement(0);
        if (null == sceneNode) {
            return;
        }
        List<SceneNode> list = sceneNode.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        int n2 = 0;
        TransformInfoImpl transformInfoImpl = (TransformInfoImpl)sceneNode.getTransform();
        LinkedHashMap<String, ArrayList<SceneNode>> linkedHashMap = new LinkedHashMap<String, ArrayList<SceneNode>>();
        for (SceneNode object3 : list) {
            object2 = object3.getId();
            int n3 = ((String)object2).indexOf("S");
            if (n3 > -1) {
                string = ((String)object2).substring(n3 + 1);
                this.addToPairMap(linkedHashMap, object3, string);
                continue;
            }
            int n4 = ((String)object2).indexOf("L");
            if (n4 <= -1) continue;
            n = ((String)object2).indexOf("P");
            object = ((String)object2).substring(n4 + 1, n);
            this.addToPairMap(linkedHashMap, object3, (String)object);
        }
        for (String string2 : linkedHashMap.keySet()) {
            object2 = (ArrayList)linkedHashMap.get(string2);
            GroupSceneNode groupSceneNode2 = SceneNodeFactory.createGroupNode(SceneNodeType.LEGEND_ENTRY);
            string = this.baseId + LE + n2;
            groupSceneNode2.setId(string);
            n = 0;
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                SceneNode sceneNode2 = (SceneNode)object.next();
                n = this.convertElementToLegendEntryChild(sceneNode2, string, n);
                groupSceneNode2.addChild(sceneNode2);
            }
            if (transformInfoImpl != null) {
                groupSceneNode2.setTransform(transformInfoImpl);
            }
            groupSceneNode.addChild(groupSceneNode2);
            ++n2;
        }
    }

    private void addToPairMap(Map<String, ArrayList<SceneNode>> map, SceneNode sceneNode, String string) {
        ArrayList<SceneNode> arrayList = map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(string, arrayList);
        }
        arrayList.add(sceneNode);
    }

    private int convertElementToLegendEntryChild(SceneNode sceneNode, String string, int n) {
        String string2;
        String string3 = sceneNode.getId();
        int n2 = string3.indexOf("S");
        if (n2 > -1) {
            string2 = string + "SW" + n;
            ++n;
        } else {
            string2 = string + "T";
        }
        this.convertItemToLegendEntryPart((SceneNodeImpl)sceneNode, string2);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private void convertItemToLegendEntryPart(SceneNodeImpl sceneNodeImpl, String string) {
        void var5_8;
        sceneNodeImpl.setId(string);
        sceneNodeImpl.setRows(null);
        List<SceneNode> list = sceneNodeImpl.getChildren();
        for (SceneNode object2 : list) {
            String string2;
            SceneNodeImpl sceneNodeImpl2 = (SceneNodeImpl)object2;
            Map<String, String> map = sceneNodeImpl2.getMetaMap();
            if (map == null || !(string2 = map.get("part")).contains("legendentry_entry") && !string2.contains("legendentry_swatchbox") && !string2.contains("legendentry_label")) continue;
            sceneNodeImpl2.setId(object2.getId() + "Y");
        }
        String string3 = sceneNodeImpl.getMeta(VALUE);
        Object var5_6 = null;
        if (string3 != null) {
            Double d = Double.parseDouble(string3);
        }
        this.setFieldAndValueAndClearMeta(sceneNodeImpl, (Double)var5_8);
    }

    private void setFieldAndValueAndClearMeta(SceneNodeImpl sceneNodeImpl, Double d) {
        if (this.addFieldInfo && this.field != null) {
            sceneNodeImpl.setField(this.field);
            sceneNodeImpl.setValue(d);
        }
        sceneNodeImpl.clearMetaMap();
        List<SceneNode> list = sceneNodeImpl.getChildren();
        if (list != null) {
            for (SceneNode sceneNode : list) {
                this.setFieldAndValueAndClearMeta((SceneNodeImpl)sceneNode, d);
            }
        }
    }

    private String extractValueAndRemoveMetaData(SceneNodeImpl sceneNodeImpl) {
        Map<String, String> map = sceneNodeImpl.getMetaMap();
        if (map == null) {
            return null;
        }
        String string = map.get(VALUE);
        map.clear();
        return string;
    }
}

