/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.legend.nonsimple.AbstractAxisLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.SceneToLegendConverter;
import com.ibm.vis.engine.internal.legend.nonsimple.SizeAxisScaleMaker;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.List;

class SizeAxisLegend
extends AbstractAxisLegend {
    public static final String METHOD = "axis";
    protected final SizeAxisScaleMaker maker;
    private final Field field;
    private final boolean modifiesWidth;
    private final boolean modifiesHeight;
    private final double calculatedAxisWidth;
    private SizeInfo cachedSizeInfo;

    SizeAxisLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list) {
        super(vis, legendSpec, n, list);
        this.field = this.firstAesthetic.valueProvider.getBaseField();
        String string = this.firstAesthetic.getModifiesType();
        if (string == null) {
            this.modifiesWidth = true;
            this.modifiesHeight = true;
        } else if ("width".equals(string)) {
            this.modifiesWidth = true;
            this.modifiesHeight = false;
        } else if ("height".equals(string)) {
            this.modifiesWidth = false;
            this.modifiesHeight = true;
        } else {
            this.modifiesWidth = true;
            this.modifiesHeight = true;
        }
        if (legendSpec.orientation == null && this.modifiesWidth != this.modifiesHeight) {
            this.verticalLegend = this.modifiesHeight;
        }
        double d = this.getLabelFont().getSize();
        this.maker = new SizeAxisScaleMaker(this.firstAesthetic, d, this.modifiesWidth, this.modifiesHeight);
        this.maker.makeScaleSpecForNumerical();
        double d2 = 1.0;
        double d3 = this.getEffectiveMarkSize(5);
        double d4 = 0.0;
        StyleSpec styleSpec = this.getTickStyle();
        if (styleSpec != null) {
            Insets insets = Insets.makeForStyle(styleSpec, new Dim(100.0, 100.0));
            d4 = this.verticalLegend ? insets.getHorizontal() : insets.getVertical();
        }
        this.calculatedAxisWidth = d3 + d2 + this.getMaxAxisLabelWidth() + d4;
        this.cachedSizeInfo = null;
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        if (this.cachedSizeInfo != null) {
            return this.cachedSizeInfo;
        }
        try {
            VisState visState = this.setLegendVisSpec();
            visState = this.parentVis.getLegendVis().makeSceneTree(null, visState);
            Dim dim = visState.getSceneTree().getSize();
            Size size = Size.makeFixed(dim.getWidth(), dim.getHeight());
            this.cachedSizeInfo = new SizeInfo(size, Size.ZERO, size);
        }
        catch (Exception exception) {
            this.cachedSizeInfo = new SizeInfo(Size.ZERO, Size.ZERO, Size.ZERO);
        }
        return this.cachedSizeInfo;
    }

    @Override
    protected List<SceneNode> makeScene() {
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = this.setLegendVisSpec();
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        try {
            visState = vis.makeSceneTree(null, visState);
            SceneTree sceneTree = visState.getSceneTree();
            String string = this.field == null ? null : this.field.id;
            SceneToLegendConverter sceneToLegendConverter = new SceneToLegendConverter((GroupSceneNode)sceneTree.getRoot(), this.legendIndex, string, METHOD);
            sceneToLegendConverter.setEllipsisValues(this.getBounds(), this.getLabelFont());
            GroupSceneNode groupSceneNode = sceneToLegendConverter.getLegend();
            arrayList.add(groupSceneNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    protected double getAxisWidth() {
        return this.calculatedAxisWidth;
    }

    private VisState setLegendVisSpec() {
        Vis vis = this.parentVis.getLegendVis();
        VisJSONSpec visJSONSpec = this.makeVisSpec();
        return vis.setTypedSpecification(visJSONSpec);
    }

    private VisJSONSpec makeVisSpec() {
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        visJSONSpec.grammar = new GrammarSpec[1];
        visJSONSpec.grammar[0] = new GrammarSpec();
        visJSONSpec.grammar[0].coordinates = this.makeCoordSpecForSizeAxis();
        visJSONSpec.grammar[0].bounds = this.makeGrammarBounds();
        visJSONSpec.grammar[0].axisPadding = false;
        visJSONSpec.grammar[0].style = new StyleSpec();
        visJSONSpec.titles = this.makeTitles();
        boolean bl = this.legendSpec.title == null || this.legendSpec.title.length > 0;
        visJSONSpec.style = this.makeVisStyle(true, 5, !bl, 5.0, !bl, true);
        this.addVersion(visJSONSpec);
        return visJSONSpec;
    }

    private BoundsSpec makeGrammarBounds() {
        BoundsSpec boundsSpec = new BoundsSpec();
        if (this.verticalLegend) {
            boundsSpec.height = Math.ceil(this.maker.getAxisLength());
        } else {
            boundsSpec.width = Math.ceil(this.maker.getAxisLength());
        }
        return boundsSpec;
    }

    private CoordinatesSpec makeCoordSpecForSizeAxis() {
        CoordinatesSpec coordinatesSpec = new CoordinatesSpec();
        DimensionSpec[] dimensionSpecArray = new DimensionSpec[]{new DimensionSpec()};
        coordinatesSpec.dimensions = dimensionSpecArray;
        dimensionSpecArray[0].axis = new AxisSpec[1];
        dimensionSpecArray[0].axis[0] = this.makeAxisSpecForSizeLegend();
        dimensionSpecArray[0].axis[0].method = "horizontal";
        dimensionSpecArray[0].scale = this.maker.makeScaleSpecForNumerical();
        if (this.isScaleReverse() && dimensionSpecArray[0].scale != null) {
            dimensionSpecArray[0].scale.reverse = true;
        }
        if (!this.verticalLegend) {
            coordinatesSpec.transforms = new TransformSpec[1];
            coordinatesSpec.transforms[0] = new TransformSpec();
            coordinatesSpec.transforms[0].type = "transpose";
        }
        return coordinatesSpec;
    }

    private StyleSpec getTickStyle() {
        StyleSpec styleSpec = this.getLabelStyle();
        if (styleSpec == null || Axis.isEmpty(styleSpec)) {
            return null;
        }
        return (StyleSpec)styleSpec.copy();
    }

    private AxisSpec makeAxisSpecForSizeLegend() {
        AxisSpec axisSpec = new AxisSpec();
        axisSpec.opposite = this.isAxisOpposite();
        axisSpec.tickStyle = this.getTickStyle();
        if (this.legendSpec.markStyle != null) {
            axisSpec.markStyle = (StyleSpec)this.legendSpec.markStyle.copy();
        }
        if (this.legendSpec.lineStyle != null) {
            axisSpec.lineStyle = (StyleSpec)this.legendSpec.lineStyle.copy();
        }
        axisSpec.preferredSize = new PreferredSizeSpec();
        axisSpec.preferredSize.preferred = "100%";
        axisSpec.outsideTickLabels = true;
        return axisSpec;
    }

    final boolean getModifiesWidth() {
        return this.modifiesWidth;
    }

    final boolean getModifiesHeight() {
        return this.modifiesHeight;
    }

    @Override
    protected double getPad() {
        return 5.0;
    }

    @Override
    public String getFieldKey() {
        return "nullField";
    }
}

