/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanOutRangeSpec;
import com.ibm.vis.spec.internal.SpanSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SizeAxisScaleMaker {
    private final Aesthetic aesthetic;
    private final Scale scale;
    private final Unit unit;
    private final Range dataRange;
    private final Range scaleRange;
    private final Range mappingRange;
    private final double minimumTickDistance;
    private final boolean modifiesWidth;
    private final boolean modifiesHeight;
    private Dim elementSize;
    private double axisLength;
    private Range axisRange;

    SizeAxisScaleMaker(Aesthetic aesthetic, double d, boolean bl, boolean bl2) {
        assert (aesthetic != null);
        this.aesthetic = aesthetic;
        this.minimumTickDistance = 1.25 * d;
        this.modifiesWidth = bl;
        this.modifiesHeight = bl2;
        this.scale = aesthetic.scale;
        Field field = aesthetic.valueProvider.getBaseField();
        this.unit = aesthetic.valueProvider.getUnit();
        this.scaleRange = this.scale.spans.get(0).getAdjustedInputRange();
        this.mappingRange = this.getMappingRange(aesthetic.spec.mapping);
        this.dataRange = field == null ? this.scaleRange : field.getDataRange();
        this.elementSize = null;
        this.axisLength = 0.0;
        this.axisRange = null;
    }

    double getAxisLength() {
        return this.axisLength;
    }

    Range getAxisRange() {
        return this.axisRange;
    }

    ScaleSpec makeScaleSpecForNumerical() {
        double d;
        double d2;
        double d3;
        double d4;
        this.axisLength = 0.0;
        this.axisRange = null;
        Range range = this.scale.spans.get(0).getInputRange();
        if ((this.dataRange == null || this.dataRange.isEmpty()) && (this.aesthetic.spec.scale == null || this.aesthetic.spec.scale.spans == null || this.aesthetic.spec.scale.spans.length <= 0 || this.aesthetic.spec.scale.spans[0].min == null && this.aesthetic.spec.scale.spans[0].max == null)) {
            return null;
        }
        this.elementSize = this.aesthetic.element.calculateDefaultShapeSize(this.aesthetic.element.spec.style);
        if (this.mappingRange == null) {
            d4 = range.getMin();
            d3 = range.getMax();
            d2 = d4;
            d = d3;
        } else if (range.getMin() > this.mappingRange.getMax()) {
            d4 = range.getMin();
            d3 = range.getMin();
            d2 = d4;
            d = d3;
        } else if (range.getMax() < this.mappingRange.getMin()) {
            d4 = range.getMax();
            d3 = range.getMax();
            d2 = d4;
            d = d3;
        } else if (this.mappingRange.getRange() == 0.0) {
            d4 = range.getMin();
            d3 = range.getMax();
            d2 = this.mappingRange.getMin();
            d = this.mappingRange.getMax();
        } else {
            d4 = Math.max(range.getMin(), this.mappingRange.getMin());
            d3 = Math.min(range.getMax(), this.mappingRange.getMax());
            d2 = d4;
            d = d3;
        }
        double d5 = this.getElementSizeForValue(d4);
        double d6 = this.getElementSizeForValue(d3);
        this.axisLength = Math.max(d5, d6);
        if (this.axisLength == 0.0) {
            this.axisLength = 1.0;
            d6 = 1.0;
        }
        this.axisRange = new Range(d4, d3);
        double d7 = Math.max(d5, d6);
        if (Math.abs(d6 - d5) < this.minimumTickDistance || d7 <= 30.0 || this.mappingRange != null && this.mappingRange.getRange() == 0.0) {
            return this.makeDiscreteScaleSpecForContinuous(d2, d5, d, d6);
        }
        return this.makeContinuousScaleSpec(d2, d5, d, d6);
    }

    private ScaleSpec makeContinuousScaleSpec(double d, double d2, double d3, double d4) {
        MappedJSONObject mappedJSONObject;
        boolean bl;
        double d5 = Math.min(d2, d4);
        SpanSpec spanSpec = new SpanSpec();
        spanSpec.fit = "exact";
        spanSpec.outRange = new SpanOutRangeSpec();
        if (this.unit != null) {
            spanSpec.unit = this.unit.toString();
        }
        boolean bl2 = bl = d4 < d2;
        if (bl) {
            spanSpec.min = d3;
            spanSpec.max = d;
            spanSpec.outRange.min = 0.0;
            spanSpec.outRange.max = Math.max(1.0E-5, 1.0 - d5 / this.axisLength);
        } else {
            spanSpec.min = d;
            spanSpec.max = d3;
            spanSpec.outRange.min = Math.min(0.99999, d5 / this.axisLength);
            spanSpec.outRange.max = 1.0;
        }
        if (this.aesthetic.spec != null && this.aesthetic.spec.scale != null && this.aesthetic.spec.scale.spans != null && this.aesthetic.spec.scale.spans.length > 0 && (mappedJSONObject = this.aesthetic.spec.scale.spans[0]) != null) {
            spanSpec.tickDelta = ((SpanSpec)mappedJSONObject).tickDelta;
            if ("log".equals(((SpanSpec)mappedJSONObject).method)) {
                spanSpec.method = "log";
            }
        }
        mappedJSONObject = new ScaleSpec();
        mappedJSONObject.spans = new SpanSpec[]{spanSpec};
        mappedJSONObject.reverse = bl;
        return mappedJSONObject;
    }

    private ScaleSpec makeDiscreteScaleSpecForContinuous(double d, double d2, double d3, double d4) {
        boolean bl;
        ScaleSpec scaleSpec = new ScaleSpec();
        boolean bl2 = bl = Math.abs(d4 - d2) >= this.minimumTickDistance;
        if (bl) {
            scaleSpec.spans = new SpanSpec[]{this.makeSolitaryTickSpan(d4, d3), this.makeSolitaryTickSpan(d2, d)};
            return scaleSpec;
        }
        if (d4 >= d2) {
            scaleSpec.spans = new SpanSpec[]{this.makeSolitaryTickSpan(d4, d3)};
            return scaleSpec;
        }
        scaleSpec.spans = new SpanSpec[]{this.makeSolitaryTickSpan(d2, d)};
        return scaleSpec;
    }

    private SpanSpec makeSolitaryTickSpan(double d, double d2) {
        SpanSpec spanSpec = new SpanSpec();
        spanSpec.tickDelta = 1.0;
        spanSpec.outRange = new SpanOutRangeSpec();
        double d3 = Math.min(0.99999, d / this.axisLength);
        spanSpec.outRange.min = d3;
        spanSpec.outRange.max = d3 + 1.0E-5;
        spanSpec.min = d2;
        spanSpec.max = d2;
        if (this.unit != null) {
            spanSpec.unit = this.unit.toString();
        }
        return spanSpec;
    }

    double getElementSizeForValue(double d) {
        Shape shape;
        Double d2 = this.scale.toZeroOneClamped(d, this.unit);
        double d3 = d2 == null ? 1.0 : d2;
        if (this.modifiesWidth != this.modifiesHeight) {
            shape = ShapeFactory2.CreateRect(0.0, 0.0, this.elementSize.getWidth(), this.elementSize.getHeight());
        } else {
            double d4 = Math.min(this.elementSize.getWidth(), this.elementSize.getHeight());
            shape = ShapeFactory2.CreateRect(0.0, 0.0, d4, d4);
        }
        this.aesthetic.element.styleShape(shape);
        Rect rect = this.aesthetic.applyValue(shape, d3, d, false).getBounds();
        double d5 = this.modifiesWidth ? rect.getWidth() : rect.getHeight();
        return d5;
    }

    private Range getMappingRange(MappingSpec[] mappingSpecArray) {
        if (mappingSpecArray == null || mappingSpecArray.length == 0) {
            return null;
        }
        Range range = Range.EMPTY;
        for (int i = 0; i < mappingSpecArray.length; ++i) {
            double d = this.getMappingAt(mappingSpecArray[i]);
            if (Double.isNaN(d)) continue;
            range = range.unionValue(d);
        }
        if (range.isEmpty()) {
            return null;
        }
        return range;
    }

    private double getMappingAt(MappingSpec mappingSpec) {
        Object object = mappingSpec.at;
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue();
        }
        if (BasicFactory.isString(object)) {
            String string = (String)object;
            if (string.endsWith("%")) {
                if (this.scaleRange == null || this.scaleRange.isEmpty()) {
                    return Double.NaN;
                }
                double d = Double.parseDouble(string.substring(0, string.length() - 1)) / 100.0;
                return this.scaleRange.fromZeroOne(d);
            }
            return Double.parseDouble(string);
        }
        return this.scaleRange.getMin();
    }
}

