/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Lengths;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.legend.nonsimple.AbstractAxisLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.SceneToLegendConverter;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchSizer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.nativeImpl.collections.DoublePrimitiveArrayList;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.FillSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
final class StaggerLegend
extends AbstractAxisLegend {
    public static final String METHOD = "stagger";
    private static final int MAX_DESIRED_TICKS = 15;
    private Dim grammarSizeWithoutTitle;
    private SizeInfo cachedSizeInfo;

    StaggerLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list) {
        super(vis, legendSpec, n, list);
        this.validateContinuousColorAesthetics(METHOD, false);
        this.cachedSizeInfo = null;
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        if (this.cachedSizeInfo != null) {
            return this.cachedSizeInfo;
        }
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = this.setLegendVisSpec();
        visState = vis.makeSceneTree(null, visState);
        Dim dim = visState.getSceneTree().getSize();
        Size size = Size.makeFixed(dim.getWidth(), dim.getHeight());
        Dim dim2 = this.getAvailableSize();
        if (dim2 != null && (dim.getWidth() > dim2.getWidth() || dim.getHeight() > dim2.getHeight())) {
            this.cachedSizeInfo = new SizeInfo(Size.ZERO, Size.ZERO, Size.ZERO);
            return this.cachedSizeInfo;
        }
        Size size2 = this.verticalLegend ? new Size(size.getWidth(), Lengths.UNLIMITED) : new Size(Lengths.UNLIMITED, size.getHeight());
        this.cachedSizeInfo = new SizeInfo(size, Size.ZERO, size2);
        return this.cachedSizeInfo;
    }

    @Override
    protected List<SceneNode> makeScene() {
        Vis vis = this.parentVis.getLegendVis();
        VisState visState = this.setLegendVisSpec();
        Dim dim = this.getExtent();
        visState = this.updateForExtent(dim, visState);
        visState = vis.makeSceneTree(dim, visState);
        SceneTree sceneTree = visState.getSceneTree();
        String string = this.firstAesthetic.valueProvider.getBaseField() == null ? null : this.firstAesthetic.valueProvider.getBaseField().id;
        SceneToLegendConverter sceneToLegendConverter = new SceneToLegendConverter((GroupSceneNode)sceneTree.getRoot(), this.legendIndex, string, METHOD);
        GroupSceneNode groupSceneNode = sceneToLegendConverter.getLegend();
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        arrayList.add(groupSceneNode);
        return arrayList;
    }

    private VisState updateForExtent(Dim dim, VisState visState) {
        double d = this.getSwatchSize(20.0);
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.verticalLegend) {
            double d4 = this.getTitleSize(dim.getWidth(), null).getHeight();
            d2 = Math.floor(dim.getHeight() - d4 - 2.0);
        } else {
            d3 = this.getMaxAxisLabelWidth();
            d2 = Math.floor(dim.getWidth() - d3 - 5.0);
        }
        return this.updateVisGivenLength(visState, dim, d2, d, d3);
    }

    private VisState updateVisGivenLength(VisState visState, Dim dim, double d, double d2, double d3) {
        Vis vis = this.parentVis.getLegendVis();
        if (d < d2 * 2.0) {
            return visState;
        }
        Scale scale = this.makeScaleForTicks(dim, d, d2);
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.getValidTicksNumerical(scale);
        this.grammarSizeWithoutTitle = null;
        int n = this.verticalLegend ? 1 : (int)Math.ceil((d3 + 2.0) / d2);
        VisJSONSpec visJSONSpec = this.makeVisSpec(d2, doublePrimitiveArrayList, false, n);
        this.addColorPaletteAndUpdateElement(doublePrimitiveArrayList, visJSONSpec);
        if (this.verticalLegend) {
            double d4 = Math.ceil(this.getLabelFont().getSize() / 2.0);
            visJSONSpec.grammar[0].bounds.top = d4;
        }
        return vis.setTypedSpecification(visJSONSpec);
    }

    private Scale makeScaleForTicks(Dim dim, double d, double d2) {
        Scale scale = this.firstAesthetic.scale;
        ScaleSpec scaleSpec = new ScaleSpec();
        scaleSpec.reverse = scale.reverse;
        scaleSpec.local = scale.localScale;
        ContinuousScaleSpan continuousScaleSpan = (ContinuousScaleSpan)scale.getSpans().get(0);
        int n = (int)Math.floor(d / d2);
        n = Math.min(n, 15);
        int n2 = 1000000;
        double d3 = 1.0;
        Scale scale2 = null;
        int n3 = n;
        while (n2 > n && n3 > 0) {
            scale2 = this.makeScale(dim, scaleSpec, continuousScaleSpan);
            n3 = (int)Math.floor((double)n * d3);
            scale2.initializeForRequiredTickCount(n3);
            n2 = this.getNumberOfTicksInScale(scale2);
            d3 -= 0.1;
        }
        return scale2;
    }

    private Scale makeScale(Dim dim, ScaleSpec scaleSpec, ContinuousScaleSpan continuousScaleSpan) {
        Scale scale = new Scale(scaleSpec, dim);
        scale.addSpan(continuousScaleSpan.makeCopyWithoutTickInfo());
        return scale;
    }

    protected VisState setLegendVisSpec() {
        if (this.firstAesthetic == null) {
            return null;
        }
        Vis vis = this.parentVis.getLegendVis();
        DoublePrimitiveArrayList doublePrimitiveArrayList = this.getValidTickValues();
        VisJSONSpec visJSONSpec = this.makeVisSpec(this.getSwatchSize(20.0), doublePrimitiveArrayList, true, 1);
        this.addColorPaletteAndUpdateElement(doublePrimitiveArrayList, visJSONSpec);
        return vis.setTypedSpecification(visJSONSpec);
    }

    protected void addColorPaletteAndUpdateElement(DoublePrimitiveArrayList doublePrimitiveArrayList, VisJSONSpec visJSONSpec) {
        StyleSpec styleSpec = this.firstAesthetic.element.spec.style;
        if (styleSpec == null) {
            styleSpec = new StyleSpec();
        }
        AestheticSpec aestheticSpec = visJSONSpec.grammar[0].elements[0].color[0];
        aestheticSpec.palette = this.makePalette(doublePrimitiveArrayList, styleSpec, this.aesthetics);
        this.copyElementStyle(visJSONSpec, styleSpec);
    }

    private void copyElementStyle(VisJSONSpec visJSONSpec, StyleSpec styleSpec) {
        ElementsSpec elementsSpec = visJSONSpec.grammar[0].elements[0];
        StyleSpec styleSpec2 = new StyleSpec();
        styleSpec2.size = elementsSpec.style.size;
        styleSpec2.fill = styleSpec.fill;
        styleSpec2.stroke = styleSpec.stroke;
        styleSpec2.outline = "transparent";
        elementsSpec.style = (StyleSpec)styleSpec2.copy();
    }

    private ColorSpec[] makePalette(DoublePrimitiveArrayList doublePrimitiveArrayList, StyleSpec styleSpec, List<Aesthetic> list) {
        Object object;
        double[] dArray = this.makeLinearTicks(doublePrimitiveArrayList);
        if (styleSpec == null) {
            styleSpec = new StyleSpec();
        } else {
            object = styleSpec.fill;
            if (object instanceof FillSpec) {
                styleSpec = (StyleSpec)styleSpec.copy();
                styleSpec.fill = null;
            }
        }
        object = list.get(0);
        String string = ((Aesthetic)object).getModifiesType();
        boolean bl = "outline".equals(string);
        Field field = ((Aesthetic)object).valueProvider.getBaseField();
        ColorSpec[] colorSpecArray = new ColorSpec[dArray.length];
        int n = field == null ? 0 : field.getIndex();
        for (int i = 0; i < colorSpecArray.length; ++i) {
            Row row = SwatchSizer.makeRow(n, dArray[i]);
            Shape shape = ShapeFactory2.CreateRect(0.0, 0.0, 20.0, 20.0);
            StyleBuilder.setFilled(shape, styleSpec);
            for (Aesthetic aesthetic : list) {
                aesthetic.apply(shape, row);
            }
            ColorNew colorNew = bl ? shape.getOutline() : shape.getFill().getSolid();
            colorSpecArray[i] = StaggerLegend.convertToColorSpec(colorNew);
        }
        return colorSpecArray;
    }

    private double[] makeLinearTicks(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        int n = doublePrimitiveArrayList.size();
        double[] dArray = new double[n - 1];
        double d = doublePrimitiveArrayList.get(0);
        for (int i = 1; i < n; ++i) {
            double d2 = doublePrimitiveArrayList.get(i);
            dArray[i - 1] = (d + d2) / 2.0;
            d = d2;
        }
        return dArray;
    }

    VisJSONSpec makeVisSpec(double d, DoublePrimitiveArrayList doublePrimitiveArrayList, boolean bl, int n) {
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        visJSONSpec.data = this.makeDataSpecs(doublePrimitiveArrayList);
        GrammarSpec grammarSpec = new GrammarSpec();
        grammarSpec.axisPadding = false;
        grammarSpec.coordinates = this.makeCoordSpec(doublePrimitiveArrayList, false, true, false, bl, n);
        grammarSpec.bounds = this.makeGrammarBounds(d, doublePrimitiveArrayList);
        grammarSpec.elements = this.makeElementSpecs(d);
        grammarSpec.style = this.makeGrammarStyle();
        visJSONSpec.grammar = new GrammarSpec[]{grammarSpec};
        visJSONSpec.titles = this.makeTitles();
        boolean bl2 = visJSONSpec.titles == null;
        visJSONSpec.style = this.makeVisStyle(true, 5, bl2, 5.0, bl2, false);
        this.addVersion(visJSONSpec);
        return visJSONSpec;
    }

    @Override
    protected double getAxisWidth() {
        return this.getDefaultAxisWidth(0);
    }

    private ElementsSpec[] makeElementSpecs(double d) {
        ElementsSpec[] elementsSpecArray = new ElementsSpec[]{this.makeBaseElementSpec(d, "minYForLegend", "yForLegend", true), this.makeBaseElementSpec(d, "0%", "100%", false)};
        StrokeSpec strokeSpec = new StrokeSpec();
        strokeSpec.width = 0;
        elementsSpecArray[0].style.stroke = strokeSpec;
        elementsSpecArray[1].style.fill = "transparent";
        this.modifyOutlineElementStyle(elementsSpecArray[1].style);
        AestheticSpec aestheticSpec = new AestheticSpec();
        aestheticSpec.field = new FieldValueRefSpec();
        aestheticSpec.field.$ref = "color";
        elementsSpecArray[0].color = new AestheticSpec[]{aestheticSpec};
        return elementsSpecArray;
    }

    private void modifyOutlineElementStyle(StyleSpec styleSpec) {
        StyleSpec styleSpec2 = this.legendSpec.itemStyle;
        if (styleSpec2 == null) {
            styleSpec.outline = "black";
            return;
        }
        styleSpec.outline = styleSpec2.outline;
        styleSpec.outlineMethod = styleSpec2.outlineMethod;
        styleSpec.stroke = styleSpec2.stroke;
    }

    private ElementsSpec makeBaseElementSpec(double d, String string, String string2, boolean bl) {
        ElementsSpec elementsSpec = new ElementsSpec();
        elementsSpec.type = "interval";
        elementsSpec.position = bl ? this.makePositionSpecsWithFields(string, string2) : this.makePositionSpecsWithValues(string, string2);
        elementsSpec.style = new StyleSpec();
        elementsSpec.style.size = d;
        return elementsSpec;
    }

    private PositionSpec[] makePositionSpecsWithValues(String string, String string2) {
        PositionSpec positionSpec = new PositionSpec();
        positionSpec.value = string;
        PositionSpec positionSpec2 = new PositionSpec();
        positionSpec2.value = string2;
        return new PositionSpec[]{positionSpec, positionSpec2};
    }

    protected BoundsSpec makeGrammarBounds(double d, DoublePrimitiveArrayList doublePrimitiveArrayList) {
        BoundsSpec boundsSpec = new BoundsSpec();
        Dim dim = this.getGrammarSizeWithoutTitle(doublePrimitiveArrayList.size());
        boundsSpec.width = dim.getWidth();
        boundsSpec.height = dim.getHeight();
        return boundsSpec;
    }

    private Dim getGrammarSizeWithoutTitle(int n) {
        if (this.grammarSizeWithoutTitle == null) {
            this.grammarSizeWithoutTitle = this.computeGrammarSizeWithoutTitle(n);
        }
        return this.grammarSizeWithoutTitle;
    }

    private Dim computeGrammarSizeWithoutTitle(int n) {
        double d;
        double d2;
        double d3 = this.getSwatchSize(20.0);
        double d4 = this.getAxisWidth();
        double d5 = (double)(n - 1) * d3;
        if (this.verticalLegend) {
            d2 = d3 + d4 + 1.0;
            d = d5;
        } else {
            d2 = d5;
            d = d4 + d3 + 1.0;
        }
        return new Dim(Math.ceil(d2), Math.ceil(d));
    }

    DataSpec[] makeDataSpecs(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        DataSpec[] dataSpecArray = new DataSpec[]{new DataSpec()};
        StaggerLegend.addDataRows(doublePrimitiveArrayList, dataSpecArray[0]);
        this.addFields(doublePrimitiveArrayList.size(), dataSpecArray[0]);
        return dataSpecArray;
    }

    private void addFields(int n, DataSpec dataSpec) {
        FieldSpec[] fieldSpecArray = new FieldSpec[3];
        fieldSpecArray[0] = new FieldSpec();
        fieldSpecArray[0].id = "color";
        String string = this.getUnitForAestheticField();
        fieldSpecArray[0].categories = StaggerLegend.makeDummyCategories(n);
        fieldSpecArray[1] = new FieldSpec();
        fieldSpecArray[1].id = "minYForLegend";
        fieldSpecArray[1].unit = string;
        fieldSpecArray[2] = new FieldSpec();
        fieldSpecArray[2].id = "yForLegend";
        fieldSpecArray[2].unit = string;
        dataSpec.fields = fieldSpecArray;
    }

    private static String[] makeDummyCategories(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "A";
        }
        return stringArray;
    }

    private static void addDataRows(DoublePrimitiveArrayList doublePrimitiveArrayList, DataSpec dataSpec) {
        double d;
        int n = doublePrimitiveArrayList.size();
        double[][] dArrayArray = new double[n - 1][];
        double d2 = d = doublePrimitiveArrayList.get(0);
        double d3 = d;
        for (int i = 1; i < n; ++i) {
            d3 = doublePrimitiveArrayList.get(i);
            dArrayArray[i - 1] = new double[]{i - 1, d2, d3};
            d2 = d3;
        }
        dataSpec.rows = dArrayArray;
    }

    private static ColorSpec convertToColorSpec(ColorNew colorNew) {
        ColorSpec colorSpec = new ColorSpec();
        double[] dArray = colorNew.getRGBA();
        colorSpec.r = dArray[0];
        colorSpec.g = dArray[1];
        colorSpec.b = dArray[2];
        colorSpec.a = dArray[3];
        return colorSpec;
    }

    @Override
    protected double getPad() {
        return 2.0;
    }

    @Override
    public String getFieldKey() {
        return "minYForLegend";
    }
}

