/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.legend.nonsimple.LegendDataCreator;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchSizer;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SwatchAestheticCreator {
    private final SwatchType swatchType;
    private final Element element;
    private final LegendDataCreator dataCreator;
    private final List<Aesthetic> aesthetics;
    private final SwatchSizer sizer;

    SwatchAestheticCreator(SwatchType swatchType, Element element, LegendDataCreator legendDataCreator, List<Aesthetic> list, SwatchSizer swatchSizer) {
        this.swatchType = swatchType;
        this.element = element;
        this.dataCreator = legendDataCreator;
        this.aesthetics = list;
        this.sizer = swatchSizer;
    }

    void copyApplicableAesthetics(ElementsSpec elementsSpec) {
        switch (this.swatchType.getType()) {
            case 1: {
                this.makePointElementAesthetics(elementsSpec);
                break;
            }
            case 2: {
                this.makeLineElementAesthetics(elementsSpec);
                break;
            }
            case 3: {
                this.makeLineWithPointsElementAesthetics(elementsSpec);
                break;
            }
            case 4: 
            case 5: {
                this.makeAreaElementAesthetics(elementsSpec);
                break;
            }
            case 6: {
                this.makeIntervalElementAesthetics(elementsSpec);
                break;
            }
            case 7: {
                this.makeEdgeElementAesthetics(elementsSpec);
                break;
            }
            case 8: {
                this.makePathElementAesthetics(elementsSpec);
                break;
            }
            case 9: {
                this.makePolygonElementAesthetics(elementsSpec);
                break;
            }
            case 10: {
                this.makeSchemaBoxplotElementAesthetics(elementsSpec);
                break;
            }
            case 11: {
                this.makeTextElementAesthetics(elementsSpec);
                break;
            }
            case 12: {
                this.makeFallbackAesthetics(elementsSpec);
            }
        }
        if (this.sizer != null) {
            this.sizer.modifySizeAesthetics(elementsSpec.size);
        }
    }

    private void makePointElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", null, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_symbol9238749274", null, false);
        elementsSpec.size = this.copyAesthetics("size", "legendentry_symbol9238749274", null, false);
        elementsSpec.symbol = this.copyAesthetics("symbol", "legendentry_symbol9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, false);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
    }

    private void makeLineElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_line9238749274", null, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_line9238749274", null, false);
        elementsSpec.size = this.copyAesthetics("size", "legendentry_line9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_line9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_line9238749274", null, false);
    }

    private void makeLineWithPointsElementAesthetics(ElementsSpec elementsSpec) {
        Object object;
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        boolean bl = false;
        if (this.element.spec.symbolStyle != null && this.element.spec.symbolStyle.symbol != null && !BasicFactory.isString(this.element.spec.symbolStyle.symbol)) {
            bl = true;
        }
        elementsSpec.color = this.copyLineWithPointAesthetics("color", !bl);
        elementsSpec.dashing = this.copyLineWithPointAesthetics("dashing", !bl);
        elementsSpec.size = this.copyLineWithPointAesthetics("size", true);
        for (Aesthetic aesthetic : this.aesthetics) {
            StyleSpec styleSpec;
            StyleSpec styleSpec2;
            int n;
            boolean bl2;
            AestheticSpec aestheticSpec;
            ModifiesSpec modifiesSpec;
            boolean bl3;
            if (!"styleBy".equals(aesthetic.type) || aesthetic.spec.palette == null) continue;
            object = aesthetic.spec.palette;
            int n2 = ((Object[])object).length;
            ModifiesSpec modifiesSpec2 = this.getModifies(aesthetic.spec);
            boolean bl4 = "line".equals(modifiesSpec2.part);
            boolean bl5 = "symbol".equals(modifiesSpec2.part);
            boolean bl6 = bl3 = modifiesSpec2.part != null && !bl4 && !bl5;
            if (modifiesSpec2.part == null || bl4) {
                modifiesSpec = new ModifiesSpec();
                modifiesSpec.part = "legendentry_line9238749274";
                aestheticSpec = this.copyAesthetic(aesthetic.spec, modifiesSpec, false);
                aestheticSpec.palette = new Object[n2];
                bl2 = false;
                for (n = 0; n < n2; ++n) {
                    styleSpec2 = (StyleSpec)object[n];
                    styleSpec = new StyleSpec();
                    aestheticSpec.palette[n] = styleSpec;
                    styleSpec.fill = styleSpec2.fill;
                    styleSpec.effect = styleSpec2.effect;
                    styleSpec.stroke = styleSpec2.stroke;
                    styleSpec.startArrow = styleSpec2.startArrow;
                    styleSpec.endArrow = styleSpec2.endArrow;
                    if (styleSpec.fill == null && styleSpec.effect == null && styleSpec.stroke == null && styleSpec.startArrow == null && styleSpec.endArrow == null) continue;
                    bl2 = true;
                }
                if (bl2) {
                    arrayList.add(aestheticSpec);
                }
            }
            if (modifiesSpec2.part != null && !bl5 && !bl3) continue;
            modifiesSpec = new ModifiesSpec();
            if (bl3) {
                modifiesSpec.part = modifiesSpec2.part;
            } else {
                modifiesSpec.part = "legendentry_symbol9238749274";
                modifiesSpec.descendants = true;
            }
            aestheticSpec = this.copyAesthetic(aesthetic.spec, modifiesSpec, true);
            aestheticSpec.palette = new Object[n2];
            bl2 = false;
            for (n = 0; n < n2; ++n) {
                styleSpec2 = (StyleSpec)object[n];
                styleSpec = new StyleSpec();
                aestheticSpec.palette[n] = styleSpec;
                styleSpec.symbol = styleSpec2.symbol;
                if (!bl5 || !bl || styleSpec.symbol != null) {
                    styleSpec.fill = styleSpec2.fill;
                    styleSpec.outline = styleSpec2.outline;
                    styleSpec.effect = styleSpec2.effect;
                    styleSpec.stroke = styleSpec2.stroke;
                    styleSpec.image = styleSpec2.image;
                }
                if (styleSpec.fill == null && styleSpec.outline == null && styleSpec.effect == null && styleSpec.stroke == null && styleSpec.symbol == null && styleSpec.image == null) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            arrayList.add(aestheticSpec);
        }
        elementsSpec.styleBy = SwatchAestheticCreator.toArray(arrayList);
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!"symbol".equals(aesthetic.type)) continue;
            object = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies((AestheticSpec)object);
            if (modifiesSpec.part == null || "symbol".equals(modifiesSpec.part)) {
                modifiesSpec.part = "legendentry_symbol9238749274";
                arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
                continue;
            }
            if ("line".equals(modifiesSpec.part)) continue;
            arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
        }
        elementsSpec.symbol = SwatchAestheticCreator.toArray(arrayList);
        elementsSpec.visibility = this.copyLineWithPointAesthetics("visibility", true);
    }

    private AestheticSpec[] copyLineWithPointAesthetics(String string, boolean bl) {
        boolean bl2 = string.equals("size");
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!string.equals(aesthetic.type)) continue;
            AestheticSpec aestheticSpec = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies(aestheticSpec);
            if (modifiesSpec.part == null) {
                modifiesSpec.part = "legendentry_line9238749274";
                arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
                modifiesSpec.part = "legendentry_symbol9238749274";
                modifiesSpec.descendants = !bl2;
                arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
                continue;
            }
            if ("line".equals(modifiesSpec.part)) {
                modifiesSpec.part = "legendentry_line9238749274";
                arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
                continue;
            }
            if ("symbol".equals(modifiesSpec.part)) {
                if (!bl) continue;
                modifiesSpec.part = "legendentry_symbol9238749274";
                modifiesSpec.descendants = !bl2;
                arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
                continue;
            }
            arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
        }
        return SwatchAestheticCreator.toArray(arrayList);
    }

    private void makePathElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", null, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_symbol9238749274", null, false);
        elementsSpec.size = this.copyAesthetics("size", "legendentry_symbol9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
    }

    private void makeEdgeElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", null, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_symbol9238749274", null, false);
        elementsSpec.size = this.copyAesthetics("size", "legendentry_symbol9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
    }

    private void makePolygonElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", null, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_symbol9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
    }

    private void makeAreaElementAesthetics(ElementsSpec elementsSpec) {
        Object object;
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!"color".equals(aesthetic.type)) continue;
            object = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies((AestheticSpec)object);
            if ("outline".equals(modifiesSpec.type)) {
                modifiesSpec.type = "fill";
                modifiesSpec.part = "legendentry_areaoutline9238749274";
                arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
                continue;
            }
            if ("both".equals(modifiesSpec.type)) {
                modifiesSpec.type = "fill";
                modifiesSpec.part = "legendentry_areafill9238749274";
                arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
                modifiesSpec.part = "legendentry_areaoutline9238749274";
                arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
                continue;
            }
            modifiesSpec.type = "fill";
            modifiesSpec.part = "legendentry_areafill9238749274";
            arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
        }
        elementsSpec.color = SwatchAestheticCreator.toArray(arrayList);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_areaoutline9238749274", null, false);
        for (Aesthetic aesthetic : this.aesthetics) {
            StyleSpec styleSpec;
            StyleSpec styleSpec2;
            int n;
            if (!"styleBy".equals(aesthetic.type) || aesthetic.spec.palette == null) continue;
            object = aesthetic.spec.palette;
            int n2 = ((Object[])object).length;
            ModifiesSpec modifiesSpec = new ModifiesSpec();
            modifiesSpec.part = "legendentry_areafill9238749274";
            AestheticSpec aestheticSpec = this.copyAesthetic(aesthetic.spec, modifiesSpec, false);
            aestheticSpec.palette = new Object[n2];
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                styleSpec2 = (StyleSpec)object[n];
                styleSpec = new StyleSpec();
                aestheticSpec.palette[n] = styleSpec;
                styleSpec.fill = styleSpec2.fill;
                styleSpec.effect = styleSpec2.effect;
                styleSpec.image = styleSpec2.image;
                if (styleSpec.fill == null && styleSpec.effect == null && styleSpec.image == null) continue;
                bl = true;
            }
            if (bl) {
                arrayList.add(aestheticSpec);
            }
            modifiesSpec = new ModifiesSpec();
            modifiesSpec.part = "legendentry_areaoutline9238749274";
            aestheticSpec = this.copyAesthetic(aesthetic.spec, modifiesSpec, true);
            aestheticSpec.palette = new Object[n2];
            bl = false;
            for (n = 0; n < n2; ++n) {
                styleSpec2 = (StyleSpec)object[n];
                styleSpec = new StyleSpec();
                aestheticSpec.palette[n] = styleSpec;
                styleSpec.fill = styleSpec2.outline;
                styleSpec.stroke = styleSpec2.stroke;
                if (styleSpec.fill == null && styleSpec.stroke == null) continue;
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(aestheticSpec);
        }
        elementsSpec.styleBy = SwatchAestheticCreator.toArray(arrayList);
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!"visibility".equals(aesthetic.type)) continue;
            object = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies((AestheticSpec)object);
            modifiesSpec.part = "legendentry_areafill9238749274";
            arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
            modifiesSpec.part = "legendentry_areaoutline9238749274";
            arrayList.add(this.copyAesthetic((AestheticSpec)object, modifiesSpec, false));
        }
        elementsSpec.visibility = SwatchAestheticCreator.toArray(arrayList);
    }

    private void makeIntervalElementAesthetics(ElementsSpec elementsSpec) {
        String string = null;
        if (this.sizer != null && this.sizer.isSizeChanging() && this.element.spec.style != null && this.element.spec.style.symbol != null && ("i-beam".equals(this.element.spec.style.symbol) || "t-beam".equals(this.element.spec.style.symbol))) {
            string = "outline";
        }
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", string, false);
        elementsSpec.dashing = this.copyAesthetics("dashing", "legendentry_symbol9238749274", null, false);
        String string2 = this.element.grammar.coordinates.containsTranspose() ? "height" : "width";
        elementsSpec.size = this.copyAesthetics("size", "legendentry_symbol9238749274", string2, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
        elementsSpec.symbol = this.copyAesthetics("symbol", "legendentry_symbol9238749274", null, false);
    }

    private void makeTextElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyAesthetics("color", "legendentry_symbol9238749274", null, false);
        elementsSpec.font = this.copyAesthetics("font", "legendentry_symbol9238749274", null, false);
        elementsSpec.size = this.copyAesthetics("size", "legendentry_symbol9238749274", null, false);
        elementsSpec.styleBy = this.copyAesthetics("styleBy", "legendentry_symbol9238749274", null, true);
        elementsSpec.visibility = this.copyAesthetics("visibility", "legendentry_symbol9238749274", null, false);
    }

    private void makeSchemaBoxplotElementAesthetics(ElementsSpec elementsSpec) {
        elementsSpec.color = this.copyBoxplotAesthetics("color", false);
        elementsSpec.size = this.copyBoxplotAesthetics("size", false);
        elementsSpec.dashing = this.copyBoxplotAesthetics("dashing", false);
        elementsSpec.styleBy = this.copyBoxplotAesthetics("styleBy", true);
        elementsSpec.visibility = this.copyBoxplotAesthetics("visibility", false);
    }

    private AestheticSpec[] copyBoxplotAesthetics(String string, boolean bl) {
        boolean bl2 = string.equals("size");
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!string.equals(aesthetic.type)) continue;
            AestheticSpec aestheticSpec = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies(aestheticSpec);
            if (modifiesSpec.part == null) {
                modifiesSpec.part = "legendentry_symbol9238749274";
                modifiesSpec.descendants = !bl2;
            }
            arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, bl));
        }
        return SwatchAestheticCreator.toArray(arrayList);
    }

    private void makeFallbackAesthetics(ElementsSpec elementsSpec) {
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!"color".equals(aesthetic.type)) continue;
            AestheticSpec aestheticSpec = aesthetic.spec;
            ModifiesSpec modifiesSpec = new ModifiesSpec();
            modifiesSpec.part = "legendentry_symbol9238749274";
            modifiesSpec.type = "fill";
            arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, false));
        }
        elementsSpec.color = SwatchAestheticCreator.toArray(arrayList);
    }

    private AestheticSpec[] copyAesthetics(String string, String string2, String string3, boolean bl) {
        assert (!bl || string.equals("styleBy"));
        boolean bl2 = string.equals("size");
        ArrayList<AestheticSpec> arrayList = new ArrayList<AestheticSpec>();
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!string.equals(aesthetic.type)) continue;
            AestheticSpec aestheticSpec = aesthetic.spec;
            ModifiesSpec modifiesSpec = this.getModifies(aestheticSpec);
            if (modifiesSpec.part == null) {
                modifiesSpec.part = string2;
                modifiesSpec.descendants = !bl2;
            }
            if (string3 != null) {
                modifiesSpec.type = string3;
            }
            if ("interval".equals(this.element.type) && "symbol".equals(string) && aestheticSpec.palette == null) {
                aestheticSpec.palette = new Object[]{"rectangle", "i-beam", "t-beam"};
            }
            arrayList.add(this.copyAesthetic(aestheticSpec, modifiesSpec, bl));
        }
        return SwatchAestheticCreator.toArray(arrayList);
    }

    private static AestheticSpec[] toArray(List<AestheticSpec> list) {
        int n = list.size();
        if (n == 0) {
            return null;
        }
        AestheticSpec[] aestheticSpecArray = list.toArray(new AestheticSpec[n]);
        list.clear();
        return aestheticSpecArray;
    }

    private ModifiesSpec getModifies(AestheticSpec aestheticSpec) {
        ModifiesSpec modifiesSpec;
        if (aestheticSpec.modifies == null) {
            modifiesSpec = new ModifiesSpec();
        } else if (BasicFactory.isString(aestheticSpec.modifies)) {
            modifiesSpec = new ModifiesSpec();
            modifiesSpec.type = (String)aestheticSpec.modifies;
        } else {
            modifiesSpec = (ModifiesSpec)((ModifiesSpec)aestheticSpec.modifies).copy();
        }
        return modifiesSpec;
    }

    private AestheticSpec copyAesthetic(AestheticSpec aestheticSpec, ModifiesSpec modifiesSpec, boolean bl) {
        AestheticSpec aestheticSpec2 = new AestheticSpec();
        aestheticSpec2.key = aestheticSpec.key;
        aestheticSpec2.mapping = this.dataCreator.makeRecodedMapping(aestheticSpec.mapping);
        aestheticSpec2.nullValue = aestheticSpec.nullValue;
        if (bl) {
            if (aestheticSpec.palette == null) {
                aestheticSpec2.palette = null;
            } else {
                int n = aestheticSpec.palette.length;
                aestheticSpec2.palette = new Object[n];
                for (int i = 0; i < n; ++i) {
                    StyleSpec styleSpec = (StyleSpec)aestheticSpec.palette[i];
                    StyleSpec styleSpec2 = (StyleSpec)styleSpec.copy();
                    styleSpec2.symbol = null;
                    aestheticSpec2.palette[i] = styleSpec2;
                }
            }
        } else {
            aestheticSpec2.palette = aestheticSpec.palette;
        }
        aestheticSpec2.field = new FieldValueRefSpec();
        aestheticSpec2.field.$ref = "legendField";
        aestheticSpec2.scale = this.dataCreator.getScaleSpec();
        aestheticSpec2.modifies = modifiesSpec.copy();
        return aestheticSpec2;
    }
}

